/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.sun;

import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.jbi.security.KeyStoreUtil;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SunASKeyStoreUtil
implements KeyStoreUtil {
    private static final String DEFAULT_ALGORITHM = "AES";
    private static final String DEFAULT_KEYNAME = "SunASKeyStoreUtil";
    private BASE64Encoder mBase64Encoder = new BASE64Encoder();
    private BASE64Decoder mBase64Decoder = new BASE64Decoder();

    public void addKey(String keyName) throws KeyStoreException {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(DEFAULT_ALGORITHM);
            SecretKey secretKey = keygen.generateKey();
            PasswordAdapter p = this.getPasswordAdapter();
            if (p.aliasExists(keyName)) {
                throw new KeyStoreException("Password Alias Exists");
            }
            p.setPasswordForAlias(keyName, secretKey.getEncoded());
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public boolean hasKey(String keyName) throws KeyStoreException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            return p.aliasExists(keyName);
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public void updateKey(String keyName) throws KeyStoreException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            if (!p.aliasExists(keyName)) {
                throw new KeyStoreException("Password Alias Does Not Exist");
            }
            KeyGenerator keygen = KeyGenerator.getInstance(DEFAULT_ALGORITHM);
            SecretKey secretKey = keygen.generateKey();
            p.setPasswordForAlias(keyName, secretKey.getEncoded());
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public void deleteKey(String keyName) throws KeyStoreException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            if (!p.aliasExists(keyName)) {
                throw new KeyStoreException("Password Alias Does Not Exist");
            }
            p.removeAlias(keyName);
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public String[] listKeyNames() throws KeyStoreException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            Enumeration en = this.getPasswordAdapter().getAliases();
            while (en.hasMoreElements()) {
                result.add((String)en.nextElement());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public String getKey(String keyName) throws KeyStoreException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            return p.getPasswordForAlias(keyName);
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public byte[] encrypt(String keyName, byte[] cleartext) throws KeyStoreException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            SecretKey instKey = p.getPasswordSecretKeyForAlias(keyName);
            Cipher cipher = Cipher.getInstance(DEFAULT_ALGORITHM);
            cipher.init(1, instKey);
            byte[] ciphertext = cipher.doFinal(cleartext);
            return ciphertext;
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public byte[] decrypt(String keyName, byte[] cipherText) throws KeyStoreException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            SecretKey instKey = p.getPasswordSecretKeyForAlias(keyName);
            Cipher cipher = Cipher.getInstance(DEFAULT_ALGORITHM);
            cipher.init(2, instKey);
            byte[] cleartext = cipher.doFinal(cipherText);
            return cleartext;
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public String encrypt(String keyName, String clearText) throws KeyStoreException {
        byte[] cipherText = this.encrypt(keyName, clearText.getBytes());
        return this.mBase64Encoder.encode(cipherText);
    }

    public String decrypt(String keyName, String base64EncodedCipherText) throws KeyStoreException {
        try {
            byte[] clearText = this.decrypt(keyName, this.mBase64Decoder.decodeBuffer(base64EncodedCipherText));
            return new String(clearText);
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public byte[] encrypt(byte[] clearText) throws KeyStoreException {
        this.initDefaultKey();
        return this.encrypt(DEFAULT_KEYNAME, clearText);
    }

    public byte[] decrypt(byte[] cipherText) throws KeyStoreException {
        return this.decrypt(DEFAULT_KEYNAME, cipherText);
    }

    public String encrypt(String clearText) throws KeyStoreException {
        this.initDefaultKey();
        return this.encrypt(DEFAULT_KEYNAME, clearText);
    }

    public String decrypt(String base64EncodedCipherText) throws KeyStoreException {
        return this.decrypt(DEFAULT_KEYNAME, base64EncodedCipherText);
    }

    private void initDefaultKey() throws KeyStoreException {
        if (!this.hasKey(DEFAULT_KEYNAME)) {
            this.addKey(DEFAULT_KEYNAME);
        }
    }

    private PasswordAdapter getPasswordAdapter() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        String masterPassword = IdentityManager.getMasterPassword();
        return new PasswordAdapter(masterPassword.toCharArray());
    }
}

