/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.websphere;

import com.sun.jbi.JBIProvider;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.platform.PlatformEventListener;
import com.sun.jbi.security.KeyStoreUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSpherePlatformContext
implements PlatformContext {
    private String mInstanceName;
    private String mInstanceRoot;
    private String mInstallRoot;
    private InitialContext mNamingContext;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());

    public WebSpherePlatformContext(String instanceName, String installRoot) {
        this.mInstanceName = instanceName;
        this.mInstallRoot = installRoot;
        this.mInstanceRoot = installRoot + File.separator + instanceName;
        try {
            Properties prop = new Properties();
            this.mNamingContext = new InitialContext(prop);
        }
        catch (NamingException nmEx) {
            this.mLog.warning(nmEx.toString());
        }
    }

    @Override
    public TransactionManager getTransactionManager() throws Exception {
        try {
            this.getClass();
            Class<?> transactionManagerFactory = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
            Method getTransactionManagerMethod = transactionManagerFactory.getMethod("getTransactionManager", null);
            TransactionManager transactionManager = (TransactionManager)getTransactionManagerMethod.invoke(null, null);
        }
        catch (Exception ex) {
            this.mLog.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(String instanceName) throws Exception {
        return this.getMBeanServer();
    }

    @Override
    public String getAdminServerName() {
        return this.mInstanceName;
    }

    @Override
    public boolean isAdminServer() {
        return true;
    }

    @Override
    public String getInstanceName() {
        return this.mInstanceName;
    }

    @Override
    public boolean isInstanceUp(String instanceName) {
        return this.mInstanceName.equals(instanceName);
    }

    @Override
    public boolean supportsMultipleServers() {
        return false;
    }

    @Override
    public String getTargetName() {
        return this.mInstanceName;
    }

    @Override
    public String getTargetName(String instanceName) {
        return instanceName;
    }

    @Override
    public Set<String> getStandaloneServerNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(this.mInstanceName);
        return names;
    }

    @Override
    public Set<String> getClusteredServerNames() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getClusterNames() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getServersInCluster(String clusterName) {
        return new HashSet<String>();
    }

    @Override
    public boolean isValidTarget(String targetName) {
        return this.mInstanceName.equals(targetName);
    }

    @Override
    public boolean isCluster(String targetName) {
        return false;
    }

    @Override
    public boolean isStandaloneServer(String targetName) {
        return this.mInstanceName.equals(targetName);
    }

    @Override
    public boolean isClusteredServer(String targetName) {
        return false;
    }

    @Override
    public boolean isInstanceClustered(String instanceName) {
        return false;
    }

    @Override
    public String getJmxRmiPort() {
        return null;
    }

    @Override
    public MBeanServer getMBeanServer() {
        MBeanServer mbeanServer = null;
        try {
            this.getClass();
            Class<?> adminServiceFactory = Class.forName("com.ibm.websphere.management.AdminServiceFactory");
            Method getMBeanFactoryMethod = adminServiceFactory.getMethod("getMBeanFactory", null);
            Object mbeanFactory = getMBeanFactoryMethod.invoke(null, null);
            Class<?> mbeanFactoryClass = getMBeanFactoryMethod.invoke(null, null).getClass();
            Method getMBeanServerMethod = mbeanFactoryClass.getMethod("getMBeanServer", null);
            mbeanServer = (MBeanServer)getMBeanServerMethod.invoke(mbeanFactory, null);
        }
        catch (Exception ex) {
            this.mLog.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return mbeanServer;
    }

    @Override
    public String getInstanceRoot() {
        return this.mInstanceRoot;
    }

    @Override
    public String getInstallRoot() {
        return this.mInstallRoot;
    }

    @Override
    public JBIProvider getProvider() {
        return JBIProvider.WEBSPHERE;
    }

    @Override
    public KeyStoreUtil getKeyStoreUtil() {
        return null;
    }

    @Override
    public InitialContext getNamingContext() {
        return this.mNamingContext;
    }

    @Override
    public ClassLoader getSystemClassLoader() throws SecurityException {
        return this.getClass().getClassLoader().getParent();
    }

    @Override
    public void addListener(PlatformEventListener listener) {
    }

    @Override
    public void removeListener(PlatformEventListener listener) {
    }

    @Override
    public Level getJbiLogLevel(String target) {
        Level jbiLoggerLevel = Logger.getLogger("com.sun.jbi").getLevel();
        if (jbiLoggerLevel == null) {
            jbiLoggerLevel = Level.INFO;
        }
        return jbiLoggerLevel;
    }

    @Override
    public void setJbiLogLevel(String target, Level level) {
        Logger.getLogger("com.sun.jbi").setLevel(level);
    }
}

