/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ComponentInfo;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.facade.Facade;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.util.ComponentConfigurationHelper;
import com.sun.jbi.util.Constants;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ComponentConfiguration
extends Facade
implements com.sun.jbi.management.ComponentConfiguration,
Constants {
    protected String mComponentName;
    protected ComponentType mComponentType;
    protected ComponentConfigurationHelper mCfgHlpr;
    protected Document mConfigDoc;

    public ComponentConfiguration(EnvironmentContext ctx, String target, String compName, ComponentType compType) throws ManagementException {
        super(ctx, target);
        this.mComponentName = compName;
        this.mComponentType = compType;
        this.mCfgHlpr = new ComponentConfigurationHelper();
        ComponentConfiguration.initPrimitiveTypeMap();
        this.mConfigDoc = null;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            if ("ApplicationVariables".equals(attribute)) {
                return this.getApplicationVariables();
            }
            if ("ApplicationConfigurations".equals(attribute)) {
                return this.getApplicationConfigurations();
            }
            this.attributeCheck(attribute);
            this.targetUpCheck();
            this.componentStartedOrStoppedOnTargetCheck();
            AttributeList attribList = this.getAttributes(new String[]{attribute});
            if (!attribList.isEmpty()) {
                return ((Attribute)attribList.get(0)).getValue();
            }
            return null;
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.setConfigurationAttribute(attribute);
        }
        catch (JBIException jex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jex)));
            throw new MBeanException((Exception)((Object)jex));
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            if (actionName.equals("setConfigurationAttribute")) {
                return this.setConfigurationAttribute((Attribute)params[0]);
            }
            if (actionName.equals("setConfigurationAttributes")) {
                return this.setConfigurationAttributes((AttributeList)params[0]);
            }
            if (actionName.equals("addApplicationVariable")) {
                return this.addApplicationVariable((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("setApplicationVariable")) {
                return this.setApplicationVariable((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("deleteApplicationVariable")) {
                return this.deleteApplicationVariable((String)params[0]);
            }
            if (actionName.equals("getApplicationVariables")) {
                return this.getApplicationVariables();
            }
            if (actionName.equals("getApplicationConfigurations")) {
                return this.getApplicationConfigurations();
            }
            if (actionName.equals("addApplicationConfiguration")) {
                if (params[1] instanceof Properties) {
                    return this.addApplicationConfiguration((String)params[0], (Properties)params[1]);
                }
                return this.addApplicationConfiguration((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("setApplicationConfiguration")) {
                if (params[1] instanceof Properties) {
                    return this.setApplicationConfiguration((String)params[0], (Properties)params[1]);
                }
                return this.setApplicationConfiguration((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("deleteApplicationConfiguration")) {
                return this.deleteApplicationConfiguration((String)params[0]);
            }
            if (actionName.equals("queryApplicationConfigurationType")) {
                return this.queryApplicationConfigurationType();
            }
            if (actionName.equals("retrieveConfigurationDisplaySchema")) {
                return this.retrieveConfigurationDisplaySchema();
            }
            if (actionName.equals("retrieveConfigurationDisplayData")) {
                return this.retrieveConfigurationDisplayData();
            }
            if (actionName.equals("isAppVarsSupported")) {
                return this.isAppVarsSupported();
            }
            if (actionName.equals("isAppConfigSupported")) {
                return this.isAppConfigSupported();
            }
            if (actionName.equals("isComponentConfigSupported")) {
                return this.isComponentConfigSupported();
            }
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        throw new UnsupportedOperationException();
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            this.setConfigurationAttributes(attributes);
            return attributes;
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
            return new AttributeList();
        }
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo;
        MBeanInfo augInfo = mbeanInfo = this.getComponentMBeanInfo();
        try {
            Method[] methods = Class.forName("com.sun.jbi.management.ComponentConfiguration").getDeclaredMethods();
            MBeanOperationInfo[] opInfos = new MBeanOperationInfo[methods.length];
            int i = 0;
            for (Method mtd : methods) {
                opInfos[i++] = new MBeanOperationInfo(mtd.getName(), mtd);
            }
            augInfo = new MBeanInfo(mbeanInfo.getClassName(), mbeanInfo.getDescription(), mbeanInfo.getAttributes(), mbeanInfo.getConstructors(), this.merge(mbeanInfo.getOperations(), opInfos), mbeanInfo.getNotifications());
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
        }
        return augInfo;
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        try {
            this.attributeCheck(attributes);
            this.targetUpCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
            return list;
        }
        String instance = this.getRunningInstance();
        ObjectName configMBeanName = null;
        if (instance != null) {
            try {
                configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance);
                AttributeList attribs = (AttributeList)this.getRemoteAttributes(configMBeanName, attributes, instance);
                return attribs;
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            }
        }
        return list;
    }

    public String setConfigurationAttribute(Attribute attrib) throws JBIException {
        this.componentStartedOrStoppedOnTargetCheck();
        this.attributeCheck(attrib);
        String result = this.setConfigurationAttributeOnTarget(attrib);
        MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result);
        if (msg.isSuccess()) {
            this.persistAttribute(attrib);
        }
        return result;
    }

    public String setConfigurationAttributes(AttributeList attribList) throws JBIException {
        this.componentStartedOrStoppedOnTargetCheck();
        this.attributeCheck(attribList);
        ComponentConfigurationResponse result = this.setConfigurationAttributesOnTarget(attribList);
        MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result.getResponseMessage());
        if (msg.isSuccess() && !this.mTarget.equals("server")) {
            this.persistAttributes(result.getAttributes());
        }
        return result.getResponseMessage();
    }

    public boolean isAppVarsSupported() throws MBeanException {
        Boolean isAppVarsSupported = false;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            try {
                Document configDoc = this.getConfigDoc();
                isAppVarsSupported = this.mCfgHlpr.isAppVarsSupported(configDoc);
            }
            catch (ManagementException ex) {
                throw new MBeanException((Exception)((Object)new JBIException((Throwable)((Object)ex))));
            }
        }
        try {
            this.targetUpCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        String instance = this.getRunningInstance();
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                isAppVarsSupported = (Boolean)this.invokeRemoteOperation(configMBeanName, "isAppVarsSupported", new Object[0], new String[0], instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        return isAppVarsSupported;
    }

    public String addApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        String result;
        this.mLog.fine("Adding application variable " + name);
        try {
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppVarsCheck();
            this.applicationVariableExistsCheck(name, false);
            this.applicationVariableCompositeIntegrityCheck(name, null, appVar, false);
            result = this.addApplicationVariableToTarget(name, appVar);
            MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result);
            if (msg.isFailure()) {
                throw new MBeanException((Exception)((Object)new JBIException(result)));
            }
            this.addApplicationVariable(appVar);
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public String setApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        String result;
        this.mLog.fine("Setting application variable " + name);
        try {
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppVarsCheck();
            String type = this.applicationVariableExistsCheck(name, true);
            this.applicationVariableCompositeIntegrityCheck(name, type, appVar, true);
            result = this.setApplicationVariableOnTarget(name, appVar);
            MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result);
            if (msg.isFailure()) {
                throw new MBeanException((Exception)((Object)new JBIException(result)));
            }
            this.updateApplicationVariable(appVar);
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public String deleteApplicationVariable(String name) throws MBeanException {
        String result;
        this.mLog.fine("Deleting application variable " + name);
        try {
            this.clusterUpCheck();
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppVarsCheck();
            result = this.deleteApplicationVariableFromTarget(name);
            MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result);
            if (msg.isFailure()) {
                throw new MBeanException((Exception)((Object)new JBIException(result)));
            }
            this.removeApplicationVariable(name);
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public TabularData getApplicationVariables() {
        TabularData appVars = null;
        String instance = this.getRunningInstance();
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                appVars = (TabularData)this.getRemoteAttribute(configMBeanName, "ApplicationVariables", instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        if (appVars == null) {
            try {
                appVars = this.createEmptyAppVarTable();
            }
            catch (OpenDataException oex) {
                throw new RuntimeException(oex);
            }
        }
        return appVars;
    }

    public TabularData getApplicationVariablesForInstance(String instance) {
        TabularData appVars = null;
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                appVars = (TabularData)this.getRemoteAttribute(configMBeanName, "ApplicationVariables", instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        if (appVars == null) {
            try {
                appVars = this.createEmptyAppVarTable();
            }
            catch (OpenDataException oex) {
                throw new RuntimeException(oex);
            }
        }
        return appVars;
    }

    public boolean isComponentConfigSupported() throws MBeanException {
        Boolean isComponentConfigSupported = false;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            try {
                Document configDoc = this.getConfigDoc();
                isComponentConfigSupported = this.mCfgHlpr.isComponentConfigSupported(configDoc);
            }
            catch (ManagementException ex) {
                throw new MBeanException((Exception)((Object)new JBIException((Throwable)((Object)ex))));
            }
        }
        try {
            this.targetUpCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        String instance = this.getRunningInstance();
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                isComponentConfigSupported = (Boolean)this.invokeRemoteOperation(configMBeanName, "isComponentConfigSupported", new Object[0], new String[0], instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        return isComponentConfigSupported;
    }

    public boolean isAppConfigSupported() throws MBeanException {
        Boolean isAppConfigSupported = false;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            try {
                Document configDoc = this.getConfigDoc();
                isAppConfigSupported = this.mCfgHlpr.isAppConfigSupported(configDoc);
            }
            catch (ManagementException ex) {
                throw new MBeanException((Exception)((Object)new JBIException((Throwable)((Object)ex))));
            }
        }
        try {
            this.targetUpCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        String instance = this.getRunningInstance();
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                isAppConfigSupported = (Boolean)this.invokeRemoteOperation(configMBeanName, "isAppConfigSupported", new Object[0], new String[0], instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        return isAppConfigSupported;
    }

    public CompositeType queryApplicationConfigurationType() {
        CompositeType appConfigType = null;
        String instance = this.getRunningInstance();
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                appConfigType = (CompositeType)this.invokeRemoteOperation(configMBeanName, "queryApplicationConfigurationType", new Object[0], new String[0], instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        return appConfigType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String addApplicationConfiguration(String name, Properties appCfgProps) throws MBeanException {
        this.mLog.fine(" adding application configuration " + appCfgProps.toString() + " to component " + this.mComponentName);
        String responseMsg = null;
        try {
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppConfigCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appCfgProps, false);
            this.applicationConfigurationExistsCheck(name, false);
            if (this.isTargetUp(this.mTarget)) {
                CompositeType appCfgType = this.queryApplicationConfigurationType();
                if (appCfgType != null) {
                    CompositeData cd = this.mCfgHlpr.convertPropertiesToCompositeData(appCfgProps, appCfgType);
                    return this.addApplicationConfigurationComposite(name, cd);
                }
                String errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_TYPE_NULL", this.mComponentName);
                throw new Exception(errMsg);
            }
            if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                Object[] params = new String[]{this.mComponentName, this.mTarget};
                String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
                return this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            }
            this.addApplicationConfiguration(appCfgProps);
            return this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception ex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("addApplicationConfiguration", ex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            }
        }
        return responseMsg;
    }

    public String addApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        String result;
        try {
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppConfigCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appConfig, false);
            this.applicationConfigurationExistsCheck(name, false);
            result = this.addApplicationConfigurationComposite(name, appConfig);
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public String deleteApplicationConfiguration(String name) throws MBeanException {
        String result;
        this.mLog.fine(" deleteing application configuration with name " + name);
        try {
            this.clusterUpCheck();
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppConfigCheck();
            result = this.deleteApplicationConfigurationFromTarget(name);
            MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result);
            if (msg.isFailure()) {
                throw new MBeanException((Exception)((Object)new JBIException(result)));
            }
            this.removeApplicationConfiguration(name);
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String setApplicationConfiguration(String name, Properties appCfgProps) throws MBeanException {
        this.mLog.fine(" setting application configuration " + appCfgProps.toString() + " on component " + this.mComponentName);
        String responseMsg = null;
        try {
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppConfigCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appCfgProps, true);
            this.applicationConfigurationExistsCheck(name, true);
            if (this.isTargetUp(this.mTarget)) {
                CompositeType appCfgType = this.queryApplicationConfigurationType();
                if (appCfgType != null) {
                    CompositeData cd = this.mCfgHlpr.convertPropertiesToCompositeData(appCfgProps, appCfgType);
                    return this.setApplicationConfigurationComposite(name, cd);
                }
                String errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_TYPE_NULL", this.mComponentName);
                throw new Exception(errMsg);
            }
            if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                Object[] params = new String[]{this.mComponentName, this.mTarget};
                String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
                return this.mMsgBuilder.buildFrameworkMessage("setApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            }
            this.updateApplicationConfiguration(appCfgProps);
            return this.mMsgBuilder.buildFrameworkMessage("updateApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        }
        catch (Exception ex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("updateApplicationConfiguration", ex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            }
        }
        return responseMsg;
    }

    public String setApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        String result;
        try {
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppConfigCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appConfig, true);
            this.applicationConfigurationExistsCheck(name, true);
            result = this.setApplicationConfigurationComposite(name, appConfig);
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public TabularData getApplicationConfigurations() {
        try {
            this.canListAppConfigCheck();
        }
        catch (JBIException jbiex) {
            throw new RuntimeException(jbiex.getMessage());
        }
        TabularData appConfigs = null;
        String instance = this.getRunningInstance();
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                appConfigs = (TabularData)this.getRemoteAttribute(configMBeanName, "ApplicationConfigurations", instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        if (appConfigs == null) {
            try {
                appConfigs = this.createEmptyAppConfigTable();
            }
            catch (OpenDataException oex) {
                throw new RuntimeException(oex);
            }
        }
        return appConfigs;
    }

    public TabularData getApplicationConfigurationsForInstance(String instance) {
        try {
            this.canListAppConfigCheck();
        }
        catch (JBIException jbiex) {
            throw new RuntimeException(jbiex.getMessage());
        }
        TabularData appConfigs = null;
        ObjectName configMBeanName = null;
        if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
            try {
                appConfigs = (TabularData)this.getRemoteAttribute(configMBeanName, "ApplicationConfigurations", instance);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        if (appConfigs == null) {
            try {
                appConfigs = this.createEmptyAppConfigTable();
            }
            catch (OpenDataException oex) {
                throw new RuntimeException(oex);
            }
        }
        return appConfigs;
    }

    public String retrieveConfigurationDisplaySchema() throws MBeanException {
        String response = null;
        try {
            String ns = this.getComponentConfigurationNS(this.mComponentName);
            if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
                response = this.getComponentConfigurationSchema();
            } else {
                this.componentStartedOrStoppedOnTargetCheck();
                String instance = this.getRunningInstance();
                ObjectName configMBeanName = null;
                if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
                    response = (String)this.invokeRemoteOperation(configMBeanName, "retrieveConfigurationDisplaySchema", new Object[0], new String[0], instance);
                }
            }
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        catch (Exception ex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("retrieveConfigurationDisplaySchema", ex);
                JBIException jbiEx = new JBIException(errMsg);
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
                throw new MBeanException((Exception)((Object)jbiEx));
            }
            catch (Exception exp) {
                this.mLog.fine(MessageHelper.getMsgString(exp));
                throw new MBeanException(ex);
            }
        }
        return response;
    }

    public String retrieveConfigurationDisplayData() throws MBeanException {
        String response = null;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            response = this.getComponentConfigurationData(this.mComponentName);
        } else {
            try {
                this.componentStartedOrStoppedOnTargetCheck();
                String instance = this.getRunningInstance();
                ObjectName configMBeanName = null;
                if (instance != null && (configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(instance)) != null) {
                    response = (String)this.invokeRemoteOperation(configMBeanName, "retrieveConfigurationDisplayData", new Object[0], new String[0], instance);
                }
            }
            catch (JBIException jbiex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
                throw new MBeanException((Exception)((Object)jbiex));
            }
            catch (Exception ex) {
                try {
                    String errMsg = this.mMsgBuilder.buildExceptionMessage("retrieveConfigurationDisplayData", ex);
                    JBIException jbiEx = new JBIException(errMsg);
                    this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
                    throw new MBeanException((Exception)((Object)jbiEx));
                }
                catch (Exception exp) {
                    this.mLog.fine(MessageHelper.getMsgString(exp));
                    throw new MBeanException(ex);
                }
            }
        }
        return response;
    }

    protected MBeanInfo getComponentMBeanInfo() {
        String instanceName = this.getRunningInstance();
        MBeanInfo mbeanInfo = null;
        if (instanceName != null) {
            try {
                mbeanInfo = this.getComponentConfigurationMBeanInfo(instanceName);
            }
            catch (Exception ex) {
                this.mLog.fine(MessageHelper.getMsgString(ex));
            }
        }
        if (mbeanInfo == null) {
            mbeanInfo = new MBeanInfo(this.getClass().getName(), "Dynaic Component Configuration facade MBean", new MBeanAttributeInfo[0], new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
        }
        return mbeanInfo;
    }

    protected ObjectName getRemoteInstanceComponentConfigMBeanName(String instanceName) {
        MBeanNames mbeanNames = new ManagementContext(this.mEnvCtx).getMBeanNames(instanceName);
        ObjectName cfgMBeanName = null;
        cfgMBeanName = this.mComponentType == ComponentType.BINDING ? mbeanNames.getBindingMBeanName(this.mComponentName, "Configuration") : mbeanNames.getEngineMBeanName(this.mComponentName, "Configuration");
        return cfgMBeanName;
    }

    private String setConfigurationAttributeOnTarget(Attribute attrib) throws JBIException {
        String result = null;
        try {
            result = this.mPlatform.isStandaloneServer(this.mTarget) ? this.setConfigurationAttributeOnInstance(attrib, this.mTarget) : this.setConfigurationAttributeOnCluster(attrib, this.mTarget);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected String setConfigurationAttributeOnInstance(Attribute attrib, String instanceName) throws ManagementException {
        String response = null;
        if (this.isInstanceRunning(instanceName)) {
            this.setRemoteAttribute(this.getRemoteInstanceComponentConfigMBeanName(instanceName), attrib, instanceName);
            Object[] params = new String[]{attrib.getName(), this.mComponentName};
            String responseMsg = this.mTranslator.getString("JBI_CCFG_SET_ATTRIBUTE_SUCCESS", params);
            response = this.mMsgBuilder.buildFrameworkMessage("setAttribute", MessageBuilder.TaskResult.SUCCESS, MessageBuilder.MessageType.INFO, MessageBuilder.getMessageString(responseMsg), (String[])params, MessageBuilder.getMessageToken(responseMsg));
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String responseMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            response = this.mMsgBuilder.buildFrameworkMessage("setAttribute", MessageBuilder.TaskResult.SUCCESS, MessageBuilder.MessageType.WARNING, MessageBuilder.getMessageString(responseMsg), (String[])params, MessageBuilder.getMessageToken(responseMsg));
        }
        return response;
    }

    private String setConfigurationAttributeOnCluster(Attribute attrib, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.setConfigurationAttributeOnInstance(attrib, instance);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("setAttribute", responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.mMsgBuilder.buildFrameworkMessage("setAttribute", MessageBuilder.TaskResult.SUCCESS);
        return response;
    }

    private ComponentConfigurationResponse setConfigurationAttributesOnTarget(AttributeList attribList) throws JBIException {
        ComponentConfigurationResponse result = null;
        try {
            result = this.mPlatform.isStandaloneServer(this.mTarget) ? this.setConfigurationAttributesOnInstance(attribList, this.mTarget) : this.setConfigurationAttributesOnCluster(attribList, this.mTarget);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected ComponentConfigurationResponse setConfigurationAttributesOnInstance(AttributeList attribList, String instanceName) throws ManagementException {
        ComponentConfigurationResponse response = null;
        if (this.isInstanceRunning(instanceName)) {
            AttributeList setAttributes = (AttributeList)this.setRemoteAttributes(this.getRemoteInstanceComponentConfigMBeanName(instanceName), attribList, instanceName);
            if (!attribList.isEmpty() && setAttributes.isEmpty()) {
                Object[] params = new String[]{this.attribListToString(attribList), this.mComponentName, instanceName};
                String responseMsg = this.mTranslator.getString("JBI_CCFG_SET_ATTRIBUTES_FAILURE", params);
                String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("setAttributes", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(responseMsg), (String[])params, MessageBuilder.getMessageToken(responseMsg));
                throw new ManagementException(jbiMsg);
            }
            Object[] params = new String[]{this.attribListToString(setAttributes), this.mComponentName};
            String responseMsg = this.mTranslator.getString("JBI_CCFG_SET_ATTRIBUTES_SUCCESS", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("setAttributes", MessageBuilder.TaskResult.SUCCESS, setAttributes.size() < attribList.size() ? MessageBuilder.MessageType.WARNING : MessageBuilder.MessageType.INFO, MessageBuilder.getMessageString(responseMsg), (String[])params, MessageBuilder.getMessageToken(responseMsg));
            response = new ComponentConfigurationResponse(jbiMsg, setAttributes);
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String responseMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("setAttributes", MessageBuilder.TaskResult.SUCCESS, MessageBuilder.MessageType.WARNING, MessageBuilder.getMessageString(responseMsg), (String[])params, MessageBuilder.getMessageToken(responseMsg));
            response = new ComponentConfigurationResponse(jbiMsg, attribList);
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ComponentConfigurationResponse setConfigurationAttributesOnCluster(AttributeList attribList, String clusterName) throws ManagementException {
        ComponentConfigurationResponse response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        AttributeList setAttributes = new AttributeList();
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    ComponentConfigurationResponse instResponse = this.setConfigurationAttributesOnInstance(attribList, instance);
                    responseMap.put(instance, instResponse.getResponseMessage());
                    for (Object attrib : instResponse.getAttributes()) {
                        if (setAttributes.contains(attrib)) continue;
                        setAttributes.add(attrib);
                    }
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("setAttributes", responseMap, exceptionMap, false);
            if (!msg.isSuccess()) throw new ManagementException(msg.getMessage());
            return new ComponentConfigurationResponse(msg.getMessage(), setAttributes);
        }
        String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("setAttributes", MessageBuilder.TaskResult.SUCCESS);
        return new ComponentConfigurationResponse(jbiMsg, attribList);
    }

    private String getRunningInstance() {
        String runningInstance;
        block5: {
            runningInstance = null;
            try {
                if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                    if (this.isInstanceRunning(this.mTarget)) {
                        runningInstance = this.mTarget;
                    }
                    break block5;
                }
                if (!this.mPlatform.isCluster(this.mTarget)) break block5;
                Set<String> instances = this.mPlatform.getServersInCluster(this.mTarget);
                for (String instance : instances) {
                    if (!this.isInstanceRunning(instance)) continue;
                    runningInstance = instance;
                    break;
                }
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            }
        }
        return runningInstance;
    }

    private ObjectName getComponentConfigurationMBeanName(String instanceName) throws JBIException {
        ObjectName configMBeanName;
        block8: {
            configMBeanName = null;
            Object compCfgMBeanInfo = null;
            MBeanServerConnection mbns = null;
            try {
                mbns = this.mPlatform.getMBeanServerConnection(instanceName);
                MBeanNames mbeanNames = new ManagementContext(this.mEnvCtx).getMBeanNames(instanceName);
                ObjectName standardPattern = mbeanNames.getCustomComponentMBeanNameFilter(instanceName, "Configuration", this.mComponentName);
                Set<ObjectName> names = mbns.queryNames(standardPattern, null);
                if (!names.isEmpty()) {
                    if (names.size() > 1) {
                        this.mLog.finest("More than one MBean matches ObjectName pattern " + standardPattern + ".  " + this.convertToString(names));
                    }
                    configMBeanName = names.iterator().next();
                    break block8;
                }
                ObjectName ebiPattern = null;
                try {
                    ebiPattern = new ObjectName("com.sun.ebi:ServiceType=Configuration,IdentificationName=" + this.mComponentName + ",*");
                }
                catch (Exception ex) {
                    this.mLog.fine(MessageHelper.getMsgString(ex));
                }
                Set<ObjectName> ebiNames = mbns.queryNames(ebiPattern, null);
                if (!ebiNames.isEmpty()) {
                    if (ebiNames.size() > 1) {
                        this.mLog.finest("More than one MBean matches ObjectName pattern " + standardPattern + ".  " + this.convertToString(ebiNames));
                    }
                    configMBeanName = ebiNames.iterator().next();
                }
            }
            catch (Exception ex) {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("getComponentConfigurationMBeanName", ex);
                throw new JBIException(errMsg);
            }
        }
        return configMBeanName;
    }

    private MBeanInfo getComponentConfigurationMBeanInfo(String instanceName) throws JBIException {
        MBeanInfo compCfgMBeanInfo = null;
        ObjectName configMBeanName = this.getComponentConfigurationMBeanName(instanceName);
        if (configMBeanName != null) {
            try {
                MBeanServerConnection mbns = this.mPlatform.getMBeanServerConnection(instanceName);
                compCfgMBeanInfo = mbns.getMBeanInfo(configMBeanName);
            }
            catch (Exception ex) {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("getComponentConfigurationMBeanInfo", ex);
                throw new JBIException(errMsg);
            }
        }
        return compCfgMBeanInfo;
    }

    protected MBeanOperationInfo[] merge(MBeanOperationInfo[] a1, MBeanOperationInfo[] a2) {
        int x;
        MBeanOperationInfo[] array = new MBeanOperationInfo[a1.length + a2.length];
        for (x = 0; x < a1.length; ++x) {
            array[x] = a1[x];
        }
        for (x = 0; x < a2.length; ++x) {
            array[x + a1.length] = a2[x];
        }
        return array;
    }

    protected void componentStartedOrStoppedOnTargetCheck() throws JBIException {
        ComponentState state = this.getComponentQuery().getStatus(this.mComponentName);
        if (ComponentState.STARTED != state && ComponentState.STOPPED != state) {
            Object[] params = new String[]{this.mComponentName, state.toString(), this.mTarget};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_NOT_STARTED_NOT_STOPPED_CFG", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("componentStartedOrStoppedOnTargetCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    private void targetUpCheck() throws JBIException {
        String instance = this.getRunningInstance();
        if (instance == null) {
            Object[] params = new String[]{this.mTarget};
            String errMsg = this.mTranslator.getString("JB_ADMIN_TARGET_NOT_UP", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("targetUpCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    private void clusterUpCheck() throws JBIException {
        if (this.mPlatform.isCluster(this.mTarget) && !this.areAllInstancesUp(this.mTarget)) {
            Object[] params = new String[]{this.mTarget};
            String errMsg = this.mTranslator.getString("JBI_CCFG_CLUSTER_NOT_COMPLETELY_UP", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("clusterUpCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    protected void canListAppConfigCheck() throws JBIException {
        ComponentState state = this.getComponentQuery().getStatus(this.mComponentName);
        if (ComponentState.STARTED != state && ComponentState.STOPPED != state) {
            Object[] params = new String[]{this.mComponentName, state.toString(), this.mTarget};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_NOT_STARTED_NOT_STOPPED_LST", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("canListAppConfigCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    protected void attributeCheck(AttributeList attributeList) throws JBIException {
        for (Object attribute : attributeList) {
            this.attributeCheck((Attribute)attribute);
        }
    }

    protected void attributeCheck(Attribute attribute) throws JBIException {
        boolean attribFound = false;
        boolean valueValid = false;
        String instance = this.getRunningInstance();
        if (instance != null) {
            MBeanAttributeInfo[] attribInfos = this.getMBeanInfo().getAttributes();
            if (attribInfos.length == 0) {
                String errMsg = null;
                ObjectName ccfgMBeanName = this.getComponentConfigurationMBeanName(instance);
                errMsg = ccfgMBeanName == null ? this.mTranslator.getString("JBI_CCFG_CONFIG_MBEAN_NOT_FOUND", this.mComponentName) : this.mTranslator.getString("JBI_CCFG_NO_CONFIG_ATTRIBUTES", this.mComponentName);
                String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("attributeCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), new String[]{this.mComponentName}, MessageBuilder.getMessageToken(errMsg));
                throw new JBIException(jbiMsg);
            }
            for (MBeanAttributeInfo attribInfo : attribInfos) {
                if (!attribInfo.getName().equals(attribute.getName())) continue;
                String type = attribInfo.getType();
                if (sTypeMap.containsKey(type)) {
                    type = (String)sTypeMap.get(type);
                }
                if (!type.equals(attribute.getValue().getClass().getName())) {
                    String errMsg = this.mTranslator.getString("JBI_CCFG_ATTRIBUTE_VALUE_INVALID", attribute.getName(), this.mComponentName, type);
                    throw new JBIException(errMsg);
                }
                return;
            }
            String errMsg = this.mTranslator.getString("JBI_CCFG_ATTRIBUTE_NOT_FOUND", attribute.getName(), this.mComponentName);
            throw new JBIException(errMsg);
        }
    }

    protected void attributeCheck(String[] attributeList) throws JBIException {
        for (String attribute : attributeList) {
            this.attributeCheck(attribute);
        }
    }

    protected void attributeCheck(String attributeName) throws JBIException {
        boolean attribFound = false;
        boolean valueValid = false;
        String instance = this.getRunningInstance();
        if (instance != null) {
            MBeanAttributeInfo[] attribInfos = this.getMBeanInfo().getAttributes();
            if (attribInfos.length == 0) {
                String errMsg = this.mTranslator.getString("JBI_CCFG_NO_CONFIG_ATTRIBUTES", this.mComponentName);
                String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("attributeCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), new String[]{this.mComponentName}, MessageBuilder.getMessageToken(errMsg));
                throw new JBIException(jbiMsg);
            }
            for (MBeanAttributeInfo attribInfo : attribInfos) {
                if (!attribInfo.getName().equals(attributeName)) continue;
                return;
            }
            String errMsg = this.mTranslator.getString("JBI_CCFG_ATTRIBUTE_NOT_FOUND", attributeName, this.mComponentName);
            throw new JBIException(errMsg);
        }
    }

    private void persistAttribute(Attribute attrib) {
        try {
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            String attributeValueToPersist = this.encryptCompConfigPasswordField(attrib.getName(), attrib.getValue().toString());
            updater.setComponentAttribute(this.mComponentName, this.mTarget, attrib.getName(), attributeValueToPersist);
        }
        catch (Exception rex) {
            String msg = this.mTranslator.getString("JBI_CCFG_PERSIST_ATTRIBUTE_FAILURE", this.mComponentName, attrib.getName(), rex.getMessage());
            this.mLog.fine(msg);
        }
    }

    private void persistAttributes(AttributeList attribs) {
        try {
            Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
            Properties props = new Properties();
            for (Object attrib : attribs) {
                Attribute attribute = (Attribute)attrib;
                String value = attribute.getValue() == null ? "" : attribute.getValue().toString();
                String attributeValueToPersist = this.encryptCompConfigPasswordField(attribute.getName(), value);
                props.put(attribute.getName(), attributeValueToPersist);
            }
            updater.setComponentAttributes(this.mComponentName, this.mTarget, props);
        }
        catch (Exception rex) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("[ ");
            int i = 0;
            for (Object attrib : attribs) {
                strBuf.append(((Attribute)attrib).getName());
                if (++i == attribs.size()) continue;
                strBuf.append(", ");
            }
            strBuf.append(" ]");
            String msg = this.mTranslator.getString("JBI_CCFG_PERSIST_ATTRIBUTE_FAILURE", this.mComponentName, strBuf.toString(), rex.getMessage());
            this.mLog.fine(msg);
        }
    }

    protected MBeanAttributeInfo getAttributeInfo(String attribute) {
        MBeanInfo mbeanInfo = this.getMBeanInfo();
        MBeanAttributeInfo[] attribInfos = null;
        MBeanAttributeInfo aInfo = null;
        if (mbeanInfo != null) {
            for (MBeanAttributeInfo attribInfo : attribInfos = mbeanInfo.getAttributes()) {
                if (!attribInfo.getName().equals(attribute)) continue;
                aInfo = attribInfo;
            }
        }
        return aInfo;
    }

    protected String applicationVariableExistsCheck(String name, boolean shouldExist) throws JBIException {
        TabularData appVars = this.getApplicationVariables();
        Object[] key = new Object[]{name};
        boolean exists = false;
        String type = "STRING";
        if (appVars.containsKey(key)) {
            exists = true;
            CompositeData appVar = appVars.get(key);
            type = (String)appVar.get(this.mCfgHlpr.getApplicationVariableItemNames()[2]);
        }
        Object[] params = new String[]{name};
        String errMsg = null;
        if (exists && !shouldExist) {
            errMsg = this.mTranslator.getString("JBI_CCFG_APP_VAR_EXISTS", params);
        } else if (!exists && shouldExist) {
            errMsg = this.mTranslator.getString("JBI_CCFG_APP_VAR_DOES_NOT_EXIST", params);
        }
        if (errMsg != null) {
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("applicationVariableExistsCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
        return type;
    }

    protected boolean applicationVariableExistsInstanceCheck(String name, String instance) {
        TabularData appVars = this.getApplicationVariablesForInstance(instance);
        Object[] key = new Object[]{name};
        boolean exists = false;
        if (appVars.containsKey(key)) {
            exists = true;
        }
        return exists;
    }

    protected void applicationVariableCompositeIntegrityCheck(String name, String type, CompositeData appVar, boolean isUpdate) throws JBIException {
        if (type == null) {
            type = "STRING";
        }
        String errMsg = null;
        Object[] params = new String[]{};
        String newType = (String)appVar.get(this.mCfgHlpr.getApplicationVariableItemNames()[2]);
        String newValue = (String)appVar.get(this.mCfgHlpr.getApplicationVariableItemNames()[1]);
        if (!appVar.get("name").equals(name)) {
            params = new String[]{name, (String)appVar.get("name")};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_VAR", params);
        }
        if (newType == null || newValue == null) {
            errMsg = this.mTranslator.getString("JBI_CCFG_INCOMPLETE_APP_VAR");
        }
        if (isUpdate && !type.equalsIgnoreCase(newType)) {
            params = new String[]{name, type, newType};
            errMsg = this.mTranslator.getString("JBI_CCFG_CANNOT_UPDATE_TYPE", params);
        }
        this.checkAppVarValue(name, newType, newValue);
        if (errMsg != null) {
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("applicationVariableCompositeIntegrityCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    private String addApplicationVariableToTarget(String name, CompositeData appVar) throws JBIException {
        String result = null;
        try {
            result = this.mPlatform.isStandaloneServer(this.mTarget) ? this.addApplicationVariableToInstance(name, appVar, this.mTarget) : this.addApplicationVariableToCluster(name, appVar, this.mTarget);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected String addApplicationVariableToInstance(String name, CompositeData appVar, String instanceName) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(instanceName)) {
            responseMsg = (String)this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(instanceName), "addApplicationVariable", new Object[]{name, appVar}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"}, instanceName);
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("addApplicationVariable", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String addApplicationVariableToCluster(String name, CompositeData appVar, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.isInstanceRunning(instance) ? this.addApplicationVariableToInstance(name, appVar, instance) : this.mMsgBuilder.buildFrameworkMessage("addApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("addApplicationVariable", responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.mMsgBuilder.buildFrameworkMessage("addApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
        return response;
    }

    private void addApplicationVariable(CompositeData appVar) throws RegistryException {
        if (!this.mTarget.equals("server")) {
            ComponentInfo.Variable[] vars = new ComponentInfo.Variable[1];
            try {
                String appVarValue = (String)appVar.get("value");
                if ("PASSWORD".equals((String)appVar.get("type"))) {
                    appVarValue = this.mPlatform.getKeyStoreUtil().encrypt(appVarValue);
                }
                vars[0] = new ComponentInfo.Variable((String)appVar.get("name"), appVarValue, (String)appVar.get("type"));
                Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
                updater.addComponentApplicationVariables(this.mComponentName, this.mTarget, vars);
            }
            catch (Exception rex) {
                String msg = this.mTranslator.getString("JBI_CCFG_FAILED_ADD_VAR_REG", this.mComponentName, vars[0].getName(), rex.getMessage());
                this.mLog.fine(msg);
            }
        }
    }

    private String setApplicationVariableOnTarget(String name, CompositeData appVar) throws JBIException {
        String result = null;
        try {
            result = this.mPlatform.isStandaloneServer(this.mTarget) ? this.setApplicationVariableOnInstance(name, appVar, this.mTarget) : this.setApplicationVariableOnCluster(name, appVar, this.mTarget);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected String setApplicationVariableOnInstance(String name, CompositeData appVar, String instanceName) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(instanceName)) {
            responseMsg = (String)this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(instanceName), "setApplicationVariable", new Object[]{name, appVar}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"}, instanceName);
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("setApplicationVariable", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String setApplicationVariableOnCluster(String name, CompositeData appVar, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.isInstanceRunning(instance) ? this.setApplicationVariableOnInstance(name, appVar, instance) : this.mMsgBuilder.buildFrameworkMessage("setApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("setApplicationVariable", responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.mMsgBuilder.buildFrameworkMessage("setApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
        return response;
    }

    private void updateApplicationVariable(CompositeData appVar) {
        if (!this.mTarget.equals("server")) {
            ComponentInfo.Variable[] vars = new ComponentInfo.Variable[1];
            try {
                String appVarValue = (String)appVar.get("value");
                if ("PASSWORD".equals((String)appVar.get("type"))) {
                    appVarValue = this.mPlatform.getKeyStoreUtil().encrypt(appVarValue);
                }
                vars[0] = new ComponentInfo.Variable((String)appVar.get("name"), appVarValue, (String)appVar.get("type"));
                Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
                updater.updateComponentApplicationVariables(this.mComponentName, this.mTarget, vars);
            }
            catch (Exception rex) {
                String msg = this.mTranslator.getString("JBI_CCFG_FAILED_UPDATE_VAR_REG", vars[0].getName(), this.mComponentName, rex.getMessage());
                this.mLog.fine(msg);
            }
        }
    }

    private String deleteApplicationVariableFromTarget(String name) throws JBIException {
        String result = null;
        try {
            if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                this.applicationVariableExistsCheck(name, true);
                result = this.deleteApplicationVariableFromInstance(name, this.mTarget);
            } else {
                result = this.deleteApplicationVariableFromCluster(name, this.mTarget);
            }
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected String deleteApplicationVariableFromInstance(String name, String instanceName) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(instanceName)) {
            responseMsg = (String)this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(instanceName), "deleteApplicationVariable", new Object[]{name}, new String[]{"java.lang.String"}, instanceName);
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationVariable", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String deleteApplicationVariableFromCluster(String name, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.isInstanceRunning(instance) && this.applicationVariableExistsInstanceCheck(name, instance) ? this.deleteApplicationVariableFromInstance(name, instance) : this.mMsgBuilder.buildFrameworkMessage("deleteApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("deleteApplicationVariable", responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationVariable", MessageBuilder.TaskResult.SUCCESS);
        return response;
    }

    private void removeApplicationVariable(String name) {
        if (!this.mTarget.equals("server")) {
            try {
                Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
                updater.deleteComponentApplicationVariables(this.mComponentName, this.mTarget, new String[]{name});
            }
            catch (RegistryException rex) {
                String msg = this.mTranslator.getString("JBI_CCFG_FAILED_DELETE_VAR_REG", name, this.mComponentName, rex.getMessage());
                this.mLog.fine(msg);
            }
        }
    }

    protected void applicationConfigurationCompositeIntegrityCheck(String name, CompositeData appConfig, boolean isUpdate) throws JBIException {
        Vector<String> keys;
        Set<String> keySet;
        CompositeType ct;
        String errMsg = null;
        Object[] params = new String[]{};
        if (name == null) {
            params = new String[]{name};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG_NAME", params);
        } else if ("".equals(name.trim())) {
            params = new String[]{name};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG_NAME", params);
        } else if (appConfig.get("configurationName") == null) {
            ct = appConfig.getCompositeType();
            keySet = ct.keySet();
            keys = new Vector<String>();
            Vector<Object> values = new Vector<Object>();
            for (String key : keySet) {
                if ("configurationName".equals(key)) {
                    keys.add(key);
                    values.add(name);
                    continue;
                }
                try {
                    values.add(appConfig.get(key));
                    keys.add(key);
                }
                catch (InvalidKeyException iex) {
                }
                catch (IllegalArgumentException iax) {}
            }
            try {
                appConfig = new CompositeDataSupport(ct, keys.toArray(new String[keys.size()]), values.toArray(new String[values.size()]));
            }
            catch (OpenDataException oex) {
                errMsg = oex.getMessage();
            }
        } else if ("".equals(((String)appConfig.get("configurationName")).trim())) {
            params = new String[]{name};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG_DATA", params);
        } else if (!name.equals(appConfig.get("configurationName"))) {
            params = new String[]{name, (String)appConfig.get("configurationName")};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG", params);
        }
        if (errMsg == null && !isUpdate) {
            ct = appConfig.getCompositeType();
            keySet = ct.keySet();
            keys = new Vector();
            for (String key : keySet) {
                boolean isInvalidValue = false;
                try {
                    if (appConfig.get(key) == null) {
                        isInvalidValue = true;
                    }
                }
                catch (InvalidKeyException iex) {
                    isInvalidValue = true;
                }
                catch (IllegalArgumentException iax) {
                    // empty catch block
                }
                try {
                    if (!isInvalidValue || !this.mCfgHlpr.isRequired(key, this.getConfigDoc())) continue;
                    params = new String[]{name, key};
                    errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_MISSING_FIELD", params);
                }
                catch (Exception ex) {
                    errMsg = this.mMsgBuilder.buildExceptionMessage("applicationConfigurationCompositeIntegrityCheck", ex);
                }
            }
        }
        if (errMsg != null) {
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("applicationConfigurationCompositeIntegrityCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    protected void applicationConfigurationCompositeIntegrityCheck(String name, Properties appCfgProps, boolean isUpdate) throws JBIException {
        CompositeType appCfgType;
        String errMsg = null;
        Object[] params = new String[]{};
        if (name == null) {
            params = new String[]{name};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG_NAME", params);
        } else if ("".equals(name.trim())) {
            params = new String[]{name};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG_NAME", params);
        }
        if (appCfgProps.get("configurationName") == null) {
            appCfgProps.setProperty("configurationName", name);
        } else if ("".equals(((String)appCfgProps.get("configurationName")).trim())) {
            params = new String[]{name};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG_DATA", params);
        } else if (!name.equals(appCfgProps.get("configurationName"))) {
            params = new String[]{name, (String)appCfgProps.get("configurationName")};
            errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_CFG", params);
        }
        if (errMsg == null && !isUpdate && (appCfgType = this.queryApplicationConfigurationType()) != null) {
            Set<String> keySet = appCfgType.keySet();
            Iterator<String> i$ = keySet.iterator();
            while (i$.hasNext()) {
                String obj;
                String key = obj = i$.next();
                boolean isInvalidValue = false;
                if (appCfgProps.getProperty(key) == null) {
                    isInvalidValue = true;
                }
                try {
                    if (!isInvalidValue || !this.mCfgHlpr.isRequired(key, this.getConfigDoc())) continue;
                    params = new String[]{key, this.mComponentName, name};
                    errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_MISSING_FIELD", params);
                }
                catch (Exception ex) {
                    errMsg = this.mMsgBuilder.buildExceptionMessage("applicationConfigurationCompositeIntegrityCheck", ex);
                }
            }
        }
        if (errMsg != null) {
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("applicationConfigurationCompositeIntegrityCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    private String addApplicationConfigurationComposite(String name, CompositeData appConfig) throws JBIException {
        String result = this.addApplicationConfigurationToTarget(name, appConfig);
        MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result);
        if (msg.isFailure()) {
            throw new JBIException(result);
        }
        this.addApplicationConfiguration(appConfig);
        return result;
    }

    private String addApplicationConfigurationToTarget(String name, CompositeData appCfg) throws JBIException {
        String result = null;
        try {
            result = this.mPlatform.isStandaloneServer(this.mTarget) ? this.addApplicationConfigurationToInstance(name, appCfg, this.mTarget) : this.addApplicationConfigurationToCluster(name, appCfg, this.mTarget);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected String addApplicationConfigurationToInstance(String name, CompositeData appCfg, String instanceName) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(instanceName)) {
            responseMsg = (String)this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(instanceName), "addApplicationConfiguration", new Object[]{name, appCfg}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"}, instanceName);
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String addApplicationConfigurationToCluster(String name, CompositeData appCfg, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.isInstanceRunning(instance) ? this.addApplicationConfigurationToInstance(name, appCfg, instance) : this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("addApplicationConfiguration", responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        return response;
    }

    private String setApplicationConfigurationComposite(String name, CompositeData appConfig) throws JBIException {
        String result = this.setApplicationConfigurationOnTarget(name, appConfig);
        MessageBuilder.Message msg = this.mMsgBuilder.createMessage(result);
        if (msg.isFailure()) {
            throw new JBIException(result);
        }
        this.updateApplicationConfiguration(appConfig);
        return result;
    }

    private String setApplicationConfigurationOnTarget(String name, CompositeData appCfg) throws JBIException {
        String result = null;
        try {
            result = this.mPlatform.isStandaloneServer(this.mTarget) ? this.setApplicationConfigurationOnInstance(name, appCfg, this.mTarget) : this.setApplicationConfigurationOnCluster(name, appCfg, this.mTarget);
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected String setApplicationConfigurationOnInstance(String name, CompositeData appCfg, String instanceName) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(instanceName)) {
            responseMsg = (String)this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(instanceName), "setApplicationConfiguration", new Object[]{name, appCfg}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"}, instanceName);
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("setApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String setApplicationConfigurationOnCluster(String name, CompositeData appCfg, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.isInstanceRunning(instance) ? this.setApplicationConfigurationOnInstance(name, appCfg, instance) : this.mMsgBuilder.buildFrameworkMessage("setApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("setApplicationConfiguration", responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.mMsgBuilder.buildFrameworkMessage("setApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        return response;
    }

    private String deleteApplicationConfigurationFromTarget(String name) throws JBIException {
        String result = null;
        try {
            if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                this.applicationConfigurationExistsCheck(name, true);
                result = this.deleteApplicationConfigurationFromInstance(name, this.mTarget);
            } else {
                result = this.deleteApplicationConfigurationFromCluster(name, this.mTarget);
            }
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        return result;
    }

    protected String deleteApplicationConfigurationFromInstance(String name, String instanceName) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(instanceName)) {
            responseMsg = (String)this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(instanceName), "deleteApplicationConfiguration", new Object[]{name}, new String[]{"java.lang.String"}, instanceName);
        } else {
            Object[] params = new String[]{this.mComponentName, instanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String deleteApplicationConfigurationFromCluster(String name, String clusterName) throws ManagementException {
        String response = null;
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            for (String instance : instances) {
                try {
                    response = this.isInstanceRunning(instance) && this.applicationConfigurationExistsInstanceCheck(name, instance) ? this.deleteApplicationConfigurationFromInstance(name, instance) : this.mMsgBuilder.buildFrameworkMessage("deleteApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
                    responseMap.put(instance, response);
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            MessageBuilder.Message msg = this.mMsgBuilder.buildCompositeMessage("deleteApplicationConfiguration", responseMap, exceptionMap, false);
            if (msg.isSuccess()) {
                return msg.getMessage();
            }
            throw new ManagementException(msg.getMessage());
        }
        response = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        return response;
    }

    private void addApplicationConfiguration(Properties cfgProps) throws RegistryException {
        if (!this.mTarget.equals("server")) {
            try {
                cfgProps = this.encryptAppConfigPasswordFields(cfgProps);
                Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
                updater.addComponentApplicationConfiguration(this.mComponentName, this.mTarget, cfgProps);
            }
            catch (Exception rex) {
                String msg = this.mTranslator.getString("JBI_CCFG_FAILED_ADD_CFG_REG", cfgProps.get("configurationName"), this.mComponentName, rex.getMessage());
                this.mLog.fine(msg);
            }
        }
    }

    private void addApplicationConfiguration(CompositeData appConfig) throws RegistryException {
        Properties cfgProps = this.mCfgHlpr.convertCompositeDataToProperties(appConfig);
        this.addApplicationConfiguration(cfgProps);
    }

    private void updateApplicationConfiguration(CompositeData appConfig) throws RegistryException {
        Properties cfgProps = this.mCfgHlpr.convertCompositeDataToProperties(appConfig);
        this.updateApplicationConfiguration(cfgProps);
    }

    private void updateApplicationConfiguration(Properties cfgProps) throws RegistryException {
        if (!this.mTarget.equals("server")) {
            try {
                cfgProps = this.encryptAppConfigPasswordFields(cfgProps);
                Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
                updater.updateComponentApplicationConfiguration(this.mComponentName, this.mTarget, cfgProps);
            }
            catch (Exception rex) {
                String msg = this.mTranslator.getString("JBI_CCFG_FAILED_UPDATE_CFG_REG", cfgProps.get("configurationName"), this.mComponentName, rex.getMessage());
                this.mLog.fine(msg);
            }
        }
    }

    private void removeApplicationConfiguration(String name) throws RegistryException {
        if (!this.mTarget.equals("server")) {
            try {
                Updater updater = ((Registry)this.mEnvCtx.getRegistry()).getUpdater();
                updater.deleteComponentApplicationConfiguration(this.mComponentName, this.mTarget, name);
            }
            catch (RegistryException rex) {
                String msg = this.mTranslator.getString("JBI_CCFG_FAILED_DELETE_CFG_REG", name, this.mComponentName, rex.getMessage());
                this.mLog.fine(msg);
            }
        }
    }

    protected void applicationConfigurationExistsCheck(String configName, boolean throwIfMissing) throws JBIException {
        TabularData td = this.getApplicationConfigurations();
        boolean isDefined = false;
        if (td != null) {
            isDefined = td.get(new String[]{configName}) != null;
            Object[] params = new String[]{configName, this.mComponentName};
            String errMsg = null;
            if (!isDefined && throwIfMissing) {
                errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_DOES_NOT_EXIST", params);
            } else if (isDefined && !throwIfMissing) {
                errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_EXISTS", params);
            }
            if (errMsg != null) {
                String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("applicationConfigurationExistsCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                throw new JBIException(jbiMsg);
            }
        }
    }

    protected boolean applicationConfigurationExistsInstanceCheck(String configName, String instance) {
        TabularData td = this.getApplicationConfigurationsForInstance(instance);
        boolean isDefined = false;
        if (td != null) {
            isDefined = td.get(new String[]{configName}) != null;
        }
        return isDefined;
    }

    protected void supportsAppVarsCheck() throws JBIException, MBeanException {
        if (!this.isAppVarsSupported()) {
            Object[] params = new String[]{this.mComponentName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_APP_VARS_NOT_SUPPORTED", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("supportsAppVarsCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    protected void supportsAppConfigCheck() throws JBIException, MBeanException {
        if (!this.isAppConfigSupported()) {
            Object[] params = new String[]{this.mComponentName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_NOT_SUPPORTED", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("supportsAppVarsCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    protected TabularData createEmptyAppConfigTable() throws OpenDataException {
        CompositeType appConfigCompositeType = this.queryApplicationConfigurationType();
        TabularDataSupport td = null;
        if (appConfigCompositeType != null) {
            TabularType tt = new TabularType("Applcation Configuration", "Table of Application configurations", appConfigCompositeType, new String[]{"configurationName"});
            td = new TabularDataSupport(tt);
        }
        return td;
    }

    protected TabularData createEmptyAppVarTable() throws OpenDataException {
        return new TabularDataSupport(this.mCfgHlpr.getApplicationVariableTabularType());
    }

    private Properties encryptAppConfigPasswordFields(Properties cfgProps) throws Exception {
        Document configDoc = this.getConfigDoc();
        Set<Object> cfgNames = cfgProps.keySet();
        for (Object cfgName : cfgNames) {
            if (!this.mCfgHlpr.isPassword((String)cfgName, configDoc)) continue;
            String clearTxt = cfgProps.getProperty((String)cfgName);
            String encrTxt = this.mPlatform.getKeyStoreUtil().encrypt(clearTxt);
            cfgProps.setProperty((String)cfgName, encrTxt);
        }
        return cfgProps;
    }

    private String encryptCompConfigPasswordField(String cfgName, String cfgValue) throws Exception {
        Document configDoc = this.getConfigDoc();
        if (this.mCfgHlpr.isPassword(cfgName, configDoc)) {
            String encrTxt = this.mPlatform.getKeyStoreUtil().encrypt(cfgValue);
            return encrTxt;
        }
        return cfgValue;
    }

    private Properties maskAppConfigPasswordFields(Properties cfgProps) throws Exception {
        Document configDoc = this.getConfigDoc();
        Set<Object> cfgNames = cfgProps.keySet();
        for (Object cfgName : cfgNames) {
            if (!this.mCfgHlpr.isPassword((String)cfgName, configDoc)) continue;
            cfgProps.setProperty((String)cfgName, "*****");
        }
        return cfgProps;
    }

    private Properties maskCompConfigPasswordFields(Properties cfgProps) throws Exception {
        Document configDoc = this.getConfigDoc();
        Set<Object> cfgNames = cfgProps.keySet();
        for (Object cfgName : cfgNames) {
            if (!this.mCfgHlpr.isPassword((String)cfgName, configDoc)) continue;
            cfgProps.setProperty((String)cfgName, "*****");
        }
        return cfgProps;
    }

    protected Document getConfigDoc() throws ManagementException {
        if (this.mConfigDoc == null) {
            try {
                String xmlConfigData = this.retrieveConfigurationDisplayData();
                if (xmlConfigData != null) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    StringReader reader = new StringReader(xmlConfigData);
                    InputSource ipsrc = new InputSource(reader);
                    this.mConfigDoc = db.parse(ipsrc);
                }
            }
            catch (Throwable exception) {
                try {
                    String errMsg = this.mMsgBuilder.buildExceptionMessage("getConfigDoc", exception);
                    throw new ManagementException(errMsg);
                }
                catch (ManagementException mex) {
                    throw new ManagementException(exception);
                }
            }
        }
        return this.mConfigDoc;
    }

    protected String attribListToString(AttributeList attribList) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("[ ");
        int i = 0;
        for (Object attrib : attribList) {
            strBuf.append(((Attribute)attrib).getName());
            if (++i == attribList.size()) continue;
            strBuf.append(", ");
        }
        strBuf.append(" ]");
        return strBuf.toString();
    }

    protected void checkAppVarValue(String name, String type, String value) throws JBIException {
        if (type == null || value == null) {
            return;
        }
        boolean isInvalidValue = false;
        if ("BOOLEAN".equalsIgnoreCase(type)) {
            if (!this.isBoolean(value)) {
                isInvalidValue = true;
            }
        } else if ("NUMBER".equalsIgnoreCase(type) && !this.isNumber(value)) {
            isInvalidValue = true;
        }
        if (isInvalidValue) {
            Object[] params = new String[]{name, value, type};
            String errMsg = this.mTranslator.getString("JBI_CCFG_INVALID_APP_VAR_VALUE", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("checkAppVarValue", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }

    protected boolean isNumber(String str) {
        String pStr = "[+|-]*\\d*[.]*[\\d]*";
        Pattern p = Pattern.compile(pStr);
        return p.matcher(str).matches();
    }

    protected boolean isBoolean(String str) {
        boolean isBoolean = true;
        if (!Boolean.FALSE.toString().equalsIgnoreCase(str) && !Boolean.TRUE.toString().equalsIgnoreCase(str)) {
            isBoolean = false;
        }
        return isBoolean;
    }

    protected class ComponentConfigurationResponse {
        private String mJbiMsg;
        private AttributeList mAttributes;

        public ComponentConfigurationResponse(String msg, AttributeList attribList) {
            this.mJbiMsg = msg;
            this.mAttributes = attribList;
        }

        public String getResponseMessage() {
            return this.mJbiMsg;
        }

        public AttributeList getAttributes() {
            return this.mAttributes;
        }
    }
}

