/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.internal.support;

import com.sun.jbi.management.system.ManagementException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DOMUtil {
    public static final DOMUtil UTIL = new DOMUtil();
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final NamespaceContext NAMESPACE_CONTEXT = new JBINamespaceContext();

    public Element getElement(Document aParentDocument, String aTagName) {
        NodeList nodeList = aParentDocument.getElementsByTagName(aTagName);
        return nodeList != null ? (Element)nodeList.item(0) : null;
    }

    public Element getElement(Element elem, String tagName) {
        NodeList nl = elem.getElementsByTagName(tagName);
        Element childElem = (Element)nl.item(0);
        return childElem;
    }

    public String getElementValue(Document doc, String elemName) {
        String elemVal = null;
        Element elem = this.getElement(doc, elemName);
        elemVal = this.getTextData(elem);
        return elemVal;
    }

    public String getAttribute(Element aElement, String aAttribute, String aPrefix) {
        String attr = this.getName(aAttribute, aPrefix);
        return aElement.getAttribute(attr);
    }

    public String getAttribute(Element aElement, String aAttribute) {
        return this.getAttribute(aElement, aAttribute, aElement.getPrefix());
    }

    private Text getText(Element aElement) {
        Node node = null;
        aElement.normalize();
        node = aElement.getFirstChild();
        if (node == null || !(node instanceof Text)) {
            node = aElement.getOwnerDocument().createTextNode("");
            aElement.appendChild(node);
        }
        return (Text)node;
    }

    public void setTextData(Element aElement, String aData) {
        this.getText(aElement).setData(aData);
    }

    public String getTextData(Element aElement) {
        return this.getText(aElement).getData();
    }

    public String getLocalName(String qname) {
        StringTokenizer tok = new StringTokenizer(qname, ":");
        try {
            if (tok.countTokens() == 1) {
                return qname;
            }
            tok.nextToken();
            return tok.nextToken();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getNamespace(Element el, String qname) {
        String namespace = "";
        if (qname.indexOf(58) > 0) {
            String prefix = qname.split(":")[0];
            namespace = el.lookupNamespaceURI(prefix);
        }
        return namespace;
    }

    public QName getQualifiedAttributeValue(Element el, String attrName) throws IllegalArgumentException {
        String attrValue = this.getAttribute(el, attrName);
        String attrValueLocalPart = this.getLocalName(attrValue);
        String attrValueNamespaceURI = this.getNamespace(el, attrValue);
        if (attrValueNamespaceURI != null) {
            return new QName(attrValueNamespaceURI, attrValueLocalPart);
        }
        return null;
    }

    public String DOM2String(Document aDocument, Writer aWriter) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("cdata-section-elements", "");
        transformer.setOutputProperty("indent", "no");
        transformer.transform(new DOMSource(aDocument), new StreamResult(aWriter));
        return aWriter.toString();
    }

    public String elementToString(Element element) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        transformer.transform(new DOMSource(element), new StreamResult(sw));
        return sw.toString();
    }

    public NodeList getElements(Element aParentElement, String aTagName) {
        return aParentElement.getElementsByTagNameNS(aParentElement.getNamespaceURI(), aTagName);
    }

    public NodeList getElements(Document aParentDocument, String aTagName) {
        return aParentDocument.getElementsByTagNameNS("*", aTagName);
    }

    public NodeList getChildElements(Element aElement, String aElementTagName) {
        NodeList nodeList = aElement.getChildNodes();
        NodeListImpl list = new NodeListImpl();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            String tagName;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(tagName = this.getElementName((Element)node)).equals(aElementTagName)) continue;
            list.add(node);
        }
        return list;
    }

    public String getElementName(Element aElement) {
        String tagName = aElement.getTagName();
        return this.getName(tagName);
    }

    public String getName(String aName) {
        int lastIdx = aName.lastIndexOf(58);
        if (lastIdx >= 0) {
            return aName.substring(lastIdx + 1);
        }
        return aName;
    }

    public String getName(String aName, String aPrefix) {
        if (aPrefix != null && aPrefix.length() > 0) {
            return aPrefix + ":" + aName;
        }
        return aName;
    }

    public static boolean areElementsEqual(File file1, File file2, String xpathExp) throws ManagementException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            InputSource inputSource1 = new InputSource(new FileInputStream(file1));
            InputSource inputSource2 = new InputSource(new FileInputStream(file2));
            String element1 = xpath.evaluate(xpathExp, inputSource1);
            String element2 = xpath.evaluate(xpathExp, inputSource2);
            return element1.equals(element2);
        }
        catch (XPathExpressionException xpathEx) {
            Logger.getLogger("com.sun.jbi.management").log(Level.WARNING, xpathEx.getMessage(), xpathEx);
            throw new ManagementException(xpathEx.toString());
        }
        catch (IOException ioEx) {
            Logger.getLogger("com.sun.jbi.management").log(Level.WARNING, ioEx.getMessage(), ioEx);
            throw new ManagementException(ioEx.toString());
        }
        catch (Exception ex) {
            Logger.getLogger("com.sun.jbi.management").log(Level.WARNING, ex.getMessage(), ex);
            throw new ManagementException(ex.toString());
        }
    }

    static class JBINamespaceContext
    implements NamespaceContext {
        JBINamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            return DOMUtil.NS_URI_XMLNS;
        }

        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }

    public static class NodeListImpl
    extends ArrayList
    implements NodeList {
        public int getLength() {
            return this.size();
        }

        public Node item(int aIndex) {
            return (Node)this.get(aIndex);
        }
    }
}

