/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.internal.support;

import com.sun.jbi.management.internal.support.FilePrefixFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DirectoryUtil {
    static final String DELETE_ME_FILE = ".DELETE_ME";

    public static void deleteDir(String dirName) throws Exception {
        boolean success = true;
        File dir = new File(dirName);
        if (dir.isDirectory()) {
            for (String child : dir.list()) {
                String absChildName = dirName + File.separator + child;
                File chldFile = new File(absChildName);
                if (chldFile.isDirectory()) {
                    DirectoryUtil.deleteDir(absChildName);
                } else {
                    success = chldFile.delete();
                }
                if (success) continue;
                throw new Exception("COULD_NOT_DELETE_FILE");
            }
        }
        if (!dir.delete()) {
            throw new Exception("COULD_NOT_DELETE_FILE");
        }
    }

    public static boolean removeDir(String dirName) {
        boolean success = false;
        try {
            DirectoryUtil.deleteDir(dirName);
            success = true;
        }
        catch (Exception ex) {
            DirectoryUtil.markDir(dirName);
        }
        return success;
    }

    public static void markDir(String dirName) {
        try {
            File dir = new File(dirName);
            if (dir.isDirectory()) {
                File deleteMe = new File(dir, DELETE_ME_FILE);
                deleteMe.createNewFile();
            }
        }
        catch (IOException ioEx) {
            Logger.getLogger("com.sun.jbi.management.internal.support").log(Level.WARNING, "java.io.IOException", ioEx);
        }
    }

    public static void removeMarkedDirs(String root) {
        ArrayList markedDirs = new ArrayList();
        DirectoryUtil.findMarkedDirs(new File(root), markedDirs);
        for (int i = 0; i < markedDirs.size(); ++i) {
            File dir = (File)markedDirs.get(i);
            try {
                DirectoryUtil.deleteDir(dir.getAbsolutePath());
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger("com.sun.jbi.management.internal.support").log(Level.WARNING, ex.getClass().getName(), ex);
            }
        }
    }

    public static String[] getFolderNameListing(File aDir) {
        ArrayList<String> folderList = new ArrayList<String>();
        if (aDir == null || !aDir.isDirectory()) {
            return null;
        }
        for (File file : aDir.listFiles()) {
            if (!file.isDirectory()) continue;
            folderList.add(file.getName());
        }
        return folderList.toArray(new String[0]);
    }

    public static boolean isMarked(File dir) {
        boolean isMarked = false;
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || !files[i].getName().equals(DELETE_ME_FILE)) continue;
            isMarked = true;
            break;
        }
        return isMarked;
    }

    public static File[] listFiles(File root, Pattern prefix) {
        return root.listFiles(new FilePrefixFilter(prefix));
    }

    private static void findMarkedDirs(File root, List markedDirs) {
        if (DirectoryUtil.isMarked(root)) {
            markedDirs.add(root);
            return;
        }
        File[] children = root.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].isDirectory()) continue;
            DirectoryUtil.findMarkedDirs(children[i], markedDirs);
        }
    }
}

