/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.repository;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.repository.ArchiveUploadMBean;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.util.FileHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class ArchiveUpload
implements ArchiveUploadMBean {
    private StringTranslator mStrings;
    private Logger mLog;
    private File mUploadDir;
    private HashMap mSessions = new HashMap();
    private HashMap<String, File> mFiles = new HashMap();

    public ArchiveUpload(ManagementContext ctx) {
        this.mLog = ctx.getLogger();
        this.mUploadDir = ctx.getRepository().getTempStore();
        this.mStrings = ctx.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
    }

    public Object initiateUpload(String archiveName) throws IOException {
        String id = this.createUID();
        File dir = new File(this.mUploadDir, id);
        dir.mkdir();
        File file = new File(dir, archiveName);
        FileOutputStream fos = new FileOutputStream(file);
        this.mSessions.put(id, fos);
        this.mFiles.put(id, file);
        return id;
    }

    public void uploadBytes(Object id, byte[] bytes) throws IOException {
        OutputStream out = this.getUploadStream(id);
        out.write(bytes);
        out.flush();
    }

    public void terminateUpload(Object id, Long timestamp) throws IOException {
        File file = this.mFiles.get(id);
        this.getUploadStream(id).close();
        this.mSessions.remove(id);
        this.mFiles.remove(id);
        if (file != null && timestamp != null && timestamp != 0L) {
            file.setLastModified(timestamp);
        }
    }

    public void terminateAllUploads() {
        try {
            Iterator ids = this.mSessions.keySet().iterator();
            while (ids.hasNext()) {
                this.terminateUpload(ids.next(), null);
            }
        }
        catch (IOException ioEx) {
            this.mLog.warning(ioEx.getMessage());
        }
    }

    public String getArchiveURL(Object id) {
        File[] files;
        String arUrl = null;
        File dir = new File(this.mUploadDir, (String)id);
        if (dir.exists() && (files = dir.listFiles()).length > 0) {
            File archive = files[0];
            URI archiveURI = archive.toURI();
            try {
                arUrl = archiveURI.toURL().toString();
            }
            catch (MalformedURLException muex) {
                this.mLog.warning(muex.getMessage());
            }
        }
        return arUrl;
    }

    public String getArchiveFilePath(Object id) {
        File archive;
        File[] files;
        String archivePath = null;
        File dir = new File(this.mUploadDir, (String)id);
        if (dir.exists() && (files = dir.listFiles()).length > 0 && (archive = files[0]) != null) {
            archivePath = archive.getAbsolutePath();
        }
        return archivePath;
    }

    public boolean removeArchive(Object id) {
        File dir = new File(this.mUploadDir, (String)id);
        boolean removed = false;
        removed = FileHelper.cleanDirectory(dir);
        if (removed) {
            dir.delete();
        }
        return removed;
    }

    private OutputStream getUploadStream(Object id) throws IOException {
        FileOutputStream fos = (FileOutputStream)this.mSessions.get(id);
        if (fos == null) {
            throw new IOException(this.mStrings.getString("JBI_ADMIN_UPLOAD_ID_NOT_FOUND"));
        }
        return fos;
    }

    private String createUID() {
        String uid = new UID().toString();
        uid = uid.replaceAll("-", "");
        uid = uid.replaceAll(":", "");
        return uid;
    }
}

