/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.support;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.support.NotifyStandardMBean;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class MBeanSet
implements com.sun.jbi.management.MBeanSet {
    private final MBeanServer mMBeanServer;
    private final Logger mLogger;
    private StringTranslator mTranslator;
    private final HashMap mStorage;
    private static ObjectName nullObjectName = null;
    private static Entry nullEntry = null;

    public MBeanSet(MBeanServer aMBeanServer, Logger aLogger) {
        block8: {
            this.mTranslator = null;
            this.mMBeanServer = aMBeanServer;
            this.mLogger = aLogger;
            this.mStorage = new HashMap();
            EnvironmentContext ctx = null;
            try {
                ctx = EnvironmentAccess.getContext();
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            if (null != ctx) {
                this.mTranslator = ctx.getStringTranslator("com.sun.jbi.management");
            }
            if (null == this.mMBeanServer && null != this.mTranslator) {
                String warningMsg = this.mTranslator.getString("MBEANSET_MBEANSERVER_NULL_OP");
                this.mLogger.warning(warningMsg);
            }
            if (null == nullObjectName) {
                try {
                    nullObjectName = new ObjectName("NULL_JMX_DOMAIN:NULL_ATTRIBUTE_KEY=NULL_ATTRIBUTE_VALUE");
                }
                catch (Exception e) {
                    if (null == this.mTranslator) break block8;
                    String severeMsg = this.mTranslator.getString("MBEANSET_OBJECTNAME_NULL", e.toString());
                    this.mLogger.severe(severeMsg);
                }
            }
        }
        if (null == nullEntry) {
            nullEntry = new Entry(nullObjectName, null, null, false);
        }
    }

    public boolean add(ObjectName theMBeanName, Class theMBeanDefinition, Object theMBeanImplementation, boolean isEmitter) {
        if (null == theMBeanName) {
            this.mStorage.put(nullObjectName, nullEntry);
        } else {
            Entry ee = new Entry(theMBeanName, theMBeanDefinition, theMBeanImplementation, isEmitter);
            this.mStorage.put(theMBeanName, ee);
        }
        return true;
    }

    public boolean add(ObjectName theMBeanName, Class theMBeanDefinition, Object theMBeanImplementation) {
        return this.add(theMBeanName, theMBeanDefinition, theMBeanImplementation, false);
    }

    public boolean replace(ObjectName theMBeanName, Class theMBeanDefinition, Object theMBeanImplementation, boolean isEmitter) {
        return this.add(theMBeanName, theMBeanDefinition, theMBeanImplementation, isEmitter);
    }

    public boolean replace(ObjectName theMBeanName, Class theMBeanDefinition, Object theMBeanImplementation) {
        return this.add(theMBeanName, theMBeanDefinition, theMBeanImplementation, false);
    }

    public boolean delete(ObjectName theMBeanName) {
        if (null == theMBeanName) {
            theMBeanName = nullObjectName;
        }
        return this.mStorage.remove(theMBeanName) != null;
    }

    public boolean exists(ObjectName theMBeanName) {
        if (null == theMBeanName) {
            theMBeanName = nullObjectName;
        }
        return this.mStorage.containsKey(theMBeanName);
    }

    public boolean isRegistered(ObjectName theMBeanName) {
        if (null == this.mMBeanServer || null == theMBeanName) {
            return false;
        }
        if (theMBeanName.toString() == nullObjectName.toString()) {
            return false;
        }
        return this.mMBeanServer.isRegistered(theMBeanName);
    }

    public boolean register() {
        if (null == this.mMBeanServer && null != this.mTranslator) {
            String warningMsg = this.mTranslator.getString("MBEANSET_MBEANSERVER_NULL_REG");
            this.mLogger.warning(warningMsg);
            return false;
        }
        int nerrors = 0;
        for (ObjectName mbn : this.mStorage.keySet()) {
            Entry ee = (Entry)this.mStorage.get(mbn);
            if (this.isRegistered(mbn) || ee == nullEntry) continue;
            try {
                StandardMBean mbean = null;
                mbean = ee.mIsEmitter ? new NotifyStandardMBean(ee.mMBeanImplementation, ee.mMBeanDefinition) : (ee.mMBeanImplementation instanceof StandardMBean ? (StandardMBean)ee.mMBeanImplementation : new StandardMBean(ee.mMBeanImplementation, ee.mMBeanDefinition));
                this.mMBeanServer.registerMBean(mbean, mbn);
            }
            catch (Exception e) {
                e.printStackTrace();
                ++nerrors;
            }
        }
        return 0 == nerrors;
    }

    public boolean unregister() {
        if (null == this.mMBeanServer && null != this.mTranslator) {
            String warningMsg = this.mTranslator.getString("MBEANSET_MBEANSERVER_NULL_UNREG");
            this.mLogger.warning(warningMsg);
            return false;
        }
        int nerrors = 0;
        for (ObjectName mbn : this.mStorage.keySet()) {
            Entry ee = (Entry)this.mStorage.get(mbn);
            if (!this.isRegistered(mbn) || ee == nullEntry) continue;
            try {
                this.mMBeanServer.unregisterMBean(mbn);
            }
            catch (InstanceNotFoundException infe) {
            }
            catch (Exception e) {
                e.printStackTrace();
                ++nerrors;
            }
        }
        return 0 == nerrors;
    }

    public void dump(String aTitle) {
        String txt = aTitle;
        for (ObjectName mbn : this.mStorage.keySet()) {
            Entry ee = (Entry)this.mStorage.get(mbn);
            txt = txt + "\n" + ee.toString();
        }
        this.mLogger.info(txt);
    }

    private class Entry {
        public final ObjectName mMBeanName;
        public final Class mMBeanDefinition;
        public final Object mMBeanImplementation;
        public final boolean mIsEmitter;

        Entry(ObjectName theMBeanName, Class theMBeanDefinition, Object theMBeanImplementation, boolean isEmitter) {
            if (null == theMBeanName) {
                theMBeanName = nullObjectName;
            }
            this.mMBeanName = theMBeanName;
            this.mMBeanDefinition = theMBeanDefinition;
            this.mMBeanImplementation = theMBeanImplementation;
            this.mIsEmitter = isEmitter;
        }

        public String toString() {
            return this.mMBeanName.toString() + "\t" + (this.mMBeanDefinition == null ? "NULL_DEFINITION" : this.mMBeanDefinition.toString()) + "\t" + (this.mMBeanImplementation == null ? "NULL_IMPLEMENTATION" : this.mMBeanImplementation.toString());
        }
    }
}

