/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.support;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.common.LoggerMBean;
import com.sun.jbi.management.support.DefaultLoggerMBeanImpl;
import com.sun.jbi.management.support.MBeanHelper;
import com.sun.jbi.util.Constants;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class SystemServiceLoggerMBeanImpl
extends DefaultLoggerMBeanImpl
implements LoggerMBean,
NotificationListener,
MBeanRegistration,
Constants {
    private boolean isListening;
    StringTranslator mTranslator;

    public SystemServiceLoggerMBeanImpl(Logger mLogger) throws Exception {
        this(mLogger, mLogger.getName());
        this.mTranslator = EnvironmentAccess.getContext().getStringTranslator("com.sun.jbi.management");
        this.isListening = false;
    }

    public SystemServiceLoggerMBeanImpl(Logger mLogger, String aDisplayName) throws Exception {
        super(mLogger, aDisplayName);
        Level level = MBeanHelper.getLogLevel(mLogger.getName(), EnvironmentAccess.getContext());
        if (level != null) {
            mLogger.setLevel(level);
        }
        this.mTranslator = EnvironmentAccess.getContext().getStringTranslator("com.sun.jbi.management");
        this.isListening = false;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification notif = (AttributeChangeNotification)notification;
            if (notif.getAttributeName().equals(this.mLogger.getName())) {
                this.mLogger.fine("run time log level change notifictaion for " + this.mLogger.getName() + " from " + notif.getOldValue() + " to " + notif.getNewValue());
            }
            String level = (String)notif.getNewValue();
            try {
                if (level == null || level == "null" || "DEFAULT".equals(level)) {
                    super.setDefault();
                } else {
                    this.mLogger.setLevel(Level.parse(level));
                }
            }
            catch (IllegalArgumentException iex) {
                this.mLogger.fine("Failed to set log level for logger " + this.mLogger.getName() + " to " + level + " : " + iex.getMessage());
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            this.startListeningToLogLevelChanges();
            this.isListening = true;
            this.mLogger.fine("Logger " + this.mLogger.getName() + " is now listening for changes in the logger configuration");
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        if (this.isListening) {
            this.stopListeningToLogLevelChanges();
            this.isListening = false;
            this.mLogger.fine("Logger " + this.mLogger.getName() + " has stopped listening for changes in the logger configuration");
        }
    }

    private void startListeningToLogLevelChanges() {
        MBeanServer mbeanServer = EnvironmentAccess.getContext().getMBeanServer();
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.disableAllAttributes();
        filter.enableAttribute(this.mLogger.getName());
        try {
            mbeanServer.addNotificationListener(MBeanHelper.getLoggerConfigMBeanName(), this, (NotificationFilter)filter, null);
        }
        catch (Exception ex) {
            Object[] params = new String[]{this.mDisplayName, this.mLogger.getName(), MBeanHelper.getLoggerConfigMBeanName().toString(), ex.getMessage()};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_FAILED_ADD_LOGGER_LISTENER", params);
            this.mLogger.info(errMsg);
        }
    }

    private void stopListeningToLogLevelChanges() {
        MBeanServer mbeanServer = EnvironmentAccess.getContext().getMBeanServer();
        try {
            if (mbeanServer.isRegistered(MBeanHelper.getLoggerConfigMBeanName())) {
                mbeanServer.removeNotificationListener(MBeanHelper.getLoggerConfigMBeanName(), this);
            }
        }
        catch (Exception ex) {
            Object[] params = new String[]{this.mDisplayName, this.mLogger.getName(), MBeanHelper.getLoggerConfigMBeanName().toString(), ex.getMessage()};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_FAILED_RM_LOGGER_LISTENER", params);
            this.mLogger.warning(errMsg);
        }
    }
}

