/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.VersionInfo;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.support.JbiNameInfo;
import com.sun.jbi.management.system.AdminServiceMBean;
import com.sun.jbi.management.system.AutoAdminTask;
import com.sun.jbi.management.system.BuildManagementMessageImpl;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementMessageHolder;
import com.sun.jbi.management.system.ModelSystemService;
import com.sun.jbi.management.system.SystemBootstrap;
import com.sun.jbi.util.EnvironmentAccess;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class AdminService
extends ModelSystemService
implements AdminServiceMBean,
NotificationListener {
    private long mHeartBeatInterval;
    private Integer mNotificationId;
    private static AutoAdminTask sAutoAdminTask = null;
    private ObjectName mAdminServiceLifeCycleMBeanName;
    private ObjectName mConfigServiceLifeCycleMBeanName;
    private ObjectName mDeployServiceLifeCycleMBeanName;
    private ObjectName mInstallServiceLifeCycleMBeanName;
    private ObjectName mLoggingServiceLifeCycleMBeanName;
    private ObjectName mMessageServiceLifeCycleMBeanName;
    private final JbiNameInfo mJbiNameInfo = new JbiNameInfo("AdminService");
    private ManagementContext mContext = null;
    private BuildManagementMessageImpl mMMImpl = null;
    private SystemBootstrap mEsbSys = null;

    public AdminService(ManagementContext anEnv) {
        this.mContext = anEnv;
        this.initModelSystemService(anEnv.getEnvironmentContext());
        AdminService adminService = this;
        this.mMMImpl = adminService.mContext.getManagementMessageObject();
    }

    protected void initModelSystemService(EnvironmentContext anEnv) {
        String loggerName = "com.sun.jbi.management.AdminService";
        Logger logger = Logger.getLogger(loggerName);
        super.initModelSystemService(anEnv, logger, this.mJbiNameInfo);
        this.initSystemServiceLifeCycleMBeanNames();
        this.mStartMBeans.add(this.mAdminServiceMBeanName, AdminServiceMBean.class, this);
        Object interval = this.getConfigurationAttribute(ConfigurationCategory.System, "heartBeatInterval");
        this.mHeartBeatInterval = interval == null ? 5500 : (Integer)interval;
        this.mLogger.fine("JBI Admin Service heartbeat interval is " + this.mHeartBeatInterval + " ms.");
    }

    public synchronized void start() throws JBIException {
        String statusMsg = this.mTranslator.getString("AS_START_SERVICE", "AdminService.start()", "JBI Framework");
        this.mLogger.fine(statusMsg);
        if (this.mEnv.getPlatformContext().isAdminServer()) {
            this.startAutoTasks();
        }
        super.start();
    }

    public synchronized void stop() throws JBIException {
        if (sAutoAdminTask != null) {
            this.stopAutoTasks();
        }
        super.stop();
    }

    public void handleNotification(Notification aNotification, Object anObject) {
        this.heartBeat();
        this.checkHeartBeat();
    }

    public ObjectName getSystemService(String serviceName) {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        String controltype = this.managementServiceControl(serviceName);
        if (controltype == null) {
            controltype = "Lifecycle";
        }
        tmp = tmp + ":" + "ServiceName" + "=" + serviceName;
        tmp = tmp + "," + "ControlType" + "=" + controltype;
        tmp = tmp + "," + "ComponentType" + "=" + "System";
        tmp = tmp + "," + "JbiName" + "=" + mbn.getJbiInstanceName();
        ObjectName[] names = this.queryHelper(tmp = tmp + ",*");
        if (names.length >= 1) {
            if (names.length > 1) {
                String statusMsg = this.mTranslator.getString("AS_GETSYSTEMSERVICE_TOO_MANY_MBEANS", tmp);
                this.mLogger.severe(statusMsg);
            }
            return names[0];
        }
        String statusMsg = this.mTranslator.getString("AS_GETSYSTEMSERVICE_LOOKUP_FAILED", tmp);
        this.mLogger.warning(statusMsg);
        return null;
    }

    public ObjectName[] getSystemServices() {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ComponentType" + "=" + "System";
        tmp = tmp + "," + "JbiName" + "=" + mbn.getJbiInstanceName();
        ObjectName[] names = this.queryHelper(tmp = tmp + ",*");
        if (names.length >= 1) {
            ArrayList<ObjectName> namelist = new ArrayList<ObjectName>();
            for (int ii = 0; ii < names.length; ++ii) {
                String ctype = names[ii].getKeyProperty("ControlType");
                if (ctype == null || !ctype.endsWith("Service")) continue;
                namelist.add(names[ii]);
            }
            if (namelist.size() > 0) {
                ObjectName[] newnames = new ObjectName[namelist.size()];
                Iterator itr = namelist.iterator();
                int ii = 0;
                while (itr.hasNext()) {
                    newnames[ii] = (ObjectName)itr.next();
                    ++ii;
                }
                return newnames;
            }
            String statusMsg = this.mTranslator.getString("AS_GETSYSTEMSERVICE_NO_SERVICES");
            this.mLogger.severe(statusMsg);
        } else {
            String statusMsg = this.mTranslator.getString("AS_GETSYSTEMSERVICE_LOOKUP_FAILED", tmp);
            this.mLogger.warning(statusMsg);
        }
        return new ObjectName[0];
    }

    public ObjectName getComponentByName(String name) {
        EnvironmentAccess.getContext().isFrameworkReady(true);
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ComponentName" + "=" + name;
        tmp = tmp + "," + "ControlType" + "=" + "Lifecycle";
        tmp = tmp + "," + "ComponentType" + "=" + "Installed";
        tmp = tmp + "," + "JbiName" + "=" + mbn.getJbiInstanceName();
        tmp = tmp + ",*";
        ObjectName[] names = this.queryHelper(tmp);
        if (names.length >= 1) {
            if (names.length > 1) {
                String statusMsg = this.mTranslator.getString("AS_GETCOMPONENTBYID_TOO_MANY_MBEANS", tmp);
                this.mLogger.severe(statusMsg);
            }
            return names[0];
        }
        String statusMsg = this.mTranslator.getString("AS_GETCOMPONENTBYID_LOOKUP_FAILED", tmp);
        this.mLogger.warning(statusMsg);
        return null;
    }

    public ObjectName[] getBindingComponents() {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        return this.getInstalledComponents("Binding");
    }

    public ObjectName[] getEngineComponents() {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        return this.getInstalledComponents("Engine");
    }

    public boolean isBinding(String componentName) {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        ObjectName compObj = this.getComponentByName(componentName);
        if (null == compObj) {
            return false;
        }
        String compType = compObj.getKeyProperty("InstalledType");
        return "Binding".equals(compType);
    }

    public boolean isEngine(String componentName) {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        ObjectName compObj = this.getComponentByName(componentName);
        if (null == compObj) {
            return false;
        }
        String compType = compObj.getKeyProperty("InstalledType");
        return "Engine".equals(compType);
    }

    public String getSystemInfo() {
        AdminService adminService = this;
        VersionInfo vers = adminService.mContext.getVersionInfo();
        return vers.fullProductName() + "\n" + vers.majorVersion() + "." + vers.minorVersion() + "(" + vers.buildNumber() + ")" + "\n" + vers.copyright() + "\n";
    }

    public ObjectName[] getDeployerMBeanNames(String componentName) {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        String qhdr = mbn.getJmxDomainName();
        qhdr = qhdr + ":" + "ComponentName" + "=" + componentName;
        qhdr = qhdr + "," + "ComponentType" + "=" + "Installed";
        qhdr = qhdr + "," + "ControlType" + "=" + "Deployer";
        qhdr = qhdr + "," + "JbiName" + "=" + mbn.getJbiInstanceName();
        qhdr = qhdr + ",*";
        return this.queryHelper(qhdr);
    }

    public String getJbiInstanceName() {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        return mbn.getJbiInstanceName();
    }

    public ObjectName[] getComponentMBeans(String componentName) {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ComponentName" + "=" + componentName;
        tmp = tmp + "," + "ComponentType" + "=" + "Installed";
        tmp = tmp + "," + "JbiName" + "=" + mbn.getJbiInstanceName();
        tmp = tmp + ",*";
        return this.queryHelper(tmp);
    }

    public String getRemoteFileUploadURL() throws Exception {
        String uploadURL = null;
        String aHttpServerIpAddr = null;
        String aHttpServerPort = null;
        ObjectName HTTPListenerConfig = null;
        try {
            aHttpServerIpAddr = InetAddress.getLocalHost().getHostAddress();
            HTTPListenerConfig = new ObjectName("amx:j2eeType=X-HTTPListenerConfig,X-ConfigConfig=server-config,name=http-listener-1,X-HTTPServiceConfig=na");
            AdminService adminService = this;
            aHttpServerPort = adminService.mContext.getMBeanServer().getAttribute(HTTPListenerConfig, "Port").toString();
            uploadURL = "http://" + aHttpServerIpAddr + ":" + aHttpServerPort + "/JBIFileUpload/UploadServlet";
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("AS_GETREMOVEFILEUPLOADURL_EXCEP", e.toString());
            this.mLogger.severe(statusMsg);
            ManagementMessageHolder mmHolder = new ManagementMessageHolder("EXCEPTION_MSG");
            mmHolder.setTaskName("getRemoteFileUploadURL");
            mmHolder.setExceptionObject(e);
            mmHolder.setLocMessage(1, statusMsg);
            mmHolder.setLocToken(1, "UNABLE_TO_GET_UPLOAD_URL");
            String jbiTaskStr = this.mMMImpl.buildCompleteExceptionMessage(mmHolder);
            throw new Exception(jbiTaskStr);
        }
        return uploadURL;
    }

    public String getFullProductName() {
        AdminService adminService = this;
        return adminService.mContext.getVersionInfo().fullProductName();
    }

    public String getShortProductName() {
        AdminService adminService = this;
        return adminService.mContext.getVersionInfo().shortProductName();
    }

    public String getMajorVersion() {
        AdminService adminService = this;
        return adminService.mContext.getVersionInfo().majorVersion();
    }

    public String getMinorVersion() {
        AdminService adminService = this;
        return adminService.mContext.getVersionInfo().minorVersion();
    }

    public String getBuildNumber() {
        AdminService adminService = this;
        return adminService.mContext.getVersionInfo().buildNumber();
    }

    public String getCopyright() {
        AdminService adminService = this;
        return adminService.mContext.getVersionInfo().copyright();
    }

    public boolean startManagementServices() {
        this.mLogger.fine("JBI runtime management services starting");
        try {
            this.mMBeanServer.invoke(this.mConfigServiceLifeCycleMBeanName, "start", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mDeployServiceLifeCycleMBeanName, "start", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mInstallServiceLifeCycleMBeanName, "start", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mLoggingServiceLifeCycleMBeanName, "start", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mMessageServiceLifeCycleMBeanName, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.mLogger.severe(e.toString());
            return false;
        }
        this.mLogger.fine("JBI runtime management services startup complete");
        return true;
    }

    public boolean stopManagementServices() {
        try {
            this.mMBeanServer.invoke(this.mConfigServiceLifeCycleMBeanName, "stop", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mDeployServiceLifeCycleMBeanName, "stop", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mInstallServiceLifeCycleMBeanName, "stop", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mLoggingServiceLifeCycleMBeanName, "stop", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mMessageServiceLifeCycleMBeanName, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.mLogger.severe(e.toString());
            return false;
        }
        return true;
    }

    public boolean shutdownManagementServices() {
        int nerrors = 0;
        try {
            this.mMBeanServer.invoke(this.mConfigServiceLifeCycleMBeanName, "shutDown", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mDeployServiceLifeCycleMBeanName, "shutDown", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mInstallServiceLifeCycleMBeanName, "shutDown", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mLoggingServiceLifeCycleMBeanName, "shutDown", new Object[0], new String[0]);
            this.mMBeanServer.invoke(this.mMessageServiceLifeCycleMBeanName, "shutDown", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.mLogger.severe(e.toString());
            ++nerrors;
        }
        try {
            this.mMBeanServer.invoke(this.mAdminServiceLifeCycleMBeanName, "shutDown", new Object[0], new String[0]);
        }
        catch (Exception e2) {
            this.mLogger.severe(e2.toString());
            ++nerrors;
        }
        return nerrors == 0;
    }

    private String managementServiceControl(String svcName) {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        if ("AdminService".equals(svcName)) {
            return "AdministrationService";
        }
        if ("ConfigurationService".equals(svcName)) {
            return "ConfigurationService";
        }
        if ("DeploymentService".equals(svcName)) {
            return "DeploymentService";
        }
        if ("InstallationService".equals(svcName)) {
            return "InstallationService";
        }
        if ("LoggingService".equals(svcName)) {
            return "LoggingService";
        }
        if ("MessageService".equals(svcName)) {
            return "MessageService";
        }
        return null;
    }

    public ObjectName[] queryHelper(String qStr) {
        AdminService adminService = this;
        return this.queryHelper(qStr, adminService.mContext.getMBeanServer());
    }

    public ObjectName[] queryHelper(String qStr, MBeanServerConnection rmbs) {
        ObjectName mbpat = null;
        Set<ObjectName> result = null;
        try {
            mbpat = new ObjectName(qStr);
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("AS_QUERYHELPER_EXCEP", "AdminService.queryHelper", qStr);
            this.mLogger.severe(statusMsg);
            this.mLogger.log(Level.FINEST, "Exception in AdminService:queryHelper ", e);
            return new ObjectName[0];
        }
        try {
            result = rmbs.queryNames(mbpat, null);
        }
        catch (Exception e) {
            String statusMsg = this.mTranslator.getString("AS_QUERYHELPER_EXCEP", "AdminService.queryHelper", qStr);
            this.mLogger.severe(statusMsg);
            this.mLogger.log(Level.FINEST, "Exception in AdminService:queryHelper ", e);
            return new ObjectName[0];
        }
        if (result.size() >= 1) {
            ObjectName[] names = new ObjectName[result.size()];
            Iterator<ObjectName> itr = result.iterator();
            int ii = 0;
            while (itr.hasNext()) {
                names[ii] = itr.next();
                ++ii;
            }
            return names;
        }
        return new ObjectName[0];
    }

    private ObjectName[] getInstalledComponents(String ctype) {
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ComponentType" + "=" + "Installed";
        tmp = tmp + "," + "ControlType" + "=" + "Lifecycle";
        tmp = tmp + "," + "InstalledType" + "=" + ctype;
        tmp = tmp + "," + "JbiName" + "=" + mbn.getJbiInstanceName();
        ObjectName[] names = this.queryHelper(tmp = tmp + ",*");
        if (names.length >= 1) {
            return names;
        }
        String statusMsg = this.mTranslator.getString("AS_GETINSTALLEDCOMPONENTS_FAILURE", tmp);
        this.mLogger.warning(statusMsg);
        return new ObjectName[0];
    }

    private void startAutoTasks() {
        this.mLogger.fine(this.mTranslator.getString("AS_HEARTBEAT_START"));
        AdminService adminService = this;
        ObjectName timerName = adminService.mContext.getMBeanNames().getSystemServiceMBeanName("AdminService", "HeartBeat");
        sAutoAdminTask = new AutoAdminTask(this.mContext);
        if (null == timerName) {
            this.mLogger.severe(this.mTranslator.getString("AS_HEARTBEAT_NULL"));
            return;
        }
        try {
            AdminService adminService2 = this;
            adminService2.mContext.getMBeanServer().createMBean("javax.management.timer.Timer", timerName);
            AdminService adminService3 = this;
            adminService3.mContext.getMBeanServer().invoke(timerName, "start", new Object[0], new String[0]);
            AdminService adminService4 = this;
            this.mNotificationId = (Integer)adminService4.mContext.getMBeanServer().invoke(timerName, "addNotification", new Object[]{"AdminService.HeartBeat", "heartBeat", null, this.nextBeat(), new Long(this.mHeartBeatInterval)}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date", "long"});
            AdminService adminService5 = this;
            adminService5.mContext.getMBeanServer().addNotificationListener(timerName, this, null, new Object());
        }
        catch (Exception e) {
            this.mLogger.log(Level.FINEST, "Exception in AdminService:startAutoTasks ", e);
        }
    }

    private void heartBeat() {
        try {
            if (null != sAutoAdminTask) {
                sAutoAdminTask.performAutoFunctions();
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.FINEST, "Exception in AdminService:heartBeat ", e);
        }
    }

    private Date nextBeat() {
        return new Date(System.currentTimeMillis() + this.mHeartBeatInterval);
    }

    private void stopAutoTasks() {
        String statusMsg = this.mTranslator.getString("AS_HEARTBEAT_STOP");
        this.mLogger.fine(statusMsg);
        sAutoAdminTask = null;
        AdminService adminService = this;
        MBeanNames mbn = adminService.mContext.getMBeanNames();
        ObjectName timerName = mbn.getSystemServiceMBeanName("AdminService", "HeartBeat");
        if (null == timerName) {
            statusMsg = this.mTranslator.getString("AS_HEARTBEAT_NULL");
            this.mLogger.severe(statusMsg);
            return;
        }
        try {
            AdminService adminService2 = this;
            adminService2.mContext.getMBeanServer().removeNotificationListener(timerName, this);
            AdminService adminService3 = this;
            adminService3.mContext.getMBeanServer().unregisterMBean(timerName);
        }
        catch (Exception e) {
            this.mLogger.log(Level.FINEST, "Exception in AdminService:stopAutoTasks", e);
        }
    }

    private void initSystemServiceLifeCycleMBeanNames() {
        this.mAdminServiceLifeCycleMBeanName = this.mMBeanNames.getSystemServiceMBeanName("AdminService", "Lifecycle");
        this.mConfigServiceLifeCycleMBeanName = this.mMBeanNames.getSystemServiceMBeanName("ConfigurationService", "Lifecycle");
        this.mDeployServiceLifeCycleMBeanName = this.mMBeanNames.getSystemServiceMBeanName("DeploymentService", "Lifecycle");
        this.mInstallServiceLifeCycleMBeanName = this.mMBeanNames.getSystemServiceMBeanName("InstallationService", "Lifecycle");
        this.mLoggingServiceLifeCycleMBeanName = this.mMBeanNames.getSystemServiceMBeanName("LoggingService", "Lifecycle");
        this.mMessageServiceLifeCycleMBeanName = this.mMBeanNames.getSystemServiceMBeanName("MessageService", "Lifecycle");
    }

    private Object getConfigurationAttribute(ConfigurationCategory category, String attrName) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(category.toString());
        ObjectName configMBeanName = this.mMBeanNames.getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        Object attrValue = null;
        try {
            if (this.mMBeanServer.isRegistered(configMBeanName)) {
                attrValue = this.mMBeanServer.getAttribute(configMBeanName, attrName);
            }
        }
        catch (JMException jmex) {
            this.mLogger.warning(jmex.toString());
        }
        return attrValue;
    }

    private void checkHeartBeat() {
        AdminService adminService = this;
        ObjectName timerName = adminService.mContext.getMBeanNames().getSystemServiceMBeanName("AdminService", "HeartBeat");
        Object interval = this.getConfigurationAttribute(ConfigurationCategory.System, "heartBeatInterval");
        long currHeartBeat = this.mHeartBeatInterval;
        try {
            if (interval != null) {
                currHeartBeat = ((Integer)interval).intValue();
            }
            if (currHeartBeat != this.mHeartBeatInterval) {
                AdminService adminService2 = this;
                if (adminService2.mContext.getMBeanServer().isRegistered(timerName)) {
                    this.mLogger.fine("Switching to new heart beat interval of " + currHeartBeat + " ms old heart beat was " + this.mHeartBeatInterval + " ms.");
                    AdminService adminService3 = this;
                    adminService3.mContext.getMBeanServer().invoke(timerName, "removeNotification", new Object[]{this.mNotificationId}, new String[]{"java.lang.Integer"});
                    this.mHeartBeatInterval = currHeartBeat;
                    AdminService adminService4 = this;
                    this.mNotificationId = (Integer)adminService4.mContext.getMBeanServer().invoke(timerName, "addNotification", new Object[]{"AdminService.HeartBeat", "heartBeat", null, new Date(System.currentTimeMillis()), new Long(this.mHeartBeatInterval)}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date", "long"});
                }
            }
        }
        catch (Exception ex) {
            this.mLogger.warning(MessageHelper.getMsgString(ex));
        }
    }
}

