/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.MBeanHelper;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.system.AdminService;
import com.sun.jbi.management.system.DeploymentService;
import com.sun.jbi.management.system.InstallationService;
import com.sun.jbi.management.system.LoggingService;
import com.sun.jbi.management.system.ManagementContext;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagementService
implements ServiceLifecycle {
    private Logger mLog;
    private EnvironmentContext mEnv;
    private ManagementContext mMgmtContext;
    private MBeanServer mMBeanServer;
    private MBeanHelper mMBeanHelper;
    private StringTranslator mTranslator;

    public void initService(EnvironmentContext envContext) throws JBIException {
        this.mEnv = envContext;
        Properties jbiprops = this.mEnv.getInitialProperties();
        this.mTranslator = this.mEnv.getStringTranslator("com.sun.jbi.management");
        this.initJbiProperties(jbiprops);
        this.exportJbiProperties(jbiprops);
        this.mMgmtContext = new ManagementContext(envContext);
        ManagementService managementService = this;
        this.mMBeanServer = managementService.mMgmtContext.getMBeanServer();
        ManagementService managementService2 = this;
        this.mMBeanHelper = managementService2.mMgmtContext.getMBeanHelper();
        ManagementService managementService3 = this;
        this.mLog = managementService3.mMgmtContext.getLogger();
        this.mLog.fine("ManagementService: initializing");
        if (!this.mMBeanHelper.createSystemServiceLoggerMBean("ManagementService", this.mLog)) {
            String errMsg = this.mTranslator.getString("MNGMTSVC_CANNOT_CREATE_LOGGERMBEAN");
            this.mLog.severe(errMsg);
        }
        if (!ManagementService.createDeploymentService(this.mMgmtContext)) {
            throw new JBIException("cannot create JBI Framework DeploymentService.");
        }
        if (!ManagementService.createInstallationService(this.mMgmtContext)) {
            throw new JBIException("cannot create JBI Framework InstallationService.");
        }
        if (!ManagementService.createLoggingService(this.mMgmtContext)) {
            throw new JBIException("cannot create JBI Framework LoggingService.");
        }
        if (!ManagementService.createAdminService(this.mMgmtContext)) {
            throw new JBIException("cannot create JBI Framework AdminService.");
        }
        try {
            ManagementService managementService4 = this;
            MBeanNames mbn = managementService4.mMgmtContext.getMBeanNames();
            ObjectName adminLC = mbn.getSystemServiceMBeanName("AdminService", "Lifecycle");
            this.mLog.fine("ManagementService: Starting admin service lifecycle, " + adminLC.toString());
            this.mMBeanServer.invoke(adminLC, "start", new Object[0], new String[0]);
            ObjectName adminSVC = mbn.getSystemServiceMBeanName("AdminService", "AdministrationService");
            this.mLog.fine("ManagementService: Starting Management Services, " + adminSVC.toString());
            this.mMBeanServer.invoke(adminSVC, "startManagementServices", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
        this.mLog.fine("ManagementService: initialization complete");
    }

    public void startService() throws JBIException {
        this.mLog.fine("ManagementService: starting");
        this.mLog.fine("ManagementService: startup complete");
    }

    public void stopService() throws JBIException {
        this.mLog.fine("ManagementService: shutting down");
        try {
            ManagementService managementService = this;
            MBeanNames mbn = managementService.mMgmtContext.getMBeanNames();
            ObjectName adminSVC = mbn.getSystemServiceMBeanName("AdminService", "AdministrationService");
            this.mLog.fine("ManagementService: shutdown Management layer, " + adminSVC.toString());
            this.mMBeanServer.invoke(adminSVC, "shutdownManagementServices", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.mLog.warning(e.toString());
            throw new JBIException((Throwable)e);
        }
        if (!this.mMBeanHelper.destroySystemServiceLoggerMBean("ManagementService", this.mLog)) {
            this.mLog.fine("ManagementService: cannot destroy my LoggerMBean!");
        }
        this.mLog.fine("ManagementService: shutdown complete");
    }

    public void updateComponentState(String componentName) {
        ManagementService managementService = this;
        DeploymentService depSvc = managementService.mMgmtContext.getDeploymentServiceHandle();
        depSvc.updateServiceAssemblyConnections(componentName);
    }

    public ManagementContext getManagementContext() {
        return this.mMgmtContext;
    }

    private void initJbiProperties(Properties jbiprops) {
        if (this.mEnv.getPlatformContext().isAdminServer()) {
            jbiprops.setProperty("com.sun.jbi.domain.root", this.mEnv.getPlatformContext().getInstanceRoot());
            String domainName = System.getProperty("com.sun.aas.domainName");
            if (domainName != null) {
                jbiprops.setProperty("com.sun.jbi.domain.name", domainName);
            }
        }
    }

    private void exportJbiProperties(Properties jbiprops) {
        Enumeration<?> e = jbiprops.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = jbiprops.getProperty(key);
            System.setProperty(key, value);
        }
    }

    private static boolean createAdminService(ManagementContext gv) {
        String thisService = "AdminService";
        AdminService svc = new AdminService(gv);
        ManagementContext.setAdminServiceHandle(svc);
        svc.bootstrap();
        return true;
    }

    private static boolean createDeploymentService(ManagementContext gv) throws JBIException {
        String thisService = "DeploymentService";
        DeploymentService svc = new DeploymentService(gv);
        ManagementContext.setDeploymentServiceHandle(svc);
        svc.bootstrap();
        return true;
    }

    private static boolean createInstallationService(ManagementContext gv) throws JBIException {
        String thisService = "InstallationService";
        InstallationService svc = new InstallationService(gv);
        ManagementContext.setInstallationServiceHandle(svc);
        svc.bootstrap();
        return true;
    }

    private static boolean createLoggingService(ManagementContext gv) {
        String thisService = "LoggingService";
        LoggingService svc = new LoggingService(gv);
        ManagementContext.setLoggingServiceHandle(svc);
        svc.bootstrap();
        return true;
    }
}

