/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.DeliveryChannelImpl;
import com.sun.jbi.messaging.DynamicEndpoint;
import com.sun.jbi.messaging.FaultImpl;
import com.sun.jbi.messaging.LinkedEndpoint;
import com.sun.jbi.messaging.MessageExchange;
import com.sun.jbi.messaging.MessageExchangeImpl;
import com.sun.jbi.messaging.MessageImpl;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.stats.METimestamps;
import com.sun.jbi.messaging.util.Translator;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

public abstract class MessageExchangeProxy
implements MessageExchange {
    public static final int SET_TRANSACTION = 1;
    public static final int ADDRESS = 2;
    public static final int SET_PROPERTY = 16;
    public static final int SET_FAULT = 32;
    public static final int SET_DONE = 64;
    public static final int SET_ERROR = 128;
    public static final int SET_IN = 4096;
    public static final int SET_OUT = 8192;
    public static final int CREATE_FAULT = 16384;
    public static final int DO_SENDSYNCH = 32768;
    public static final int DO_SEND = 65536;
    public static final int DO_ACCEPT = 131072;
    public static final int SUSPEND_TX = 0x100000;
    public static final int RESUME_TX = 0x200000;
    public static final int MARK_DONE = 0x400000;
    public static final int MARK_ACTIVE = 0x800000;
    public static final int COMPLETE = 0x1000000;
    public static final int CHECK_STATUS_OR_FAULT = 0x2000000;
    public static final int REQUEST = 0x4000000;
    public static final int STATUS = 0x8000000;
    public static final int ACTION_MASK = 0;
    public static final int ACTION_SEND = 1;
    public static final int ACTION_ACCEPT = 2;
    public static final int ACTION_STATUS = 3;
    public static final int ACTION_FAULT = 4;
    static final String IN_MSG = new String("in");
    static final String OUT_MSG = new String("out");
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private MessageExchangeImpl mMEI;
    private int[][] mState;
    private int mStateIndex;
    private MessageExchangeProxy mTwin;
    private DeliveryChannelImpl mSendChannel;
    private ServiceEndpoint mEndpointLink;
    private boolean mStatisticsEnabled;
    private int mSynchState;
    static final int NONE = 0;
    static final int WAIT = 1;
    static final int WAIT_TIMEOUT = 2;
    static final int HALF_DONE = 3;
    static final int DONE = 4;
    static final int ERROR = 5;
    private int mPhase;
    static final int PHASE_NONE = 0;
    static final int PHASE_DONE = 1;
    static final int PHASE_ERROR = 3;
    static final int PHASE_REQUEST = 4;
    static final int PHASE_REPLY = 5;
    static final int PHASE_FAULT = 6;
    private int mPhaseMask;
    static final int PM_SEND_DONE = 1;
    static final int PM_SEND_ERROR = 2;
    static final int PM_SEND_REQUEST = 4;
    static final int PM_SEND_REPLY = 8;
    static final int PM_SEND_FAULT = 16;
    static final int PM_RECEIVE_DONE = 256;
    static final int PM_RECEIVE_ERROR = 512;
    static final int PM_RECEIVE_REQUEST = 1024;
    static final int PM_RECEIVE_REPLY = 2048;
    static final int PM_RECEIVE_FAULT = 4096;

    MessageExchangeProxy(int[][] states) {
        this.mState = states;
        this.mStateIndex = 0;
        this.mSynchState = 0;
    }

    abstract MessageExchangeProxy newTwin();

    public String getExchangeId() {
        return this.mMEI.getExchangeId();
    }

    public ExchangeStatus getStatus() {
        return this.mMEI.getStatus();
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        boolean isDone = status.equals(ExchangeStatus.DONE);
        boolean isError = status.equals(ExchangeStatus.ERROR);
        if (isDone && this.can(64) || isError && this.can(128)) {
            if (isDone) {
                if (this.can(8192) && this.getMessage(OUT_MSG) != null) {
                    throw new MessagingException(Translator.translate("STATUS_ON_MSG", this.getPattern().toString()));
                }
                if (this.mMEI.getStatus().equals(ExchangeStatus.ERROR)) {
                    throw new MessagingException(Translator.translate("ERROR_STATUS"));
                }
            } else {
                this.mMEI.setMessage(null, OUT_MSG);
            }
            this.mMEI.setStatus(status);
            this.mPhase = isDone ? 1 : 3;
            this.mPhaseMask |= isDone ? 1 : 2;
            this.nextState(3);
            return;
        }
        throw new MessagingException(Translator.translate("PATTERN_INCONSISTENT", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex));
    }

    public Exception getError() {
        return this.mMEI.getError();
    }

    public void setError(Exception error) {
        this.mMEI.setMessage(null, OUT_MSG);
        this.mMEI.setStatus(ExchangeStatus.ERROR);
        this.mMEI.setError(error);
        this.mPhase = 3;
        this.mPhaseMask |= 2;
        this.nextState(3);
    }

    public Fault getFault() {
        return this.mMEI.getFault();
    }

    public void setFault(Fault fault) throws MessagingException {
        if (!this.can(32)) {
            throw new MessagingException(Translator.translate("FAULT_NOT_SUPPORTED", this.getPattern().toString()));
        }
        if (this.can(4096) && this.getMessage(IN_MSG) != null || this.can(8192) && this.getMessage(OUT_MSG) != null) {
            throw new MessagingException(Translator.translate("FAULT_ON_MSG", this.getPattern().toString()));
        }
        this.mMEI.setFault(fault);
        this.mPhase = 6;
        this.mPhaseMask |= 0x10;
        this.nextState(4);
    }

    public ServiceEndpoint getEndpoint() {
        if (this.mEndpointLink != null && this.getRole().equals(MessageExchange.Role.CONSUMER)) {
            return this.mEndpointLink;
        }
        ServiceEndpoint se = this.mMEI.getEndpoint();
        RegisteredEndpoint re = (RegisteredEndpoint)se;
        if (re != null && this.getRole().equals(MessageExchange.Role.PROVIDER) && re.isDynamic()) {
            se = ((DynamicEndpoint)re).getDelegate();
        }
        return se;
    }

    public void setEndpoint(ServiceEndpoint endPoint) {
        if (this.can(2)) {
            this.mMEI.setEndpoint(endPoint);
        }
    }

    public ServiceEndpoint getActualEndpoint() {
        return this.mMEI.getEndpoint();
    }

    public QName getService() {
        return this.mMEI.getService();
    }

    public void setService(QName service) {
        if (this.can(2)) {
            this.mMEI.setService(service);
        }
    }

    public QName getOperation() {
        return this.mMEI.getOperation();
    }

    public void setOperation(QName operation) {
        if (this.can(2)) {
            this.mMEI.setOperation(operation);
        }
    }

    public QName getInterfaceName() {
        return this.mMEI.getInterfaceName();
    }

    public void setInterfaceName(QName interfaceName) {
        if (this.can(2)) {
            this.mMEI.setInterfaceName(interfaceName);
        }
    }

    public NormalizedMessage getMessage(String name) {
        return this.mMEI.getMessage(name);
    }

    public void setMessage(NormalizedMessage message, String name) throws MessagingException {
        if (this.can(4096) && name.equals(IN_MSG) || this.can(8192) && name.equals(OUT_MSG)) {
            this.mMEI.setMessage(message, name);
            if (name.equals(IN_MSG)) {
                this.mPhase = 4;
                this.mPhaseMask |= 4;
            } else {
                this.mPhase = 5;
                this.mPhaseMask |= 8;
            }
        } else {
            throw new MessagingException(Translator.translate("PATTERN_INCONSISTENT", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex));
        }
    }

    public Object getProperty(String name) {
        return this.mMEI.getProperty(name);
    }

    public void setProperty(String name, Object object) {
        if (this.can(16)) {
            if (name.equals("javax.jbi.transaction.jta")) {
                if (this.can(1)) {
                    this.mMEI.setProperty(name, object);
                }
            } else {
                this.mMEI.setProperty(name, object);
            }
        }
    }

    public Set getPropertyNames() {
        return this.mMEI.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        return (this.mState[0][0] & 0x20000) == 0 ? MessageExchange.Role.CONSUMER : MessageExchange.Role.PROVIDER;
    }

    public String getSourceComponent() {
        DeliveryChannelImpl dc = this.mSendChannel;
        if ((this.mState[0][0] & 0x20000) != 0) {
            dc = this.mTwin.mSendChannel;
        }
        return dc.getChannelId();
    }

    public String getTargetComponent() {
        DeliveryChannelImpl dc = this.mSendChannel;
        if ((this.mState[0][0] & 0x20000) == 0) {
            dc = this.mTwin.mSendChannel;
        }
        return dc.getChannelId();
    }

    public boolean isTransacted() {
        return this.mMEI.isTransacted();
    }

    public Fault createFault() throws MessagingException {
        if (!this.can(16384)) {
            throw new MessagingException(Translator.translate("FAULT_NOT_SUPPORTED", this.getPattern().toString()));
        }
        return new FaultImpl();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new MessageImpl();
    }

    void setTwin(MessageExchangeProxy mep) {
        this.mTwin = mep;
    }

    MessageExchangeProxy getTwin() {
        return this.mTwin;
    }

    void setSynchState(int state) {
        this.mSynchState = state;
    }

    int getSynchState() {
        return this.mSynchState;
    }

    public int getPhase() {
        int phase = this.mPhase;
        this.mPhase = 0;
        return phase;
    }

    public int getPhaseMask() {
        return this.mPhaseMask;
    }

    void setMessageExchange(MessageExchangeImpl me, boolean statsEnabled) {
        this.mMEI = me;
        this.mStatisticsEnabled = statsEnabled;
    }

    MessageExchangeImpl getMessageExchange() {
        return this.mMEI;
    }

    boolean isSource() {
        return this == this.mMEI.getSource();
    }

    void validate(DeliveryChannelImpl channel, boolean isSynch) throws MessagingException {
        String message = null;
        if (this.mSendChannel == null) {
            ServiceEndpoint endpoint = this.getActualEndpoint();
            if (endpoint == null) {
                message = Translator.translate("ADDR_NO_ENDPOINT");
            } else if (!((RegisteredEndpoint)endpoint).isActive()) {
                message = Translator.translate("INACTIVE_ENDPOINT", endpoint.getServiceName(), endpoint.getEndpointName());
            }
        }
        if (message == null) {
            if (!this.can(65536)) {
                message = Translator.translate("SEND_NOT_LEGAL", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex);
            } else if (isSynch && !this.can(32768)) {
                message = Translator.translate("SENDSYNCH_NOT_LEGAL", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex);
            }
        }
        if (message != null) {
            throw new MessagingException(message);
        }
        if (this.mSendChannel == null) {
            this.setupChannels(channel);
        }
    }

    private void setupChannels(DeliveryChannelImpl dc) throws MessagingException {
        boolean invertedTwin = false;
        RegisteredEndpoint endpoint = (RegisteredEndpoint)this.mMEI.getEndpoint();
        String target = endpoint.getOwnerId();
        DeliveryChannelImpl targetDc = dc.getChannel(target);
        if (targetDc == null) {
            throw new MessagingException(Translator.translate("INVALID_DESTINATION"));
        }
        this.bindChannels(dc, targetDc);
    }

    DeliveryChannelImpl getSendChannel() {
        return this.mSendChannel;
    }

    void bindChannels(DeliveryChannelImpl source, DeliveryChannelImpl target) {
        MessageExchangeProxy twin = this.newTwin();
        twin.setMessageExchange(this.mMEI, this.mStatisticsEnabled);
        twin.mTwin = this;
        this.mTwin = twin;
        this.mTwin.mSendChannel = source;
        this.mSendChannel = target;
    }

    private boolean can(int operation) {
        return this.mStateIndex >= 0 && (this.mState[this.mStateIndex][0] & operation) != 0;
    }

    public synchronized boolean terminate() {
        boolean terminated = true;
        if (this.can(128)) {
            this.mStateIndex = this.mState[this.mStateIndex][3];
            this.mMEI.setStatus(ExchangeStatus.ERROR);
            terminated = !this.can(65536);
        } else if (this.can(131072)) {
            this.mMEI.setStatus(ExchangeStatus.ERROR);
            while (!this.can(0x400000)) {
                if (this.can(65536)) {
                    terminated = false;
                    break;
                }
                ++this.mStateIndex;
            }
        }
        while (!this.can(0x400000)) {
            ++this.mStateIndex;
        }
        if (this.mSynchState == 1 || this.mSynchState == 2) {
            this.notify();
            terminated = true;
        }
        if (terminated) {
            this.mSynchState = 5;
        }
        return terminated;
    }

    private void nextState(int state) {
        int newStateIndex = this.mState[this.mStateIndex][state];
        if (newStateIndex <= 0) {
            throw new IllegalStateException(Translator.translate("ILLEGAL_STATE_CHANGE", this.getPattern().toString(), this == this.mMEI.getSource() ? Translator.translate("SOURCE") : Translator.translate("TARGET"), this.mStateIndex));
        }
        this.mStateIndex = newStateIndex;
    }

    boolean handleAccept(DeliveryChannelImpl channel) throws MessagingException {
        this.mSynchState = 0;
        if (channel.isTransactional() && this.can(0x200000)) {
            this.mMEI.resumeTX();
        }
        if (this.can(0x2000000)) {
            if (this.getFault() != null) {
                this.mPhase = 6;
                this.mPhaseMask |= 0x1000;
                this.nextState(4);
            } else if (!this.getStatus().equals(ExchangeStatus.ACTIVE)) {
                if (this.getStatus().equals(ExchangeStatus.DONE)) {
                    this.mPhase = 1;
                    this.mPhaseMask |= 0x100;
                } else {
                    this.mPhase = 3;
                    this.mPhaseMask |= 0x200;
                }
                this.nextState(3);
            } else {
                this.mPhase = 5;
                this.mPhaseMask |= 0x800;
                this.nextState(2);
            }
        } else {
            if (this.can(0x4000000)) {
                this.mPhase = 4;
                this.mPhaseMask |= 0x400;
            } else if (this.can(0x8000000)) {
                if (this.getStatus().equals(ExchangeStatus.DONE)) {
                    this.mPhase = 1;
                    this.mPhaseMask |= 0x100;
                } else {
                    this.mPhase = 3;
                    this.mPhaseMask |= 0x200;
                }
            }
            this.nextState(2);
        }
        return this.can(0x400000);
    }

    void setEndpointLink(ServiceEndpoint se) {
        this.mEndpointLink = se;
    }

    ServiceEndpoint getEndpointLink() {
        return this.mEndpointLink;
    }

    boolean handleSend(DeliveryChannelImpl channel) throws MessagingException {
        this.mSynchState = 0;
        if (channel.isTransactional() && this.can(0x100000)) {
            this.mMEI.suspendTX();
        }
        this.nextState(1);
        if (this.can(0x800000)) {
            this.mMEI.setStatus(ExchangeStatus.ACTIVE);
        }
        this.mMEI.setSyncProperty(false);
        return this.can(0x400000);
    }

    void handleSendSync(DeliveryChannelImpl channel) throws MessagingException {
        this.mSynchState = 0;
        if (channel.isTransactional() && this.can(0x100000)) {
            this.mMEI.suspendTX();
        }
        this.nextState(1);
        if (this.can(0x800000)) {
            this.mMEI.setStatus(ExchangeStatus.ACTIVE);
        }
        this.mMEI.setSyncProperty(true);
    }

    void beforeCapabilityCheck(ServiceEndpoint se) {
        this.mStateIndex = -1;
        this.mMEI.setEndpoint(se);
    }

    void afterCapabilityCheck() {
        this.mStateIndex = 0;
        this.mMEI.setEndpoint(null);
    }

    public boolean isRemoteInvocation() {
        return this.mMEI.isRemote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTimeout() {
        boolean timedout = false;
        MessageExchangeProxy messageExchangeProxy = this;
        synchronized (messageExchangeProxy) {
            if (this.mSynchState == 0) {
                this.mSynchState = 5;
                timedout = true;
            }
        }
        return timedout;
    }

    public Set getDeltaProperties() {
        return this.mMEI.getDeltaProperties();
    }

    public void mergeProperties() {
        this.mMEI.mergeProperties();
    }

    void setInUse(String ownerId) {
        if (this.getRole().equals(MessageExchange.Role.CONSUMER)) {
            if (this.mEndpointLink != null) {
                ((LinkedEndpoint)this.mEndpointLink).setInUse(ownerId);
            }
        } else {
            ((RegisteredEndpoint)this.mMEI.getEndpoint()).setInUse();
        }
    }

    void resetInUse() {
        if (this.getRole().equals(MessageExchange.Role.CONSUMER)) {
            if (this.mEndpointLink != null) {
                ((RegisteredEndpoint)this.mEndpointLink).resetInUse();
            }
        } else {
            ((RegisteredEndpoint)this.mMEI.getEndpoint()).resetInUse();
        }
    }

    boolean capture(byte consumerTag, byte providerTag) {
        if (this.mStatisticsEnabled) {
            this.mMEI.capture((this.mState[0][0] & 0x20000) == 0 ? consumerTag : providerTag);
        }
        return this.can(0x1000000);
    }

    void updateStatistics() {
        boolean isConsumer;
        METimestamps ts = this.mMEI.getTimestamps();
        boolean bl = isConsumer = (this.mState[0][0] & 0x20000) == 0;
        if (ts != null) {
            ts.compute();
            if (isConsumer) {
                this.mSendChannel.updateProviderStatistics(ts);
                this.mTwin.mSendChannel.updateConsumerStatistics(ts);
            } else {
                this.mSendChannel.updateConsumerStatistics(ts);
                this.mTwin.mSendChannel.updateProviderStatistics(ts);
            }
        }
        if (isConsumer) {
            if (this.mEndpointLink != null) {
                ((RegisteredEndpoint)this.mEndpointLink).updateStatistics(this);
            }
            ((RegisteredEndpoint)this.mMEI.getEndpoint()).updateStatistics(this.mTwin);
        } else {
            if (this.mTwin.mEndpointLink != null) {
                ((RegisteredEndpoint)this.mTwin.mEndpointLink).updateStatistics(this.mTwin);
            }
            ((RegisteredEndpoint)this.mMEI.getEndpoint()).updateStatistics(this);
        }
        this.mSendChannel = null;
        this.mTwin.mSendChannel = null;
        this.mTwin.mTwin = null;
        this.mTwin = null;
    }

    METimestamps getTimestamps() {
        return this.mMEI.getTimestamps();
    }

    String getSummary() {
        String provider;
        String consumer;
        StringBuilder sb = new StringBuilder();
        MessageExchangeProxy c = null;
        MessageExchangeProxy p = null;
        ServiceEndpoint se = this.mMEI.getEndpoint();
        String service = "null";
        String operation = "null";
        if (this.getRole().equals(MessageExchange.Role.CONSUMER)) {
            c = this;
            p = this.mTwin;
            consumer = this.mTwin == null || this.mTwin.mSendChannel == null ? "Null" : this.mTwin.mSendChannel.getChannelId();
            provider = this.mSendChannel == null ? "Null" : this.mSendChannel.getChannelId();
        } else {
            p = this;
            c = this.mTwin;
            consumer = this.mSendChannel == null ? "Null" : this.mSendChannel.getChannelId();
            String string = provider = this.mTwin == null || this.mTwin.mSendChannel == null ? "Null" : this.mTwin.mSendChannel.getChannelId();
        }
        if (se != null && se.getServiceName() != null && se.getServiceName().getLocalPart() != null) {
            service = se.getServiceName().getLocalPart();
        }
        if (this.mMEI.getOperation() != null && this.mMEI.getOperation().getLocalPart() != null) {
            operation = this.mMEI.getOperation().getLocalPart();
        }
        sb.append(consumer + this.mepState(c) + " -> " + provider + this.mepState(p) + " (" + service + ")(" + operation + ")");
        return sb.toString();
    }

    String mepState(MessageExchangeProxy mep) {
        String result = "[?]";
        if (mep != null) {
            result = (mep.mState[mep.mStateIndex][0] & 0x20000) != 0 ? "[ACCEPT]" : ((mep.mState[mep.mStateIndex][0] & 0x400000) != 0 ? "[DONE]" : "[RUN]");
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("      ExchangeId: ");
        sb.append(this.mMEI.getExchangeId());
        sb.append("\n        Pattern: ");
        sb.append(this.getPattern());
        sb.append("\n        Role: " + this.getRole().toString() + "\n");
        if (this.getRole().equals(MessageExchange.Role.CONSUMER)) {
            sb.append("        Consumer: " + (this.mTwin == null || this.mTwin.mSendChannel == null ? "Null" : this.mTwin.mSendChannel.getChannelId()));
            sb.append("\n        Provider: " + (this.mSendChannel == null ? "Null" : this.mSendChannel.getChannelId()) + "\n");
        } else {
            sb.append("\n        Provider: " + (this.mTwin == null || this.mTwin.mSendChannel == null ? "Null" : this.mTwin.mSendChannel.getChannelId()) + "\n");
            sb.append("        Consumer: " + (this.mSendChannel == null ? "Null" : this.mSendChannel.getChannelId()));
        }
        sb.append("        Index: ");
        sb.append(this.mStateIndex);
        sb.append("  SynchState: ");
        sb.append(this.mSynchState == 0 ? "NONE" : (this.mSynchState == 1 ? "WAIT" : (this.mSynchState == 2 ? "WAIT_TIMEOUT" : (this.mSynchState == 3 ? "HALF_DONE" : (this.mSynchState == 4 ? "DONE" : "ERROR")))));
        sb.append("\n        EndpointLink: ");
        sb.append(this.mEndpointLink == null ? "Null" : ((RegisteredEndpoint)this.mEndpointLink).toExternalName());
        sb.append(this.mMEI.toString());
        return sb.toString();
    }
}

