/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.EndpointReference;
import com.sun.jbi.messaging.EndpointRegistry;
import com.sun.jbi.messaging.EndpointStatistics;
import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.stats.METimestamps;
import com.sun.jbi.messaging.stats.Value;
import com.sun.jbi.messaging.util.WSDLHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class RegisteredEndpoint
implements ServiceEndpoint,
EndpointStatistics {
    public static final int DYNAMIC = 10;
    public static final int INTERNAL = 20;
    public static final int EXTERNAL = 30;
    public static final int LINKED = 40;
    private QName mService;
    private String mEndpoint;
    String mOwnerId;
    private boolean mActive;
    private HashMap mOperations;
    private QName[] mInterfaces;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    long mActivationTimestamp;
    AtomicLong mActiveExchanges;
    long mSendRequest;
    long mReceiveReply;
    long mReceiveRequest;
    long mSendReply;
    long mSendFault;
    long mReceiveFault;
    long mLastFaultTime;
    long mSendDONE;
    long mLastDONETime;
    long mReceiveDONE;
    long mSendERROR;
    long mLastERRORTime;
    long mReceiveERROR;
    Value mResponseTime;
    Value mChannelTime;
    Value mNMRTime;
    Value mComponentTime;
    Value mStatusTime;
    private static final int ITEMS_BASE = 14;
    private static final int ITEMS_EXTRA = 16;
    private static final String[] ITEM_NAMES = new String[]{"OwningChannel", "ActivationTimestamp", "ActiveExchanges", "ReceiveRequest", "SendReply", "SendFault", "ReceiveFault", "LastFaultTime", "SendDONE", "ReceiveDONE", "LastDONETime", "SendERROR", "ReceiveERROR", "LastERRORTime", "ResponseTimeMin (ns)", "ResponseTimeAvg (ns)", "ResponseTimeMax (ns)", "ResponseTimeStd (ns)", "NMRTimeMin (ns)", "NMRTimeAvg (ns)", "NMRTimeMax (ns)", "NMRTimeStd (ns)", "ComponentTimeMin (ns)", "ComponentTimeAvg (ns)", "ComponentTimeMax (ns)", "ComponentTimeStd (ns)", "ChannelTimeMin (ns)", "ChannelTimeAvg (ns)", "ChannelTimeMax (ns)", "ChannelTimeStd (ns)"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"Owning DeliveryChannel", "Activation Timestamp (ms)", "Active Exchanges", "Number of requests received", "Number of replies sent", "Number of faults sent", "Number of faults received", "Timestamp of last fault", "Number of DONE requests sent", "Number of DONE requests received", "Timestamp of last DONE", "Number of ERROR requests sent", "Number of ERROR requests received", "Timestamp of last ERROR", "Response Time Min", "Response Time Avg", "Response Time Max", "Response Time Std", "NMR Time Min", "NMR Time Avg", "NMR Time Max", "NMR Time Std", "Component Time Min", "Component Time Avg", "Component Time Max", "Component Time Std", "Channel Time Min", "Channel Time Avg", "Channel Time Max", "Channel Time Std"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};

    public RegisteredEndpoint(QName service, String endpoint, String ownerId) {
        this.mOwnerId = ownerId;
        this.mService = service;
        this.mEndpoint = endpoint;
        this.mActive = true;
        this.mResponseTime = new Value();
        this.mNMRTime = new Value();
        this.mComponentTime = new Value();
        this.mChannelTime = new Value();
        this.mStatusTime = new Value();
        this.mActivationTimestamp = System.currentTimeMillis();
        this.mActiveExchanges = new AtomicLong();
    }

    public String getEndpointName() {
        return this.mEndpoint;
    }

    public QName getServiceName() {
        return this.mService;
    }

    public String getOwnerId() {
        return this.mOwnerId;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public abstract int getType();

    public void setActive(boolean isActive) {
        this.mActive = isActive;
    }

    public HashMap getOperations() {
        return this.mOperations;
    }

    public void setOperations(HashMap map) {
        this.mOperations = map;
    }

    public QName[] getInterfaces() {
        if (this.mInterfaces == null) {
            EndpointRegistry.getInstance().getInterfacesForEndpoint(this);
        }
        return this.mInterfaces;
    }

    public QName[] getInterfacesInternal() {
        return this.mInterfaces;
    }

    public void setInterfaces(QName[] interfaces) {
        this.mInterfaces = interfaces;
    }

    public boolean isInternal() {
        return this.getType() == 20;
    }

    public boolean isExternal() {
        return this.getType() == 30;
    }

    public boolean isLinked() {
        return this.getType() == 40;
    }

    public boolean isDynamic() {
        return this.getType() == 10;
    }

    public boolean implementsInterface(QName interfaceName) {
        boolean implemented = false;
        for (QName in : this.getInterfaces()) {
            if (!in.equals(interfaceName)) continue;
            implemented = true;
            break;
        }
        return implemented;
    }

    public void parseDescriptor(Document descriptor) throws MessagingException {
        if (descriptor != null) {
            this.mOperations = WSDLHelper.getOperationsForService(descriptor, this.mService);
            this.mInterfaces = WSDLHelper.getInterfacesForService(descriptor, this.mService);
        } else {
            this.mInterfaces = new QName[0];
            this.mOperations = new HashMap();
        }
    }

    public DocumentFragment getAsReference(QName operationName) {
        DocumentFragment doc = null;
        try {
            doc = EndpointReference.asReference(this);
        }
        catch (MessagingException msgEx) {
            this.mLog.warning(msgEx.toString());
        }
        return doc;
    }

    public void setInUse() {
        this.mActiveExchanges.incrementAndGet();
    }

    public void resetInUse() {
        this.mActiveExchanges.decrementAndGet();
    }

    synchronized void updateStatistics(MessageExchangeProxy me) {
        int mask = me.getPhaseMask();
        METimestamps ts = me.getTimestamps();
        if ((mask & 8) != 0) {
            ++this.mSendReply;
        }
        if ((mask & 0x10) != 0) {
            ++this.mSendFault;
            this.mLastFaultTime = System.currentTimeMillis();
        }
        if ((mask & 1) != 0) {
            ++this.mSendDONE;
            this.mLastDONETime = System.currentTimeMillis();
        }
        if ((mask & 2) != 0) {
            ++this.mSendERROR;
            this.mLastERRORTime = System.currentTimeMillis();
        }
        if ((mask & 0x400) != 0) {
            ++this.mReceiveRequest;
        }
        if ((mask & 0x1000) != 0) {
            ++this.mReceiveFault;
            this.mLastFaultTime = System.currentTimeMillis();
        }
        if ((mask & 0x100) != 0) {
            ++this.mReceiveDONE;
            this.mLastDONETime = System.currentTimeMillis();
        }
        if ((mask & 0x200) != 0) {
            ++this.mReceiveERROR;
            this.mLastERRORTime = System.currentTimeMillis();
        }
        if (ts != null) {
            this.mResponseTime.addSample(ts.mResponseTime);
            this.mNMRTime.addSample(ts.mNMRTime);
            this.mChannelTime.addSample(ts.mProviderChannelTime);
            this.mComponentTime.addSample(ts.mProviderTime);
        }
    }

    synchronized void zeroStatistics() {
        this.mSendRequest = 0L;
        this.mReceiveReply = 0L;
        this.mReceiveRequest = 0L;
        this.mSendReply = 0L;
        this.mSendFault = 0L;
        this.mReceiveFault = 0L;
        this.mLastFaultTime = 0L;
        this.mSendDONE = 0L;
        this.mLastDONETime = 0L;
        this.mReceiveDONE = 0L;
        this.mSendERROR = 0L;
        this.mLastERRORTime = 0L;
        this.mReceiveERROR = 0L;
        this.mResponseTime.zero();
        this.mChannelTime.zero();
        this.mNMRTime.zero();
        this.mComponentTime.zero();
        this.mStatusTime.zero();
    }

    public String getName() {
        return this.toExternalName();
    }

    public CompositeData getStatistics() {
        try {
            String[] descs;
            String[] names;
            OpenType[] types;
            Object[] values;
            boolean enabled;
            boolean bl = enabled = this.mChannelTime.getCount() != 0L;
            if (enabled) {
                values = new Object[30];
                types = ITEM_TYPES;
                names = ITEM_NAMES;
                descs = ITEM_DESCRIPTIONS;
            } else {
                values = new Object[14];
                types = new OpenType[14];
                System.arraycopy(ITEM_TYPES, 0, types, 0, 14);
                names = new String[14];
                System.arraycopy(ITEM_NAMES, 0, names, 0, 14);
                descs = new String[14];
                System.arraycopy(ITEM_DESCRIPTIONS, 0, descs, 0, 14);
            }
            values[0] = this.mOwnerId;
            values[1] = this.mActivationTimestamp;
            values[2] = this.mActiveExchanges.get();
            values[3] = this.mReceiveRequest;
            values[4] = this.mSendReply;
            values[5] = this.mSendFault;
            values[6] = this.mReceiveFault;
            values[7] = this.mLastFaultTime;
            values[8] = this.mSendDONE;
            values[9] = this.mReceiveDONE;
            values[10] = this.mLastDONETime;
            values[11] = this.mSendERROR;
            values[12] = this.mReceiveERROR;
            values[13] = this.mLastERRORTime;
            if (enabled) {
                values[14] = this.mResponseTime.getMin();
                values[15] = (long)this.mResponseTime.getAverage();
                values[16] = this.mResponseTime.getMax();
                values[17] = (long)this.mResponseTime.getSd();
                values[18] = this.mNMRTime.getMin();
                values[19] = (long)this.mNMRTime.getAverage();
                values[20] = this.mNMRTime.getMax();
                values[21] = (long)this.mNMRTime.getSd();
                values[22] = this.mComponentTime.getMin();
                values[23] = (long)this.mComponentTime.getAverage();
                values[24] = this.mComponentTime.getMax();
                values[25] = (long)this.mComponentTime.getSd();
                values[26] = this.mChannelTime.getMin();
                values[27] = (long)this.mChannelTime.getAverage();
                values[28] = this.mChannelTime.getMax();
                values[29] = (long)this.mChannelTime.getSd();
            }
            return new CompositeDataSupport(new CompositeType("EndpointStatistics", "Endpoint statistics", names, descs, types), names, values);
        }
        catch (OpenDataException openDataException) {
            return null;
        }
    }

    public int hashCode() {
        return this.mService.hashCode() ^ this.mEndpoint.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && this.getClass() == obj.getClass()) {
            RegisteredEndpoint target = (RegisteredEndpoint)obj;
            if (target.mService.equals(this.mService) && target.mEndpoint.equals(this.mEndpoint)) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public String toExternalName() {
        StringBuilder sb = new StringBuilder();
        if (this.mService.getNamespaceURI() != null) {
            sb.append(this.mService.getNamespaceURI());
            sb.append(",");
        }
        sb.append(this.mService.getLocalPart().toString());
        sb.append(",");
        sb.append(this.mEndpoint);
        return sb.toString();
    }

    public String toStringBrief() {
        StringBuilder sb = new StringBuilder();
        sb.append("          Owner:     ");
        sb.append(this.mOwnerId);
        sb.append("  Active: ");
        sb.append(this.mActive ? "True" : "False");
        sb.append("  Exchanges: " + this.mActiveExchanges.get());
        sb.append("\n          Service :  ");
        sb.append(this.mService);
        sb.append("\n          Endpoint:  ");
        sb.append(this.mEndpoint);
        if (this.mLastDONETime != 0L) {
            sb.append("\n            LastDoneTime  : " + new Date(this.mLastDONETime).toString());
        }
        if (this.mLastERRORTime != 0L) {
            sb.append("\n            LastErrorTime : " + new Date(this.mLastERRORTime).toString());
        }
        if (this.mLastFaultTime != 0L) {
            sb.append("\n            LastFaultTime : " + new Date(this.mLastFaultTime).toString());
        }
        sb.append("\n");
        if (this.mOperations != null) {
            sb.append("          Operations Count: ");
            sb.append(this.mOperations.size());
            sb.append("\n");
            Iterator i = this.mOperations.values().iterator();
            while (i.hasNext()) {
                sb.append("            ");
                sb.append(i.next().toString());
                sb.append("\n");
            }
        }
        if (this.mInterfaces != null) {
            sb.append("          Interfaces Count: ");
            sb.append(this.mInterfaces.length);
            sb.append("\n");
            for (int i = 0; i < this.mInterfaces.length; ++i) {
                sb.append("            ");
                sb.append(this.mInterfaces[i].toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringBrief());
        sb.append("            RecvRequest: " + this.mReceiveRequest);
        sb.append("  SendReply: " + this.mSendReply);
        sb.append("\n            RecvDONE: " + this.mReceiveDONE);
        sb.append("  SendDONE: " + this.mSendDONE);
        sb.append("\n            RecvERROR: " + this.mReceiveERROR);
        sb.append("  SendERROR: " + this.mSendERROR);
        sb.append("\n            RecvFault: " + this.mReceiveFault);
        sb.append("  SendFault: " + this.mSendFault);
        sb.append("\n");
        if (this.mChannelTime.getCount() != 0L) {
            sb.append("            ResponseTime:  " + this.mResponseTime.toString());
            sb.append("\n            ComponentTime: " + this.mComponentTime.toString());
            sb.append("\n            ChannelTime:   " + this.mChannelTime.toString());
            sb.append("\n            NMRTime:       " + this.mNMRTime.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

