/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.jbi.ui.client.ConnectionType;
import com.sun.jbi.ui.client.JBIAdminCommandsClientImpl;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIAdminCommandsClientFactory {
    private static I18NBundle sI18NBundle = null;

    private JBIAdminCommandsClientFactory() {
    }

    protected static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.client");
        }
        return sI18NBundle;
    }

    static Exception createManagementException(String bundleKey, String[] args, Exception sourceException) {
        Exception exception = null;
        String xmlManagementMessage = JBIResultXmlBuilder.createJbiResultXml(JBIAdminCommandsClientFactory.getI18NBundle(), bundleKey, args, sourceException);
        exception = new Exception(xmlManagementMessage);
        return exception;
    }

    public static JBIAdminCommands getInstance(String hostName, int portNumber, String userName, String password, ConnectionType connectionType) throws JBIRemoteException {
        JBIAdminCommandsClientFactory factory = new JBIAdminCommandsClientFactory();
        JBIAdminCommandsClientImpl commands = null;
        MBeanServerConnection connection = null;
        try {
            connection = factory.getMBeanServerConnection(hostName, portNumber, userName, password, connectionType);
        }
        catch (JBIRemoteException rEx) {
            throw rEx;
        }
        catch (Exception e) {
            String[] args = new String[]{hostName, new Integer(portNumber).toString(), userName, connectionType.getProtocol()};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection.host.port.uname.password.protocol", args, e);
            throw new JBIRemoteException(exception);
        }
        boolean isLocalHost = false;
        try {
            isLocalHost = Util.isLocalHost(hostName);
        }
        catch (UnknownHostException e) {
            String[] args = new String[]{hostName};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection.unknown.host", args, null);
            throw new JBIRemoteException(exception);
        }
        commands = isLocalHost ? new JBIAdminCommandsClientImpl(connection, false) : new JBIAdminCommandsClientImpl(connection, true);
        return commands;
    }

    public static JBIAdminCommands getInstance(String url, String userName, String password, boolean isRemoteConnection) throws JBIRemoteException {
        JBIAdminCommandsClientFactory factory = new JBIAdminCommandsClientFactory();
        JBIAdminCommandsClientImpl commands = null;
        MBeanServerConnection connection = null;
        try {
            connection = factory.getMBeanServerConnection(url, userName, password);
        }
        catch (JBIRemoteException rEx) {
            throw rEx;
        }
        catch (Exception e) {
            String[] args = new String[]{url, userName};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection.url.uname.password", args, e);
            throw new JBIRemoteException(exception);
        }
        commands = new JBIAdminCommandsClientImpl(connection, isRemoteConnection);
        return commands;
    }

    public static JBIAdminCommands getInstance(String hostName, int portNumber, String userName, String password) throws JBIRemoteException {
        JBIAdminCommandsClientFactory factory = new JBIAdminCommandsClientFactory();
        JBIAdminCommandsClientImpl commands = null;
        MBeanServerConnection connection = null;
        boolean result = false;
        ObjectName mbeanName = null;
        Exception exceptionArgument = null;
        try {
            connection = factory.getMBeanServerConnection(hostName, portNumber, userName, password, ConnectionType.HTTP);
            mbeanName = JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName();
            result = connection.isRegistered(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            connection = null;
            exceptionArgument = e;
        }
        catch (IOException e) {
            connection = null;
            exceptionArgument = e;
        }
        catch (RuntimeException runtimeException) {
            connection = null;
            exceptionArgument = runtimeException;
        }
        catch (Exception e) {
            connection = null;
            exceptionArgument = e;
        }
        if (connection == null) {
            try {
                connection = factory.getMBeanServerConnection(hostName, portNumber, userName, password, ConnectionType.HTTPS);
                mbeanName = JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName();
                result = connection.isRegistered(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                connection = null;
                exceptionArgument = e;
            }
            catch (IOException e) {
                connection = null;
                exceptionArgument = e;
            }
            catch (RuntimeException runtimeException) {
                connection = null;
                exceptionArgument = runtimeException;
            }
            catch (Exception e) {
                connection = null;
                exceptionArgument = e;
            }
        }
        if (connection == null) {
            try {
                connection = factory.getMBeanServerConnection(hostName, portNumber, userName, password, ConnectionType.JRMP);
                mbeanName = JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName();
                result = connection.isRegistered(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                connection = null;
                exceptionArgument = e;
            }
            catch (IOException e) {
                connection = null;
                exceptionArgument = e;
            }
            catch (RuntimeException runtimeException) {
                connection = null;
                exceptionArgument = runtimeException;
            }
            catch (Exception e) {
                connection = null;
                exceptionArgument = e;
            }
        }
        if (connection == null) {
            PrintStream oldErr = System.err;
            try {
                PrintStream newErr = new PrintStream(new ByteArrayOutputStream());
                System.setErr(newErr);
                connection = factory.getMBeanServerConnection(hostName, portNumber, userName, password, ConnectionType.IIOP);
                mbeanName = JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName();
                result = connection.isRegistered(mbeanName);
                newErr.close();
            }
            catch (MalformedObjectNameException e) {
                connection = null;
                exceptionArgument = e;
            }
            catch (IOException e) {
                connection = null;
                exceptionArgument = e;
            }
            catch (RuntimeException runtimeException) {
                connection = null;
                exceptionArgument = runtimeException;
            }
            catch (Exception e) {
                connection = null;
                exceptionArgument = e;
            }
            System.setErr(oldErr);
        }
        boolean isLocalHost = false;
        try {
            isLocalHost = Util.isLocalHost(hostName);
        }
        catch (UnknownHostException e) {
            String[] args = new String[]{hostName};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection.unknown.host", args, null);
            throw new JBIRemoteException(exception);
        }
        if (connection != null) {
            commands = isLocalHost ? new JBIAdminCommandsClientImpl(connection, false) : new JBIAdminCommandsClientImpl(connection, true);
        } else {
            String[] args = new String[]{hostName, Integer.valueOf(portNumber).toString(), userName};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.connection.failure", args, null);
            throw new JBIRemoteException(exception);
        }
        return commands;
    }

    public static JBIAdminCommands getInstance(MBeanServerConnection connection) throws JBIRemoteException {
        JBIAdminCommandsClientImpl commands = null;
        if (connection == null) {
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection", null, null);
            throw new JBIRemoteException(exception);
        }
        commands = new JBIAdminCommandsClientImpl(connection, true);
        return commands;
    }

    public static JBIAdminCommands getInstance(MBeanServerConnection connection, boolean isRemoteConnection) throws JBIRemoteException {
        JBIAdminCommandsClientImpl commands = null;
        if (connection == null) {
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection", null, null);
            throw new JBIRemoteException(exception);
        }
        commands = new JBIAdminCommandsClientImpl(connection, isRemoteConnection);
        return commands;
    }

    protected MBeanServerConnection getMBeanServerConnection(String urlString, String userName, String password) throws JBIRemoteException {
        try {
            JMXServiceURL url = new JMXServiceURL(urlString);
            String[] credentials = new String[]{userName, password};
            HashMap<String, String[]> environment = new HashMap<String, String[]>();
            environment.put("jmx.remote.credentials", credentials);
            JMXConnector connector = JMXConnectorFactory.connect(url, environment);
            return connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            String[] args = new String[]{urlString, userName};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection.url.uname.password", args, e);
            throw new JBIRemoteException(exception);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection(String hostName, int portNumber, String userName, String password, ConnectionType type) throws JBIRemoteException {
        try {
            if (type == ConnectionType.JRMP) {
                String urlString = "service:jmx:rmi:///jndi/rmi://" + hostName + ":" + portNumber + "/jmxrmi";
                return this.getMBeanServerConnection(urlString, userName, password);
            }
            if (type == ConnectionType.IIOP) {
                String urlString = "service:jmx:iiop://" + hostName + ":" + portNumber + "/jndi/JMXConnector";
                return this.getMBeanServerConnection(urlString, userName, password);
            }
            JMXServiceURL url = new JMXServiceURL(type.getProtocol(), hostName, portNumber);
            JMXConnector connector = JMXConnectorFactory.connect(url, this.initEnvironment(userName, password));
            return connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            String[] args = new String[]{hostName, new Integer(portNumber).toString(), userName, type.getProtocol()};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection.host.port.uname.password.protocol", args, null);
            throw new JBIRemoteException(exception);
        }
    }

    private Map<String, Object> initEnvironment(String userName, String password) {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        String PKGS = "com.sun.enterprise.admin.jmx.remote.protocol";
        environment.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        environment.put("jmx.remote.protocol.provider.pkgs", "com.sun.enterprise.admin.jmx.remote.protocol");
        environment.put("USER", userName);
        environment.put("PASSWORD", password);
        environment.put("com.sun.enterprise.as.http.auth", "BASIC");
        return environment;
    }

    private JMXServiceURL getJMXServiceURL(String protocol, String hostName, int portNumber) throws JBIRemoteException {
        try {
            JMXServiceURL url = new JMXServiceURL(protocol, hostName, portNumber);
            System.out.println("url = " + url.toString());
            return url;
        }
        catch (MalformedURLException mue) {
            String[] args = new String[]{protocol, hostName, new Integer(portNumber).toString()};
            Exception exception = JBIAdminCommandsClientFactory.createManagementException("jbi.ui.client.factory.connection.protocol.host.port", args, mue);
            throw new JBIRemoteException(exception);
        }
    }

    public static void main(String[] args) {
        Object factory = null;
        JBIAdminCommands commands = null;
        String hostName = "localhost";
        int port = 5651;
        port = 5649;
        String userName = "admin";
        String password = "adminadmin";
        String dummyName = "foo";
        try {
            commands = JBIAdminCommandsClientFactory.getInstance(hostName, port, userName, password);
        }
        catch (JBIRemoteException e) {
            e.printStackTrace();
        }
    }
}

