/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.ToolsLogManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static I18NBundle sI18NBundle = null;

    public static I18NBundle getCommonI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.common");
        }
        return sI18NBundle;
    }

    public static void logDebug(String msg) {
        ToolsLogManager.getCommonLogger().log(Level.FINE, msg);
    }

    public static void logDebug(Logger logger, Exception ex) {
        logger.log(Level.FINE, ex.getMessage(), ex);
    }

    public static void logDebug(Exception ex) {
        Util.logDebug(ToolsLogManager.getCommonLogger(), ex);
    }

    public static Object newInstance(String type, String arg) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        Class objClass = null;
        Object instance = null;
        if (type.equals("boolean")) {
            objClass = Boolean.class;
            Util.checkBooleanArgumentString(arg);
        } else {
            objClass = type.equals("byte") ? Byte.class : (type.equals("char") ? Character.class : (type.equals("short") ? Short.class : (type.equals("int") ? Integer.class : (type.equals("long") ? Long.class : (type.equals("float") ? Float.class : (type.equals("double") ? Double.class : (type.equals("void") ? Void.class : Class.forName(type))))))));
        }
        Class[] argClass = new Class[]{String.class};
        Constructor objConstructor = objClass.getConstructor(argClass);
        Object[] argValue = new String[]{arg};
        try {
            instance = objConstructor.newInstance(argValue);
        }
        catch (InvocationTargetException ex) {
            String msg = Util.getCommonI18NBundle().getMessage("ui.util.invalid.object.value.error", new Object[]{arg, objClass.getName()});
            IllegalArgumentException iaex = new IllegalArgumentException(msg, ex);
            throw iaex;
        }
        return instance;
    }

    public static boolean isLocalHost(String host) throws UnknownHostException {
        String localhostName = "localhost";
        String loopbackIP = "127.0.0.1";
        String loopbackIP6 = "0:0:0:0:0:0:0:1";
        String remoteHost = null;
        if (host != null) {
            remoteHost = host.trim().toLowerCase();
        }
        if (remoteHost == null || remoteHost.length() == 0 || remoteHost.equalsIgnoreCase(localhostName) || remoteHost.equalsIgnoreCase(loopbackIP) || remoteHost.equalsIgnoreCase(loopbackIP6)) {
            return true;
        }
        InetAddress localInetAddr = InetAddress.getLocalHost();
        String localHostIP = localInetAddr.getHostAddress();
        InetAddress[] remoteInetAddrs = InetAddress.getAllByName(remoteHost);
        for (int i = 0; i < remoteInetAddrs.length; ++i) {
            String remoteHostIP = remoteInetAddrs[i].getHostAddress();
            if (!localHostIP.equalsIgnoreCase(remoteHostIP) && !remoteHostIP.equalsIgnoreCase(loopbackIP) && !remoteHostIP.equalsIgnoreCase(loopbackIP6)) continue;
            return true;
        }
        return false;
    }

    public static String getHostName(String aHostName) throws UnknownHostException {
        InetAddress ia = null;
        ia = aHostName.equalsIgnoreCase("localhost") || aHostName.equals("") ? InetAddress.getLocalHost() : InetAddress.getByName(aHostName);
        String hostName = ia.getHostName();
        String hostAddress = ia.getHostAddress();
        String returnStr = hostName + "/" + hostAddress;
        return returnStr;
    }

    private static void checkBooleanArgumentString(String arg) throws IllegalArgumentException {
        String msg = Util.getCommonI18NBundle().getMessage("ui.util.invalid.boolean.value.error", new Object[]{arg});
        if (arg == null) {
            throw new IllegalArgumentException(msg);
        }
        if (!Boolean.FALSE.toString().equalsIgnoreCase(arg) && !Boolean.TRUE.toString().equalsIgnoreCase(arg)) {
            throw new IllegalArgumentException(msg);
        }
    }
}

