/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime.mbeans;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportReader;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.runtime.mbeans.AbstractUIMBeanImpl;
import com.sun.jbi.ui.runtime.mbeans.JBIAdminCommandsUIMBean;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIAdminCommandsUIMBeanImpl
extends AbstractUIMBeanImpl
implements JBIAdminCommandsUIMBean {
    private static final String NO_OPERATION = "Not Implemented";
    private static final String LOG_LEVEL_KEY = "LogLevel";
    private static final String LOGGER_NAME_KEY = "LoggerName";

    public JBIAdminCommandsUIMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    @Override
    public String deployServiceAssembly(String zipFilePath, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getDeploymentService().deployServiceAssembly(zipFilePath, targetName);
        return resultObject;
    }

    String validateServiceAssembly(String zipFilePath) {
        JBIArchive archive = null;
        ServiceAssemblyDD descriptor = null;
        String name = null;
        try {
            archive = new JBIArchive(zipFilePath);
            if (archive.isServiceAssemblyArchive()) {
                descriptor = (ServiceAssemblyDD)archive.getJbiDescriptor();
                name = descriptor.getName();
            }
        }
        catch (IOException ioException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    public Map<String, String> deployServiceAssembly(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.deployServiceAssembly(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String getComponentInstallationDescriptor(String componentName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getComponentInstallationDescriptor(componentName);
        return resultObject;
    }

    @Override
    public String getServiceAssemblyDeploymentDescriptor(String serviceAssemblyName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getServiceAssemblyDeploymentDescriptor(serviceAssemblyName);
        return resultObject;
    }

    @Override
    public String getSharedLibraryInstallationDescriptor(String sharedLibraryName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getSharedLibraryInstallationDescriptor(sharedLibraryName);
        return resultObject;
    }

    @Override
    public String getServiceUnitDeploymentDescriptor(String serviceAssemblyName, String serviceUnitName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getServiceUnitDeploymentDescriptor(serviceAssemblyName, serviceUnitName);
        return resultObject;
    }

    @Override
    public String installComponent(String zipFilePath, Properties paramProps, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().installComponent(zipFilePath, paramProps, targetName);
        return resultObject;
    }

    @Override
    public String installComponent(String zipFilePath, String targetName) throws JBIRemoteException {
        Properties params = new Properties();
        return this.installComponent(zipFilePath, params, targetName);
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, Properties paramProps, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponent(zipFilePath, paramProps, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponent(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String installSharedLibrary(String zipFilePath, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().installSharedLibrary(zipFilePath, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> installSharedLibrary(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installSharedLibrary(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public boolean isJBIRuntimeEnabled() throws JBIRemoteException {
        boolean resultObject = false;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.isJBIRuntimeEnabled();
        return resultObject;
    }

    @Override
    public String listBindingComponents(String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listBindingComponents(targetName);
        return resultObject;
    }

    @Override
    public String listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listBindingComponents(state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listBindingComponents(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listBindingComponents(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listBindingComponents(state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listServiceAssemblies(String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listServiceAssemblies(targetName);
        return resultObject;
    }

    @Override
    public String listServiceAssemblies(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listServiceAssemblies(componentName, targetName);
        return resultObject;
    }

    @Override
    public String listServiceAssemblies(String state, String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listServiceAssemblies(state, componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String state, String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(state, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listServiceEngines(String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listServiceEngines(targetName);
        return resultObject;
    }

    @Override
    public String listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listServiceEngines(state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listServiceEngines(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceEngines(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceEngines(state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listSharedLibraries(String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listSharedLibraries(targetName);
        return resultObject;
    }

    @Override
    public String listSharedLibraries(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listSharedLibraries(componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listSharedLibraries(String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraries(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listSharedLibraries(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraries(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String listSharedLibraryDependents(String sharedLibraryName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().listSharedLibraryDependents(sharedLibraryName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listSharedLibraryDependents(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraryDependents(sharedLibraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().showBindingComponent(name, state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showBindingComponent(name, state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String showServiceAssembly(String name, String state, String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().showServiceAssembly(name, state, componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showServiceAssembly(String name, String state, String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showServiceAssembly(name, state, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().showServiceEngine(name, state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showServiceEngine(name, state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String showSharedLibrary(String name, String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().showSharedLibrary(name, componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showSharedLibrary(String name, String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showSharedLibrary(name, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String shutdownComponent(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().shutdownComponent(componentName, targetName);
        return resultObject;
    }

    @Override
    public String shutdownComponent(String componentName, boolean force, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().shutdownComponent(componentName, force, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, boolean force, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownComponent(componentName, force, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().shutdownServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().shutdownServiceAssembly(serviceAssemblyName, forceShutdown, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownServiceAssembly(serviceAssemblyName, forceShutdown, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String startComponent(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().startComponent(componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> startComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.startComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String startServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().startServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> startServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.startServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String stopComponent(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().stopComponent(componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> stopComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.stopComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String stopServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getRuntimeManagementService().stopServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> stopServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.stopServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getDeploymentService().undeployServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String uninstallComponent(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallComponent(componentName, targetName);
        return resultObject;
    }

    String uninstallComponentInternal(String componentName, boolean force, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallComponent(componentName, force, targetName);
        return resultObject;
    }

    String uninstallComponentInternal(String componentName, boolean force, boolean retainInDomain, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallComponent(componentName, force, retainInDomain, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallSharedLibrary(sharedLibraryName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String installComponentFromDomain(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().installComponentFromDomain(componentName, targetName);
        return resultObject;
    }

    @Override
    public String installComponentFromDomain(String componentName, Properties properties, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().installComponentFromDomain(componentName, properties, targetName);
        return resultObject;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallComponent(componentName, forceDelete, targetName);
        return resultObject;
    }

    @Override
    public String installSharedLibraryFromDomain(String libraryName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().installSharedLibraryFromDomain(libraryName, targetName);
        return resultObject;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallSharedLibrary(sharedLibraryName, forceDelete, targetName);
        return resultObject;
    }

    @Override
    public String deployServiceAssemblyFromDomain(String assemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getDeploymentService().deployServiceAssemblyFromDomain(assemblyName, targetName);
        return resultObject;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getDeploymentService().undeployServiceAssembly(serviceAssemblyName, forceDelete, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponentFromDomain(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, Properties properties, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponentFromDomain(componentName, properties, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installSharedLibraryFromDomain(String libraryName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installSharedLibraryFromDomain(libraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> deployServiceAssemblyFromDomain(String assemblyName, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.deployServiceAssemblyFromDomain(assemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallComponent(componentName, forceDelete, retainInDomain, targetName);
        return resultObject;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().uninstallSharedLibrary(sharedLibraryName, forceDelete, retainInDomain, targetName);
        return resultObject;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getDeploymentService().undeployServiceAssembly(serviceAssemblyName, forceDelete, retainInDomain, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (JBIRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, Level> getComponentLoggerLevels(String componentName, String targetName, String targetInstanceName) throws JBIRemoteException {
        TreeMap<String, Level> resultObject = new TreeMap();
        resultObject = this.getConfigurationService().getComponentLoggerLevels(componentName, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public Map<String, String> getComponentLoggerDisplayNames(String componentName, String targetName, String targetInstanceName) throws JBIRemoteException {
        TreeMap<String, String> resultObject = new TreeMap();
        resultObject = this.getConfigurationService().getComponentLoggerDisplayNames(componentName, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public void setComponentLoggerLevel(String componentName, String loggerName, Level logLevel, String targetName, String targetInstanceName) throws JBIRemoteException {
        this.getConfigurationService().setComponentLoggerLevel(componentName, loggerName, logLevel, targetName, targetInstanceName);
    }

    @Override
    public Map<String, Level> getRuntimeLoggerLevels(String targetName, String targetInstanceName) throws JBIRemoteException {
        return this.getRuntimeLoggerLevels(targetName);
    }

    @Override
    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName, String targetInstanceName) throws JBIRemoteException {
        return this.getRuntimeLoggerLevel(runtimeLoggerName, targetName);
    }

    @Override
    public Map<String, String> getRuntimeLoggerNames(String targetName, String targetInstanceName) throws JBIRemoteException {
        return this.getRuntimeLoggerNames(targetName);
    }

    @Override
    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName, String targetInstanceName) throws JBIRemoteException {
        return this.getRuntimeLoggerDisplayName(runtimeLoggerName, targetName);
    }

    @Override
    public Map<String, Level> getRuntimeLoggerLevels(String targetName) throws JBIRemoteException {
        TreeMap<String, Level> resultObject = new TreeMap();
        resultObject = this.getConfigurationService().getRuntimeLoggerLevels(targetName);
        return resultObject;
    }

    @Override
    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName) throws JBIRemoteException {
        Level resultObject = null;
        resultObject = this.getConfigurationService().getRuntimeLoggerLevel(runtimeLoggerName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> getRuntimeLoggerNames(String targetName) throws JBIRemoteException {
        TreeMap<String, String> resultObject = new TreeMap();
        resultObject = this.getConfigurationService().getRuntimeLoggerNames(targetName);
        return resultObject;
    }

    @Override
    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().getRuntimeLoggerDisplayName(runtimeLoggerName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, ObjectName[]> getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws JBIRemoteException {
        Map<String, ObjectName[]> resultObject = null;
        resultObject = this.getConfigurationService().getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName);
        return resultObject;
    }

    @Override
    public ObjectName[] getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName, String targetInstanceName) throws JBIRemoteException {
        ObjectName[] resultObject = null;
        resultObject = this.getConfigurationService().getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName, targetInstanceName);
        return resultObject;
    }

    public Properties setComponentConfiguration(String componentName, Properties configurationValues, String targetName) throws JBIRemoteException {
        Properties resultObject = new Properties();
        String result = "";
        result = this.getConfigurationService().setComponentConfiguration(componentName, configurationValues, targetName);
        if (result == null) {
            result = "";
        }
        resultObject.put("result", result);
        return resultObject;
    }

    @Override
    public String setComponentConfiguration(String componentName, String targetName, Properties configurationValues) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().setComponentConfiguration(componentName, configurationValues, targetName);
        return resultObject;
    }

    @Override
    public String updateComponent(String componentName, String zipFilePath) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getInstallationService().upgradeComponent(componentName, zipFilePath);
        return resultObject;
    }

    @Override
    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName, String targetInstanceName) throws JBIRemoteException {
        this.setRuntimeLoggerLevel(runtimeLoggerName, logLevel, targetName);
    }

    @Override
    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName) throws JBIRemoteException {
        this.getConfigurationService().setRuntimeLoggerLevel(runtimeLoggerName, logLevel, targetName);
    }

    @Override
    public boolean isTargetUp(String targetName) throws JBIRemoteException {
        boolean resultObject = false;
        resultObject = this.getAdministrationService().isTargetUp(targetName);
        return resultObject;
    }

    @Override
    public Properties getRuntimeConfigurationMetaData(String propertyKeyName) throws JBIRemoteException {
        Properties resultObject = null;
        resultObject = this.getConfigurationService().getRuntimeConfigurationMetaData(propertyKeyName);
        return resultObject;
    }

    @Override
    public boolean setRuntimeConfiguration(Properties parameters, String targetName) throws JBIRemoteException {
        boolean resultObject = false;
        resultObject = this.getConfigurationService().setRuntimeConfiguration(parameters, targetName);
        return resultObject;
    }

    @Override
    public Properties getRuntimeConfiguration(String targetName) throws JBIRemoteException {
        Properties resultObject = null;
        resultObject = this.getConfigurationService().getRuntimeConfiguration(targetName);
        return resultObject;
    }

    @Override
    public Properties getDefaultRuntimeConfiguration() throws JBIRemoteException {
        Properties resultObject = null;
        resultObject = this.getConfigurationService().getDefaultRuntimeConfiguration();
        return resultObject;
    }

    @Override
    public boolean isServerRestartRequired() throws JBIRemoteException {
        boolean resultObject = false;
        resultObject = this.getConfigurationService().isServerRestartRequired();
        return resultObject;
    }

    @Override
    public boolean isComponentConfigSupported(String componentName, String targetName) throws JBIRemoteException {
        Boolean resultObject = null;
        resultObject = this.getConfigurationService().isComponentConfigSupported(componentName, targetName);
        return resultObject;
    }

    @Override
    public boolean isAppVarsSupported(String componentName, String targetName) throws JBIRemoteException {
        Boolean resultObject = null;
        resultObject = this.getConfigurationService().isAppVarsSupported(componentName, targetName);
        return resultObject;
    }

    @Override
    public String addApplicationVariables(String componentName, String targetName, Properties appVariables) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().addApplicationVariables(componentName, targetName, appVariables);
        return resultObject;
    }

    @Override
    public String setApplicationVariables(String componentName, String targetName, Properties appVariables) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().setApplicationVariables(componentName, appVariables, targetName);
        return resultObject;
    }

    @Override
    public String deleteApplicationVariables(String componentName, String targetName, String[] appVariableNames) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().deleteApplicationVariables(componentName, targetName, appVariableNames);
        return resultObject;
    }

    @Override
    public Properties getApplicationVariables(String componentName, String targetName) throws JBIRemoteException {
        Properties resultObject = null;
        resultObject = this.getConfigurationService().getApplicationVariables(componentName, targetName);
        return resultObject;
    }

    @Override
    public boolean isAppConfigSupported(String componentName, String targetName) throws JBIRemoteException {
        Boolean resultObject = null;
        resultObject = this.getConfigurationService().isAppConfigSupported(componentName, targetName);
        return resultObject;
    }

    @Override
    public CompositeType queryApplicationConfigurationType(String componentName, String targetName) throws JBIRemoteException {
        CompositeType resultObject = null;
        resultObject = this.getConfigurationService().queryApplicationConfigurationType(componentName, targetName);
        return resultObject;
    }

    @Override
    public String addApplicationConfiguration(String componentName, String targetName, String name, Properties config) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().addApplicationConfiguration(componentName, targetName, name, config);
        return resultObject;
    }

    @Override
    public String setApplicationConfiguration(String componentName, String targetName, String name, Properties config) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().setApplicationConfiguration(componentName, name, config, targetName);
        return resultObject;
    }

    @Override
    public String deleteApplicationConfiguration(String componentName, String targetName, String name) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().deleteApplicationConfiguration(componentName, targetName, name);
        return resultObject;
    }

    @Override
    public String[] listApplicationConfigurationNames(String componentName, String targetName) throws JBIRemoteException {
        String[] resultObject = null;
        resultObject = this.getConfigurationService().listApplicationConfigurationNames(componentName, targetName);
        return resultObject;
    }

    @Override
    public Properties getApplicationConfiguration(String componentName, String targetName, String name) throws JBIRemoteException {
        Properties resultObject = null;
        resultObject = this.getConfigurationService().getApplicationConfiguration(componentName, name, targetName);
        return resultObject;
    }

    @Override
    public Map<String, Properties> getApplicationConfigurations(String componentName, String targetName) throws JBIRemoteException {
        Map<String, Properties> resultObject = null;
        resultObject = this.getConfigurationService().getApplicationConfigurations(componentName, targetName);
        return resultObject;
    }

    @Override
    public Properties getComponentConfiguration(String componentName, String targetName) throws JBIRemoteException {
        Properties resultObject = null;
        resultObject = this.getConfigurationService().getComponentConfiguration(componentName, targetName);
        return resultObject;
    }

    private String getStackTrace(JBIRemoteException exception) {
        String buffer = "";
        if (exception != null) {
            JBIManagementMessage message = exception.extractJBIManagementMessage();
            if (message != null) {
                buffer = message.getStackTrace();
            }
            if (buffer == null || buffer.trim().length() == 0) {
                int index;
                Object[] elements;
                buffer = "";
                StringBuffer cause = exception.getCauseStackTrace();
                if (cause != null) {
                    buffer = buffer + AbstractUIMBeanImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.caused.by.info") + ":\n" + cause.toString();
                    buffer = buffer + "\n";
                } else {
                    elements = exception.getCauseMessageTrace();
                    if (elements != null) {
                        buffer = buffer + AbstractUIMBeanImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.caused.by.info") + ":\n";
                        for (index = 0; index < elements.length; ++index) {
                            if (elements[index] == null) continue;
                            buffer = buffer + ((String)elements[index]).toString();
                            buffer = buffer + "\n";
                        }
                    }
                }
                elements = exception.getStackTrace();
                if (elements != null) {
                    buffer = buffer + AbstractUIMBeanImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.stack.trace.info") + ":\n";
                    for (index = 0; index < elements.length; ++index) {
                        if (elements[index] == null) continue;
                        buffer = buffer + ((StackTraceElement)elements[index]).toString();
                        buffer = buffer + "\n";
                    }
                }
            }
        }
        return buffer;
    }

    @Override
    public CompositeData verifyApplication(String applicationURL, String targetName, boolean generateTemplates, String templateDir, boolean includeDeployCommand) throws JBIRemoteException {
        CompositeData resultObject = null;
        String rawXMLData = null;
        ApplicationVerificationReport report = null;
        rawXMLData = this.getConfigurationService().verifyApplication(applicationURL, generateTemplates, templateDir, includeDeployCommand, targetName, applicationURL);
        if (rawXMLData != null && rawXMLData.length() > 0) {
            try {
                report = ApplicationVerificationReportReader.parseFromXMLData(rawXMLData);
            }
            catch (MalformedURLException e) {
                throw new JBIRemoteException(e);
            }
            catch (ParserConfigurationException e) {
                throw new JBIRemoteException(e);
            }
            catch (SAXException e) {
                throw new JBIRemoteException(e);
            }
            catch (URISyntaxException e) {
                throw new JBIRemoteException(e);
            }
            catch (IOException e) {
                throw new JBIRemoteException(e);
            }
        }
        resultObject = report.generateCompositeData();
        return resultObject;
    }

    @Override
    public String exportApplicationConfiguration(String applicationName, String targetName, String configDir) throws JBIRemoteException {
        String resultObject = null;
        resultObject = this.getConfigurationService().exportApplicationConfiguration(applicationName, targetName, configDir);
        return resultObject;
    }

    @Override
    public String retrieveConfigurationDisplaySchema(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = "";
        resultObject = this.getConfigurationService().retrieveConfigurationDisplaySchema(componentName, targetName);
        return resultObject;
    }

    @Override
    public String retrieveConfigurationDisplayData(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = "";
        resultObject = this.getConfigurationService().retrieveConfigurationDisplayData(componentName, targetName);
        return resultObject;
    }

    @Override
    public TabularData getFrameworkStats(String targetName) throws JBIRemoteException {
        return this.getPerformanceMeasurementService().getFrameworkStatisticsAsTabularData(targetName);
    }

    @Override
    public TabularData getComponentStats(String componentName, String targetName) throws JBIRemoteException {
        return this.getPerformanceMeasurementService().getComponentStatisticsAsTabularData(componentName, targetName);
    }

    @Override
    public TabularData getEndpointStats(String endpointName, String targetName) throws JBIRemoteException {
        return this.getPerformanceMeasurementService().getEndpointStatisticsAsTabularData(endpointName, targetName);
    }

    @Override
    public TabularData getNMRStats(String targetName) throws JBIRemoteException {
        return this.getPerformanceMeasurementService().getNMRStatisticsAsTabularData(targetName);
    }

    @Override
    public TabularData getServiceAssemblyStats(String saName, String targetName) throws JBIRemoteException {
        return this.getPerformanceMeasurementService().getServiceAssemblyStatisticsAsTabularData(saName, targetName);
    }

    @Override
    public TabularData getConsumingEndpointsForComponent(String componentName, String targetName) throws JBIRemoteException {
        return this.getPerformanceMeasurementService().getConsumingEndpointsForComponentAsTabularData(componentName, targetName);
    }

    @Override
    public TabularData getProvidingEndpointsForComponent(String componentName, String targetName) throws JBIRemoteException {
        return this.getPerformanceMeasurementService().getProvidingEndpointsForComponentAsTabularData(componentName, targetName);
    }
}

