/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime.mbeans;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIStatisticsItemNames;
import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.runtime.mbeans.AbstractUIMBeanImpl;
import com.sun.jbi.ui.runtime.mbeans.JBIStatisticsMBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIStatisticsMBeanImpl
extends AbstractUIMBeanImpl
implements JBIStatisticsMBean {
    public static String COMMA = ",";
    public static String COLON = ":";
    public static String EQUAL = "=";
    public static String SERVICE_TYPE_KEY = "CustomControlName";
    static String PROVIDER_MARKER = "Provider";
    static String CONSUMER_MARKER = "Consumer";
    static String QUERY_ENDPOINT_LIST = "getEndpointsForDeliveryChannel";
    static String QUERY_CONSUMING_ENDPOINT_LIST = "getConsumingEndpointsForDeliveryChannel";
    MBeanNames mBeanNames = null;
    I18NBundle mResourceBundle = null;
    static String[] STATS_TABLE_INDEX = new String[]{"InstanceName"};
    static String FRAMEWORK_MBEAN_STARTUP_TIME_ATTR = "StartupTime";
    static String FRAMEWORK_MBEAN_LAST_RESTART_TIME_ATTR = "LastRestartTime";
    static String[] FRAMEWORK_STATS_ITEM_NAMES = new String[]{JBIStatisticsItemNames.INSTANCE_NAME, JBIStatisticsItemNames.FRAMEWORK_STARTUP_TIME, JBIStatisticsItemNames.FRAMEWORK_UPTIME};
    static String[] FRAMEWORK_STATS_ITEM_DESCRIPTIONS = new String[]{"Instance Name", "Time taken to startup the framework (ms)", "Time elapsed since framework has been started (ms)"};
    static OpenType[] FRAMEWORK_STATS_ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG};
    static String NMR_MBEAN_ACTIVE_CHANNELS_ATTR = "ActiveChannels";
    static String NMR_MBEAN_ACTIVE_ENDPOINTS_ATTR = "ActiveEndpoints";
    static String[] NMR_STATS_ITEM_NAMES = new String[]{JBIStatisticsItemNames.INSTANCE_NAME, JBIStatisticsItemNames.NMR_STATS_ACTIVE_CHANNELS, JBIStatisticsItemNames.NMR_STATS_ACTIVE_ENDPOINTS};
    static String[] NMR_STATS_ITEM_DESCRIPTIONS = new String[]{"Instance Name", "List of active delivery channels", "List of active endpoints"};
    static String COMPONENT_LAST_RESTART_TIME_ATTR = "LastRestartTime";
    static String COMPONENT_ACTIVE_ENDPOINTS = "ActiveEndpoints";
    static String COMPONENT_RECEIVE_REQUEST = "ReceiveRequest";
    static String COMPONENT_SEND_REQUEST = "SendRequest";
    static String COMPONENT_RECEIVE_REPLY = "ReceiveReply";
    static String COMPONENT_SEND_REPLY = "SendReply";
    static String COMPONENT_RECEIVE_DONE = "ReceiveDONE";
    static String COMPONENT_SEND_DONE = "SendDONE";
    static String COMPONENT_RECEIVE_FAULT = "ReceiveFault";
    static String COMPONENT_SEND_FAULT = "SendFault";
    static String COMPONENT_RECEIVE_ERROR = "ReceiveERROR";
    static String COMPONENT_SEND_ERROR = "SendERROR";
    static String COMPONENT_ACTIVE_EXCHANGE = "ActiveExchanges";
    static String COMPONENT_ACTIVE_EXCHANGE_MAX = "MaxActiveExchanges";
    static String COMPONENT_QUEUED_EXCHANGE = "QueuedExchanges";
    static String COMPONENT_QUEUED_EXCHANGE_MAX = "MaxQueuedExchanges";
    static String COMPONENT_RESPONSE_TIME = "ResponseTimeAvg (ns)";
    static String COMPONENT_COMPONENT_TIME = "ComponentTimeAvg (ns)";
    static String COMPONENT_CHANNEL_TIME = "ChannelTimeAvg (ns)";
    static String COMPONENT_NMR_TIME = "NMRTimeAvg (ns)";
    static String OWNING_COMPONENT = "OwningChannel";
    static String PROVIDER_ACTIVATION_TIMESTAMP = "ActivationTimestamp";
    static String COMPONENT_STATUS_TIME = "StatusTimeAvg (ns)";
    static String[] ENDPOINT_STATS_PROVIDER_ITEM_NAMES = new String[]{PROVIDER_ACTIVATION_TIMESTAMP, COMPONENT_RECEIVE_REQUEST, COMPONENT_SEND_REPLY};
    static String[] ENDPOINT_LIST_STATS_ITEM_NAMES = new String[]{JBIStatisticsItemNames.INSTANCE_NAME, "Endpoints"};
    static String[] ENDPOINT_LIST_STATS_ITEM_DESCRIPTIONS = new String[]{"Instance Name", "List of endpoints"};
    static Map<String, OpenType> JAVATYPE_TO_OPENTYPE = new HashMap<String, OpenType>();
    public static final String NUMBEROFMEASUREMENTS_KEY = "n";
    public static final String TOTALTIME_KEY = "total time (ms)";
    public static final String AVERAGEWITHOUTFIRSTMEASUREMENT_KEY = "average' (ms)";
    public static final String NUMBEROFMEASUREMENTOBJECTS_KEY = "act";
    public static final String FIRSTMEASUREMENTTIME_KEY = "first (ms)";
    public static final String AVERAGE_KEY = "average (ms)";
    public static final String THROUGHPUT_KEY = "throughput (s-1)";
    public static final String TIMETAKEN_KEY = "last-first (ms)";
    public static final String LOAD_KEY = "load";
    public static final String MEDIAN_KEY = "median (ms)";
    public static final String SOURCE_KEY = "source";
    public static final String SUB_TOPIC_KEY = "sub topic";
    public static final String TOPIC_KEY = "topic";
    static String[] OJC_HULP_STATS_ITEMS;
    static String[] OJC_HULP_STATS_DESCRIPTIONS;
    static OpenType[] OJC_HULP_STATS_TYPES;
    static String[] OJC_STATS_TABLE_INDEX;

    public JBIStatisticsMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
        this.mBeanNames = anEnvContext.getMBeanNames();
        this.mResourceBundle = JBIStatisticsMBeanImpl.getI18NBundle();
    }

    @Override
    public TabularData getFrameworkStats(String targetName) throws JBIRemoteException {
        if (!this.isValidTarget(targetName)) {
            JBIStatisticsMBeanImpl.logDebug("getFrameworkStats(): target " + targetName + " not valid target.");
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", new String[]{targetName}, null);
            throw new JBIRemoteException(exception);
        }
        try {
            Map<String, ObjectName> frameworkMBeans = this.getFrameworkStatsMBeans(targetName);
            Set<String> instances = frameworkMBeans.keySet();
            CompositeType frameworkStatsEntriesType = new CompositeType(JBIStatisticsItemNames.FRAMEWORK_STATISTICS_NAME, JBIStatisticsItemNames.FRAMEWORK_STATISTICS_DESCRIPTION, FRAMEWORK_STATS_ITEM_NAMES, FRAMEWORK_STATS_ITEM_DESCRIPTIONS, FRAMEWORK_STATS_ITEM_TYPES);
            TabularType frameworkStatsType = new TabularType(JBIStatisticsItemNames.FRAMEWORK_STATISTICS_TABLE_ITEM_NAME, "Framework statistics for instance", frameworkStatsEntriesType, JBIStatisticsItemNames.STATS_TABLE_INDEX);
            TabularDataSupport frameworkStatsTable = new TabularDataSupport(frameworkStatsType);
            for (String instance : instances) {
                ObjectName mbean = frameworkMBeans.get(instance);
                if (mbean == null) continue;
                JBIStatisticsMBeanImpl.logDebug("Getting framework statistics for " + instance);
                frameworkStatsTable.put(this.getFrameworkStats(frameworkStatsEntriesType, instance, mbean));
            }
            return frameworkStatsTable;
        }
        catch (OpenDataException ex) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.error.in.compose", new String[]{targetName}, ex);
            JBIStatisticsMBeanImpl.logDebug(ex.getMessage());
            throw new JBIRemoteException(exception);
        }
    }

    @Override
    public TabularData getComponentStats(String componentName, String targetName) throws JBIRemoteException {
        if (!this.isValidTarget(targetName)) {
            JBIStatisticsMBeanImpl.logDebug("getFrameworkStats(): target " + targetName + " not valid target.");
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", new String[]{targetName}, null);
            throw new JBIRemoteException(exception);
        }
        try {
            if (!this.isComponentUp(componentName, targetName)) {
                Exception exception = this.createManagementException("ui.mbean.system.stats.comp.not.started", new String[]{componentName, targetName}, null);
                JBIStatisticsMBeanImpl.logDebug(exception.getMessage());
                throw new JBIRemoteException(exception);
            }
            Map<String, ObjectName> compStatsFrameworkMBeans = this.getCompStatsFrameworkMBeans(targetName, componentName);
            JBIStatisticsMBeanImpl.logDebug("Got statistics MBeans for components registered by framework");
            Map<String, ObjectName> compStatsExtensionMBeans = this.getCompStatsExtensionMBeans(targetName, componentName);
            JBIStatisticsMBeanImpl.logDebug("Got statistics MBeans for components registered by components");
            Map<String, ObjectName> messageServiceStatsMBeans = this.getNMRStatsMBeans(targetName);
            JBIStatisticsMBeanImpl.logDebug("Got statistics MBeans for message service");
            Set<String> instances = compStatsFrameworkMBeans.keySet();
            TabularType componentStatsTableType = null;
            TabularDataSupport componentStatsTable = null;
            CompositeData[] componentStats = new CompositeData[instances.size()];
            int i = 0;
            for (String instance : instances) {
                ObjectName compFrameworkMBean = compStatsFrameworkMBeans.get(instance);
                if (compFrameworkMBean == null) continue;
                JBIStatisticsMBeanImpl.logDebug("Getting component stats for " + instance);
                componentStats[i++] = this.getComponentStats(instance, componentName, compFrameworkMBean, messageServiceStatsMBeans.get(instance), compStatsExtensionMBeans.get(instance));
            }
            if (i > 0 && componentStats[0] != null) {
                componentStatsTableType = new TabularType("ComponentStats", "Component Statistic Information", componentStats[0].getCompositeType(), JBIStatisticsItemNames.STATS_TABLE_INDEX);
                componentStatsTable = new TabularDataSupport(componentStatsTableType);
                for (int j = 0; j < i; ++j) {
                    componentStatsTable.put(componentStats[j]);
                }
            }
            return componentStatsTable;
        }
        catch (OpenDataException ex) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.error.in.compose", new String[]{componentName}, ex);
            JBIStatisticsMBeanImpl.logDebug(ex.getMessage());
            throw new JBIRemoteException(exception);
        }
    }

    @Override
    public TabularData getEndpointStats(String endpointName, String targetName) throws JBIRemoteException {
        if (!this.isValidTarget(targetName)) {
            JBIStatisticsMBeanImpl.logDebug("getFrameworkStats(): target " + targetName + " not valid target.");
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", new String[]{targetName}, null);
            throw new JBIRemoteException(exception);
        }
        try {
            JBIStatisticsMBeanImpl.logDebug("Entered getEndpointStats");
            Map<String, ObjectName> messageServiceStatsMBeans = this.getNMRStatsMBeans(targetName);
            JBIStatisticsMBeanImpl.logDebug("Obtained statistics MBeans for message service");
            Set<String> instances = messageServiceStatsMBeans.keySet();
            TabularType endpointStatsTableType = null;
            TabularDataSupport endpointsStatsTable = null;
            CompositeData[] endpointStats = new CompositeData[instances.size()];
            int i = 0;
            for (String instance : instances) {
                ObjectName messageServiceMBean = messageServiceStatsMBeans.get(instance);
                if (messageServiceMBean == null) continue;
                JBIStatisticsMBeanImpl.logDebug("Obtaining endpoint stats for " + instance);
                endpointStats[i++] = this.getEndpointStats(targetName, instance, endpointName, messageServiceStatsMBeans.get(instance));
            }
            if (i > 0 && endpointStats[0] != null) {
                endpointStatsTableType = new TabularType("EndpointStats", "Endpoint Statistic Information", endpointStats[0].getCompositeType(), JBIStatisticsItemNames.STATS_TABLE_INDEX);
                endpointsStatsTable = new TabularDataSupport(endpointStatsTableType);
                for (int j = 0; j < i; ++j) {
                    endpointsStatsTable.put(endpointStats[j]);
                }
            }
            return endpointsStatsTable;
        }
        catch (OpenDataException ex) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.error.in.compose", new String[]{endpointName}, ex);
            JBIStatisticsMBeanImpl.logDebug(ex.getMessage());
            throw new JBIRemoteException(exception);
        }
    }

    @Override
    public TabularData getNMRStats(String targetName) throws JBIRemoteException {
        if (!this.isValidTarget(targetName)) {
            JBIStatisticsMBeanImpl.logDebug("getFrameworkStats(): target " + targetName + " not valid target.");
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", new String[]{targetName}, null);
            throw new JBIRemoteException(exception);
        }
        try {
            Map<String, ObjectName> nmrMBeans = this.getNMRStatsMBeans(targetName);
            Set<String> instances = nmrMBeans.keySet();
            OpenType[] nmrStatsItemTypes = new OpenType[]{SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING)};
            CompositeType NMRStatsEntriesType = new CompositeType(JBIStatisticsItemNames.NMR_STATISTICS_NAME, JBIStatisticsItemNames.NMR_STATISTICS_DESCRIPTION, NMR_STATS_ITEM_NAMES, NMR_STATS_ITEM_DESCRIPTIONS, nmrStatsItemTypes);
            TabularType nmrStatsType = new TabularType(JBIStatisticsItemNames.NMR_STATISTICS_TABLE_ITEM_NAME, "NMR statistics for an instance", NMRStatsEntriesType, JBIStatisticsItemNames.STATS_TABLE_INDEX);
            TabularDataSupport nmrStatsTable = new TabularDataSupport(nmrStatsType);
            for (String instance : instances) {
                ObjectName mbean = nmrMBeans.get(instance);
                if (mbean == null) continue;
                JBIStatisticsMBeanImpl.logDebug("Getting NMR statistics for " + instance);
                nmrStatsTable.put(this.getNMRStats(NMRStatsEntriesType, instance, mbean));
            }
            return nmrStatsTable;
        }
        catch (OpenDataException ex) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.error.in.compose", new String[]{targetName}, ex);
            JBIStatisticsMBeanImpl.logDebug(ex.getMessage());
            throw new JBIRemoteException(exception);
        }
    }

    @Override
    public TabularData getServiceAssemblyStats(String saName, String targetName) throws JBIRemoteException {
        if (!this.isValidTarget(targetName)) {
            JBIStatisticsMBeanImpl.logDebug("getFrameworkStats(): target " + targetName + " not valid target.");
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", new String[]{targetName}, null);
            throw new JBIRemoteException(exception);
        }
        try {
            Map<String, ObjectName> deploymentServiceStatsMBeans = this.getDeploymentServiceStatsMBeans(targetName);
            Set<String> instances = deploymentServiceStatsMBeans.keySet();
            TabularType saStatsTableType = null;
            TabularDataSupport saStatsTable = null;
            CompositeData[] saStats = new CompositeData[instances.size()];
            int i = 0;
            for (String instance : instances) {
                ObjectName deploymentServiceMBean = deploymentServiceStatsMBeans.get(instance);
                if (deploymentServiceMBean == null) continue;
                JBIStatisticsMBeanImpl.logDebug("Getting service assembly statistics for " + instance);
                saStats[i++] = this.getSAStats(instance, saName, deploymentServiceStatsMBeans.get(instance));
            }
            if (i > 0 && saStats[0] != null) {
                saStatsTableType = new TabularType(JBIStatisticsItemNames.SA_STATISTICS_NAME, JBIStatisticsItemNames.SA_STATISTICS_DESCRIPTION, saStats[0].getCompositeType(), JBIStatisticsItemNames.STATS_TABLE_INDEX);
                saStatsTable = new TabularDataSupport(saStatsTableType);
                for (int j = 0; j < i; ++j) {
                    saStatsTable.put(saStats[j]);
                }
            }
            return saStatsTable;
        }
        catch (JBIRemoteException remoteException) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.error.in.compose", new String[]{saName}, remoteException);
            JBIStatisticsMBeanImpl.logDebug(remoteException.getMessage());
            throw new JBIRemoteException(remoteException);
        }
        catch (OpenDataException ex) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.error.in.compose", new String[]{saName}, ex);
            JBIStatisticsMBeanImpl.logDebug(ex.getMessage());
            throw new JBIRemoteException(ex);
        }
    }

    private Map<String, ObjectName> getFrameworkStatsMBeans(String targetName) throws JBIRemoteException {
        return this.getStatsMBeans(targetName, "Framework");
    }

    private Map<String, ObjectName> getDeploymentServiceStatsMBeans(String targetName) throws JBIRemoteException {
        return this.getStatsMBeans(targetName, "DeploymentService");
    }

    private Map<String, ObjectName> getNMRStatsMBeans(String targetName) throws JBIRemoteException {
        return this.getStatsMBeans(targetName, "MessageService");
    }

    private Map<String, ObjectName> getCompStatsFrameworkMBeans(String targetName, String componentName) throws JBIRemoteException {
        try {
            ComponentType compType;
            HashMap<String, ObjectName> mbeanList = new HashMap<String, ObjectName>();
            if ("domain".equals(targetName)) {
                JBIStatisticsMBeanImpl.logDebug("getCompStatsFrameworkMBeans(): target " + targetName + " type not supported.");
                Exception exception = this.createManagementException("ui.mbean.system.stats.target.type.not.supported", new String[]{targetName}, null);
                throw new JBIRemoteException(exception);
            }
            try {
                ComponentQuery compQuery = this.mEnvContext.getComponentQuery(targetName);
                ComponentInfo compInfo = compQuery.getComponentInfo(componentName);
                compType = compInfo.getComponentType();
                JBIStatisticsMBeanImpl.logDebug("ComponentQuery in target " + targetName + " returned component type " + (Object)((Object)compType));
            }
            catch (Exception ex) {
                JBIStatisticsMBeanImpl.logDebug("getCompStatsFrameworkMBeans(): component " + componentName + " type not known.");
                Exception exception = this.createManagementException("ui.mbean.system.stats.comp.type.not.known", new String[]{componentName}, null);
                throw new JBIRemoteException(exception);
            }
            if (this.getPlatformContext().isStandaloneServer(targetName)) {
                mbeanList.put(targetName, this.getCompStatsFrameworkMBeans(targetName, componentName, compType));
            } else if (this.getPlatformContext().isClusteredServer(targetName)) {
                mbeanList.put(targetName, this.getCompStatsFrameworkMBeans(targetName, componentName, compType));
            } else if (this.getPlatformContext().isCluster(targetName)) {
                Set<String> servers = this.getPlatformContext().getServersInCluster(targetName);
                for (String server : servers) {
                    mbeanList.put(server, this.getCompStatsFrameworkMBeans(server, componentName, compType));
                }
            }
            return mbeanList;
        }
        catch (Exception ex) {
            throw new JBIRemoteException(ex);
        }
    }

    private Map<String, ObjectName> getCompStatsExtensionMBeans(String targetName, String componentName) throws JBIRemoteException {
        try {
            ComponentType compType;
            HashMap<String, ObjectName> mbeanList = new HashMap<String, ObjectName>();
            if ("domain".equals(targetName)) {
                JBIStatisticsMBeanImpl.logDebug("getCompStatsExtensionMBeans(): target " + targetName + " type not supported.");
                Exception exception = this.createManagementException("ui.mbean.system.stats.target.type.not.supported", new String[]{targetName}, null);
                throw new JBIRemoteException(exception);
            }
            try {
                ComponentQuery compQuery = this.mEnvContext.getComponentQuery(targetName);
                ComponentInfo compInfo = compQuery.getComponentInfo(componentName);
                compType = compInfo.getComponentType();
            }
            catch (Exception ex) {
                JBIStatisticsMBeanImpl.logDebug("getCompStatsExtensionMBeans(): component " + componentName + " type not known.");
                Exception exception = this.createManagementException("ui.mbean.system.stats.comp.type.not.known", new String[]{componentName}, null);
                throw new JBIRemoteException(exception);
            }
            if (this.getPlatformContext().isStandaloneServer(targetName)) {
                mbeanList.put(targetName, this.getCompStatsExtensionMBeans(targetName, componentName, compType));
            } else if (this.getPlatformContext().isClusteredServer(targetName)) {
                mbeanList.put(targetName, this.getCompStatsExtensionMBeans(targetName, componentName, compType));
            } else if (this.getPlatformContext().isCluster(targetName)) {
                Set<String> servers = this.getPlatformContext().getServersInCluster(targetName);
                for (String server : servers) {
                    mbeanList.put(server, this.getCompStatsExtensionMBeans(server, componentName, compType));
                }
            }
            return mbeanList;
        }
        catch (Exception ex) {
            throw new JBIRemoteException(ex);
        }
    }

    private ObjectName getCompStatsExtensionMBeans(String instance, String componentName, ComponentType compType) throws JBIRemoteException {
        String componentType;
        boolean isUp = this.getPlatformContext().isInstanceUp(instance);
        if (!isUp) {
            JBIStatisticsMBeanImpl.logDebug("getCompStatsExtensionMBeans(): instance " + instance + " is down.");
            Exception exception = this.createManagementException("ui.mbean.system.stats.server.is.down", new String[]{instance}, null);
            throw new JBIRemoteException(exception);
        }
        if (compType.equals((Object)ComponentType.BINDING)) {
            componentType = "Binding";
        } else if (compType.equals((Object)ComponentType.ENGINE)) {
            componentType = "Engine";
        } else {
            Exception exception = this.createManagementException("ui.mbean.system.stats.not.available.for.component", new String[]{componentName}, null);
            throw new JBIRemoteException(exception);
        }
        String statsMBeanName = "com.sun.jbi" + COLON + "JbiName" + EQUAL + instance + COMMA + "ComponentName" + EQUAL + componentName + COMMA + "ControlType" + EQUAL + "Custom" + COMMA + "ComponentType" + EQUAL + "Installed" + COMMA + "InstalledType" + EQUAL + componentType + COMMA + SERVICE_TYPE_KEY + EQUAL + "Statistics";
        try {
            return new ObjectName(statsMBeanName);
        }
        catch (Exception e) {
            ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("ui.mbean.system.stats.mbean.not.present", new Object[]{statsMBeanName}));
            JBIStatisticsMBeanImpl.logWarning(e);
            return null;
        }
    }

    private ObjectName getCompStatsFrameworkMBeans(String instance, String componentName, ComponentType compType) throws JBIRemoteException {
        String componentType;
        boolean isUp = this.getPlatformContext().isInstanceUp(instance);
        if (!isUp) {
            JBIStatisticsMBeanImpl.logDebug("getCompStatsFrameworkMBeans(): instance " + instance + " is down.");
            Exception exception = this.createManagementException("ui.mbean.system.stats.server.is.down", new String[]{instance}, null);
            throw new JBIRemoteException(exception);
        }
        if (compType.equals((Object)ComponentType.BINDING)) {
            componentType = "Binding";
        } else if (compType.equals((Object)ComponentType.ENGINE)) {
            componentType = "Engine";
        } else {
            Exception exception = this.createManagementException("ui.mbean.system.stats.not.available.for.component", new String[]{componentName}, null);
            throw new JBIRemoteException(exception);
        }
        String statsMBeanName = "com.sun.jbi" + COLON + "JbiName" + EQUAL + instance + COMMA + "ComponentName" + EQUAL + componentName + COMMA + "ControlType" + EQUAL + "Statistics" + COMMA + "ComponentType" + EQUAL + "Installed" + COMMA + "InstalledType" + EQUAL + componentType;
        try {
            return new ObjectName(statsMBeanName);
        }
        catch (Exception e) {
            ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("ui.mbean.system.stats.mbean.not.present", new Object[]{statsMBeanName}));
            JBIStatisticsMBeanImpl.logWarning(e);
            return null;
        }
    }

    private Map<String, ObjectName> getStatsMBeans(String targetName, String serviceName) throws JBIRemoteException {
        HashMap<String, ObjectName> mbeanList = new HashMap<String, ObjectName>();
        if ("domain".equals(targetName)) {
            JBIStatisticsMBeanImpl.logDebug("getStatsMBeans(): target " + targetName + " type not supported.");
            Exception exception = this.createManagementException("ui.mbean.system.stats.target.type.not.supported", new String[]{targetName}, null);
            throw new JBIRemoteException(exception);
        }
        if (this.getPlatformContext().isStandaloneServer(targetName)) {
            mbeanList.put(targetName, this.getStatsMBean(targetName, serviceName));
        } else if (this.getPlatformContext().isClusteredServer(targetName)) {
            mbeanList.put(targetName, this.getStatsMBean(targetName, serviceName));
        } else if (this.getPlatformContext().isCluster(targetName)) {
            Set<String> servers = this.getPlatformContext().getServersInCluster(targetName);
            for (String server : servers) {
                mbeanList.put(server, this.getStatsMBean(server, serviceName));
            }
        }
        return mbeanList;
    }

    private ObjectName getStatsMBean(String instance, String serviceName) throws JBIRemoteException {
        boolean isUp = this.getPlatformContext().isInstanceUp(instance);
        if (!isUp) {
            JBIStatisticsMBeanImpl.logDebug("getStatsMBeans(): instance " + instance + " is down.");
            Exception exception = this.createManagementException("ui.mbean.system.stats.server.is.down", new String[]{instance}, null);
            throw new JBIRemoteException(exception);
        }
        String statsMBeanName = "com.sun.jbi" + COLON + "JbiName" + EQUAL + instance + COMMA + "ServiceName" + EQUAL + serviceName + COMMA + "ControlType" + EQUAL + "Statistics" + COMMA + "ComponentType" + EQUAL + "System";
        try {
            return new ObjectName(statsMBeanName);
        }
        catch (Exception ex) {
            ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("ui.mbean.system.stats.mbean.not.present", new Object[]{statsMBeanName}));
            JBIStatisticsMBeanImpl.logWarning(ex);
            return null;
        }
    }

    private CompositeData getFrameworkStats(CompositeType frameworkStatsEntriesType, String instanceName, ObjectName mbean) throws JBIRemoteException {
        try {
            Long startTime = (Long)this.getMBeanAttribute(mbean, FRAMEWORK_MBEAN_STARTUP_TIME_ATTR);
            Date lastRestart = (Date)this.getMBeanAttribute(mbean, FRAMEWORK_MBEAN_LAST_RESTART_TIME_ATTR);
            long upTime = 0L;
            if (lastRestart != null) {
                upTime = System.currentTimeMillis() - lastRestart.getTime();
            }
            Object[] values = new Object[]{instanceName, startTime, upTime};
            return new CompositeDataSupport(frameworkStatsEntriesType, FRAMEWORK_STATS_ITEM_NAMES, values);
        }
        catch (OpenDataException ex) {
            throw new JBIRemoteException(ex);
        }
    }

    private CompositeData getNMRStats(CompositeType NMRStatsEntriesType, String instanceName, ObjectName mbean) throws JBIRemoteException {
        try {
            String[] channels = (String[])this.getMBeanAttribute(mbean, NMR_MBEAN_ACTIVE_CHANNELS_ATTR);
            String[] endpoints = (String[])this.getMBeanAttribute(mbean, NMR_MBEAN_ACTIVE_ENDPOINTS_ATTR);
            Object[] values = new Object[]{instanceName, channels, endpoints};
            return new CompositeDataSupport(NMRStatsEntriesType, NMR_STATS_ITEM_NAMES, values);
        }
        catch (OpenDataException ex) {
            throw new JBIRemoteException(ex);
        }
    }

    private CompositeData getSAStats(String instanceName, String saName, ObjectName deploymentServiceMBean) throws JBIRemoteException {
        try {
            return (CompositeData)this.invokeMBeanOperation(deploymentServiceMBean, "getServiceAssemblyStatistics", new Object[]{saName}, new String[]{"java.lang.String"});
        }
        catch (JBIRemoteException remoteException) {
            throw new JBIRemoteException(remoteException);
        }
    }

    private CompositeData getComponentStats(String instanceName, String componentName, ObjectName frameworkMBean, ObjectName messageServiceStatsMBean, ObjectName compExtnMBean) throws JBIRemoteException {
        CompositeData allDeliveryChannelStats;
        long upTime = 0L;
        Date lastRestartTime = (Date)this.getMBeanAttribute(frameworkMBean, COMPONENT_LAST_RESTART_TIME_ATTR);
        if (lastRestartTime != null) {
            upTime = System.currentTimeMillis() - lastRestartTime.getTime();
        }
        if ((allDeliveryChannelStats = (CompositeData)this.invokeMBeanOperation(messageServiceStatsMBean, "getDeliveryChannelStatistics", new Object[]{componentName}, new String[]{"java.lang.String"})) == null) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.comp.not.exists", new String[]{componentName}, null);
            JBIStatisticsMBeanImpl.logDebug(exception.getMessage());
            throw new JBIRemoteException(exception);
        }
        long completedExchanges = 0L;
        long errorExchanges = 0L;
        Long numSendDone = (Long)allDeliveryChannelStats.get(COMPONENT_SEND_DONE);
        Long numReceiveDone = (Long)allDeliveryChannelStats.get(COMPONENT_RECEIVE_DONE);
        Long numSendError = (Long)allDeliveryChannelStats.get(COMPONENT_SEND_ERROR);
        Long numReceiveError = (Long)allDeliveryChannelStats.get(COMPONENT_RECEIVE_ERROR);
        if (numSendDone != null && numReceiveDone != null && numSendError != null && numReceiveError != null) {
            completedExchanges = numSendDone + numReceiveDone + numSendError + numReceiveError;
            errorExchanges = numSendError + numReceiveError;
        }
        Object componentExtnStats = null;
        return this.composeComponentStats(instanceName, upTime, allDeliveryChannelStats, completedExchanges, errorExchanges, this.getCompStatsAttributes(compExtnMBean));
    }

    private CompositeData composeComponentStats(String instanceName, long upTime, CompositeData deliveryChannelStats, long completedExchanges, long errorExchanges, CompositeData componentExtnStats) throws JBIRemoteException {
        try {
            ArrayList<String> itemNames = new ArrayList<String>();
            itemNames.add(JBIStatisticsItemNames.INSTANCE_NAME);
            itemNames.add("ComponentUpTime (ms)");
            itemNames.add("NumActivatedEndpoints");
            itemNames.add("NumReceivedRequests");
            itemNames.add("NumSentRequests");
            itemNames.add("NumReceivedReplies");
            itemNames.add("NumSentReplies");
            itemNames.add("NumReceivedDONEs");
            itemNames.add("NumSentDONEs");
            itemNames.add("NumReceivedFaults");
            itemNames.add("NumSentFaults");
            itemNames.add("NumReceivedErrors");
            itemNames.add("NumSentErrors");
            itemNames.add("NumCompletedExchanges");
            itemNames.add("NumActiveExchanges");
            itemNames.add("NumActiveExchangesMax");
            itemNames.add("NumQueuedExchanges");
            itemNames.add("NumQueuedExchangesMax");
            itemNames.add("NumErrorExchanges");
            ArrayList<String> itemDescriptions = new ArrayList<String>();
            itemDescriptions.add("Instance Name");
            itemDescriptions.add("Component Uptime");
            itemDescriptions.add("Number of activated endpoints");
            itemDescriptions.add("Number of received requests");
            itemDescriptions.add("Number of sent requests");
            itemDescriptions.add("Number of received replies");
            itemDescriptions.add("Number of sent replies");
            itemDescriptions.add("Number of received DONEs");
            itemDescriptions.add("Number of sent DONEs");
            itemDescriptions.add("Number of received faults");
            itemDescriptions.add("Number of sent faults");
            itemDescriptions.add("Number of received errors");
            itemDescriptions.add("Number of sent errors");
            itemDescriptions.add("Number of completed exchanges");
            itemDescriptions.add("Number of active exchanges");
            itemDescriptions.add("Number of active exchanges max");
            itemDescriptions.add("Number of queued exchanges");
            itemDescriptions.add("Number of queued exchanges max");
            itemDescriptions.add("Number of error exchanges");
            ArrayList<OpenType> itemTypes = new ArrayList<OpenType>();
            itemTypes.add(SimpleType.STRING);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            itemTypes.add(SimpleType.LONG);
            ArrayList<Object> itemValues = new ArrayList<Object>();
            itemValues.add(instanceName);
            itemValues.add(new Long(upTime));
            itemValues.add(deliveryChannelStats.get(COMPONENT_ACTIVE_ENDPOINTS));
            itemValues.add(deliveryChannelStats.get(COMPONENT_RECEIVE_REQUEST));
            itemValues.add(deliveryChannelStats.get(COMPONENT_SEND_REQUEST));
            itemValues.add(deliveryChannelStats.get(COMPONENT_RECEIVE_REPLY));
            itemValues.add(deliveryChannelStats.get(COMPONENT_SEND_REPLY));
            itemValues.add(deliveryChannelStats.get(COMPONENT_RECEIVE_DONE));
            itemValues.add(deliveryChannelStats.get(COMPONENT_SEND_DONE));
            itemValues.add(deliveryChannelStats.get(COMPONENT_RECEIVE_FAULT));
            itemValues.add(deliveryChannelStats.get(COMPONENT_SEND_FAULT));
            itemValues.add(deliveryChannelStats.get(COMPONENT_RECEIVE_ERROR));
            itemValues.add(deliveryChannelStats.get(COMPONENT_SEND_ERROR));
            itemValues.add(new Long(completedExchanges));
            itemValues.add(deliveryChannelStats.get(COMPONENT_ACTIVE_EXCHANGE));
            itemValues.add(deliveryChannelStats.get(COMPONENT_ACTIVE_EXCHANGE_MAX));
            itemValues.add(deliveryChannelStats.get(COMPONENT_QUEUED_EXCHANGE));
            itemValues.add(deliveryChannelStats.get(COMPONENT_QUEUED_EXCHANGE_MAX));
            itemValues.add(new Long(errorExchanges));
            if (deliveryChannelStats.containsKey(COMPONENT_RESPONSE_TIME)) {
                itemNames.add("MessageExchangeResponseTime Avg (ns)");
                itemDescriptions.add("Avg. response time for message exchange");
                itemTypes.add(SimpleType.LONG);
                itemValues.add(deliveryChannelStats.get(COMPONENT_RESPONSE_TIME));
            }
            if (deliveryChannelStats.containsKey(COMPONENT_COMPONENT_TIME)) {
                itemNames.add("MessageExchangeComponentTime Avg (ns)");
                itemDescriptions.add("Avg. time taken in component by message exchange");
                itemTypes.add(SimpleType.LONG);
                itemValues.add(deliveryChannelStats.get(COMPONENT_COMPONENT_TIME));
            }
            if (deliveryChannelStats.containsKey(COMPONENT_CHANNEL_TIME)) {
                itemNames.add("MessageExchangeDeliveryTime Avg (ns)");
                itemDescriptions.add("Avg. time taken in delivery channel by message exchange");
                itemTypes.add(SimpleType.LONG);
                itemValues.add(deliveryChannelStats.get(COMPONENT_CHANNEL_TIME));
            }
            if (deliveryChannelStats.containsKey(COMPONENT_NMR_TIME)) {
                itemNames.add("MessageExchangeNMRTime Avg (ns)");
                itemDescriptions.add("Avg. time taken in message service by message exchange");
                itemTypes.add(SimpleType.LONG);
                itemValues.add(deliveryChannelStats.get(COMPONENT_NMR_TIME));
            }
            if (deliveryChannelStats.containsKey(COMPONENT_STATUS_TIME)) {
                itemNames.add("MessageExchangeStatusTime Avg (ns)");
                itemDescriptions.add("Avg. status time taken by message exchange");
                itemTypes.add(SimpleType.LONG);
                itemValues.add(deliveryChannelStats.get(COMPONENT_STATUS_TIME));
            }
            if (componentExtnStats != null) {
                itemNames.add("ComponentExtensionStats");
                itemDescriptions.add("Statistics reported by component statistics MBeans");
                itemTypes.add(componentExtnStats.getCompositeType());
                itemValues.add(componentExtnStats);
            }
            return new CompositeDataSupport(new CompositeType("ComponentStatisticsItem", "Component statistics in an instance", itemNames.toArray(new String[0]), itemDescriptions.toArray(new String[0]), itemTypes.toArray(new OpenType[0])), itemNames.toArray(new String[0]), itemValues.toArray(new Object[0]));
        }
        catch (OpenDataException ex) {
            throw new JBIRemoteException(ex);
        }
    }

    private CompositeData getCompStatsAttributes(ObjectName mbeanName) throws JBIRemoteException {
        try {
            if (!this.isValidTarget(mbeanName)) {
                return null;
            }
            MBeanInfo mbeanInfo = this.getMBeanInfo(mbeanName);
            MBeanAttributeInfo[] attributes = mbeanInfo.getAttributes();
            String[] compExtnItems = new String[attributes.length];
            String[] compExtnDesc = new String[attributes.length];
            OpenType[] compExtnTypes = new OpenType[attributes.length];
            Object[] compAttrValues = new Object[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                String attrName = attributes[i].getName();
                String attrType = attributes[i].getType();
                Object attrValue = this.getMBeanAttribute(mbeanName, attrName);
                compExtnItems[i] = attrName;
                compExtnDesc[i] = attrName;
                compExtnTypes[i] = this.getOpenType(attrType, attrValue);
                compAttrValues[i] = attrValue;
            }
            return new CompositeDataSupport(new CompositeType("ComponentExtensionStats", "Component extension stats", compExtnItems, compExtnDesc, compExtnTypes), compExtnItems, compAttrValues);
        }
        catch (OpenDataException ex) {
            throw new JBIRemoteException(ex);
        }
        catch (JBIRemoteException jbiRemoteEx) {
            JBIStatisticsMBeanImpl.logDebug("Component custom stats are not available: " + jbiRemoteEx.getMessage());
            return null;
        }
        catch (Exception exception) {
            JBIStatisticsMBeanImpl.logDebug(exception);
            return null;
        }
    }

    private CompositeData getEndpointStats(String targetName, String instanceName, String endpointName, ObjectName messageServiceStatsMBean) throws JBIRemoteException {
        boolean isProvider = true;
        CompositeData allEndpointStats = (CompositeData)this.invokeMBeanOperation(messageServiceStatsMBean, "getEndpointStatistics", new Object[]{endpointName}, new String[]{"java.lang.String"});
        if (allEndpointStats == null) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.endpoint.not.exists", new String[]{endpointName}, null);
            JBIStatisticsMBeanImpl.logDebug(exception.getMessage());
            throw new JBIRemoteException(exception);
        }
        String owningComponent = null;
        try {
            Object[] exposedEndpointStatsProvider = allEndpointStats.getAll(ENDPOINT_STATS_PROVIDER_ITEM_NAMES);
            owningComponent = (String)allEndpointStats.get(OWNING_COMPONENT);
        }
        catch (InvalidKeyException invalidKeyException) {
            JBIStatisticsMBeanImpl.logDebug("All provider items are not present, could be consuming endpoint");
            isProvider = false;
        }
        TabularData ojcPerfTable = null;
        ObjectName compStatsExtensionMBean = null;
        Map<String, ObjectName> compStatsExtensionMBeans = null;
        if (owningComponent != null && owningComponent.length() > 0) {
            compStatsExtensionMBeans = this.getCompStatsExtensionMBeans(targetName, owningComponent);
        }
        if (compStatsExtensionMBeans != null) {
            compStatsExtensionMBean = (ObjectName)compStatsExtensionMBeans.get(instanceName);
        }
        if (compStatsExtensionMBean != null) {
            if (!endpointName.endsWith(COMMA)) {
                endpointName = endpointName + COMMA;
            }
            endpointName = isProvider ? endpointName + PROVIDER_MARKER : endpointName + CONSUMER_MARKER;
            JBIStatisticsMBeanImpl.logDebug("Getting extension stats from component");
            ojcPerfTable = this.getOJCPerformanceMeasurement(compStatsExtensionMBean, endpointName);
        }
        return this.composeEndpointStats(instanceName, allEndpointStats, isProvider, ojcPerfTable);
    }

    private TabularData getOJCPerformanceMeasurement(ObjectName compMbeanName, String endpointName) {
        try {
            TabularData allPerformanceStats = (TabularData)this.invokeMBeanOperation(compMbeanName, "getPerformanceInstrumentationMeasurement", new Object[]{endpointName}, new String[]{"java.lang.String"});
            CompositeType performanceStatsType = new CompositeType("PerformanceInstrumentationStats", "Performance Instrumentation Stats", OJC_HULP_STATS_ITEMS, OJC_HULP_STATS_DESCRIPTIONS, OJC_HULP_STATS_TYPES);
            TabularType performanceStatsTableType = new TabularType("PerformanceInstrumentationStats", "Performance Instrumentation Stats", performanceStatsType, OJC_STATS_TABLE_INDEX);
            TabularDataSupport perfStats = new TabularDataSupport(performanceStatsTableType);
            for (CompositeData compositeData : allPerformanceStats.values()) {
                CompositeType compositeType = compositeData.getCompositeType();
                Iterator<String> perfStatsIter = compositeType.keySet().iterator();
                Object[] values = new Object[OJC_HULP_STATS_ITEMS.length];
                while (perfStatsIter.hasNext()) {
                    String item = perfStatsIter.next();
                    if (item.equals(AVERAGE_KEY)) {
                        values[0] = (Double)compositeData.get(item);
                    }
                    if (item.equals(AVERAGEWITHOUTFIRSTMEASUREMENT_KEY)) {
                        values[1] = (Double)compositeData.get(item);
                    }
                    if (item.equals(FIRSTMEASUREMENTTIME_KEY)) {
                        values[2] = (Double)compositeData.get(item);
                    }
                    if (item.equals(LOAD_KEY)) {
                        values[3] = (Double)compositeData.get(item);
                    }
                    if (item.equals(NUMBEROFMEASUREMENTOBJECTS_KEY)) {
                        values[4] = (Integer)compositeData.get(item);
                    }
                    if (item.equals(NUMBEROFMEASUREMENTS_KEY)) {
                        values[5] = (Integer)compositeData.get(item);
                    }
                    if (item.equals(THROUGHPUT_KEY)) {
                        values[6] = (Double)compositeData.get(item);
                    }
                    if (item.equals(TIMETAKEN_KEY)) {
                        values[7] = (Double)compositeData.get(item);
                    }
                    if (item.equals(TOTALTIME_KEY)) {
                        values[8] = (Double)compositeData.get(item);
                    }
                    if (item.equals(MEDIAN_KEY)) {
                        values[9] = (Double)compositeData.get(item);
                    }
                    if (item.equals(SOURCE_KEY)) {
                        values[10] = (String)compositeData.get(item);
                    }
                    if (item.equals(SUB_TOPIC_KEY)) {
                        values[11] = (String)compositeData.get(item);
                    }
                    if (!item.equals(TOPIC_KEY)) continue;
                    values[12] = (String)compositeData.get(item);
                }
                perfStats.put(new CompositeDataSupport(performanceStatsType, OJC_HULP_STATS_ITEMS, values));
            }
            return perfStats;
        }
        catch (OpenDataException openDataEx) {
            JBIStatisticsMBeanImpl.logWarning(openDataEx);
            return null;
        }
        catch (JBIRemoteException jbiRemoteEx) {
            JBIStatisticsMBeanImpl.logDebug("Perfomance Instrumentation details are not available: " + jbiRemoteEx.getMessage());
            return null;
        }
        catch (Exception ex) {
            JBIStatisticsMBeanImpl.logWarning(ex);
            return null;
        }
    }

    private CompositeData composeEndpointStats(String instanceName, CompositeData endpointStats, boolean isProvider, TabularData ojcStats) {
        try {
            if (isProvider) {
                return this.composeProviderEndpointStats(instanceName, endpointStats, ojcStats);
            }
            return this.composeConsumerEndpointStats(instanceName, endpointStats, ojcStats);
        }
        catch (Exception ex) {
            JBIStatisticsMBeanImpl.logWarning(ex);
            return null;
        }
    }

    private CompositeData composeProviderEndpointStats(String instanceName, CompositeData endpointStats, TabularData ojcStats) {
        TabularType ojcStatsType = null;
        if (ojcStats != null) {
            ojcStatsType = ojcStats.getTabularType();
        }
        ArrayList<String> providerItemNames = new ArrayList<String>();
        providerItemNames.add(JBIStatisticsItemNames.INSTANCE_NAME);
        providerItemNames.add("ActivationTime");
        providerItemNames.add("EndpointUpTime (ms)");
        providerItemNames.add("NumActiveExchanges");
        providerItemNames.add("NumReceivedRequests");
        providerItemNames.add("NumSentReplies");
        providerItemNames.add("NumReceivedDONEs");
        providerItemNames.add("NumSentDONEs");
        providerItemNames.add("NumReceivedFaults");
        providerItemNames.add("NumSentFaults");
        providerItemNames.add("NumReceivedErrors");
        providerItemNames.add("NumSentErrors");
        providerItemNames.add("ComponentName");
        ArrayList<String> providerItemDescriptions = new ArrayList<String>();
        providerItemDescriptions.add("Instance Name");
        providerItemDescriptions.add("Time of activation");
        providerItemDescriptions.add("Endpoint upTime");
        providerItemDescriptions.add("Number of Active Exchanges");
        providerItemDescriptions.add("Number of Received Requests");
        providerItemDescriptions.add("Number of Sent Replies");
        providerItemDescriptions.add("Number of Received DONEs");
        providerItemDescriptions.add("Number of Sent DONEs");
        providerItemDescriptions.add("Number of Received Faults");
        providerItemDescriptions.add("Number of Sent Faults");
        providerItemDescriptions.add("Number of Received Errors");
        providerItemDescriptions.add("Number of Sent Errors");
        providerItemDescriptions.add("Component Name");
        ArrayList<OpenType> providerItemTypes = new ArrayList<OpenType>();
        providerItemTypes.add(SimpleType.STRING);
        providerItemTypes.add(SimpleType.DATE);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.STRING);
        Date activationTime = null;
        long upTime = 0L;
        Long activationTimeStamp = (Long)endpointStats.get(PROVIDER_ACTIVATION_TIMESTAMP);
        if (activationTimeStamp != null) {
            activationTime = new Date(activationTimeStamp);
            upTime = System.currentTimeMillis() - activationTime.getTime();
        }
        ArrayList<Object> providerItemValues = new ArrayList<Object>();
        providerItemValues.add(instanceName);
        providerItemValues.add(activationTime);
        providerItemValues.add(new Long(upTime));
        providerItemValues.add(endpointStats.get(COMPONENT_ACTIVE_EXCHANGE));
        providerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_REQUEST));
        providerItemValues.add(endpointStats.get(COMPONENT_SEND_REPLY));
        providerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_DONE));
        providerItemValues.add(endpointStats.get(COMPONENT_SEND_DONE));
        providerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_FAULT));
        providerItemValues.add(endpointStats.get(COMPONENT_SEND_FAULT));
        providerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_ERROR));
        providerItemValues.add(endpointStats.get(COMPONENT_SEND_ERROR));
        providerItemValues.add(endpointStats.get(OWNING_COMPONENT));
        if (endpointStats.containsKey(COMPONENT_RESPONSE_TIME)) {
            providerItemNames.add("MessageExchangeResponseTime Avg (ns)");
            providerItemDescriptions.add("Message Exchange ResponseTime Avg in ns");
            providerItemTypes.add(SimpleType.LONG);
            providerItemValues.add(endpointStats.get(COMPONENT_RESPONSE_TIME));
        }
        if (endpointStats.containsKey(COMPONENT_CHANNEL_TIME)) {
            providerItemNames.add("MessageExchangeDeliveryTime Avg (ns)");
            providerItemDescriptions.add("Message Exchange DeliveryChannelTime Avg in ns");
            providerItemTypes.add(SimpleType.LONG);
            providerItemValues.add(endpointStats.get(COMPONENT_CHANNEL_TIME));
        }
        if (endpointStats.containsKey(COMPONENT_COMPONENT_TIME)) {
            providerItemNames.add("MessageExchangeComponentTime Avg (ns)");
            providerItemDescriptions.add("Message Exchange ComponentTime Avg in ns");
            providerItemTypes.add(SimpleType.LONG);
            providerItemValues.add(endpointStats.get(COMPONENT_COMPONENT_TIME));
        }
        if (endpointStats.containsKey(COMPONENT_NMR_TIME)) {
            providerItemNames.add("MessageExchangeNMRTime Avg (ns)");
            providerItemTypes.add(SimpleType.LONG);
            providerItemDescriptions.add("Message Exchange MessageServiceTime  Avg in ns");
            providerItemValues.add(endpointStats.get(COMPONENT_NMR_TIME));
        }
        if (ojcStatsType != null) {
            providerItemNames.add("PerformanceMeasurements");
            providerItemDescriptions.add("Performance Measurements recorded by OJC Components");
            providerItemTypes.add(ojcStatsType);
            providerItemValues.add(ojcStats);
        }
        try {
            return new CompositeDataSupport(new CompositeType("ProviderEndpointStats", "Providing endpoint statistics in an instance", providerItemNames.toArray(new String[0]), providerItemDescriptions.toArray(new String[0]), providerItemTypes.toArray(new OpenType[0])), providerItemNames.toArray(new String[0]), providerItemValues.toArray(new Object[0]));
        }
        catch (OpenDataException ode) {
            JBIStatisticsMBeanImpl.logWarning(ode);
            return null;
        }
    }

    private CompositeData composeConsumerEndpointStats(String instanceName, CompositeData endpointStats, TabularData ojcStats) {
        TabularType ojcStatsType = null;
        if (ojcStats != null) {
            ojcStatsType = ojcStats.getTabularType();
        }
        ArrayList<String> consumerItemNames = new ArrayList<String>();
        consumerItemNames.add(JBIStatisticsItemNames.INSTANCE_NAME);
        consumerItemNames.add("NumSentRequests");
        consumerItemNames.add("NumReceivedReplies");
        consumerItemNames.add("NumReceivedDONEs");
        consumerItemNames.add("NumSentDONEs");
        consumerItemNames.add("NumReceivedFaults");
        consumerItemNames.add("NumSentFaults");
        consumerItemNames.add("NumReceivedErrors");
        consumerItemNames.add("NumSentErrors");
        consumerItemNames.add("NumActiveExchanges");
        consumerItemNames.add("ComponentName");
        ArrayList<String> consumerItemDescriptions = new ArrayList<String>();
        consumerItemDescriptions.add("Instance Name");
        consumerItemDescriptions.add("Number of Sent Requests");
        consumerItemDescriptions.add("Number of Received Replies");
        consumerItemDescriptions.add("Number of Received DONEs");
        consumerItemDescriptions.add("Number of Sent DONEs");
        consumerItemDescriptions.add("Number of Received Faults");
        consumerItemDescriptions.add("Number of Sent Faults");
        consumerItemDescriptions.add("Number of Received Errors");
        consumerItemDescriptions.add("Number of Sent Errors");
        consumerItemDescriptions.add("Number of active exchanges");
        consumerItemDescriptions.add("Name of the owning component");
        ArrayList<OpenType> consumerItemTypes = new ArrayList<OpenType>();
        consumerItemTypes.add(SimpleType.STRING);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.LONG);
        consumerItemTypes.add(SimpleType.STRING);
        ArrayList<Object> consumerItemValues = new ArrayList<Object>();
        consumerItemValues.add(instanceName);
        consumerItemValues.add(endpointStats.get(COMPONENT_SEND_REQUEST));
        consumerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_REPLY));
        consumerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_DONE));
        consumerItemValues.add(endpointStats.get(COMPONENT_SEND_DONE));
        consumerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_FAULT));
        consumerItemValues.add(endpointStats.get(COMPONENT_SEND_FAULT));
        consumerItemValues.add(endpointStats.get(COMPONENT_RECEIVE_ERROR));
        consumerItemValues.add(endpointStats.get(COMPONENT_SEND_ERROR));
        consumerItemValues.add(endpointStats.get(COMPONENT_ACTIVE_EXCHANGE));
        consumerItemValues.add(endpointStats.get(OWNING_COMPONENT));
        if (endpointStats.containsKey(COMPONENT_STATUS_TIME)) {
            consumerItemNames.add("MessageExchangeStatusTime Avg (ns)");
            consumerItemDescriptions.add("Message Exchange Status Time Avg in ns");
            consumerItemTypes.add(SimpleType.LONG);
            consumerItemValues.add(endpointStats.get(COMPONENT_STATUS_TIME));
        }
        if (endpointStats.containsKey(COMPONENT_COMPONENT_TIME)) {
            consumerItemNames.add("MessageExchangeComponentTime Avg (ns)");
            consumerItemDescriptions.add("Message Exchange ComponentTime Avg in ns");
            consumerItemTypes.add(SimpleType.LONG);
            consumerItemValues.add(endpointStats.get(COMPONENT_COMPONENT_TIME));
        }
        if (endpointStats.containsKey(COMPONENT_CHANNEL_TIME)) {
            consumerItemNames.add("MessageExchangeDeliveryTime Avg (ns)");
            consumerItemDescriptions.add("Message Exchange DeliveryChannelTime Avg in ns");
            consumerItemTypes.add(SimpleType.LONG);
            consumerItemValues.add(endpointStats.get(COMPONENT_CHANNEL_TIME));
        }
        if (endpointStats.containsKey(COMPONENT_NMR_TIME)) {
            consumerItemNames.add("MessageExchangeNMRTime Avg (ns)");
            consumerItemDescriptions.add("Message Exchange MessageServiceTime  Avg in ns");
            consumerItemTypes.add(SimpleType.LONG);
            consumerItemValues.add(endpointStats.get(COMPONENT_NMR_TIME));
        }
        if (ojcStatsType != null) {
            consumerItemNames.add("PerformanceMeasurements");
            consumerItemDescriptions.add("Performance Measurements recorded by OJC Components");
            consumerItemTypes.add(ojcStatsType);
            consumerItemValues.add(ojcStats);
        }
        try {
            return new CompositeDataSupport(new CompositeType("ConsumerEndpointStats", "Consumer Endpoint Statistics", consumerItemNames.toArray(new String[0]), consumerItemDescriptions.toArray(new String[0]), consumerItemTypes.toArray(new SimpleType[0])), consumerItemNames.toArray(new String[0]), consumerItemValues.toArray(new Object[0]));
        }
        catch (OpenDataException ode) {
            JBIStatisticsMBeanImpl.logWarning(ode);
            return null;
        }
    }

    private OpenType getOpenType(String javaType, Object value) throws JBIRemoteException {
        try {
            if (javaType.equals("javax.management.openmbean.CompositeType")) {
                return ((CompositeData)value).getCompositeType();
            }
            if (javaType.equals("javax.management.openmbean.TabularType")) {
                return ((TabularData)value).getTabularType();
            }
            if (javaType.startsWith("[")) {
                String className = javaType.substring(javaType.indexOf("java"), javaType.length() - 1);
                return new ArrayType(1, JAVATYPE_TO_OPENTYPE.get(className));
            }
            return JAVATYPE_TO_OPENTYPE.get(javaType);
        }
        catch (OpenDataException ex) {
            throw new JBIRemoteException(ex);
        }
    }

    private boolean isComponentUp(String componentName, String targetName) throws JBIRemoteException {
        ComponentQuery compQuery = this.mEnvContext.getComponentQuery(targetName);
        ComponentInfo compInfo = compQuery.getComponentInfo(componentName);
        if (compInfo == null) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.comp.not.exists", new String[]{componentName}, null);
            JBIStatisticsMBeanImpl.logDebug(exception.getMessage());
            throw new JBIRemoteException(exception);
        }
        JBIStatisticsMBeanImpl.logDebug("Component status in target " + targetName + " is " + (Object)((Object)compInfo.getStatus()));
        return compInfo.getStatus() == ComponentState.STARTED;
    }

    private boolean isComponentInstalled(String componentName, String targetName) {
        ComponentQuery compQuery = this.mEnvContext.getComponentQuery(targetName);
        return compQuery.getComponentInfo(componentName) != null;
    }

    @Override
    public TabularData getConsumingEndpointsForComponent(String componentName, String targetName) throws JBIRemoteException {
        return this.getEndpointListForComponent(componentName, targetName, true);
    }

    @Override
    public TabularData getProvidingEndpointsForComponent(String componentName, String targetName) throws JBIRemoteException {
        return this.getEndpointListForComponent(componentName, targetName, false);
    }

    public TabularData getEndpointListForComponent(String componentName, String targetName, boolean listConsuming) throws JBIRemoteException {
        try {
            if (!this.isComponentInstalled(componentName, targetName)) {
                Exception exception = this.createManagementException("ui.mbean.system.stats.comp.not.installed", new String[]{componentName, targetName}, null);
                JBIStatisticsMBeanImpl.logDebug(exception.getMessage());
                throw new JBIRemoteException(exception);
            }
            Map<String, ObjectName> nmrMBeans = this.getNMRStatsMBeans(targetName);
            Set<String> instances = nmrMBeans.keySet();
            OpenType[] endpointListItemTypes = new OpenType[]{SimpleType.STRING, new ArrayType(1, SimpleType.STRING)};
            CompositeType endpointListCompositeType = new CompositeType("EndpointsList", "List of Endpoints", ENDPOINT_LIST_STATS_ITEM_NAMES, ENDPOINT_LIST_STATS_ITEM_DESCRIPTIONS, endpointListItemTypes);
            TabularType endpointListTabularType = new TabularType("Endpoints Table", "Endpoints Table", endpointListCompositeType, JBIStatisticsItemNames.STATS_TABLE_INDEX);
            TabularDataSupport endpointListTable = new TabularDataSupport(endpointListTabularType);
            for (String instance : instances) {
                ObjectName mbean = nmrMBeans.get(instance);
                if (mbean == null) continue;
                JBIStatisticsMBeanImpl.logDebug("Getting endpoint list statistics for " + instance);
                endpointListTable.put(this.getEndpointsList(endpointListCompositeType, instance, componentName, mbean, listConsuming));
            }
            return endpointListTable;
        }
        catch (OpenDataException ex) {
            Exception exception = this.createManagementException("ui.mbean.system.stats.error.in.compose", new String[]{targetName}, ex);
            JBIStatisticsMBeanImpl.logDebug(ex.getMessage());
            throw new JBIRemoteException(exception);
        }
    }

    private CompositeData getEndpointsList(CompositeType endpointListStatsEntriesType, String instanceName, String componentName, ObjectName mbean, boolean listConsuming) throws JBIRemoteException {
        try {
            String endpointQueryMethodName = listConsuming ? QUERY_CONSUMING_ENDPOINT_LIST : QUERY_ENDPOINT_LIST;
            String[] endpointsList = (String[])this.invokeMBeanOperation(mbean, endpointQueryMethodName, new Object[]{componentName}, new String[]{"java.lang.String"});
            Object[] values = new Object[]{instanceName, endpointsList};
            return new CompositeDataSupport(endpointListStatsEntriesType, ENDPOINT_LIST_STATS_ITEM_NAMES, values);
        }
        catch (OpenDataException ex) {
            throw new JBIRemoteException(ex);
        }
    }

    static {
        JAVATYPE_TO_OPENTYPE.put("java.lang.Long", SimpleType.LONG);
        JAVATYPE_TO_OPENTYPE.put("java.lang.String", SimpleType.STRING);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Boolean", SimpleType.BOOLEAN);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Character", SimpleType.CHARACTER);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Byte", SimpleType.BYTE);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Short", SimpleType.SHORT);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Integer", SimpleType.INTEGER);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Float", SimpleType.FLOAT);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Double", SimpleType.DOUBLE);
        JAVATYPE_TO_OPENTYPE.put("java.lang.BigDecimal", SimpleType.BIGDECIMAL);
        JAVATYPE_TO_OPENTYPE.put("java.lang.BigInteger", SimpleType.BIGINTEGER);
        JAVATYPE_TO_OPENTYPE.put("java.lang.Date", SimpleType.DATE);
        OJC_HULP_STATS_ITEMS = new String[]{AVERAGE_KEY, AVERAGEWITHOUTFIRSTMEASUREMENT_KEY, FIRSTMEASUREMENTTIME_KEY, LOAD_KEY, NUMBEROFMEASUREMENTOBJECTS_KEY, NUMBEROFMEASUREMENTS_KEY, THROUGHPUT_KEY, TIMETAKEN_KEY, TOTALTIME_KEY, MEDIAN_KEY, SOURCE_KEY, SUB_TOPIC_KEY, TOPIC_KEY};
        OJC_HULP_STATS_DESCRIPTIONS = new String[]{"average sum of all dt-s divided by N", "average' (ms) (the sum of all dt-s minus the first dt) divided by N", "first dt", "Load The sum of all dt-s divided by (tlast - tfirst)", "the number of measurement objects on which begin() was called but not * end()", "Number of measurements (or N)", "throughput N divided by (tlast - tfirst)", "tlast - tfirst the wallclock time of the first measurement's begin()method", "total time (ms) the sum of all dt-s", "median key", "source key", "sub topic the name of the measurement", "topic the name of the measurement"};
        OJC_HULP_STATS_TYPES = new OpenType[]{SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        OJC_STATS_TABLE_INDEX = new String[]{SUB_TOPIC_KEY};
    }
}

