/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime.verifier.util;

import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.runtime.verifier.VerifierException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierUtils {
    private static final int BUFFER_SIZE = 8192;
    private I18NBundle mResourceBundle;
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String SU_DESC_PATH = "META-INF" + File.separator + "jbi.xml";
    private static final String INTERFACE_NAME = "interface-name";
    private static final String ENDPOINT_NAME = "endpoint-name";
    private static final String SERVICE_NAME = "service-name";
    private static final String NAME = "name";
    private static final String TARGET_NS = "targetNamespace";
    private static final String JAVAEE_SERVICE_ENGINE = "sun-javaee-engine";
    private static final short WSDL11 = 11;
    private static final short WSDL20 = 20;

    public VerifierUtils(I18NBundle resourceBundle) {
        this.mResourceBundle = resourceBundle;
    }

    public boolean cleanup(String tmpDir) {
        return this.cleanDirectory(new File(tmpDir));
    }

    private boolean cleanDirectory(File dir) {
        File[] tmps = dir.listFiles();
        for (int i = 0; i < tmps.length; ++i) {
            if (tmps[i].isDirectory() && !this.cleanDirectory(tmps[i])) {
                return false;
            }
            if (tmps[i].delete()) continue;
            return false;
        }
        return true;
    }

    public Map<String, File[]> getWSDLs(String saDirPath) throws VerifierException {
        HashMap<String, File[]> wsdlMap = new HashMap<String, File[]>();
        try {
            File saDir = new File(saDirPath);
            if (!saDir.exists()) {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_SA_NOT_EXTRACTED"));
            }
            File[] sus = saDir.listFiles();
            for (int i = 0; i < sus.length; ++i) {
                StringBuffer logInfo = new StringBuffer();
                logInfo.append("WSDLs in " + sus[i].getName() + ": ");
                if (!sus[i].isDirectory()) continue;
                List<File> wsdls = this.getWSDLFiles(sus[i]);
                for (File wsdl : wsdls) {
                    logInfo.append(wsdl.getName());
                }
                ToolsLogManager.getRuntimeLogger().finer(logInfo.toString());
                wsdlMap.put(sus[i].getName(), wsdls.toArray(new File[wsdls.size()]));
            }
            return wsdlMap;
        }
        catch (Exception ex) {
            throw new VerifierException(ex);
        }
    }

    public Map<String, String[]> getWSDLs(JBIArchive archive) throws VerifierException {
        HashMap<String, String[]> wsdlMap = new HashMap<String, String[]>();
        try {
            JarFile saJar = new JarFile(archive.getJarFile().getName());
            if (!new File(saJar.getName()).exists()) {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_INVALID_SA"));
            }
            ServiceAssemblyDD saDesc = (ServiceAssemblyDD)archive.getJbiDescriptor();
            List suDescs = saDesc.getServiceUnitDDList();
            for (ServiceAssemblyDD.ServiceUnitDD suDesc : suDescs) {
                String suName = suDesc.getName();
                String suArtifactZipName = suDesc.getArtifactZipName();
                ZipEntry suZipEntry = saJar.getEntry(suArtifactZipName);
                if (suZipEntry == null) {
                    throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_SU_ARTIFACT_MISSING", new Object[]{suArtifactZipName}));
                }
                ZipInputStream suEntryInStream = new ZipInputStream(saJar.getInputStream(suZipEntry));
                StringBuffer logInfo = new StringBuffer();
                logInfo.append("WSDLs in " + suName + ": ");
                ZipEntry wsdlZipEntry = null;
                ArrayList<String> wsdls = new ArrayList<String>();
                while (suEntryInStream != null && (wsdlZipEntry = suEntryInStream.getNextEntry()) != null) {
                    if (wsdlZipEntry.getName().endsWith(".wsdl")) {
                        // empty if block
                    }
                    int i = 0;
                    byte[] buffer = new byte[512];
                    ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
                    while ((i = suEntryInStream.read(buffer)) > 0) {
                        outBuffer.write(buffer, 0, i);
                    }
                    wsdls.add(new String(outBuffer.toString()));
                    outBuffer.close();
                }
                suEntryInStream.close();
                ToolsLogManager.getRuntimeLogger().finer(logInfo.toString());
                wsdlMap.put(suName, wsdls.toArray(new String[wsdls.size()]));
            }
            saJar.close();
            return wsdlMap;
        }
        catch (Exception ex) {
            throw new VerifierException(ex);
        }
    }

    public Map<String, String> getSUJarEntryMap(JBIArchive archive) throws VerifierException {
        HashMap<String, String> suNameToSUJarEntryMap = new HashMap<String, String>();
        try {
            JarFile saJar = new JarFile(archive.getJarFile().getName());
            if (!new File(saJar.getName()).exists()) {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_INVALID_SA"));
            }
            ServiceAssemblyDD saDesc = (ServiceAssemblyDD)archive.getJbiDescriptor();
            List suDescs = saDesc.getServiceUnitDDList();
            for (ServiceAssemblyDD.ServiceUnitDD suDesc : suDescs) {
                suNameToSUJarEntryMap.put(suDesc.getName(), suDesc.getArtifactZipName());
            }
            saJar.close();
            return suNameToSUJarEntryMap;
        }
        catch (Exception ex) {
            throw new VerifierException(ex);
        }
    }

    public Map<String, List<String>> getEndpointConfigMap(String suDir) throws VerifierException {
        HashMap<String, List<String>> configMap = new HashMap<String, List<String>>();
        try {
            int i;
            File descriptor = new File(suDir, SU_DESC_PATH);
            if (!descriptor.exists()) {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_SA_NOT_EXTRACTED"));
            }
            InputSource inputSource = new InputSource(new FileInputStream(descriptor));
            ArrayList endpointNames = new ArrayList();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new WSDLNamespaceContext());
            NodeList consumes = (NodeList)xpath.evaluate("/jbi:jbi/jbi:services/jbi:consumes", inputSource, XPathConstants.NODESET);
            inputSource = new InputSource(new FileInputStream(descriptor));
            NodeList provides = (NodeList)xpath.evaluate("/jbi:jbi/jbi:services/jbi:provides", inputSource, XPathConstants.NODESET);
            for (i = 0; i < consumes.getLength(); ++i) {
                configMap.putAll(this.getConfigsUsedInNode(consumes.item(i)));
            }
            for (i = 0; i < provides.getLength(); ++i) {
                configMap.putAll(this.getConfigsUsedInNode(provides.item(i)));
            }
            return configMap;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (IOException ioEx) {
            throw new VerifierException(ioEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    public Map<String, List<String>> getEndpointConfigMap(JBIArchive archive, String suJarEntryName) throws VerifierException {
        HashMap<String, List<String>> configMap = new HashMap<String, List<String>>();
        try {
            int i;
            JarFile saJar = new JarFile(archive.getJarFile().getName());
            if (!new File(saJar.getName()).exists()) {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_INVALID_SA"));
            }
            ZipEntry suZipEntry = saJar.getEntry(suJarEntryName);
            if (suZipEntry == null) {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_SU_ARTIFACT_MISSING", new Object[]{suJarEntryName}));
            }
            ZipInputStream suEntryInStream = new ZipInputStream(saJar.getInputStream(suZipEntry));
            ZipEntry ddZipEntry = null;
            String outputString = null;
            while (suEntryInStream != null && (ddZipEntry = suEntryInStream.getNextEntry()) != null) {
                if (!ddZipEntry.getName().endsWith("jbi.xml")) continue;
                int i2 = 0;
                byte[] buffer = new byte[512];
                ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
                while ((i2 = suEntryInStream.read(buffer)) > 0) {
                    outBuffer.write(buffer, 0, i2);
                }
                outputString = new String(outBuffer.toString());
                outBuffer.close();
                break;
            }
            suEntryInStream.close();
            if (outputString == null) {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_SU_ARTIFACT_MISSING", new Object[]{suJarEntryName}));
            }
            InputSource inputSource = new InputSource(new StringReader(outputString));
            ArrayList endpointNames = new ArrayList();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new WSDLNamespaceContext());
            NodeList consumes = (NodeList)xpath.evaluate("/jbi:jbi/jbi:services/jbi:consumes", inputSource, XPathConstants.NODESET);
            inputSource = new InputSource(new StringReader(outputString));
            NodeList provides = (NodeList)xpath.evaluate("/jbi:jbi/jbi:services/jbi:provides", inputSource, XPathConstants.NODESET);
            for (i = 0; i < consumes.getLength(); ++i) {
                configMap.putAll(this.getConfigsUsedInNode(consumes.item(i)));
            }
            for (i = 0; i < provides.getLength(); ++i) {
                configMap.putAll(this.getConfigsUsedInNode(provides.item(i)));
            }
            saJar.close();
            return configMap;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (IOException ioEx) {
            throw new VerifierException(ioEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    private Map<String, List<String>> getConfigsUsedInNode(Node node) throws VerifierException {
        try {
            HashMap<String, List<String>> configMap = new HashMap<String, List<String>>();
            String URI2 = "";
            String interfaceName = this.getAttributeValue(node, INTERFACE_NAME);
            if (interfaceName != null) {
                String prefix = interfaceName.substring(0, interfaceName.indexOf(":"));
                URI2 = node.lookupNamespaceURI(prefix);
            }
            ArrayList<String> configList = new ArrayList<String>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new WSDLNamespaceContext());
            NodeList config = (NodeList)xpath.evaluate("config:application-config", node, XPathConstants.NODESET);
            for (int j = 0; j < config.getLength(); ++j) {
                configList.add(this.getAttributeValue(config.item(j), NAME));
            }
            String serviceName = null;
            String epName = null;
            serviceName = this.getAttributeValue(node, SERVICE_NAME);
            if (serviceName != null) {
                serviceName = serviceName.substring(serviceName.indexOf(":") + 1);
            }
            epName = this.getAttributeValue(node, ENDPOINT_NAME);
            String endpointName = this.createEndpointName(URI2, serviceName, epName);
            ToolsLogManager.getRuntimeLogger().finer("Adding config list to endpoint " + endpointName + configList);
            configMap.put(endpointName, configList);
            return configMap;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    private List<File> getWSDLFiles(File dir) {
        ArrayList<File> wsdlFiles = new ArrayList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                wsdlFiles.addAll(this.getWSDLFiles(files[i]));
                continue;
            }
            if (!files[i].getName().endsWith(".wsdl")) continue;
            wsdlFiles.add(files[i]);
        }
        return wsdlFiles;
    }

    public String[] getEndpointName(File wsdlFile) throws VerifierException {
        try {
            ArrayList<String> endpointNames = new ArrayList<String>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            InputSource inputSource = new InputSource(new FileInputStream(wsdlFile));
            short wsdlVer = this.getWSDLVersionNumber(wsdlFile);
            NodeList ports = null;
            if (wsdlVer == 11) {
                xpath.setNamespaceContext(new WSDL11NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-11:definitions/wsdl-11:service/wsdl-11:port", inputSource, XPathConstants.NODESET);
            } else if (wsdlVer == 20) {
                xpath.setNamespaceContext(new WSDL20NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-20:description/wsdl-20:service/wsdl-20:endport", inputSource, XPathConstants.NODESET);
            } else {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WRONG_WSDL_VERSION"));
            }
            String serviceName = this.getServiceName(wsdlFile);
            String namespaceURI = null;
            if (ports.getLength() > 0) {
                Node port = ports.item(0);
                Document doc = port.getOwnerDocument();
                Element definitions = doc.getDocumentElement();
                namespaceURI = definitions.getAttribute(TARGET_NS);
            }
            int length = ports.getLength();
            for (int i = 0; i < length; ++i) {
                String endpointName = this.createEndpointName(namespaceURI, serviceName, this.getAttributeValue(ports.item(i), NAME));
                ToolsLogManager.getRuntimeLogger().finer("Adding endpoint " + endpointName);
                endpointNames.add(endpointName);
            }
            String[] endpoints = new String[endpointNames.size()];
            endpointNames.toArray(endpoints);
            return endpoints;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (IOException ioEx) {
            throw new VerifierException(ioEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    public String[] getEndpointName(String wsdlString) throws VerifierException {
        try {
            short wsdlVer = this.getWSDLVersionNumber(wsdlString);
            ArrayList<String> endpointNames = new ArrayList<String>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            NodeList ports = null;
            InputSource inputSource = new InputSource(new StringReader(wsdlString));
            if (wsdlVer == 11) {
                xpath.setNamespaceContext(new WSDL11NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-11:definitions/wsdl-11:service/wsdl-11:port", inputSource, XPathConstants.NODESET);
            } else if (wsdlVer == 20) {
                xpath.setNamespaceContext(new WSDL20NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-20:description/wsdl-20:service/wsdl-20:endport", inputSource, XPathConstants.NODESET);
            } else {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WRONG_WSDL_VERSION"));
            }
            String serviceName = this.getServiceName(wsdlString);
            String namespaceURI = null;
            if (ports.getLength() > 0) {
                Node port = ports.item(0);
                Document doc = port.getOwnerDocument();
                Element definitions = doc.getDocumentElement();
                namespaceURI = definitions.getAttribute(TARGET_NS);
            }
            int length = ports.getLength();
            for (int i = 0; i < length; ++i) {
                String endpointName = this.createEndpointName(namespaceURI, serviceName, this.getAttributeValue(ports.item(i), NAME));
                ToolsLogManager.getRuntimeLogger().finer("Adding endpoint " + endpointName);
                endpointNames.add(endpointName);
            }
            String[] endpoints = new String[endpointNames.size()];
            endpointNames.toArray(endpoints);
            return endpoints;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    public String createEndpointName(String namespace, String serviceName, String endpointName) {
        StringBuffer epname = new StringBuffer();
        if (namespace != null) {
            epname.append(namespace);
            if (!namespace.endsWith("/")) {
                epname.append("/");
            }
            epname.append(",");
        }
        epname.append(serviceName);
        epname.append(",");
        epname.append(endpointName);
        return epname.toString();
    }

    private String getServiceName(File wsdlFile) throws VerifierException {
        try {
            short wsdlVer = this.getWSDLVersionNumber(wsdlFile);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            InputSource inputSource = new InputSource(new FileInputStream(wsdlFile));
            if (wsdlVer == 11) {
                xpath.setNamespaceContext(new WSDL11NamespaceContext());
                return xpath.evaluate("/wsdl-11:definitions/wsdl-11:service/attribute::name", inputSource);
            }
            if (wsdlVer == 20) {
                xpath.setNamespaceContext(new WSDL20NamespaceContext());
                return xpath.evaluate("/wsdl-20:description/wsdl-20:service/attribute::name", inputSource);
            }
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WRONG_WSDL_VERSION"));
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    private String getServiceName(String wsdlString) throws VerifierException {
        try {
            short wsdlVer = this.getWSDLVersionNumber(wsdlString);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            InputSource inputSource = new InputSource(new StringReader(wsdlString));
            if (wsdlVer == 11) {
                xpath.setNamespaceContext(new WSDL11NamespaceContext());
                return xpath.evaluate("/wsdl-11:definitions/wsdl-11:service/attribute::name", inputSource);
            }
            if (wsdlVer == 20) {
                xpath.setNamespaceContext(new WSDL20NamespaceContext());
                return xpath.evaluate("/wsdl-20:description/wsdl-20:service/attribute::name", inputSource);
            }
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WRONG_WSDL_VERSION"));
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    public String getAttributeValue(Node node, String attribute) {
        if (node != null) {
            NamedNodeMap attrbs = node.getAttributes();
            Node attrb = attrbs.getNamedItem(attribute);
            return attrb.getNodeValue();
        }
        return null;
    }

    public List getApplicationVariables(File wsdlFile, String endpointName) throws VerifierException {
        try {
            short wsdlVer = this.getWSDLVersionNumber(wsdlFile);
            String epName = null;
            if (endpointName != null) {
                epName = endpointName.substring(endpointName.lastIndexOf(",") + 1);
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            InputSource inputSource = new InputSource(new FileInputStream(wsdlFile));
            ArrayList appVarList = new ArrayList();
            NodeList ports = null;
            if (wsdlVer == 11) {
                xpath.setNamespaceContext(new WSDL11NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-11:definitions/wsdl-11:service/wsdl-11:port", inputSource, XPathConstants.NODESET);
            } else if (wsdlVer == 20) {
                xpath.setNamespaceContext(new WSDL20NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-20:description/wsdl-20:service/wsdl-20:endport", inputSource, XPathConstants.NODESET);
            } else {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WRONG_WSDL_VERSION"));
            }
            int length = ports.getLength();
            for (int i = 0; i < length; ++i) {
                if (!epName.equals(this.getAttributeValue(ports.item(i), NAME))) continue;
                appVarList.addAll(this.getAppVars(ports.item(i)));
            }
            ToolsLogManager.getRuntimeLogger().finer("Application Variables used in " + epName + " are: " + appVarList);
            return appVarList;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (IOException ioEx) {
            throw new VerifierException(ioEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    public List getApplicationVariables(String wsdlString, String endpointName) throws VerifierException {
        try {
            short wsdlVer = this.getWSDLVersionNumber(wsdlString);
            String epName = null;
            if (endpointName != null) {
                epName = endpointName.substring(endpointName.lastIndexOf(",") + 1);
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            InputSource inputSource = new InputSource(new StringReader(wsdlString));
            ArrayList appVarList = new ArrayList();
            NodeList ports = null;
            if (wsdlVer == 11) {
                xpath.setNamespaceContext(new WSDL11NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-11:definitions/wsdl-11:service/wsdl-11:port", inputSource, XPathConstants.NODESET);
            } else if (wsdlVer == 20) {
                xpath.setNamespaceContext(new WSDL20NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-20:description/wsdl-20:service/wsdl-20:endport", inputSource, XPathConstants.NODESET);
            } else {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WRONG_WSDL_VERSION"));
            }
            int length = ports.getLength();
            for (int i = 0; i < length; ++i) {
                if (!epName.equals(this.getAttributeValue(ports.item(i), NAME))) continue;
                appVarList.addAll(this.getAppVars(ports.item(i)));
            }
            ToolsLogManager.getRuntimeLogger().finer("Application Variables used in " + epName + " are: " + appVarList);
            return appVarList;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    private List getAppVars(Node node) {
        ArrayList applicationVariables;
        block6: {
            applicationVariables = new ArrayList();
            try {
                int i;
                applicationVariables.addAll(this.getAppVars(node.getNodeValue()));
                if (node.hasAttributes()) {
                    NamedNodeMap attrs = node.getAttributes();
                    for (i = 0; i < attrs.getLength(); ++i) {
                        applicationVariables.addAll(this.getAppVars(attrs.item(i).getNodeValue()));
                    }
                }
                if (node.hasChildNodes()) {
                    NodeList children = node.getChildNodes();
                    for (i = 0; i < children.getLength(); ++i) {
                        applicationVariables.addAll(this.getAppVars(children.item(i)));
                    }
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() == null) break block6;
                ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
            }
        }
        return applicationVariables;
    }

    private short getWSDLVersionNumber(InputSource inputSource11, InputSource inputSource20) throws VerifierException {
        try {
            XPath xpath11 = XPathFactory.newInstance().newXPath();
            String expression11 = "/wsdl-11:definitions";
            xpath11.setNamespaceContext(new WSDL11NamespaceContext());
            NodeList nodes = (NodeList)xpath11.evaluate(expression11, inputSource11, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                return 11;
            }
            XPath xpath20 = XPathFactory.newInstance().newXPath();
            String expression20 = "/wsdl-20:description";
            xpath20.setNamespaceContext(new WSDL20NamespaceContext());
            nodes = (NodeList)xpath20.evaluate(expression20, inputSource20, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                return 20;
            }
        }
        catch (XPathExpressionException exp) {
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_INVALID_WSDL_FORMAT"));
        }
        throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_INVALID_WSDL_FORMAT"));
    }

    private short getWSDLVersionNumber(File inputFile) throws VerifierException {
        try {
            InputSource inputSource11 = new InputSource(new FileInputStream(inputFile));
            InputSource inputSource20 = new InputSource(new FileInputStream(inputFile));
            return this.getWSDLVersionNumber(inputSource11, inputSource20);
        }
        catch (FileNotFoundException exp) {
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WSDL_FILE_NOT_FOUND", new Object[]{("" + inputFile).toString()}));
        }
    }

    private short getWSDLVersionNumber(String inputString) throws VerifierException {
        InputSource inputSource11 = new InputSource(new StringReader(inputString));
        InputSource inputSource20 = new InputSource(new StringReader(inputString));
        return this.getWSDLVersionNumber(inputSource11, inputSource20);
    }

    public List getAppVars(String content) {
        ArrayList<String> appVars;
        block5: {
            appVars = new ArrayList<String>();
            try {
                if (content != null && content.indexOf("$") != -1) {
                    String[] tokens = content.split("[$}]");
                    for (int i = 0; i < tokens.length; ++i) {
                        if (tokens[i].indexOf("{") == -1) continue;
                        String[] variables = tokens[i].split("[{]");
                        for (int j = 0; j < variables.length; ++j) {
                            if (variables[j].length() <= 0) continue;
                            appVars.add(variables[j]);
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() == null) break block5;
                ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
            }
        }
        return appVars;
    }

    public boolean isPortConfiguredForEndpoint(String wsdlString, String endpointName) throws VerifierException {
        try {
            short wsdlVer = this.getWSDLVersionNumber(wsdlString);
            String epName = null;
            if (endpointName != null) {
                epName = endpointName.substring(endpointName.lastIndexOf(",") + 1);
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            InputSource inputSource = new InputSource(new StringReader(wsdlString));
            NodeList ports = null;
            if (wsdlVer == 11) {
                xpath.setNamespaceContext(new WSDL11NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-11:definitions/wsdl-11:service/wsdl-11:port", inputSource, XPathConstants.NODESET);
            } else if (wsdlVer == 20) {
                xpath.setNamespaceContext(new WSDL20NamespaceContext());
                ports = (NodeList)xpath.evaluate("/wsdl-20:description/wsdl-20:service/wsdl-20:endport", inputSource, XPathConstants.NODESET);
            } else {
                throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_WRONG_WSDL_VERSION"));
            }
            int length = ports.getLength();
            for (int i = 0; i < length; ++i) {
                if (!epName.equals(this.getAttributeValue(ports.item(i), NAME)) || !ports.item(i).hasChildNodes()) continue;
                return true;
            }
            ToolsLogManager.getRuntimeLogger().finer("Endpoint " + endpointName + " has no child elements for port definition");
            return false;
        }
        catch (XPathExpressionException xpathEx) {
            throw new VerifierException(xpathEx.toString());
        }
        catch (Exception ex) {
            throw new VerifierException(ex.toString());
        }
    }

    class WSDL20NamespaceContext
    implements NamespaceContext {
        WSDL20NamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            if (prefix.equals("wsdl-20")) {
                return "http://www.w3.org/ns/wsdl";
            }
            return VerifierUtils.NS_URI_XMLNS;
        }

        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }

    class WSDL11NamespaceContext
    implements NamespaceContext {
        WSDL11NamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            if (prefix.equals("wsdl-11")) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }
            return VerifierUtils.NS_URI_XMLNS;
        }

        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }

    class WSDLNamespaceContext
    implements NamespaceContext {
        WSDLNamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            if (prefix.equals("jbi")) {
                return "http://java.sun.com/xml/ns/jbi";
            }
            if (prefix.equals("config")) {
                return "http://www.sun.com/jbi/descriptor/configuration";
            }
            return VerifierUtils.NS_URI_XMLNS;
        }

        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

