/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ConsumingEndpointStatisticsData;
import com.sun.esb.management.common.data.IEndpointStatisticsData;
import com.sun.esb.management.common.data.PerformanceData;
import com.sun.esb.management.common.data.ProvisioningEndpointStatisticsData;
import com.sun.esb.management.common.data.helper.ConsumingEndpointStatisticsDataCreator;
import com.sun.esb.management.common.data.helper.EndpointStatisticsDataWriter;
import com.sun.esb.management.common.data.helper.ProvisioningEndpointStatisticsDataCreator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointStatisticsData
implements IEndpointStatisticsData,
Serializable {
    static final long serialVersionUID = -1L;
    public static final String INSTANCE_NAME_KEY = "InstanceName";
    public static final String COMPONENT_NAME_KEY = "ComponentName";
    public static final String NUM_ACTIVE_EXCHANGES_KEY = "NumActiveExchanges";
    public static final String NUM_RECEIVED_DONES_KEY = "NumReceivedDONEs";
    public static final String NUM_SENT_DONES_KEY = "NumSentDONEs";
    public static final String NUM_RECEIVED_FAULTS_KEY = "NumReceivedFaults";
    public static final String NUM_SENT_FAULTS_KEY = "NumSentFaults";
    public static final String NUM_RECEIVED_ERRORS_KEY = "NumReceivedErrors";
    public static final String NUM_SENT_ERRORS_KEY = "NumSentErrors";
    public static final String ME_COMPONENT_TIME_AVG_KEY = "MessageExchangeComponentTime Avg (ns)";
    public static final String ME_DELIVERY_CHANNEL_TIME_AVG_KEY = "MessageExchangeDeliveryTime Avg (ns)";
    public static final String ME_MESSAGE_SERVICE_TIME_AVG_KEY = "MessageExchangeNMRTime Avg (ns)";
    public static final String PERFORMANCE_MEASUREMENTS_KEY = "PerformanceMeasurements";
    public static final String EXTENDED_TIMING_STATISTICS_FLAG_ENABLED_KEY = "ExtendedTimingStatisticsFlagEnabled";
    protected boolean isProvisioningEndpoint;
    protected String componentName;
    protected String instanceName;
    protected long numberOfActiveExchanges;
    protected long numberOfReceivedDones;
    protected long numberOfSentDones;
    protected long numberOfReceivedFaults;
    protected long numberOfReceivedErrors;
    protected long numberOfSentFaults;
    protected long numberOfSentErrors;
    protected long messageExchangeComponentTimeAverage;
    protected long messageExchangeDeliveryChannelTimeAverage;
    protected long messageExchangeServiceTimeAverage;
    protected boolean extendedTimingStatisticsFlagEnabled;
    protected Map<String, PerformanceData> categoryToPerformanceDataMap = new HashMap<String, PerformanceData>();

    public EndpointStatisticsData() {
    }

    public EndpointStatisticsData(EndpointStatisticsData data) {
        this.setCategoryToPerformanceDataMap(data.getCategoryToPerformanceDataMap());
        this.setInstanceName(data.getInstanceName());
        this.setComponentName(data.getComponentName());
        this.setNumberOfActiveExchanges(data.getNumberOfActiveExchanges());
        this.setNumberOfReceivedDones(data.getNumberOfReceivedDones());
        this.setNumberOfReceivedErrors(data.getNumberOfReceivedErrors());
        this.setNumberOfReceivedFaults(data.getNumberOfReceivedFaults());
        this.setNumberOfSentDones(data.getNumberOfSentDones());
        this.setNumberOfSentErrors(data.getNumberOfSentErrors());
        this.setNumberOfSentFaults(data.getNumberOfSentFaults());
        this.setExtendedTimingStatisticsFlagEnabled(data.isExtendedTimingStatisticsFlagEnabled());
        this.setMessageExchangeComponentTimeAverage(data.getMessageExchangeComponentTimeAverage());
        this.setMessageExchangeDeliveryChannelTimeAverage(data.getMessageExchangeDeliveryChannelTimeAverage());
        this.setMessageExchangeServiceTimeAverage(data.getMessageExchangeServiceTimeAverage());
    }

    public static TabularData generateTabularData(Map<String, IEndpointStatisticsData> map) {
        IEndpointStatisticsData data;
        TabularData tabularData = null;
        boolean isProvisioningEndpoint = false;
        Collection<IEndpointStatisticsData> collection = map.values();
        Iterator<IEndpointStatisticsData> i$ = collection.iterator();
        if (i$.hasNext() && (data = i$.next()).isProvisioningEndpoint()) {
            isProvisioningEndpoint = true;
        }
        try {
            tabularData = isProvisioningEndpoint ? ProvisioningEndpointStatisticsDataCreator.createTabularData(map) : ConsumingEndpointStatisticsDataCreator.createTabularData(map);
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return tabularData;
    }

    public static Map<String, IEndpointStatisticsData> retrieveDataMap(TabularData tabularData) {
        EndpointStatisticsData data = null;
        ProvisioningEndpointStatisticsData provisioningData = null;
        ConsumingEndpointStatisticsData consumingData = null;
        HashMap<String, IEndpointStatisticsData> map = null;
        map = new HashMap<String, IEndpointStatisticsData>();
        for (CompositeData compositeData : tabularData.values()) {
            CompositeType compositeType = compositeData.getCompositeType();
            if (compositeType.keySet().contains("ActivationTime") || compositeType.keySet().contains("MessageExchangeResponseTime Avg (ns)") || compositeType.keySet().contains("NumReceivedRequests") || compositeType.keySet().contains("NumSentReplies") || compositeType.keySet().contains("EndpointUpTime (ms)")) {
                data = new ProvisioningEndpointStatisticsData();
                provisioningData = data;
            } else {
                data = new ConsumingEndpointStatisticsData();
                consumingData = (ConsumingEndpointStatisticsData)data;
            }
            for (String item : compositeType.keySet()) {
                Object value;
                if (item.equals("ActivationTime")) {
                    if (data == null) {
                        data = new ProvisioningEndpointStatisticsData();
                        provisioningData = data;
                    }
                    value = (Date)compositeData.get(item);
                    provisioningData.setActivationTime((Date)value);
                }
                if (item.equals("NumReceivedRequests")) {
                    if (data == null) {
                        data = new ProvisioningEndpointStatisticsData();
                        provisioningData = data;
                    }
                    if ((value = (Long)compositeData.get(item)) != null) {
                        provisioningData.setNumberOfReceivedRequests((Long)value);
                    }
                }
                if (item.equals("NumSentReplies")) {
                    if (data == null) {
                        data = new ProvisioningEndpointStatisticsData();
                        provisioningData = data;
                    }
                    if ((value = (Long)compositeData.get(item)) != null) {
                        provisioningData.setNumberOfSentReplies((Long)value);
                    }
                }
                if (item.equals("EndpointUpTime (ms)")) {
                    if (data == null) {
                        data = new ProvisioningEndpointStatisticsData();
                        provisioningData = data;
                    }
                    if ((value = (Long)compositeData.get(item)) != null) {
                        provisioningData.setUptime((Long)value);
                    }
                }
                if (item.equals("MessageExchangeResponseTime Avg (ns)")) {
                    if (data == null) {
                        data = new ProvisioningEndpointStatisticsData();
                        provisioningData = data;
                    }
                    if ((value = (Long)compositeData.get(item)) != null) {
                        provisioningData.setMessageExchangeResponseTimeAverage((Long)value);
                    }
                }
                if (item.equals("NumReceivedReplies")) {
                    if (data == null) {
                        data = new ConsumingEndpointStatisticsData();
                        consumingData = (ConsumingEndpointStatisticsData)data;
                    }
                    if ((value = (Long)compositeData.get(item)) != null) {
                        consumingData.setNumberOfReceivedReplies((Long)value);
                    }
                }
                if (item.equals("NumSentRequests")) {
                    if (data == null) {
                        data = new ConsumingEndpointStatisticsData();
                        consumingData = (ConsumingEndpointStatisticsData)data;
                    }
                    if ((value = (Long)compositeData.get(item)) != null) {
                        consumingData.setNumberOfSentRequests((Long)value);
                    }
                }
                if (item.equals("MessageExchangeStatusTime Avg (ns)")) {
                    if (data == null) {
                        data = new ConsumingEndpointStatisticsData();
                        consumingData = (ConsumingEndpointStatisticsData)data;
                    }
                    if ((value = (Long)compositeData.get(item)) != null) {
                        consumingData.setMessageExchangeStatusTimeAverage((Long)value);
                    }
                }
                if (item.equals(INSTANCE_NAME_KEY)) {
                    value = (String)compositeData.get(item);
                    if (data != null) {
                        data.setInstanceName((String)value);
                    }
                }
                if (item.equals(COMPONENT_NAME_KEY)) {
                    value = (String)compositeData.get(item);
                    if (data == null) {
                        data.setComponentName((String)value);
                    }
                }
                if (item.equals(NUM_ACTIVE_EXCHANGES_KEY) && (value = (Long)compositeData.get(item)) != null) {
                    data.setNumberOfActiveExchanges((Long)value);
                }
                if (item.equals(NUM_RECEIVED_DONES_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setNumberOfReceivedDones((Long)value);
                    }
                }
                if (item.equals(NUM_RECEIVED_ERRORS_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setNumberOfReceivedErrors((Long)value);
                    }
                }
                if (item.equals(NUM_RECEIVED_FAULTS_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setNumberOfReceivedFaults((Long)value);
                    }
                }
                if (item.equals(NUM_SENT_DONES_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setNumberOfSentDones((Long)value);
                    }
                }
                if (item.equals(NUM_SENT_ERRORS_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setNumberOfSentErrors((Long)value);
                    }
                }
                if (item.equals(NUM_SENT_FAULTS_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setNumberOfSentFaults((Long)value);
                    }
                }
                if (item.equals(EXTENDED_TIMING_STATISTICS_FLAG_ENABLED_KEY)) {
                    value = (Boolean)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setExtendedTimingStatisticsFlagEnabled((Boolean)value);
                    }
                }
                if (item.equals(ME_COMPONENT_TIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setMessageExchangeComponentTimeAverage((Long)value);
                    }
                }
                if (item.equals(ME_DELIVERY_CHANNEL_TIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setMessageExchangeDeliveryChannelTimeAverage((Long)value);
                    }
                }
                if (item.equals(ME_MESSAGE_SERVICE_TIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null && value != null) {
                        data.setMessageExchangeServiceTimeAverage((Long)value);
                    }
                }
                if (!item.equals(PERFORMANCE_MEASUREMENTS_KEY)) continue;
                Map<String, PerformanceData> performanceMap = null;
                TabularData value2 = (TabularData)compositeData.get(item);
                if (value2 != null) {
                    performanceMap = PerformanceData.retrieveDataMap(value2);
                }
                if (data == null) continue;
                data.setCategoryToPerformanceDataMap(performanceMap);
            }
            map.put(data.getInstanceName(), data);
        }
        return map;
    }

    public static String convertDataMapToXML(Map<String, IEndpointStatisticsData> map) throws ManagementRemoteException {
        String xmlText = null;
        try {
            xmlText = EndpointStatisticsDataWriter.serialize(map);
        }
        catch (ParserConfigurationException e) {
            throw new ManagementRemoteException(e);
        }
        catch (TransformerException e) {
            throw new ManagementRemoteException(e);
        }
        return xmlText;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public boolean isProvisioningEndpoint() {
        return this.isProvisioningEndpoint;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public long getNumberOfActiveExchanges() {
        return this.numberOfActiveExchanges;
    }

    @Override
    public void setNumberOfActiveExchanges(long numberOfActiveExchanges) {
        this.numberOfActiveExchanges = numberOfActiveExchanges;
    }

    @Override
    public void setProvisioningEndpoint(boolean isProvisioningEndpoint) {
        this.isProvisioningEndpoint = isProvisioningEndpoint;
    }

    @Override
    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public long getNumberOfReceivedDones() {
        return this.numberOfReceivedDones;
    }

    @Override
    public void setNumberOfReceivedDones(long numberOfReceivedDones) {
        this.numberOfReceivedDones = numberOfReceivedDones;
    }

    @Override
    public long getNumberOfSentDones() {
        return this.numberOfSentDones;
    }

    @Override
    public void setNumberOfSentDones(long numberOfSentDones) {
        this.numberOfSentDones = numberOfSentDones;
    }

    @Override
    public long getNumberOfReceivedFaults() {
        return this.numberOfReceivedFaults;
    }

    @Override
    public void setNumberOfReceivedFaults(long numberOfReceivedFaults) {
        this.numberOfReceivedFaults = numberOfReceivedFaults;
    }

    @Override
    public long getNumberOfReceivedErrors() {
        return this.numberOfReceivedErrors;
    }

    @Override
    public void setNumberOfReceivedErrors(long numberOfReceivedErrors) {
        this.numberOfReceivedErrors = numberOfReceivedErrors;
    }

    @Override
    public long getNumberOfSentFaults() {
        return this.numberOfSentFaults;
    }

    @Override
    public void setNumberOfSentFaults(long numberOfSentFaults) {
        this.numberOfSentFaults = numberOfSentFaults;
    }

    @Override
    public long getNumberOfSentErrors() {
        return this.numberOfSentErrors;
    }

    @Override
    public void setNumberOfSentErrors(long numberOfSentErrors) {
        this.numberOfSentErrors = numberOfSentErrors;
    }

    @Override
    public boolean isExtendedTimingStatisticsFlagEnabled() {
        return this.extendedTimingStatisticsFlagEnabled;
    }

    @Override
    public void setExtendedTimingStatisticsFlagEnabled(boolean extendedTimingStatisticsFlagEnabled) {
        this.extendedTimingStatisticsFlagEnabled = extendedTimingStatisticsFlagEnabled;
    }

    @Override
    public long getMessageExchangeComponentTimeAverage() {
        return this.messageExchangeComponentTimeAverage;
    }

    @Override
    public void setMessageExchangeComponentTimeAverage(long messageExchangeComponentTimeAverage) {
        this.messageExchangeComponentTimeAverage = messageExchangeComponentTimeAverage;
    }

    @Override
    public long getMessageExchangeDeliveryChannelTimeAverage() {
        return this.messageExchangeDeliveryChannelTimeAverage;
    }

    @Override
    public void setMessageExchangeDeliveryChannelTimeAverage(long messageExchangeDeliveryChannelTimeAverage) {
        this.messageExchangeDeliveryChannelTimeAverage = messageExchangeDeliveryChannelTimeAverage;
    }

    @Override
    public long getMessageExchangeServiceTimeAverage() {
        return this.messageExchangeServiceTimeAverage;
    }

    @Override
    public void setMessageExchangeServiceTimeAverage(long messageExchangeServiceTimeAverage) {
        this.messageExchangeServiceTimeAverage = messageExchangeServiceTimeAverage;
    }

    @Override
    public Map<String, PerformanceData> getCategoryToPerformanceDataMap() {
        return this.categoryToPerformanceDataMap;
    }

    @Override
    public void setCategoryToPerformanceDataMap(Map<String, PerformanceData> categoryToPerformanceDataMap) {
        this.categoryToPerformanceDataMap = categoryToPerformanceDataMap;
    }

    @Override
    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n    Instance Name=" + this.getInstanceName());
        buffer.append("\n    Component Name=" + this.getComponentName());
        buffer.append("\n    Number of Active Exchanges=" + this.getNumberOfActiveExchanges());
        buffer.append("\n    Number Of Received Dones=" + this.getNumberOfReceivedDones());
        buffer.append("\n    Number Of Received Faults=" + this.getNumberOfReceivedFaults());
        buffer.append("\n    Number Of Received Errors=" + this.getNumberOfReceivedErrors());
        buffer.append("\n    Number Of Sent Dones=" + this.getNumberOfSentDones());
        buffer.append("\n    Number Of Sent Errors=" + this.getNumberOfSentErrors());
        buffer.append("\n    Number Of Sent Faults=" + this.getNumberOfSentFaults());
        buffer.append("\n    Extended Timing Statistics are " + (this.isExtendedTimingStatisticsFlagEnabled() ? "" : "NOT") + " Enabled.");
        buffer.append("\n\t    Message Exchange Component Time Average=" + this.getMessageExchangeComponentTimeAverage());
        buffer.append("\n\t    Message Exchange Delivery Channel Time Average=" + this.getMessageExchangeDeliveryChannelTimeAverage());
        buffer.append("\n\t    Message Exchange Service Time Average=" + this.getMessageExchangeServiceTimeAverage());
        for (String category : this.getCategoryToPerformanceDataMap().keySet()) {
            System.out.println(this.getCategoryToPerformanceDataMap().get(category).getDisplayString());
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

