/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.EndpointInformation;
import com.sun.esb.management.common.data.JavaEEVerifierReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportXMLConstants;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ApplicationVerificationReportReader
implements ApplicationVerificationReportXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private Stack<String> qNameStack = new Stack();
    private EndpointInformation endpointInformation;
    private List<EndpointInformation> endpointInformationList;
    private List<JavaEEVerifierReport> javaEEVerifierReportList;
    private JavaEEVerifierReport javaEEVerifierReport;
    private JavaEEVerifierReport.JavaEEReportItem javaEEVerifierTableItem;
    private List<String> missingComponentsList;
    private ApplicationVerificationReport report;
    private String applicationVerificationReportVersion;
    private List<String> missingAppVars;
    private List<String> missingAppConfigs;
    private HashMap<String, String> javaEEReportMap;

    public ApplicationVerificationReport getApplicationVerificationReport() {
        return this.report;
    }

    public ApplicationVerificationReport read(Document document) throws IOException {
        this.traverseNode(document);
        return this.report;
    }

    public static ApplicationVerificationReport parseFromXMLData(String rawXMLData) throws SAXException, IOException, ParserConfigurationException, URISyntaxException {
        StringReader stringReader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(stringReader);
        DOMParser parser = new DOMParser();
        parser.parse(inputSource);
        Document document = parser.getDocument();
        ApplicationVerificationReportReader reader = new ApplicationVerificationReportReader();
        reader.read(document);
        return reader.getApplicationVerificationReport();
    }

    public static ApplicationVerificationReport parseFromFile(String fileName) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException, URISyntaxException {
        File file = new File(fileName);
        return ApplicationVerificationReportReader.parseFromFile(file);
    }

    public static ApplicationVerificationReport parseFromFile(File file) throws FileNotFoundException, SAXException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        DOMParser parser = new DOMParser();
        parser.parse(inputSource);
        Document document = parser.getDocument();
        ApplicationVerificationReportReader reader = new ApplicationVerificationReportReader();
        reader.read(document);
        return reader.getApplicationVerificationReport();
    }

    public static ApplicationVerificationReport parseFromURI(String uriString) throws URISyntaxException, IOException, SAXException {
        URI uri = new URI(uriString);
        return ApplicationVerificationReportReader.parseFromURI(uri);
    }

    public static ApplicationVerificationReport parseFromURI(URI uri) throws IOException, SAXException {
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        DOMParser parser = new DOMParser();
        parser.parse(inputSource);
        Document document = parser.getDocument();
        ApplicationVerificationReportReader reader = new ApplicationVerificationReportReader();
        reader.read(document);
        return reader.getApplicationVerificationReport();
    }

    private void traverseNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    this.traverseNode(nodes.item(i));
                }
                break;
            }
            case 1: {
                Node item;
                NamedNodeMap attributes;
                if (node == null) break;
                String name = node.getNodeName();
                this.qNameStack.push(name);
                if (node.getNodeName().equals("ApplicationVerificationReport")) {
                    if (this.report != null) break;
                    attributes = node.getAttributes();
                    if (attributes != null) {
                        String namespace = attributes.getNamedItem("xmlns").getNodeValue();
                        Node namedItem = null;
                        namedItem = attributes.getNamedItem("version");
                        if (namedItem != null) {
                            this.applicationVerificationReportVersion = namedItem.getNodeValue();
                            if (this.applicationVerificationReportVersion != null && "1.0".equals(this.applicationVerificationReportVersion)) {
                                this.report = new ApplicationVerificationReport();
                            }
                        }
                    }
                } else if (node.getNodeName().equals("MissingComponentsList")) {
                    if (this.report != null) {
                        this.missingComponentsList = new ArrayList<String>();
                        this.report.setMissingComponentsList(this.missingComponentsList);
                    }
                } else if (node.getNodeName().equals("EndpointInformationList")) {
                    if (this.report != null) {
                        this.endpointInformationList = new ArrayList<EndpointInformation>();
                        this.report.setEndpointInformationList(this.endpointInformationList);
                    }
                } else if (node.getNodeName().equals("Endpoint")) {
                    if (this.report != null && this.endpointInformationList != null) {
                        this.endpointInformation = new EndpointInformation();
                        this.endpointInformationList.add(this.endpointInformation);
                    }
                } else if (node.getNodeName().equals("MissingApplicationVariables")) {
                    if (this.report != null && this.endpointInformationList != null) {
                        this.missingAppVars = new ArrayList<String>();
                        this.endpointInformation.setMissingApplicationVariables(this.missingAppVars.toArray(new String[0]));
                    }
                } else if (node.getNodeName().equals("MissingApplicationConfigurations")) {
                    if (this.report != null && this.endpointInformationList != null) {
                        this.missingAppConfigs = new ArrayList<String>();
                        this.endpointInformation.setMissingApplicationConfigurations(this.missingAppConfigs.toArray(new String[0]));
                    }
                } else if (node.getNodeName().equals("JavaEEVerifierReports")) {
                    if (this.report != null) {
                        this.javaEEVerifierReportList = new ArrayList<JavaEEVerifierReport>();
                        this.report.setJavaEEVerifierReports(this.javaEEVerifierReportList);
                    }
                } else if (node.getNodeName().equals("JavaEEVerifierReport")) {
                    if (this.report != null && this.javaEEVerifierReportList != null) {
                        this.javaEEVerifierReport = new JavaEEVerifierReport();
                        this.javaEEVerifierReportList.add(this.javaEEVerifierReport);
                    }
                } else if (node.getNodeName().equals("ReportItem")) {
                    if (this.report != null && this.javaEEVerifierReport != null) {
                        this.javaEEVerifierTableItem = this.javaEEVerifierReport.new JavaEEVerifierReport.JavaEEReportItem();
                        this.javaEEReportMap = new HashMap();
                        this.javaEEVerifierTableItem.setReportItems(this.javaEEReportMap);
                        this.javaEEVerifierReport.addJavaEEVerifierReportItem(this.javaEEVerifierTableItem);
                    }
                } else if (node.getNodeName().equals("ReportItemContent")) {
                    if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null && this.javaEEReportMap != null && (attributes = node.getAttributes()) != null) {
                        Node item2 = null;
                        String key = null;
                        item2 = attributes.getNamedItem("Key");
                        if (item2 != null) {
                            key = item2.getNodeValue();
                        }
                        item2 = attributes.getNamedItem("Value");
                        String value = item2.getNodeValue();
                        if (key != null) {
                            this.javaEEReportMap.put(key, value);
                        }
                    }
                } else if (node.getNodeName().equals("ServiceAssemblyName")) {
                    if (this.report != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.report.setServiceAssemblyName(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("ServiceAssemblyDescription")) {
                    if (this.report != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.report.setServiceAssemblyDescription(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("NumberOfServiceUnits")) {
                    if (this.report != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            int numberOfServiceUnits = Integer.valueOf(item.getNodeValue());
                            this.report.setNumberOfServiceUnits(numberOfServiceUnits);
                        }
                    }
                } else if (node.getNodeName().equals("AllComponentsInstalled")) {
                    if (this.report != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            boolean allComponentsInstalled = Boolean.valueOf(item.getNodeValue());
                            this.report.setAllComponentsInstalled(allComponentsInstalled);
                        }
                    }
                } else if (node.getNodeName().equals("TemplateZIPID")) {
                    if (this.report != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.report.setTemplateZipId(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("MissingComponentName")) {
                    if (this.report != null && this.missingComponentsList != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.missingComponentsList.add(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("EndpointName")) {
                    if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.endpointInformation.setEndpointName(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("ServiceUnitName")) {
                    if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.endpointInformation.setServiceUnitName(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("ComponentName")) {
                    if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.endpointInformation.setComponentName(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("Status")) {
                    if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.endpointInformation.setStatus(item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("ApplicationVariable")) {
                    if (this.report != null && this.missingAppVars != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.addMissingApplicationVariable(this.endpointInformation, item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("ApplicationConfiguration")) {
                    if (this.report != null && this.missingAppConfigs != null) {
                        item = null;
                        item = node.getFirstChild();
                        if (item != null) {
                            this.addMissingApplicationConfiguration(this.endpointInformation, item.getNodeValue());
                        }
                    }
                } else if (node.getNodeName().equals("JavaEESUName") && this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null) {
                    item = null;
                    item = node.getFirstChild();
                    if (item != null) {
                        this.javaEEVerifierReport.setServiceUnitName(item.getNodeValue());
                    }
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() == 3 && children.item(i).getNodeValue() != null && this.qNameStack != null && this.qNameStack.size() > 0 && this.qNameStack.peek().equals(name)) {
                        this.qNameStack.pop();
                        continue;
                    }
                    this.traverseNode(children.item(i));
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    private void addMissingApplicationVariable(EndpointInformation information, String appvar) {
        String[] oldVariables = information.getMissingApplicationVariables();
        int size = oldVariables != null ? oldVariables.length : 0;
        String[] variables = new String[size + 1];
        if (oldVariables != null) {
            for (int index = 0; index < size; ++index) {
                variables[index] = oldVariables[index];
            }
        }
        variables[size] = appvar;
        information.setMissingApplicationVariables(variables);
    }

    private void addMissingApplicationConfiguration(EndpointInformation information, String appConfig) {
        String[] oldVariables = information.getMissingApplicationConfigurations();
        int size = oldVariables != null ? oldVariables.length : 0;
        String[] variables = new String[size + 1];
        if (oldVariables != null) {
            for (int index = 0; index < size; ++index) {
                variables[index] = oldVariables[index];
            }
        }
        variables[size] = appConfig;
        information.setMissingApplicationConfigurations(variables);
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/verification/ApplicationVerificationReport.xml";
        try {
            ApplicationVerificationReport report = ApplicationVerificationReportReader.parseFromFile(uri);
            System.out.println(report.getDisplayString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

