/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.jboss;

import com.sun.jbi.framework.jboss.JBossJBIBootstrapMBean;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader3;

public class JBossJBIBootstrap
implements JBossJBIBootstrapMBean {
    private static final String JBI_FRAMEWORK_CLASS_NAME = "com.sun.jbi.framework.jboss.JBossASJBIFramework";
    private static final String JBOSS_SERVER_NAME = "jboss.server.name";
    private static final String JBOSS_HOME_URL = "jboss.server.home.url";
    private static final String JBI_JAR_NAME = "jbi.jar";
    private static final String JBI_EXT_JAR_NAME = "jbi-ext.jar";
    private ClassLoader mFrameworkClassLoader;
    private Object mJbiFramework;
    private Properties mEnvironment;
    private List<String> mBlacklistJars = new ArrayList<String>();
    private String mInstallRoot;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());

    public void create() {
        this.mLog.fine("Creating JBI Framework");
        this.mBlacklistJars.add(JBI_JAR_NAME);
        this.mBlacklistJars.add(JBI_EXT_JAR_NAME);
        try {
            String serverName = System.getProperty(JBOSS_SERVER_NAME);
            String jbossurl = System.getProperty(JBOSS_HOME_URL);
            URI jbossuri = new URI(jbossurl);
            this.mInstallRoot = System.getProperty("jbi.install.root");
            String mInstanceRoot = jbossuri.getPath();
            this.mEnvironment = new Properties();
            this.mEnvironment.put("instance.name", serverName);
            this.mEnvironment.put("instance.root", mInstanceRoot);
            this.mEnvironment.put("install.root", this.mInstallRoot);
            this.createJBIFramework();
            this.loadJBIFramework();
        }
        catch (Exception e) {
            this.mLog.warning("Error creating JBI Framework: " + e.getMessage());
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        this.destroyJBIFramework();
    }

    private void createJBIFramework() throws Exception {
        try {
            this.createExtensionClassLoader();
            this.createFrameworkClassLoader();
            Class<?> fwClass = this.mFrameworkClassLoader.loadClass(JBI_FRAMEWORK_CLASS_NAME);
            Constructor<?> fwCtor = fwClass.getDeclaredConstructor(Properties.class);
            this.mJbiFramework = fwCtor.newInstance(this.mEnvironment);
        }
        catch (Exception ex) {
            throw new Exception("Failed to create JBI framework: " + ex.getMessage());
        }
    }

    private void createFrameworkClassLoader() {
        ArrayList<URL> cpList = new ArrayList<URL>();
        URL[] cpURLs = new URL[]{};
        File libDir = new File(this.mInstallRoot);
        File libDir2 = new File(this.mInstallRoot, "lib");
        for (File lib : libDir.listFiles()) {
            try {
                if (this.mBlacklistJars.contains(lib.getName())) continue;
                cpList.add(lib.toURL());
            }
            catch (MalformedURLException urlEx) {
                this.mLog.warning("Bad library URL: " + urlEx.getMessage());
            }
        }
        for (File lib2 : libDir2.listFiles()) {
            try {
                cpList.add(lib2.toURL());
            }
            catch (MalformedURLException e) {
                this.mLog.warning("Bad library URL: " + e.getMessage());
            }
        }
        cpURLs = cpList.toArray(cpURLs);
        this.mFrameworkClassLoader = new URLClassLoader(cpURLs, this.getClass().getClassLoader());
    }

    private void createExtensionClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        UnifiedClassLoader3 ucl = (UnifiedClassLoader3)loader;
        File libDir = new File(this.mInstallRoot, "lib/ext");
        if (libDir.exists() || libDir.isDirectory()) {
            try {
                ucl.addURL(libDir.toURL());
                for (File lib : libDir.listFiles()) {
                    ucl.addURL(lib.toURL());
                }
            }
            catch (MalformedURLException urlEx) {
                this.mLog.warning("Bad library URL: " + urlEx.getMessage());
            }
        }
    }

    void loadJBIFramework() {
        try {
            this.invoke(this.mJbiFramework, "load", new Object[0]);
        }
        catch (Throwable t) {
            this.mLog.severe(t.toString());
        }
    }

    private void destroyJBIFramework() {
        try {
            this.invoke(this.mJbiFramework, "unload", new Object[0]);
        }
        catch (Throwable t) {
            this.mLog.severe(t.toString());
        }
    }

    private Object invoke(Object obj, String method, Object ... params) throws Throwable {
        Object result = null;
        try {
            for (Method m : obj.getClass().getDeclaredMethods()) {
                if (!m.getName().equals(method)) continue;
                result = m.invoke(obj, params);
                break;
            }
            return result;
        }
        catch (InvocationTargetException itEx) {
            throw itEx.getTargetException();
        }
    }
}

