/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.CompositeTypeFromNameCallback;
import com.sun.appserv.management.util.jmx.OpenMBeanUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataHelper {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final OpenType[] EMPTY_OPENTYPES = new OpenType[0];

    protected <T extends Serializable> CompositeType mapToCompositeType(String typeName, String description, Map<String, T> map) throws OpenDataException {
        return this.mapToCompositeType(typeName, description, map, null);
    }

    protected <T extends Serializable> CompositeType mapToCompositeType(String typeName, String description, Map<String, T> map, CompositeTypeFromNameCallback callback) throws OpenDataException {
        return OpenMBeanUtil.mapToCompositeType(typeName, description, map, callback);
    }

    protected <T extends Serializable> CompositeData mapToCompositeData(String typeName, String description, Map<String, T> map) throws OpenDataException {
        CompositeType type = this.mapToCompositeType(typeName, description, map);
        return new CompositeDataSupport(type, map);
    }

    public Serializable asData(Serializable o) throws OpenDataException {
        Object result = null;
        if (o instanceof StackTraceElement) {
            result = this.stackTraceElementCompositeData((StackTraceElement)o);
        } else if (o instanceof Throwable) {
            result = this.throwableToCompositeData((Throwable)o);
        } else if (o instanceof Map) {
            Map m = TypeCast.asSerializableMap(o);
            result = this.mapToCompositeData(Map.class.getName(), "", m);
        } else {
            OpenType type = OpenMBeanUtil.getOpenType(o);
            if (type instanceof SimpleType) {
                result = o;
            } else if (type instanceof ArrayType) {
                result = o;
            } else {
                throw new IllegalArgumentException("" + o);
            }
        }
        return (Serializable)Serializable.class.cast(result);
    }

    public CompositeType getStackTraceElementCompositeType() throws OpenDataException {
        String[] itemNames = new String[]{"ClassName", "FileName", "LineNumber", "isNativeMethod"};
        String[] descriptions = new String[]{"ClassName", "FileName", "LineNumber", "IsNativeMethod"};
        OpenType[] openTypes = new OpenType[itemNames.length];
        openTypes[0] = SimpleType.STRING;
        openTypes[1] = SimpleType.STRING;
        openTypes[2] = SimpleType.INTEGER;
        openTypes[3] = SimpleType.BOOLEAN;
        CompositeType type = new CompositeType(StackTraceElement.class.getName(), "StackTraceElement composite type", itemNames, descriptions, openTypes);
        return type;
    }

    public CompositeData stackTraceElementCompositeData(StackTraceElement elem) throws OpenDataException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("ClassName", elem.getClassName());
        m.put("FileName", elem.getFileName());
        m.put("LineNumber", new Integer(elem.getLineNumber()));
        m.put("isNativeMethod", elem.isNativeMethod());
        return new CompositeDataSupport(this.getStackTraceElementCompositeType(), m);
    }

    public CompositeData throwableToCompositeData(Throwable t) throws OpenDataException {
        Throwable cause = t.getCause();
        String[] itemNames = new String[]{"Message", "Cause", "StackTrace"};
        String[] descriptions = new String[]{"The message from the Throwable", "The cause (if any) from the Throwable", "The stack trace from the Throwable"};
        OpenType[] openTypes = new OpenType[itemNames.length];
        openTypes[0] = SimpleType.STRING;
        openTypes[1] = cause == null ? CompositeDataHelper.getEmptyCompositeType() : this.throwableToCompositeData(cause).getCompositeType();
        openTypes[2] = new ArrayType(t.getStackTrace().length, this.getStackTraceElementCompositeType());
        CompositeType type = new CompositeType(t.getClass().getName(), "Throwable composite type", itemNames, descriptions, openTypes);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("Message", t.getMessage());
        m.put("Cause", cause == null ? null : this.throwableToCompositeData(cause));
        m.put("StackTrace", t.getStackTrace());
        return new CompositeDataSupport(type, m);
    }

    public static CompositeType getEmptyCompositeType() throws OpenDataException {
        return new CompositeType(CompositeType.class.getName() + ".Empty", "Empty composite type", EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_OPENTYPES);
    }
}

