/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ExtensionModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.PELaunch;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASClassLoaderUtil {
    private static final Logger _logger = Logger.getAnonymousLogger();
    private static String sharedClasspathForWebModule = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebModuleClassPath(String moduleId) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ASClassLoaderUtil.getWebModuleClassPath for module Id : " + moduleId);
        }
        Class<ASClassLoaderUtil> clazz = ASClassLoaderUtil.class;
        synchronized (ASClassLoaderUtil.class) {
            if (sharedClasspathForWebModule == null) {
                StringBuilder tmpString = new StringBuilder();
                if (Boolean.getBoolean("com.sun.aas.useNewClassLoader")) {
                    ArrayList tmpList = new ArrayList();
                    tmpList.addAll(PELaunch.getSharedClasspath());
                    tmpList.addAll(PELaunch.getAddOnsClasspath());
                    for (String s : tmpList) {
                        tmpString.append(s);
                        tmpString.append(File.pathSeparatorChar);
                    }
                } else {
                    tmpString.append(System.getProperty("java.class.path"));
                }
                sharedClasspathForWebModule = tmpString.toString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            StringBuilder classpath = new StringBuilder(sharedClasspathForWebModule);
            if (moduleId != null) {
                String specifiedLibraries = ASClassLoaderUtil.getLibrariesForWebModule(moduleId);
                URL[] libs = ASClassLoaderUtil.getLibraries(specifiedLibraries);
                if (libs == null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "classpath: " + classpath.toString());
                    }
                    return classpath.toString();
                }
                for (URL u : libs) {
                    classpath.append(u + File.pathSeparator);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Final classpath: " + classpath.toString());
            }
            return classpath.toString();
        }
    }

    public static String getLibrariesForJ2EEApplication(String moduleId) {
        J2eeApplication app = null;
        try {
            app = ASClassLoaderUtil.getApplications().getJ2eeApplicationByName(moduleId);
            if (app == null) {
                return null;
            }
        }
        catch (ConfigException malEx) {
            _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", moduleId);
            _logger.log(Level.WARNING, "loader.exception", malEx);
        }
        return app.getLibraries();
    }

    public static String getLibrariesForWebModule(String moduleId) {
        WebModule app = null;
        try {
            app = ASClassLoaderUtil.getApplications().getWebModuleByName(moduleId);
            if (app == null) {
                return null;
            }
        }
        catch (ConfigException malEx) {
            _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", moduleId);
            _logger.log(Level.WARNING, "loader.exception", malEx);
        }
        String librariesStr = null;
        librariesStr = app.getLibraries();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "app = " + app + " library = " + librariesStr);
        }
        return librariesStr;
    }

    public static String getLibrariesForEJBJars(String moduleId) {
        EjbModule app = null;
        try {
            app = ASClassLoaderUtil.getApplications().getEjbModuleByName(moduleId);
            if (app == null) {
                return null;
            }
        }
        catch (ConfigException malEx) {
            _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", moduleId);
            _logger.log(Level.WARNING, "loader.exception", malEx);
        }
        return app.getLibraries();
    }

    public static String getLibrariesForExtensionModule(String moduleId) {
        ExtensionModule app = null;
        try {
            app = ASClassLoaderUtil.getApplications().getExtensionModuleByName(moduleId);
            if (app == null) {
                return null;
            }
        }
        catch (ConfigException malEx) {
            _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", moduleId);
            _logger.log(Level.WARNING, "loader.exception", malEx);
        }
        return app.getLibraries();
    }

    private static Applications getApplications() throws ConfigException {
        ConfigContext serverConfigCtx = ApplicationServer.getServerContext().getConfigContext();
        Domain domain = (Domain)serverConfigCtx.getRootConfigBean();
        return domain.getApplications();
    }

    public static URL[] getLibraries(String librariesStr) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        if (librariesStrArray == null) {
            return null;
        }
        URL[] urls = new URL[librariesStrArray.length];
        String appLibsDir = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "lib" + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            String libString = libraryStr.trim();
            try {
                File f = new File(libString);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libString);
                }
                URL url = f.toURI().toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", libString);
                _logger.log(Level.WARNING, "loader.exception", malEx);
            }
        }
        return urls;
    }

    public static synchronized ClassLoader getSharedClassLoader() {
        return ApplicationServer.getServerContext().getSharedClassLoader();
    }
}

