/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.esb.eventmanagement.api.NotificationEvent;
import com.sun.esb.eventmanagement.impl.CompositeDataEventElementType;
import com.sun.esb.eventmanagement.impl.NotificationEventImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDataConverter {
    private final String[] itemNames = new String[]{CompositeDataEventElementType.EVENTDATE.getCompositeDataElement(), CompositeDataEventElementType.EVENTID.getCompositeDataElement(), CompositeDataEventElementType.EVENTENVIRONMENT.getCompositeDataElement(), CompositeDataEventElementType.EVENTLOGICALHOST.getCompositeDataElement(), CompositeDataEventElementType.EVENTSERVER.getCompositeDataElement(), CompositeDataEventElementType.EVENTCOMPONENTPROJECTPATH.getCompositeDataElement(), CompositeDataEventElementType.EVENTDEPLOYMENT.getCompositeDataElement(), CompositeDataEventElementType.EVENTCOMPONENTNAME.getCompositeDataElement(), CompositeDataEventElementType.EVENTSEVERITY.getCompositeDataElement(), CompositeDataEventElementType.EVENTTYPE.getCompositeDataElement(), CompositeDataEventElementType.EVENTSTATUS.getCompositeDataElement(), CompositeDataEventElementType.EVENTSTATE.getCompositeDataElement(), CompositeDataEventElementType.EVENTPHYSICALHOST.getCompositeDataElement(), CompositeDataEventElementType.EVENTMESSAGECODE.getCompositeDataElement(), CompositeDataEventElementType.EVENTMESSAGEDETAILS.getCompositeDataElement(), CompositeDataEventElementType.EVENTSERVERTYPE.getCompositeDataElement(), CompositeDataEventElementType.EVENTCOMPONENTTYPE.getCompositeDataElement(), CompositeDataEventElementType.DBEVENTID.getCompositeDataElement()};
    private final String[] itemDescriptions = new String[]{CompositeDataEventElementType.EVENTDATE.getDescription(), CompositeDataEventElementType.EVENTID.getDescription(), CompositeDataEventElementType.EVENTENVIRONMENT.getDescription(), CompositeDataEventElementType.EVENTLOGICALHOST.getDescription(), CompositeDataEventElementType.EVENTSERVER.getDescription(), CompositeDataEventElementType.EVENTCOMPONENTPROJECTPATH.getDescription(), CompositeDataEventElementType.EVENTDEPLOYMENT.getDescription(), CompositeDataEventElementType.EVENTCOMPONENTNAME.getDescription(), CompositeDataEventElementType.EVENTSEVERITY.getDescription(), CompositeDataEventElementType.EVENTTYPE.getDescription(), CompositeDataEventElementType.EVENTSTATUS.getDescription(), CompositeDataEventElementType.EVENTSTATE.getDescription(), CompositeDataEventElementType.EVENTPHYSICALHOST.getDescription(), CompositeDataEventElementType.EVENTMESSAGECODE.getDescription(), CompositeDataEventElementType.EVENTMESSAGEDETAILS.getDescription(), CompositeDataEventElementType.EVENTSERVERTYPE.getDescription(), CompositeDataEventElementType.EVENTCOMPONENTTYPE.getDescription(), CompositeDataEventElementType.DBEVENTID.getDescription()};
    private final OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};

    public CompositeData getEventCompositeData(NotificationEvent event, String aDBEventID) throws Exception {
        CompositeType compositeType = new CompositeType("event", "The Object Represent single event instance", this.itemNames, this.itemDescriptions, this.itemTypes);
        Map<String, String> map = this.getEventMap(event, aDBEventID);
        CompositeDataSupport compositeData = new CompositeDataSupport(compositeType, map);
        return compositeData;
    }

    public CompositeData getEventCompositeData(ResultSet aResultSet, String aDBEventID) throws Exception {
        CompositeType compositeType = new CompositeType("event", "The Object Represent single event row in the persistence DB", this.itemNames, this.itemDescriptions, this.itemTypes);
        Map<String, String> map = this.getEventRowMap(aResultSet, aDBEventID);
        CompositeDataSupport compositeData = new CompositeDataSupport(compositeType, map);
        return compositeData;
    }

    public NotificationEvent getEventFromCompositeData(CompositeData compositeData) {
        NotificationEventImpl event = new NotificationEventImpl();
        Object[] eventData = compositeData.getAll(this.itemNames);
        this.populateEventObject(event, eventData);
        return event;
    }

    private Map<String, String> getEventRowMap(ResultSet aResultSet, String aDBEventID) throws SQLException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CompositeDataEventElementType.EVENTDATE.getCompositeDataElement(), aResultSet.getLong(2) + "");
        properties.put(CompositeDataEventElementType.EVENTID.getCompositeDataElement(), aResultSet.getInt(1) + "");
        properties.put(CompositeDataEventElementType.EVENTENVIRONMENT.getCompositeDataElement(), aResultSet.getString(4));
        properties.put(CompositeDataEventElementType.EVENTLOGICALHOST.getCompositeDataElement(), aResultSet.getString(5));
        properties.put(CompositeDataEventElementType.EVENTSERVER.getCompositeDataElement(), aResultSet.getString(7));
        properties.put(CompositeDataEventElementType.EVENTCOMPONENTPROJECTPATH.getCompositeDataElement(), aResultSet.getString(9));
        properties.put(CompositeDataEventElementType.EVENTDEPLOYMENT.getCompositeDataElement(), aResultSet.getString(17));
        properties.put(CompositeDataEventElementType.EVENTCOMPONENTNAME.getCompositeDataElement(), aResultSet.getString(10));
        properties.put(CompositeDataEventElementType.EVENTSEVERITY.getCompositeDataElement(), aResultSet.getInt(12) + "");
        properties.put(CompositeDataEventElementType.EVENTTYPE.getCompositeDataElement(), aResultSet.getString(11));
        properties.put(CompositeDataEventElementType.EVENTSTATUS.getCompositeDataElement(), aResultSet.getInt(16) + "");
        properties.put(CompositeDataEventElementType.EVENTSTATE.getCompositeDataElement(), aResultSet.getInt(13) + "");
        properties.put(CompositeDataEventElementType.EVENTPHYSICALHOST.getCompositeDataElement(), aResultSet.getString(3));
        properties.put(CompositeDataEventElementType.EVENTMESSAGECODE.getCompositeDataElement(), aResultSet.getString(14));
        properties.put(CompositeDataEventElementType.EVENTMESSAGEDETAILS.getCompositeDataElement(), aResultSet.getString(15));
        properties.put(CompositeDataEventElementType.EVENTSERVERTYPE.getCompositeDataElement(), aResultSet.getString(6));
        properties.put(CompositeDataEventElementType.EVENTCOMPONENTTYPE.getCompositeDataElement(), aResultSet.getString(8));
        return properties;
    }

    private Map<String, String> getEventMap(NotificationEvent event, String aDBEventID) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CompositeDataEventElementType.EVENTDATE.getCompositeDataElement(), event.getTimeStamp() + "");
        properties.put(CompositeDataEventElementType.EVENTID.getCompositeDataElement(), event.getId() + "");
        properties.put(CompositeDataEventElementType.EVENTENVIRONMENT.getCompositeDataElement(), event.getEnvironmentName());
        properties.put(CompositeDataEventElementType.EVENTLOGICALHOST.getCompositeDataElement(), event.getLogicalHostName());
        properties.put(CompositeDataEventElementType.EVENTSERVER.getCompositeDataElement(), event.getServerName());
        properties.put(CompositeDataEventElementType.EVENTCOMPONENTPROJECTPATH.getCompositeDataElement(), event.getComponentProjectPathName());
        properties.put(CompositeDataEventElementType.EVENTDEPLOYMENT.getCompositeDataElement(), event.getDeploymentName());
        properties.put(CompositeDataEventElementType.EVENTCOMPONENTNAME.getCompositeDataElement(), event.getComponentName());
        properties.put(CompositeDataEventElementType.EVENTSEVERITY.getCompositeDataElement(), event.getSeverity() + "");
        properties.put(CompositeDataEventElementType.EVENTTYPE.getCompositeDataElement(), event.getType());
        properties.put(CompositeDataEventElementType.EVENTSTATUS.getCompositeDataElement(), event.getObservationalState() + "");
        properties.put(CompositeDataEventElementType.EVENTSTATE.getCompositeDataElement(), event.getOperationalState() + "");
        properties.put(CompositeDataEventElementType.EVENTPHYSICALHOST.getCompositeDataElement(), event.getPhysicalHostName());
        properties.put(CompositeDataEventElementType.EVENTMESSAGECODE.getCompositeDataElement(), event.getMessageCode());
        properties.put(CompositeDataEventElementType.EVENTMESSAGEDETAILS.getCompositeDataElement(), event.getMessageDetails());
        properties.put(CompositeDataEventElementType.EVENTSERVERTYPE.getCompositeDataElement(), event.getServerType());
        properties.put(CompositeDataEventElementType.EVENTCOMPONENTTYPE.getCompositeDataElement(), event.getComponentType());
        properties.put(CompositeDataEventElementType.DBEVENTID.getCompositeDataElement(), aDBEventID);
        return properties;
    }

    private void populateEventObject(NotificationEvent event, Object[] eventData) {
        block19: for (int index = 0; index < eventData.length; ++index) {
            Object value = eventData[index];
            if (value == null) continue;
            String eventEntryValue = (String)value;
            switch (index) {
                case 0: {
                    event.setTimeStamp(Long.parseLong(eventEntryValue));
                    continue block19;
                }
                case 1: {
                    continue block19;
                }
                case 2: {
                    event.setEnvironmentName(eventEntryValue);
                    continue block19;
                }
                case 3: {
                    event.setLogicalHostName(eventEntryValue);
                    continue block19;
                }
                case 4: {
                    event.setServerName(eventEntryValue);
                    continue block19;
                }
                case 5: {
                    event.setComponentProjectPathName(eventEntryValue);
                    continue block19;
                }
                case 6: {
                    event.setDeploymentName(eventEntryValue);
                    continue block19;
                }
                case 7: {
                    event.setComponentName(eventEntryValue);
                    continue block19;
                }
                case 8: {
                    event.setSeverity(Integer.parseInt(eventEntryValue));
                    continue block19;
                }
                case 9: {
                    event.setType(eventEntryValue);
                    continue block19;
                }
                case 10: {
                    event.setObservationalState(Integer.parseInt(eventEntryValue));
                    continue block19;
                }
                case 11: {
                    event.setOperationalState(Integer.parseInt(eventEntryValue));
                    continue block19;
                }
                case 12: {
                    event.setPhysicalHostName(eventEntryValue);
                    continue block19;
                }
                case 13: {
                    event.setMessageCode(eventEntryValue);
                    continue block19;
                }
                case 14: {
                    event.setMessageDetails(eventEntryValue);
                    continue block19;
                }
                case 15: {
                    event.setServerType(eventEntryValue);
                    continue block19;
                }
                case 16: {
                    event.setComponentType(eventEntryValue);
                }
            }
        }
    }

    public Date getEventDateFromString(String eventDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        return sdf.parse(eventDate, new ParsePosition(0));
    }
}

