/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class EventManagementBroadcaster
extends NotificationBroadcasterSupport {
    ConcurrentHashMap<String, NotificationListenerInfo> mListenerMap = new ConcurrentHashMap();
    private static final Executor mExecutor = new Executor(){

        public void execute(Runnable r) {
            r.run();
        }
    };

    protected void addEventNotificationListener(NotificationListener aListener, NotificationFilter aFilter, Object handback, String UUID) {
        if (aListener == null) {
            return;
        }
        NotificationListenerInfo nli = new NotificationListenerInfo(aListener, aFilter, handback);
        this.mListenerMap.put(UUID, nli);
    }

    protected void removeEventNotificationListener(String UUID) {
        this.mListenerMap.remove(UUID);
    }

    protected Boolean isValidID(String UUID) {
        boolean exist = this.mListenerMap.containsKey(UUID);
        return new Boolean(exist);
    }

    protected void removeAllListener() {
        this.mListenerMap.clear();
    }

    protected boolean hasListeners() {
        return this.mListenerMap.size() > 0;
    }

    public void sendEventNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        for (String listenerID : this.mListenerMap.keySet()) {
            NotificationListenerInfo nli = this.mListenerMap.get(listenerID);
            NotificationFilter nf = nli.getNotificationFilter();
            boolean enabled = nf == null || nf.isNotificationEnabled(notification);
            if (!enabled) continue;
            mExecutor.execute(new SendEvent(notification, nli, listenerID));
        }
    }

    protected void handleNotification(NotificationListener aListener, Notification notif, Object handback) {
        if (aListener == null) {
            return;
        }
        super.handleNotification(aListener, notif, handback);
    }

    private class SendEvent
    implements Runnable {
        private Notification mNotification;
        private NotificationListenerInfo mNotificationListenerInfo;
        private String mUUID;

        public SendEvent(Notification aNotification, NotificationListenerInfo aNotificationListenerInfo, String aUUID) {
            this.mNotification = aNotification;
            this.mNotificationListenerInfo = aNotificationListenerInfo;
            this.mUUID = aUUID;
        }

        public void run() {
            try {
                EventManagementBroadcaster.this.handleNotification(this.mNotificationListenerInfo.getNotificationListener(), this.mNotification, this.mNotificationListenerInfo.getHandback());
            }
            catch (Exception e) {
                EventManagementBroadcaster.this.removeEventNotificationListener(this.mUUID);
            }
        }
    }

    private class NotificationListenerInfo {
        private NotificationListener mNotificationListener;
        private NotificationFilter mNotificationFilter;
        private Object mHandback;

        private NotificationListenerInfo(NotificationListener aListener, NotificationFilter aFilter, Object handback) {
            this.mNotificationListener = aListener;
            this.mNotificationFilter = aFilter;
            this.mHandback = handback;
        }

        private NotificationListener getNotificationListener() {
            return this.mNotificationListener;
        }

        private NotificationFilter getNotificationFilter() {
            return this.mNotificationFilter;
        }

        private Object getHandback() {
            return this.mHandback;
        }
    }
}

