/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.NMRStatisticsDataCreator;
import com.sun.esb.management.common.data.helper.NMRStatisticsDataWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMRStatisticsData
implements Serializable {
    static final long serialVersionUID = -1L;
    public static final String INSTANCENAME_KEY = "InstanceName";
    public static final String ACTIVECHANNELS_KEY = "ListActiveChannels";
    public static final String ACTIVEENDPOINTS_KEY = "ListActiveEndpoints";
    String instanceName;
    List<String> activeChannelsList = new ArrayList<String>();
    List<String> activeEndpointsList = new ArrayList<String>();

    public static TabularData generateTabularData(Map<String, NMRStatisticsData> map) {
        TabularData tabularData = null;
        try {
            tabularData = NMRStatisticsDataCreator.createTabularData(map);
        }
        catch (ManagementRemoteException managementRemoteException) {
            // empty catch block
        }
        return tabularData;
    }

    public static Map<String, NMRStatisticsData> retrieveDataMap(TabularData tabularData) {
        NMRStatisticsData data = null;
        HashMap<String, NMRStatisticsData> map = null;
        map = new HashMap<String, NMRStatisticsData>();
        for (CompositeData compositeData : tabularData.values()) {
            CompositeType compositeType = compositeData.getCompositeType();
            data = new NMRStatisticsData();
            for (String item : compositeType.keySet()) {
                String[] values;
                if (item.equals(INSTANCENAME_KEY)) {
                    String value = (String)compositeData.get(item);
                    data.setInstanceName(value);
                }
                if (item.equals(ACTIVECHANNELS_KEY)) {
                    values = (String[])compositeData.get(item);
                    data.setActiveChannelsList(values);
                }
                if (!item.equals(ACTIVEENDPOINTS_KEY)) continue;
                values = (String[])compositeData.get(item);
                data.setActiveEndpointsList(values);
            }
            map.put(data.getInstanceName(), data);
        }
        return map;
    }

    public static String convertDataMapToXML(Map<String, NMRStatisticsData> map) throws ManagementRemoteException {
        String xmlText = null;
        try {
            xmlText = NMRStatisticsDataWriter.serialize(map);
        }
        catch (ParserConfigurationException e) {
            throw new ManagementRemoteException(e);
        }
        catch (TransformerException e) {
            throw new ManagementRemoteException(e);
        }
        return xmlText;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public List<String> getActiveChannelsList() {
        return this.activeChannelsList;
    }

    public String[] getActiveChannelsArray() {
        String[] result = NMRStatisticsData.toArray(this.activeChannelsList, String.class);
        return result;
    }

    public void setActiveChannelsList(List<String> activeChannelList) {
        this.activeChannelsList = activeChannelList;
    }

    public void setActiveChannelsList(String[] activeChannelsArray) {
        for (String activeChannel : activeChannelsArray) {
            this.activeChannelsList.add(activeChannel);
        }
    }

    public List<String> getActiveEndpointsList() {
        return this.activeEndpointsList;
    }

    public void setActiveEndpointsList(List<String> activeEndpoints) {
        this.activeEndpointsList = activeEndpoints;
    }

    public String[] getActiveEndpointsArray() {
        String[] result = NMRStatisticsData.toArray(this.activeEndpointsList, String.class);
        return result;
    }

    public void setActiveEndpointsList(String[] activeEndpointsArray) {
        for (String activeEndpoint : activeEndpointsArray) {
            this.activeEndpointsList.add(activeEndpoint);
        }
    }

    protected static <Type> Type[] toArray(Collection<Type> collection, Class<Type> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, collection.size());
        int index = 0;
        for (Type value : collection) {
            array[index++] = value;
        }
        return array;
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n  Instance Name=" + this.getInstanceName());
        if (this.getActiveChannelsList() != null && this.getActiveChannelsList().size() > 0) {
            buffer.append("\n  Active Channels List:");
            for (String channel : this.getActiveChannelsList()) {
                buffer.append("\n    Active Channel=" + channel);
            }
        }
        if (this.getActiveEndpointsList() != null && this.getActiveEndpointsList().size() > 0) {
            buffer.append("\n  Active Endpoints List:");
            for (String endpoint : this.getActiveEndpointsList()) {
                buffer.append("\n    Active Endpoint=" + endpoint);
            }
        }
        buffer.append("\n  ========================================\n");
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

