/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.ComponentLogger;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.management.ManagementMessageFactory;
import com.sun.jbi.messaging.DeliveryChannelImpl;
import com.sun.jbi.security.KeyStoreUtil;
import com.sun.jbi.wsdl2.WsdlException;
import com.sun.jbi.wsdl2.WsdlFactory;
import java.io.File;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class ComponentContext
implements com.sun.jbi.component.ComponentContext,
MBeanNames {
    private Component mComponent;
    private String mComponentName;
    private EnvironmentContext mContext;
    private DeliveryChannelImpl mDeliveryChannel;
    private StringTranslator mTranslator;
    public static final String LOGGER_NAME_PREFIX = "com.sun.jbi.component.";
    private static final String PERIOD = ".";

    public ComponentContext(Component component, EnvironmentContext jbiContext) {
        this.mComponent = component;
        this.mComponentName = component.getName();
        this.mContext = jbiContext;
        this.mTranslator = this.mContext.getStringTranslatorFor(this);
    }

    public ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.activateEndpoint(serviceName, endpointName);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public void deactivateEndpoint(ServiceEndpoint endpoint) throws JBIException {
        if (null == this.mDeliveryChannel) {
            throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
        }
        this.mDeliveryChannel.deactivateEndpoint(endpoint);
    }

    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        if (null == this.mDeliveryChannel) {
            throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
        }
        this.mDeliveryChannel.deregisterExternalEndpoint(externalEndpoint);
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        return this.getDeliveryChannel(true);
    }

    DeliveryChannel getDeliveryChannel(boolean activateNewChannel) throws MessagingException {
        if (activateNewChannel && (null == this.mDeliveryChannel || this.mDeliveryChannel.isClosed())) {
            this.mDeliveryChannel = this.mContext.getNormalizedMessageService().activateChannel(this.mComponentName, null);
        }
        return this.mDeliveryChannel;
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.getEndpoint(service, name);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.getEndpointDescriptor(endpoint);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.getEndpointsForService(serviceName);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.getExternalEndpoints(interfaceName);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.getEndpoints(interfaceName);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.getExternalEndpointsForService(serviceName);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public String getInstallRoot() {
        if (File.separator.equals("/")) {
            return this.mComponent.getInstallRoot();
        }
        return this.mComponent.getInstallRoot().replace('/', File.separatorChar);
    }

    public Logger getLogger(String suffix, String resourceBundleName) throws MissingResourceException, JBIException {
        String logName;
        Logger log = null;
        boolean mainLogger = false;
        ComponentLogger logMBean = this.mComponent.getLoggerInstance();
        if (null == suffix) {
            throw new IllegalArgumentException(this.mTranslator.getString("CC_LOGGER_NULL_SUFFIX"));
        }
        String prefix = null != logMBean ? logMBean.getLoggerNamePrefix() : this.mComponentName + PERIOD;
        if (0 == suffix.length()) {
            mainLogger = true;
            logName = prefix.substring(0, prefix.length() - 1);
        } else {
            logName = !suffix.startsWith(prefix) ? (suffix.startsWith(PERIOD) ? prefix + suffix.substring(1) : prefix + suffix) : suffix;
        }
        if (null != resourceBundleName) {
            try {
                log = Logger.getLogger(logName, resourceBundleName);
            }
            catch (MissingResourceException mrEx) {
                this.mContext.getLogger().log(Level.WARNING, this.mTranslator.getString("CC_LOGGER_MISSING_RESOURCE", logName, resourceBundleName), mrEx);
                throw mrEx;
            }
            catch (IllegalArgumentException iaEx) {
                String msg = this.mTranslator.getString("CC_LOGGER_DIFFERENT_RESOURCE", logName, resourceBundleName, Logger.getLogger(logName).getResourceBundleName());
                this.mContext.getLogger().log(Level.WARNING, msg, iaEx);
                throw new JBIException(msg, (Throwable)iaEx);
            }
        } else {
            log = Logger.getLogger(logName);
        }
        if (mainLogger) {
            log.setParent(this.mContext.getJbiLogger());
        }
        if (null != logMBean && !logMBean.isLoggerRegistered(logName)) {
            int lastDot = logName.lastIndexOf(PERIOD);
            String displayName = -1 < lastDot ? logName.substring(lastDot + 1) : logName;
            logMBean.addLogger(log, displayName);
        }
        return log;
    }

    public MBeanNames getMBeanNames() {
        return this;
    }

    public MBeanServer getMBeanServer() {
        return this.mContext.getMBeanServer();
    }

    public InitialContext getNamingContext() {
        return this.mContext.getNamingContext();
    }

    public Object getTransactionManager() {
        return this.mContext.getTransactionManager();
    }

    public String getWorkspaceRoot() {
        if (File.separator.equals("/")) {
            return this.mComponent.getWorkspaceRoot();
        }
        return this.mComponent.getWorkspaceRoot().replace('/', File.separatorChar);
    }

    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        if (null == this.mDeliveryChannel) {
            throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
        }
        this.mDeliveryChannel.registerExternalEndpoint(externalEndpoint);
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment endpointReference) {
        if (null != this.mDeliveryChannel) {
            return this.mDeliveryChannel.resolveEndpointReference(endpointReference);
        }
        throw new IllegalStateException(this.mTranslator.getString("CC_NO_DC_AVAILABLE", this.mComponentName));
    }

    public ManagementMessageFactory getManagementMessageFactory() {
        return this.mContext.getManagementMessageFactory();
    }

    public StringTranslator getStringTranslator(String packageName) {
        return this.mContext.getStringTranslator(packageName, this.mComponentName);
    }

    public StringTranslator getStringTranslatorFor(Object object) {
        return this.mContext.getStringTranslator(object.getClass().getPackage().getName(), this.mComponentName);
    }

    public WsdlFactory getWsdlFactory() throws WsdlException {
        return this.mContext.getWsdlFactory();
    }

    public void registerXAResource(XAResource resource) throws JBIException {
        ((DeliveryChannelImpl)this.getDeliveryChannel(true)).registerXAResource(resource);
    }

    public KeyStoreUtil getKeyStoreUtil() {
        return this.mContext.getPlatformContext().getKeyStoreUtil();
    }

    public ObjectName createCustomComponentMBeanName(String customName) {
        if (this.mComponent.isBinding()) {
            return this.mContext.getMBeanNames().getCustomBindingMBeanName(customName, this.mComponentName);
        }
        return this.mContext.getMBeanNames().getCustomEngineMBeanName(customName, this.mComponentName);
    }

    public String getJmxDomainName() {
        return this.mContext.getMBeanNames().getJmxDomainName();
    }
}

