/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.EventNotifierBase;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.ComponentRegistry;
import com.sun.jbi.framework.ComponentStatistics;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.OperationCounter;
import com.sun.jbi.framework.ServiceUnit;
import com.sun.jbi.framework.ServiceUnitOperation;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.framework.TimeOutException;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.system.ManagementContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUnitFramework {
    private EnvironmentContext mContext;
    private ComponentRegistry mCompReg;
    private Logger mLog;
    private StringTranslator mTranslator;
    private static final int TIMEOUT_LIMIT = 3;
    private static final long TIMEOUT_DEFAULT = 1200000L;

    ServiceUnitFramework(EnvironmentContext env) {
        this.mContext = env;
        this.mCompReg = env.getComponentRegistry();
        this.mLog = env.getLogger();
        this.mTranslator = (StringTranslator)env.getStringTranslatorFor(this);
    }

    private void initializeServiceUnit(Component comp, ServiceUnitManager suMgr, ServiceUnit su) throws JBIException {
        this.mLog.finer("Initializing Service Unit " + su.getName() + " for " + comp.getComponentTypeAsString() + " " + comp.getName());
        if (su.isStopped()) {
            return;
        }
        ComponentStatistics stats = comp.getStatisticsInstance();
        try {
            if (stats.isEnabled()) {
                stats.incrementInitSURequests();
            }
            this.performServiceUnitOperation(2, "init", su, suMgr, comp);
            this.mLog.finer("Setting Service Unit " + su.getName() + " to STOPPED state");
            su.setStopped();
            if (ServiceUnitState.SHUTDOWN == su.getDesiredState()) {
                this.mLog.finest("Returning Service Unit " + su.getName() + " to shutdown state");
                if (stats.isEnabled()) {
                    stats.incrementShutDownSURequests();
                }
                this.performServiceUnitOperation(5, "init", su, suMgr, comp);
                this.mLog.finer("Setting Service Unit " + su.getName() + " to SHUTDOWN state");
                su.setShutdown();
            }
        }
        catch (JBIException ex) {
            String m = ex.getMessage();
            if (ex.getCause() instanceof JBIException) {
                this.mLog.warning(this.mTranslator.getString("SUM_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), m));
            } else {
                this.mLog.log(Level.WARNING, this.mTranslator.getString("SUM_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), m), ex);
            }
            throw ex;
        }
        finally {
            this.persistState(su, "init");
        }
    }

    void initializeServiceUnits(Component comp) {
        if (!comp.isStarted()) {
            return;
        }
        this.mLog.finest("Initializing Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
        ServiceUnitManager suMgr = comp.getServiceUnitManager();
        if (null == suMgr) {
            return;
        }
        List<ServiceUnitInfo> sus = comp.getServiceUnitList();
        Iterator<ServiceUnitInfo> suIter = sus.iterator();
        int timeouts = 0;
        while (suIter.hasNext()) {
            try {
                this.initializeServiceUnit(comp, suMgr, (ServiceUnit)suIter.next());
            }
            catch (Throwable ex) {
                if (ex instanceof TimeOutException) {
                    if (++timeouts < 3) continue;
                    this.mLog.warning(this.mTranslator.getString("SUM_INIT_TIMEOUT_LIMIT", new Long(3L), comp.getComponentTypeAsString(), comp.getName()));
                    break;
                }
                timeouts = 0;
            }
        }
        this.mLog.finest("Initialized Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
    }

    private void shutDownServiceUnit(Component comp, ServiceUnitManager suMgr, ServiceUnit su) throws JBIException {
        this.mLog.finest("Shutting down Service Unit " + su.getName() + " for " + comp.getComponentTypeAsString() + " " + comp.getName());
        if (su.isShutdown()) {
            return;
        }
        ComponentStatistics stats = comp.getStatisticsInstance();
        try {
            if (stats.isEnabled()) {
                stats.incrementShutDownSURequests();
            }
            this.performServiceUnitOperation(5, "shutDown", su, suMgr, comp);
            this.mLog.finer("Setting Service Unit " + su.getName() + " to SHUTDOWN state");
            su.setShutdown();
            this.mContext.getNotifier().emitServiceUnitNotification(EventNotifierBase.EventType.ShutDown, su.getName(), comp.getName(), su.getServiceAssemblyName(), this.mTranslator.getString("SUF_SHUT_DOWN", su.getName(), comp.getName(), su.getServiceAssemblyName()));
        }
        catch (JBIException ex) {
            String m = ex.getMessage();
            this.mLog.warning(this.mTranslator.getString("SUM_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), m));
            if (!(ex.getCause() instanceof JBIException)) {
                this.mLog.warning(this.mTranslator.getString("SUM_STACK_TRACE", this.stackTraceToString(ex)));
            }
            throw ex;
        }
        finally {
            this.persistState(su, "shutDown");
        }
    }

    void shutDownServiceUnits(Component comp) {
        this.mLog.finest("Shutting down Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
        ServiceUnitManager suMgr = comp.getServiceUnitManager();
        if (null == suMgr) {
            return;
        }
        List<ServiceUnitInfo> sus = comp.getServiceUnitList();
        Iterator<ServiceUnitInfo> suIter = sus.iterator();
        int timeouts = 0;
        while (suIter.hasNext()) {
            ServiceUnit su = (ServiceUnit)suIter.next();
            if (su.isStopped()) {
                try {
                    this.shutDownServiceUnit(comp, suMgr, su);
                }
                catch (Throwable ex) {
                    if (ex instanceof TimeOutException) {
                        if (++timeouts < 3) continue;
                        this.mLog.warning(this.mTranslator.getString("SUM_SHUTDOWN_TIMEOUT_LIMIT", new Long(3L), comp.getComponentTypeAsString(), comp.getName()));
                        break;
                    }
                    timeouts = 0;
                }
                continue;
            }
            this.mLog.finest("Skipping Service Unit " + su.getName() + ": was not started");
        }
        this.mLog.finest("Shut down Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
    }

    private void startServiceUnit(Component comp, ServiceUnitManager suMgr, ServiceUnit su) throws JBIException {
        this.mLog.finest("Starting Service Unit " + su.getName() + " for " + comp.getComponentTypeAsString() + " " + comp.getName());
        ComponentStatistics stats = comp.getStatisticsInstance();
        try {
            if (stats.isEnabled()) {
                stats.incrementStartSURequests();
            }
            this.performServiceUnitOperation(3, "start", su, suMgr, comp);
            this.mLog.finer("Setting Service Unit " + su.getName() + " to STARTED state");
            su.setStarted();
            this.mContext.getNotifier().emitServiceUnitNotification(EventNotifierBase.EventType.Started, su.getName(), comp.getName(), su.getServiceAssemblyName(), this.mTranslator.getString("SUF_STARTED", su.getName(), comp.getName(), su.getServiceAssemblyName()));
        }
        catch (JBIException ex) {
            block11: {
                try {
                    if (stats.isEnabled()) {
                        stats.incrementShutDownSURequests();
                    }
                    this.performServiceUnitOperation(5, "start", su, suMgr, comp);
                    this.mLog.finer("Setting Service Unit " + su.getName() + " to SHUTDOWN state");
                    su.setShutdown();
                }
                catch (JBIException e) {
                    String em = e.getMessage();
                    this.mLog.warning(this.mTranslator.getString("SUM_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), em));
                    if (e.getCause() instanceof JBIException) break block11;
                    this.mLog.warning(this.mTranslator.getString("SUM_STACK_TRACE", this.stackTraceToString(e)));
                }
            }
            String m = ex.getMessage();
            this.mLog.warning(this.mTranslator.getString("SUM_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), m));
            if (!(ex.getCause() instanceof JBIException)) {
                this.mLog.warning(this.mTranslator.getString("SUM_STACK_TRACE", this.stackTraceToString(ex)));
            }
            throw ex;
        }
        finally {
            this.persistState(su, "start");
        }
    }

    void startServiceUnits(Component comp) {
        if (!comp.isStarted()) {
            return;
        }
        this.mLog.finest("Starting Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
        ServiceUnitManager suMgr = comp.getServiceUnitManager();
        if (null == suMgr) {
            return;
        }
        List<ServiceUnitInfo> sus = comp.getServiceUnitList();
        Iterator<ServiceUnitInfo> suIter = sus.iterator();
        int timeouts = 0;
        while (suIter.hasNext()) {
            ServiceUnit su = (ServiceUnit)suIter.next();
            if (ServiceUnitState.STARTED == su.getDesiredState() && su.isStopped()) {
                try {
                    this.startServiceUnit(comp, suMgr, su);
                }
                catch (Throwable ex) {
                    if (ex instanceof TimeOutException) {
                        if (++timeouts < 3) continue;
                        this.mLog.warning(this.mTranslator.getString("SUM_START_TIMEOUT_LIMIT", new Long(3L), comp.getComponentTypeAsString(), comp.getName()));
                        break;
                    }
                    timeouts = 0;
                }
                continue;
            }
            this.mLog.finest("Skipping Service Unit " + su.getName() + ": was not started at last shutdown");
        }
        this.mLog.finest("Started Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
    }

    private void stopServiceUnit(Component comp, ServiceUnitManager suMgr, ServiceUnit su) throws JBIException {
        this.mLog.finest("Stopping Service Unit " + su.getName() + " for " + comp.getComponentTypeAsString() + " " + comp.getName());
        ComponentStatistics stats = comp.getStatisticsInstance();
        try {
            if (stats.isEnabled()) {
                stats.incrementStopSURequests();
            }
            this.performServiceUnitOperation(4, "stop", su, suMgr, comp);
            this.mLog.finer("Setting Service Unit " + su.getName() + " to STOPPED state");
            su.setStopped();
            this.mContext.getNotifier().emitServiceUnitNotification(EventNotifierBase.EventType.Stopped, su.getName(), comp.getName(), su.getServiceAssemblyName(), this.mTranslator.getString("SUF_STOPPED", su.getName(), comp.getName(), su.getServiceAssemblyName()));
        }
        catch (JBIException ex) {
            String m = ex.getMessage();
            this.mLog.warning(this.mTranslator.getString("SUM_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), m));
            if (!(ex.getCause() instanceof JBIException)) {
                this.mLog.warning(this.mTranslator.getString("SUM_STACK_TRACE", this.stackTraceToString(ex)));
            }
            throw ex;
        }
        finally {
            this.persistState(su, "stop");
        }
    }

    void stopServiceUnits(Component comp) {
        if (!comp.isStarted()) {
            return;
        }
        this.mLog.finest("Stopping Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
        ServiceUnitManager suMgr = comp.getServiceUnitManager();
        if (null == suMgr) {
            return;
        }
        List<ServiceUnitInfo> sus = comp.getServiceUnitList();
        Iterator<ServiceUnitInfo> suIter = sus.iterator();
        int timeouts = 0;
        while (suIter.hasNext()) {
            ServiceUnit su = (ServiceUnit)suIter.next();
            if (su.isStarted()) {
                try {
                    this.stopServiceUnit(comp, suMgr, su);
                }
                catch (Throwable ex) {
                    if (ex instanceof TimeOutException) {
                        if (++timeouts < 3) continue;
                        this.mLog.warning(this.mTranslator.getString("SUM_STOP_TIMEOUT_LIMIT", new Long(3L), comp.getComponentTypeAsString(), comp.getName()));
                        break;
                    }
                    timeouts = 0;
                }
                continue;
            }
            this.mLog.finest("Skipping Service Unit " + su.getName() + ": was not started");
        }
        this.mLog.finest("Stopped Service Units for " + comp.getComponentTypeAsString() + " " + comp.getName());
    }

    void updateServiceAssemblies(Set<String> saNames) {
        if (saNames.isEmpty()) {
            this.mLog.finer("No Service Assemblies to be updated");
            return;
        }
        this.mLog.finer("Updating Service Assemblies...");
        for (String saName : saNames) {
            this.mLog.finer("Updating Service Assembly " + saName + "...");
            String result = ManagementContext.getDeploymentServiceHandle().updateSAState(saName);
            this.mLog.finer("Updated Service Assembly state to " + result);
        }
        this.mLog.finer("Updated Service Assemblies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performServiceUnitOperation(int operation, String task, ServiceUnit su, ServiceUnitManager suMgr, Component comp) throws JBIException {
        String suName = su.getName();
        Object[] args = new Object[]{suName, su.getFilePath()};
        OperationCounter oc = new OperationCounter();
        ServiceUnitOperation suOper = new ServiceUnitOperation(oc, comp.getName(), suMgr, operation, args);
        long timeout = this.mContext.getServiceUnitTimeout();
        ComponentStatistics stats = comp.getStatisticsInstance();
        new Thread((Runnable)suOper, suName).start();
        OperationCounter operationCounter = oc;
        synchronized (operationCounter) {
            try {
                if (0 < oc.getValue()) {
                    oc.wait(timeout);
                }
            }
            catch (InterruptedException iEx) {
                suOper.getThread().interrupt();
                String msg = this.mTranslator.getString("DMB_SU_OPERATION_INTERRUPTED", task, suName);
                throw new JBIException(msg, (Throwable)iEx);
            }
        }
        if (suOper.completed()) {
            Throwable ex = suOper.getException();
            if (null != ex) {
                if (stats.isEnabled()) {
                    stats.incrementFailedSURequests();
                }
                if (ex instanceof DeploymentException) {
                    throw (DeploymentException)ex;
                }
                String exMsg = ex.getMessage();
                String msg = null == exMsg ? this.mTranslator.getString("DMB_SU_OPERATION_EXCEPTION_NO_MSG", ex.getClass().getName(), task, suName) : this.mTranslator.getString("DMB_SU_OPERATION_EXCEPTION", ex.getClass().getName(), task, suName, exMsg);
                throw new JBIException(msg, ex);
            }
        } else {
            if (stats.isEnabled()) {
                stats.incrementTimedOutSURequests();
            }
            suOper.getThread().interrupt();
            String msg = this.mTranslator.getString("DMB_SU_OPERATION_TIMEOUT", task, suName, new Long(timeout));
            throw new TimeOutException(msg);
        }
    }

    private void persistState(ServiceUnit su, String task) {
        try {
            Updater updater = ((Registry)this.mContext.getRegistry()).getUpdater();
            updater.setServiceUnitState(su.getDesiredState(), su.getTargetComponent(), su.getName());
        }
        catch (RegistryException rex) {
            String msg = this.mTranslator.getString("DMB_SU_STATE_PERSIST_FAILURE", su.getName(), task, rex.getMessage());
            this.mLog.warning(msg);
        }
    }

    private String stackTraceToString(Throwable exception) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception ex) {
            return this.mTranslator.getString("STACK_TRACE_PRINT_FAILED");
        }
    }
}

