/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.framework.XmlParseException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private static StringTranslator sTranslator;
    private static final String VALUE_UTF8 = "UTF-8";

    static Node getElement(Node node, String tag, boolean isRequired) throws XmlParseException {
        Node retNode = null;
        NodeList nodeList = XmlUtil.getElements(node, tag, isRequired);
        int n = nodeList.getLength();
        if (n > 1) {
            throw new XmlParseException(sTranslator.getString("XML_EXTRA_ELEMENTS", new Integer(n), tag));
        }
        if (n > 0) {
            retNode = nodeList.item(0);
        }
        return retNode;
    }

    static NodeList getElements(Node node, String tag, boolean isRequired) throws XmlParseException {
        NodeList nodeList = null;
        if (null != node) {
            try {
                node = node.cloneNode(true);
                nodeList = node.getChildNodes();
                for (int n = 0; n < nodeList.getLength(); ++n) {
                    if (nodeList.item(n).getNodeName().equals(tag)) continue;
                    node.removeChild(nodeList.item(n));
                    --n;
                }
                nodeList = node.getChildNodes();
                if (isRequired && 0 == nodeList.getLength()) {
                    throw new XmlParseException(sTranslator.getString("XML_MISSING_ELEMENT", tag, node.getNodeName()));
                }
            }
            catch (DOMException domEx) {
                throw new XmlParseException(sTranslator.getString("XML_DOM_EXCEPTION", domEx.getMessage()));
            }
        }
        return nodeList;
    }

    static String getAttribute(Node node, String attrName) {
        String value;
        if (null == node) {
            throw new IllegalArgumentException(sTranslator.getString("NULL_ARGUMENT", "node"));
        }
        if (null == attrName) {
            throw new IllegalArgumentException(sTranslator.getString("NULL_ARGUMENT", "attrName"));
        }
        Element elem = (Element)node;
        try {
            value = URLDecoder.decode(elem.getAttribute(attrName), VALUE_UTF8).trim();
        }
        catch (UnsupportedEncodingException ueEx) {
            value = elem.getAttribute(attrName);
        }
        return value;
    }

    static Boolean getBooleanValue(Node node, String tag, boolean isRequired) throws XmlParseException {
        String s;
        Boolean value = null;
        NodeList nl = XmlUtil.getElements(node, tag, isRequired);
        if (0 != nl.getLength() && null != (s = XmlUtil.getStringValue(nl))) {
            value = Boolean.valueOf(s);
        }
        return value;
    }

    static String getStringValue(Node node) throws XmlParseException {
        String value;
        if (null == node) {
            throw new IllegalArgumentException(sTranslator.getString("NULL_ARGUMENT", "node"));
        }
        NodeList nodes = node.getChildNodes();
        int nodeCount = nodes.getLength();
        if (0 == nodeCount) {
            throw new XmlParseException(sTranslator.getString("XML_EMPTY_ELEMENT", node.getNodeName()));
        }
        Node textNode = null;
        for (int n = 0; n < nodeCount; ++n) {
            if (nodes.item(n).getNodeType() != 3) continue;
            textNode = nodes.item(n);
            break;
        }
        if (null == textNode) {
            throw new XmlParseException(sTranslator.getString("XML_MISSING_ELEMENT", "TEXT", node.getNodeName()));
        }
        try {
            value = URLDecoder.decode(((Text)textNode).getData(), VALUE_UTF8).trim();
        }
        catch (UnsupportedEncodingException ueEx) {
            value = ((Text)textNode).getData();
        }
        return value;
    }

    static String getStringValue(Node node, String tag, boolean isRequired) throws XmlParseException {
        String value = null;
        NodeList nl = XmlUtil.getElements(node, tag, isRequired);
        if (0 != nl.getLength()) {
            value = XmlUtil.getStringValue(nl);
        }
        return value;
    }

    static String getStringValue(NodeList nodeList) throws XmlParseException {
        String value;
        if (null == nodeList) {
            throw new IllegalArgumentException(sTranslator.getString("NULL_ARGUMENT", "nodeList"));
        }
        if (0 == nodeList.getLength()) {
            throw new IllegalArgumentException(sTranslator.getString("EMPTY_LIST_ARGUMENT", "nodeList"));
        }
        Node node = nodeList.item(0);
        if (1 != nodeList.getLength()) {
            throw new XmlParseException(sTranslator.getString("XML_EXTRA_ELEMENTS", new Integer(nodeList.getLength()), node.getNodeName()));
        }
        Node textNode = node.getFirstChild();
        if (null == textNode) {
            throw new XmlParseException(sTranslator.getString("XML_EMPTY_ELEMENT", node.getNodeName()));
        }
        if (!(textNode instanceof Text)) {
            throw new XmlParseException(sTranslator.getString("XML_INVALID_ELEMENT", node.getNodeName()));
        }
        try {
            value = URLDecoder.decode(((Text)textNode).getData(), VALUE_UTF8).trim();
        }
        catch (UnsupportedEncodingException ueEx) {
            value = ((Text)textNode).getData();
        }
        return value;
    }

    static List<String> getStringValueArray(Node node, String tag, boolean isRequired) throws XmlParseException {
        NodeList nl = XmlUtil.getElements(node, tag, isRequired);
        if (null == nl && !isRequired) {
            return new ArrayList<String>();
        }
        return XmlUtil.getStringValueArray(nl);
    }

    static List<String> getStringValueArray(Node node, String tag1, String tag2, boolean isRequired) throws XmlParseException {
        NodeList nl = XmlUtil.getElements(node, tag1, isRequired);
        if (nl.getLength() > 1) {
            throw new XmlParseException(sTranslator.getString("XML_EXTRA_ELEMENTS", new Integer(nl.getLength()), tag1));
        }
        NodeList nl2 = XmlUtil.getElements(nl.item(0), tag2, isRequired);
        if (null == nl2 && !isRequired) {
            return new ArrayList<String>();
        }
        return XmlUtil.getStringValueArray(nl2);
    }

    static List<String> getStringValueArray(NodeList nodeList) throws XmlParseException {
        if (null == nodeList) {
            throw new IllegalArgumentException(sTranslator.getString("NULL_ARGUMENT", "nodeList"));
        }
        ArrayList<String> elements = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String value;
            Node node = nodeList.item(i);
            Node textNode = node.getFirstChild();
            if (null == textNode) {
                throw new XmlParseException(sTranslator.getString("XML_EMPTY_ELEMENT", node.getNodeName()));
            }
            if (!(textNode instanceof Text)) {
                throw new XmlParseException(sTranslator.getString("XML_INVALID_ELEMENT", node.getNodeName()));
            }
            try {
                value = URLDecoder.decode(((Text)textNode).getData(), VALUE_UTF8).trim();
            }
            catch (UnsupportedEncodingException ueEx) {
                value = ((Text)textNode).getData();
            }
            elements.add(value);
        }
        return elements;
    }

    static {
        EnvironmentContext ec = EnvironmentContext.getInstance();
        sTranslator = (StringTranslator)ec.getStringTranslatorFor(ec);
    }
}

