/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.jboss;

import com.sun.jbi.framework.JBIFramework;
import com.sun.jbi.framework.jboss.JBossASJBIFrameworkMBean;
import com.sun.jbi.framework.jboss.JBossPlatformContext;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JBossASJBIFramework
extends JBIFramework
implements JBossASJBIFrameworkMBean {
    private static final String JBI_HOME = "com.sun.jbi.home";
    private static final String JBOSS_NAMING_SERVICE = "jboss:service=Naming";
    public static final String INSTALL_ROOT = "install.root";
    public static final String INSTANCE_NAME = "instance.name";
    public static final String INSTANCE_ROOT = "instance.root";
    private static final String DEFAULT_INSTALL_ROOT = System.getProperty("user.dir");
    private static final String DEFAULT_INSTANCE_NAME = "default";
    private static final String JBOSS_NAMING_PREFIX = "";
    private boolean mLoaded;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private String mInstallRoot;
    private JMXConnectorServer mConnectorServer;
    private JBossPlatformContext mPlatformContext;

    public JBossASJBIFramework(Properties env) {
        this.mInstallRoot = env.getProperty(INSTALL_ROOT, DEFAULT_INSTALL_ROOT);
        this.mPlatformContext = new JBossPlatformContext(env.getProperty(INSTANCE_NAME, DEFAULT_INSTANCE_NAME), this.mInstallRoot, env.getProperty(INSTANCE_ROOT, DEFAULT_INSTALL_ROOT));
    }

    public void load() throws Exception {
        Properties props = new Properties();
        props.put(JBI_HOME, this.mInstallRoot);
        MBeanServer mbs = this.mPlatformContext.getMBeanServer();
        this.startJMXConnectorServer(mbs);
        super.init(this.mPlatformContext, props);
        InitialContext ctx = new InitialContext();
        Context subctx = null;
        try {
            Object obj = ctx.lookup("jbi");
            subctx = (Context)obj;
        }
        catch (NamingException ne) {
            subctx = ctx.createSubcontext("jbi");
        }
        this.mConnectorServer.start();
        super.startup(ctx, JBOSS_NAMING_PREFIX);
        super.prepare();
        this.mLog.info("JBI Framework - Created");
        super.ready(true);
        this.mLog.info("JBI Framework - Started");
        this.mLoaded = true;
    }

    private void startJMXConnectorServer(MBeanServer mbs) {
        try {
            ObjectName mbeanName = new ObjectName(JBOSS_NAMING_SERVICE);
            Integer port = (Integer)mbs.getAttribute(mbeanName, "Port");
            String jmxurl = "service:jmx:rmi:///jndi/jnp://localhost:" + port.toString() + "/jbiconnector";
            this.mLog.info("JMX Url: " + jmxurl);
            JMXServiceURL url = new JMXServiceURL(jmxurl);
            this.mConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
            this.mLog.info("RMI Connector server started - JMXServiceURL to access    the mbean server would be " + jmxurl);
        }
        catch (Exception e) {
            this.mLog.severe("Cannot create Connector " + e.getMessage());
        }
    }

    public boolean isLoaded() {
        return this.mLoaded;
    }

    public synchronized void unload() throws Exception {
        if (!this.mLoaded) {
            return;
        }
        this.shutdown();
        this.mLog.info("JBI Framework - Stopped");
        this.mConnectorServer.stop();
        this.mLog.info("JBI RMI Connector server stopped ");
        this.terminate();
        this.mLoaded = false;
    }
}

