/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.jse;

import com.sun.jbi.framework.JBIFramework;
import com.sun.jbi.framework.jse.JSEJBIFrameworkMBean;
import com.sun.jbi.framework.jse.JSEPlatformContext;
import com.sun.jndi.rmi.registry.RegistryContextFactory;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JSEJBIFramework
extends JBIFramework
implements JSEJBIFrameworkMBean {
    public static final String INSTALL_ROOT = "install.root";
    public static final String INSTANCE_NAME = "instance.name";
    public static final String CONNECTOR_PORT = "connector.port";
    private static final String DEFAULT_INSTALL_ROOT = System.getProperty("user.dir");
    private static final String DEFAULT_INSTANCE_NAME = "server";
    private JSEPlatformContext mPlatformContext;
    private boolean mLoaded;
    private Properties mEnvironment;
    private JMXConnectorServer mJMXServer;
    private Registry mRegistry;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());

    public JSEJBIFramework(Properties environment) {
        this.mEnvironment = environment;
        this.mPlatformContext = new JSEPlatformContext(this.mEnvironment.getProperty(INSTANCE_NAME, DEFAULT_INSTANCE_NAME), this.mEnvironment.getProperty(INSTALL_ROOT, DEFAULT_INSTALL_ROOT));
    }

    public synchronized void load() throws Exception {
        if (this.mLoaded) {
            throw new IllegalStateException("JBI framework already loaded!");
        }
        ObjectName fwMBeanName = new ObjectName("com.sun.jbi.jse", "instance", this.mPlatformContext.getInstanceName());
        MBeanServer mbs = this.mPlatformContext.getMBeanServer();
        if (mbs.isRegistered(fwMBeanName)) {
            if (mbs.getAttribute(fwMBeanName, "Loaded").equals(Boolean.TRUE)) {
                throw new IllegalStateException("JBI framework instance " + this.mPlatformContext.getInstanceName() + " has already been loaded");
            }
            mbs.unregisterMBean(fwMBeanName);
        }
        mbs.registerMBean(this, fwMBeanName);
        String portStr = this.mEnvironment.getProperty(CONNECTOR_PORT);
        if (portStr != null) {
            try {
                int port = Integer.parseInt(portStr);
                this.createJMXConnectorServer(port);
            }
            catch (NumberFormatException nfEx) {
                this.mLog.warning("Invalid connector server port: " + portStr + ". Remote JMX connector will not be created.");
            }
        }
        this.mEnvironment.setProperty("com.sun.jbi.home", this.mPlatformContext.getInstallRoot());
        this.init(this.mPlatformContext, this.mEnvironment);
        this.startup(this.mPlatformContext.getNamingContext(), "");
        this.prepare();
        this.ready(true);
        this.mLoaded = true;
    }

    public boolean isLoaded() {
        return this.mLoaded;
    }

    public synchronized void unload() throws Exception {
        if (!this.mLoaded) {
            return;
        }
        this.shutdown();
        this.terminate();
        try {
            this.mJMXServer.stop();
            UnicastRemoteObject.unexportObject(this.mRegistry, true);
        }
        catch (Exception ex) {
            this.mLog.severe("Error during framework shutdown: " + ex.toString());
        }
        this.mLoaded = false;
    }

    public JMXServiceURL getServiceURL(int port) throws MalformedURLException {
        return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi");
    }

    private void createJMXConnectorServer(int port) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("java.naming.factory.initial", RegistryContextFactory.class.getName());
        try {
            JMXServiceURL serviceURL = this.getServiceURL(port);
            this.mRegistry = LocateRegistry.createRegistry(port);
            this.mJMXServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, map, this.mPlatformContext.getMBeanServer());
            this.mJMXServer.start();
            this.mLog.info("remote JMX connector available at " + this.mJMXServer.getAddress());
        }
        catch (Exception ex) {
            this.mLog.severe("Failed to create remote JMX connector: " + ex.toString());
        }
    }
}

