/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.sun;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class SystemComponentBootstrap {
    private static final int PORT_OFFSET = 1000;
    private static final String HTTP_SOAP_WORKSPACE = "components" + File.separator + "sun-http-binding" + File.separator + "install_root" + File.separator + "workspace";
    private static final String HTTP_SOAP_CONFIG = "config.properties";
    private static final String HTTP_LISTENER = "http-listener-1";
    private static final String HTTPS_LISTENER = "http-listener-2";
    private static final String HTTP_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_TOKEN = "${HttpsDefaultPort}";
    private static final int HTTP_DEFAULT_PORT = 9080;
    private static final int HTTPS_DEFAULT_PORT = 9181;
    private String mConfigPath;
    private StringTranslator mTranslator;
    private Logger mLogger;
    private ConfigContext mServerConfig;
    private EnvironmentContext mJbiCtx;

    public SystemComponentBootstrap(EnvironmentContext envCtx) throws Exception {
        this.mJbiCtx = envCtx;
        this.mServerConfig = ApplicationServer.getServerContext().getConfigContext();
        this.mTranslator = envCtx.getStringTranslatorFor(this);
        this.mLogger = Logger.getLogger("com.sun.jbi.framework.sun");
        this.mConfigPath = envCtx.getJbiInstanceRoot() + File.separator + HTTP_SOAP_WORKSPACE + File.separator + HTTP_SOAP_CONFIG;
    }

    public void configureHttpSoapDefaultPorts() {
        Properties props = this.readHttpSoapConfig();
        if (props.containsValue(HTTP_TOKEN) || props.containsValue(HTTPS_TOKEN)) {
            this.setHttpSoapDefaultPorts(props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readHttpSoapConfig() {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.mConfigPath);
            props.load(fis);
        }
        catch (IOException ioEx) {
            this.mLogger.fine(this.mTranslator.getString("HTTP_SOAP_CONFIG_READ_ERROR", this.mConfigPath, ioEx.getMessage()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHttpSoapDefaultPorts(Properties props) {
        HttpListener httpsListener;
        HttpListener httpListener;
        try {
            HttpService httpService = ServerBeansFactory.getHttpServiceBean((ConfigContext)this.mServerConfig);
            httpListener = httpService.getHttpListenerById(HTTP_LISTENER);
            httpsListener = httpService.getHttpListenerById(HTTPS_LISTENER);
        }
        catch (Exception ex) {
            this.mLogger.warning(this.mTranslator.getString("APPSERVER_CONFIG_ERROR", this.mConfigPath, ex.getMessage()));
            return;
        }
        int httpPort = null != httpListener ? Integer.parseInt(httpListener.getPort()) + 1000 : 9080;
        while (this.portInUse(httpPort)) {
            ++httpPort;
        }
        int httpsPort = null != httpsListener ? Integer.parseInt(httpsListener.getPort()) + 1000 : 9181;
        while (this.portInUse(httpsPort)) {
            if (++httpsPort != httpPort) continue;
            ++httpsPort;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (entry.getValue().equals(HTTP_TOKEN)) {
                entry.setValue(String.valueOf(httpPort));
                continue;
            }
            if (!entry.getValue().equals(HTTPS_TOKEN)) continue;
            entry.setValue(String.valueOf(httpsPort));
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.mConfigPath);
            props.store(fos, null);
        }
        catch (IOException ioEx) {
            this.mLogger.warning(this.mTranslator.getString("HTTP_SOAP_CONFIG_WRITE_ERROR", this.mConfigPath, ioEx.getMessage()));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioEx) {}
            }
        }
    }

    private boolean portInUse(int port) {
        boolean ret = false;
        try {
            Socket s = new Socket("127.0.0.1", port);
            ret = true;
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

