/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management;

import com.sun.jbi.component.InstallationContext;
import com.sun.jbi.util.StringTranslator;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jbi.component.ComponentContext;
import org.w3c.dom.DocumentFragment;

public class ComponentInstallationContext
implements InstallationContext {
    private boolean mBootstrapClassLoaderSelfFirst;
    private String mClassName;
    private List mClassPathElements;
    private boolean mComponentClassLoaderSelfFirst;
    private String mComponentName;
    private int mComponentType;
    private ComponentContext mContext;
    private String mDescription;
    private String mInstallRoot;
    private boolean mIsInstall;
    private StringTranslator mTranslator;
    private String mWorkspaceRoot;
    private DocumentFragment mInstallationDescriptorExtension;

    public ComponentInstallationContext(String componentName, int componentType, String className, List classPathElements, DocumentFragment extensionData) {
        this.mComponentName = componentName;
        this.mComponentType = componentType;
        this.mClassName = className;
        this.mClassPathElements = classPathElements;
        this.mInstallationDescriptorExtension = extensionData;
        this.mBootstrapClassLoaderSelfFirst = false;
        this.mComponentClassLoaderSelfFirst = false;
        this.mIsInstall = false;
        this.mTranslator = new StringTranslator(this.getClass().getPackage().getName(), null);
    }

    public List getClassPathElements() {
        if (File.separator.equals("/")) {
            return this.mClassPathElements;
        }
        ArrayList<String> retList = new ArrayList<String>();
        Iterator i = this.mClassPathElements.iterator();
        while (i.hasNext()) {
            String e = ((String)i.next()).replace('/', File.separatorChar);
            retList.add(e);
        }
        return retList;
    }

    public String getComponentClassName() {
        return this.mClassName;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public ComponentContext getContext() {
        return this.mContext;
    }

    public DocumentFragment getInstallationDescriptorExtension() {
        return this.mInstallationDescriptorExtension;
    }

    public String getInstallRoot() {
        if (File.separator.equals("/")) {
            return this.mInstallRoot;
        }
        return this.mInstallRoot.replace('/', File.separatorChar);
    }

    public boolean isInstall() {
        return this.mIsInstall;
    }

    public void setClassPathElements(List classPathElements) {
        if (null == classPathElements) {
            throw new IllegalArgumentException(this.mTranslator.getString("IC_NULL_CLASS_PATH_ELEMENTS"));
        }
        if (classPathElements.isEmpty()) {
            throw new IllegalArgumentException(this.mTranslator.getString("IC_EMPTY_CLASS_PATH_ELEMENTS"));
        }
        Iterator i = classPathElements.iterator();
        int index = 0;
        while (i.hasNext()) {
            String element = (String)i.next();
            File f = new File(element);
            if (f.isAbsolute()) {
                throw new IllegalArgumentException(this.mTranslator.getString("IC_ABSOLUTE_PATH_NOT_ALLOWED", new Integer(index), element));
            }
            String sep = File.separator.equals("\\") ? "/" : "\\";
            int offset = element.indexOf(sep);
            if (offset > -1) {
                throw new IllegalArgumentException(this.mTranslator.getString("IC_INCORRECT_FILE_SEPARATOR", sep, new Integer(offset), new Integer(index), element));
            }
            element.replace('\\', '/');
            ++index;
        }
        this.mClassPathElements = classPathElements;
    }

    public List getAbsoluteClassPathElements() {
        ArrayList<String> retList = new ArrayList<String>();
        Iterator i = this.mClassPathElements.iterator();
        while (i.hasNext()) {
            String e = this.mInstallRoot + "/" + (String)i.next();
            retList.add(e);
        }
        return retList;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getWorkspaceRoot() {
        return this.mWorkspaceRoot;
    }

    public boolean isBinding() {
        return 1 == this.mComponentType;
    }

    public boolean isBootstrapClassLoaderSelfFirst() {
        return this.mBootstrapClassLoaderSelfFirst;
    }

    public boolean isComponentClassLoaderSelfFirst() {
        return this.mComponentClassLoaderSelfFirst;
    }

    public boolean isEngine() {
        return 2 == this.mComponentType;
    }

    public void setContext(ComponentContext context) {
        this.mContext = context;
    }

    public void setBootstrapClassLoaderSelfFirst() {
        this.mBootstrapClassLoaderSelfFirst = true;
    }

    public void setComponentClassLoaderSelfFirst() {
        this.mComponentClassLoaderSelfFirst = true;
    }

    public void setComponentClassName(String name) {
        this.mClassName = name;
    }

    public void setComponentName(String name) {
        this.mComponentName = name;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setInstallationDescriptorExtension(DocumentFragment extension) {
        this.mInstallationDescriptorExtension = extension;
    }

    public void setInstallRoot(String installRoot) {
        this.mInstallRoot = installRoot;
    }

    public void setIsInstall(boolean isInstall) {
        this.mIsInstall = isInstall;
    }

    public void setWorkspaceRoot(String workspaceRoot) {
        this.mWorkspaceRoot = workspaceRoot;
    }
}

