/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.config.DescriptorSupport;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.Properties;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public class SystemConfigurationFactory
extends ConfigurationFactory {
    public static final String JBI_HOME = "jbiHome";
    public static final String HEART_BEAT_INTERVAL = "heartBeatInterval";
    public static final String MSG_SVC_STATS_ENABLED = "msgSvcTimingStatisticsEnabled";
    private static final int sNumAttributes = 3;

    public SystemConfigurationFactory(Properties defProps) {
        super(defProps, ConfigurationCategory.System);
    }

    public ModelMBeanAttributeInfo[] createMBeanAttributeInfo() {
        ModelMBeanAttributeInfo[] attributeInfos = new ModelMBeanAttributeInfo[3];
        DescriptorSupport descr = new DescriptorSupport();
        String attrDescr = this.getString("JBI_HOME_DESCR");
        descr.setAttributeName(JBI_HOME);
        descr.setDisplayName(this.getString("JBI_HOME_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("JBI_HOME_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("JBI_HOME_DESCR"));
        descr.setToolTip(this.getString("JBI_HOME_DESCR"));
        descr.setToolTipId(this.getToken("JBI_HOME_DESCR"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(true);
        descr.setIsPassword(false);
        descr.setDefault(this.getJbiHome());
        attributeInfos[0] = new ModelMBeanAttributeInfo(JBI_HOME, "java.lang.String", attrDescr, true, false, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("HEART_BEAT_INTERVAL_DESCR");
        descr.setAttributeName(HEART_BEAT_INTERVAL);
        descr.setDisplayName(this.getString("HEART_BEAT_INTERVAL_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("HEART_BEAT_INTERVAL_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("HEART_BEAT_INTERVAL_DESCR"));
        descr.setToolTip(this.getString("HEART_BEAT_INTERVAL_TOOLTIP"));
        descr.setToolTipId(this.getToken("HEART_BEAT_INTERVAL_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defHeartBeat = this.mDefaults.getProperty(this.getQualifiedKey(HEART_BEAT_INTERVAL), "5500");
        descr.setDefault(Integer.parseInt(defHeartBeat));
        descr.setMinValue(1000);
        descr.setMaxValue(Integer.MAX_VALUE);
        descr.setUnit("milliseconds");
        attributeInfos[1] = new ModelMBeanAttributeInfo(HEART_BEAT_INTERVAL, "int", attrDescr, true, true, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("MSG_SVC_STATS_ENABLED_DESCR");
        descr.setAttributeName(MSG_SVC_STATS_ENABLED);
        descr.setDisplayName(this.getString("MSG_SVC_STATS_ENABLED_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("MSG_SVC_STATS_ENABLED_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("MSG_SVC_STATS_ENABLED_DESCR"));
        descr.setToolTip(this.getString("MSG_SVC_STATS_ENABLED_TOOLTIP"));
        descr.setToolTipId(this.getToken("MSG_SVC_STATS_ENABLED_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        descr.setIsPassword(false);
        String defMsgSvcStatsEnabled = this.mDefaults.getProperty(this.getQualifiedKey(MSG_SVC_STATS_ENABLED), "false");
        descr.setDefault(Boolean.parseBoolean(defMsgSvcStatsEnabled));
        attributeInfos[2] = new ModelMBeanAttributeInfo(MSG_SVC_STATS_ENABLED, "boolean", attrDescr, true, true, true, descr);
        return attributeInfos;
    }

    private String getJbiHome() {
        EnvironmentContext envCtx = EnvironmentAccess.getContext();
        return envCtx.getJbiInstallRoot();
    }
}

