/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.facade.ComponentConfiguration;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.util.ComponentConfigurationHelper;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.w3c.dom.Document;

public class ClusterInstanceComponentConfiguration
extends ComponentConfiguration
implements com.sun.jbi.management.ComponentConfiguration {
    private String mInstanceName;

    public ClusterInstanceComponentConfiguration(EnvironmentContext ctx, String instanceName, String clusterName, String compName, ComponentType compType) throws ManagementException {
        super(ctx, clusterName, compName, compType);
        if (!this.mPlatform.isClusteredServer(instanceName)) {
            Object[] params = new String[]{instanceName};
            String responseMsg = this.mTranslator.getString("JBI_CCFG_INVALID_CLUSTER_INST_NAME", params);
            String jbiMgtMsg = this.mMsgBuilder.buildFrameworkMessage("ClusterInstanceComponentConfiguration[ctor]", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(responseMsg), (String[])params, MessageBuilder.getMessageToken(responseMsg));
            throw new ManagementException(jbiMgtMsg);
        }
        this.mInstanceName = instanceName;
        this.mComponentName = compName;
        this.mComponentType = compType;
        this.mCfgHlpr = new ComponentConfigurationHelper();
        ClusterInstanceComponentConfiguration.initPrimitiveTypeMap();
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            if ("ApplicationVariables".equals(attribute)) {
                return this.getApplicationVariables();
            }
            if ("ApplicationConfigurations".equals(attribute)) {
                return this.getApplicationConfigurations();
            }
            this.attributeCheck(attribute);
            AttributeList attribList = this.getAttributes(new String[]{attribute});
            if (!attribList.isEmpty()) {
                return ((Attribute)attribList.get(0)).getValue();
            }
            return null;
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.setConfigurationAttribute(attribute);
        }
        catch (JBIException jex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jex)));
            throw new MBeanException((Exception)((Object)jex));
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            if (actionName.equals("setConfigurationAttribute")) {
                return this.setConfigurationAttribute((Attribute)params[0]);
            }
            if (actionName.equals("setConfigurationAttributes")) {
                return this.setConfigurationAttributes((AttributeList)params[0]);
            }
            if (actionName.equals("addApplicationVariable")) {
                return this.addApplicationVariable((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("setApplicationVariable")) {
                return this.setApplicationVariable((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("deleteApplicationVariable")) {
                return this.deleteApplicationVariable((String)params[0]);
            }
            if (actionName.equals("getApplicationVariables")) {
                return this.getApplicationVariables();
            }
            if (actionName.equals("getApplicationConfigurations")) {
                return this.getApplicationConfigurations();
            }
            if (actionName.equals("addApplicationConfiguration")) {
                if (params[1] instanceof Properties) {
                    return this.addApplicationConfiguration((String)params[0], (Properties)params[1]);
                }
                return this.addApplicationConfiguration((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("setApplicationConfiguration")) {
                if (params[1] instanceof Properties) {
                    return this.setApplicationConfiguration((String)params[0], (Properties)params[1]);
                }
                return this.setApplicationConfiguration((String)params[0], (CompositeData)params[1]);
            }
            if (actionName.equals("deleteApplicationConfiguration")) {
                return this.deleteApplicationConfiguration((String)params[0]);
            }
            if (actionName.equals("queryApplicationConfigurationType")) {
                return this.queryApplicationConfigurationType();
            }
            if (actionName.equals("retrieveConfigurationDisplaySchema")) {
                return this.retrieveConfigurationDisplaySchema();
            }
            if (actionName.equals("retrieveConfigurationDisplayData")) {
                return this.retrieveConfigurationDisplayData();
            }
            if (actionName.equals("isAppVarsSupported")) {
                return this.isAppVarsSupported();
            }
            if (actionName.equals("isAppConfigSupported")) {
                return this.isAppConfigSupported();
            }
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        throw new UnsupportedOperationException();
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            this.setConfigurationAttributes(attributes);
            return attributes;
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
            return new AttributeList();
        }
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo;
        MBeanInfo augInfo = mbeanInfo = this.getComponentMBeanInfo();
        try {
            Method[] methods = Class.forName("com.sun.jbi.management.ComponentConfiguration").getDeclaredMethods();
            MBeanOperationInfo[] opInfos = new MBeanOperationInfo[methods.length];
            int i = 0;
            for (Method mtd : methods) {
                opInfos[i++] = new MBeanOperationInfo(mtd.getName(), mtd);
            }
            augInfo = new MBeanInfo(mbeanInfo.getClassName(), mbeanInfo.getDescription(), mbeanInfo.getAttributes(), mbeanInfo.getConstructors(), this.merge(mbeanInfo.getOperations(), opInfos), mbeanInfo.getNotifications());
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
        }
        return augInfo;
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        try {
            this.instanceRunningCheck();
        }
        catch (JBIException jbiex) {
            throw new RuntimeException(jbiex);
        }
        try {
            this.attributeCheck(attributes);
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
            return list;
        }
        ObjectName configMBeanName = null;
        try {
            configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName);
            AttributeList attribs = (AttributeList)this.getRemoteAttributes(configMBeanName, attributes, this.mInstanceName);
            return attribs;
        }
        catch (ManagementException mex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            return list;
        }
    }

    public String setConfigurationAttribute(Attribute attrib) throws JBIException {
        this.instanceRunningCheck();
        this.componentStartedOrStoppedOnTargetCheck();
        this.attributeCheck(attrib);
        String result = this.setConfigurationAttributeOnInstance(attrib, this.mInstanceName);
        return result;
    }

    public String setConfigurationAttributes(AttributeList attribList) throws JBIException {
        this.instanceRunningCheck();
        this.componentStartedOrStoppedOnTargetCheck();
        this.attributeCheck(attribList);
        ComponentConfiguration.ComponentConfigurationResponse result = this.setConfigurationAttributesOnInstance(attribList, this.mInstanceName);
        return result.getResponseMessage();
    }

    public boolean isAppVarsSupported() throws MBeanException {
        Boolean result = false;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            try {
                Document configDoc = this.getConfigDoc();
                result = this.mCfgHlpr.isAppVarsSupported(configDoc);
            }
            catch (ManagementException ex) {
                throw new MBeanException((Exception)((Object)new JBIException((Throwable)((Object)ex))));
            }
        }
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        MBeanInfo mbnInfo = this.getComponentMBeanInfo();
        if (mbnInfo != null) {
            MBeanAttributeInfo[] attrInfos;
            MBeanOperationInfo[] opInfos = mbnInfo.getOperations();
            int numOpsSupported = 0;
            for (MBeanOperationInfo opInfo : opInfos) {
                MBeanParameterInfo[] params;
                if (opInfo.getName().equals("addApplicationVariable")) {
                    params = opInfo.getSignature();
                    if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                    ++numOpsSupported;
                    continue;
                }
                if (opInfo.getName().equals("setApplicationVariable")) {
                    params = opInfo.getSignature();
                    if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                    ++numOpsSupported;
                    continue;
                }
                if (!opInfo.getName().equals("deleteApplicationVariable") || (params = opInfo.getSignature()).length != 1 || !params[0].getType().equals("java.lang.String")) continue;
                ++numOpsSupported;
            }
            boolean isAppVarsAttribSupported = false;
            for (MBeanAttributeInfo attrInfo : attrInfos = mbnInfo.getAttributes()) {
                if (!attrInfo.getName().equals("ApplicationVariables")) continue;
                isAppVarsAttribSupported = true;
            }
            result = numOpsSupported == 3 && isAppVarsAttribSupported;
        }
        return result;
    }

    public String addApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        String result;
        this.mLog.fine("Adding application variable " + name);
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppVarsCheck();
            this.applicationVariableExistsCheck(name, false);
            this.applicationVariableCompositeIntegrityCheck(name, null, appVar, false);
            result = this.addApplicationVariableToInstance(name, appVar, this.mInstanceName);
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public String setApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        String result;
        this.mLog.fine("Setting application variable " + name);
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppVarsCheck();
            String type = this.applicationVariableExistsCheck(name, true);
            this.applicationVariableCompositeIntegrityCheck(name, type, appVar, true);
            result = this.setApplicationVariableOnInstance(name, appVar, this.mInstanceName);
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public String deleteApplicationVariable(String name) throws MBeanException {
        String result;
        this.mLog.fine("Deleting application variable " + name);
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
            this.supportsAppVarsCheck();
            this.applicationVariableExistsCheck(name, true);
            result = this.deleteApplicationVariableFromInstance(name, this.mInstanceName);
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public TabularData getApplicationVariables() {
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (JBIException jbiex) {
            throw new RuntimeException(jbiex);
        }
        TabularData appVars = null;
        ObjectName configMBeanName = null;
        configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName);
        if (configMBeanName != null) {
            try {
                appVars = (TabularData)this.getRemoteAttribute(configMBeanName, "ApplicationVariables", this.mInstanceName);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        return appVars;
    }

    public boolean isComponentConfigSupported() throws MBeanException {
        Boolean result = false;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            try {
                Document configDoc = this.getConfigDoc();
                result = this.mCfgHlpr.isComponentConfigSupported(configDoc);
            }
            catch (ManagementException ex) {
                throw new MBeanException((Exception)((Object)new JBIException((Throwable)((Object)ex))));
            }
        }
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        MBeanInfo mbnInfo = this.getComponentMBeanInfo();
        if (mbnInfo != null) {
            MBeanAttributeInfo[] attrInfos = mbnInfo.getAttributes();
            int realAttrCount = 0;
            for (MBeanAttributeInfo attrInfo : attrInfos) {
                if ("ApplicationVariables".equals(attrInfo.getName()) || "ApplicationConfigurations".equals(attrInfo.getName()) || !attrInfo.isReadable() || !attrInfo.isWritable()) continue;
                ++realAttrCount;
            }
            result = realAttrCount > 0;
        }
        return result;
    }

    public boolean isAppConfigSupported() throws MBeanException {
        Boolean result = false;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            try {
                Document configDoc = this.getConfigDoc();
                result = this.mCfgHlpr.isAppConfigSupported(configDoc);
            }
            catch (ManagementException ex) {
                throw new MBeanException((Exception)((Object)new JBIException((Throwable)((Object)ex))));
            }
        }
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        MBeanInfo mbnInfo = this.getComponentMBeanInfo();
        if (mbnInfo != null) {
            MBeanAttributeInfo[] attrInfos;
            MBeanOperationInfo[] opInfos = mbnInfo.getOperations();
            int numOpsSupported = 0;
            for (MBeanOperationInfo opInfo : opInfos) {
                String returnType;
                MBeanParameterInfo[] params;
                if (opInfo.getName().equals("addApplicationConfiguration")) {
                    params = opInfo.getSignature();
                    if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                    ++numOpsSupported;
                    continue;
                }
                if (opInfo.getName().equals("setApplicationConfiguration")) {
                    params = opInfo.getSignature();
                    if (params.length != 2 || !params[0].getType().equals("java.lang.String") || !params[1].getType().equals("javax.management.openmbean.CompositeData")) continue;
                    ++numOpsSupported;
                    continue;
                }
                if (opInfo.getName().equals("deleteApplicationConfiguration")) {
                    params = opInfo.getSignature();
                    if (params.length != 1 || !params[0].getType().equals("java.lang.String")) continue;
                    ++numOpsSupported;
                    continue;
                }
                if (!opInfo.getName().equals("queryApplicationConfigurationType") || (params = opInfo.getSignature()).length != 0 || !(returnType = opInfo.getReturnType()).equals("javax.management.openmbean.CompositeType")) continue;
                ++numOpsSupported;
            }
            boolean isAppConfigAttribSupported = false;
            for (MBeanAttributeInfo attrInfo : attrInfos = mbnInfo.getAttributes()) {
                if (!attrInfo.getName().equals("ApplicationConfigurations")) continue;
                isAppConfigAttribSupported = true;
            }
            result = numOpsSupported == 4 && isAppConfigAttribSupported;
        }
        return result;
    }

    public CompositeType queryApplicationConfigurationType() {
        try {
            this.instanceRunningCheck();
        }
        catch (JBIException jbiex) {
            throw new RuntimeException(jbiex);
        }
        CompositeType appConfigType = null;
        ObjectName configMBeanName = null;
        configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName);
        if (configMBeanName != null) {
            try {
                appConfigType = (CompositeType)this.invokeRemoteOperation(configMBeanName, "queryApplicationConfigurationType", new Object[0], new String[0], this.mInstanceName);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        return appConfigType;
    }

    public String addApplicationConfiguration(String name, Properties appCfgProps) throws MBeanException {
        this.mLog.fine(" adding application configuration " + appCfgProps.toString() + " to component " + this.mComponentName);
        String responseMsg = null;
        try {
            this.instanceRunningCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appCfgProps, false);
            this.componentStartedOrStoppedOnTargetCheck();
            this.applicationConfigurationExistsCheck(name, false);
            CompositeType appCfgType = this.queryApplicationConfigurationType();
            if (appCfgType == null) {
                String errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_TYPE_NULL", this.mComponentName);
                throw new Exception(errMsg);
            }
            CompositeData cd = this.mCfgHlpr.convertPropertiesToCompositeData(appCfgProps, appCfgType);
            responseMsg = this.addApplicationConfigurationComposite(name, cd);
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        catch (Exception ex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("addApplicationConfiguration", ex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            }
        }
        return responseMsg;
    }

    public String addApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        String result;
        try {
            this.instanceRunningCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appConfig, false);
            this.componentStartedOrStoppedOnTargetCheck();
            this.applicationConfigurationExistsCheck(name, false);
            result = this.addApplicationConfigurationComposite(name, appConfig);
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public String deleteApplicationConfiguration(String name) throws MBeanException {
        String result;
        this.mLog.fine(" deleteing application configuration with name " + name);
        try {
            this.instanceRunningCheck();
            this.componentStartedOrStoppedOnTargetCheck();
            this.applicationConfigurationExistsCheck(name, true);
            result = this.deleteApplicationConfigurationFromInstance(name);
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public String setApplicationConfiguration(String name, Properties appCfgProps) throws MBeanException {
        this.mLog.fine(" setting application configuration " + appCfgProps.toString() + " on component " + this.mComponentName);
        String responseMsg = null;
        try {
            this.instanceRunningCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appCfgProps, true);
            this.componentStartedOrStoppedOnTargetCheck();
            this.applicationConfigurationExistsCheck(name, true);
            CompositeType appCfgType = this.queryApplicationConfigurationType();
            if (appCfgType == null) {
                String errMsg = this.mTranslator.getString("JBI_CCFG_APP_CFG_TYPE_NULL", this.mComponentName);
                throw new Exception(errMsg);
            }
            CompositeData cd = this.mCfgHlpr.convertPropertiesToCompositeData(appCfgProps, appCfgType);
            responseMsg = this.setApplicationConfigurationComposite(name, cd);
        }
        catch (Exception ex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("updateApplicationConfiguration", ex);
                throw new MBeanException((Exception)((Object)new JBIException(errMsg)));
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
            }
        }
        return responseMsg;
    }

    public String setApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        String result;
        try {
            this.instanceRunningCheck();
            this.applicationConfigurationCompositeIntegrityCheck(name, appConfig, true);
            this.componentStartedOrStoppedOnTargetCheck();
            this.applicationConfigurationExistsCheck(name, true);
            result = this.setApplicationConfigurationComposite(name, appConfig);
        }
        catch (JBIException jbiex) {
            throw new MBeanException((Exception)((Object)jbiex));
        }
        return result;
    }

    public TabularData getApplicationConfigurations() {
        try {
            this.instanceRunningCheck();
            this.canListAppConfigCheck();
        }
        catch (JBIException jbiex) {
            throw new RuntimeException(jbiex.getMessage());
        }
        TabularData appConfigs = null;
        ObjectName configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName);
        if (configMBeanName != null) {
            try {
                appConfigs = (TabularData)this.getRemoteAttribute(configMBeanName, "ApplicationConfigurations", this.mInstanceName);
            }
            catch (ManagementException mex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
                throw new RuntimeException(mex.getMessage());
            }
        }
        return appConfigs;
    }

    public String retrieveConfigurationDisplaySchema() throws MBeanException {
        String response = null;
        try {
            String ns = this.getComponentConfigurationNS(this.mComponentName);
            if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
                response = this.getComponentConfigurationSchema();
            } else {
                this.instanceRunningCheck();
                this.componentStartedOrStoppedOnTargetCheck();
                ObjectName configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName);
                if (configMBeanName != null) {
                    response = (String)this.invokeRemoteOperation(configMBeanName, "retrieveConfigurationDisplaySchema", new Object[0], new String[0], this.mInstanceName);
                }
            }
        }
        catch (JBIException jbiex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
            throw new MBeanException((Exception)((Object)jbiex));
        }
        catch (Exception ex) {
            try {
                String errMsg = this.mMsgBuilder.buildExceptionMessage("retrieveConfigurationDisplaySchema", ex);
                JBIException jbiEx = new JBIException(errMsg);
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
                throw new MBeanException((Exception)((Object)jbiEx));
            }
            catch (Exception exp) {
                this.mLog.fine(MessageHelper.getMsgString(exp));
                throw new MBeanException(ex);
            }
        }
        return response;
    }

    public String retrieveConfigurationDisplayData() throws MBeanException {
        String response = null;
        String ns = this.getComponentConfigurationNS(this.mComponentName);
        if ("http://www.sun.com/jbi/Configuration/V1.0".equals(ns)) {
            response = this.getComponentConfigurationData(this.mComponentName);
        } else {
            try {
                this.instanceRunningCheck();
                this.componentStartedOrStoppedOnTargetCheck();
                ObjectName configMBeanName = this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName);
                if (configMBeanName != null) {
                    response = (String)this.invokeRemoteOperation(configMBeanName, "retrieveConfigurationDisplayData", new Object[0], new String[0], this.mInstanceName);
                }
            }
            catch (JBIException jbiex) {
                this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiex)));
                throw new MBeanException((Exception)((Object)jbiex));
            }
            catch (Exception ex) {
                try {
                    String errMsg = this.mMsgBuilder.buildExceptionMessage("retrieveConfigurationDisplayData", ex);
                    JBIException jbiEx = new JBIException(errMsg);
                    this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
                    throw new MBeanException((Exception)((Object)jbiEx));
                }
                catch (Exception exp) {
                    this.mLog.fine(MessageHelper.getMsgString(exp));
                    throw new MBeanException(ex);
                }
            }
        }
        return response;
    }

    protected MBeanInfo getComponentMBeanInfo() {
        MBeanInfo mbeanInfo = null;
        boolean isInstanceUp = false;
        try {
            isInstanceUp = this.isInstanceRunning(this.mInstanceName);
        }
        catch (ManagementException mex) {
            this.mLog.fine(MessageHelper.getMsgString((Exception)((Object)mex)));
        }
        if (isInstanceUp) {
            try {
                ObjectName cfgMBeanName = this.getComponentConfigurationMBeanName();
                if (cfgMBeanName != null) {
                    mbeanInfo = this.getMBeanServerConnection(this.mInstanceName).getMBeanInfo(cfgMBeanName);
                }
            }
            catch (Exception ex) {
                this.mLog.fine(MessageHelper.getMsgString(ex));
            }
        }
        if (mbeanInfo == null) {
            mbeanInfo = new MBeanInfo(this.getClass().getName(), "Dynaic Component Configuration facade MBean", new MBeanAttributeInfo[0], new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
        }
        return mbeanInfo;
    }

    protected void attributeCheck(String attributeName) throws JBIException {
        boolean attribFound = false;
        boolean valueValid = false;
        if (this.isInstanceRunning(this.mInstanceName)) {
            MBeanAttributeInfo[] attribInfos = this.getMBeanInfo().getAttributes();
            if (attribInfos.length == 0) {
                String errMsg = this.mTranslator.getString("JBI_CCFG_NO_CONFIG_ATTRIBUTES", this.mComponentName);
                String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("attributeCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), new String[]{this.mComponentName}, MessageBuilder.getMessageToken(errMsg));
                throw new JBIException(jbiMsg);
            }
            for (MBeanAttributeInfo attribInfo : attribInfos) {
                if (!attribInfo.getName().equals(attributeName)) continue;
                return;
            }
            String errMsg = this.mTranslator.getString("JBI_CCFG_ATTRIBUTE_NOT_FOUND", attributeName, this.mComponentName);
            throw new JBIException(errMsg);
        }
    }

    private String addApplicationConfigurationComposite(String name, CompositeData appConfig) throws JBIException {
        String result = this.addApplicationConfigurationToInstance(name, appConfig);
        return result;
    }

    private String addApplicationConfigurationToInstance(String name, CompositeData appCfg) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(this.mInstanceName)) {
            this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName), "addApplicationConfiguration", new Object[]{name, appCfg}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"}, this.mInstanceName);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        } else {
            Object[] params = new String[]{this.mComponentName, this.mInstanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("addApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String setApplicationConfigurationComposite(String name, CompositeData appConfig) throws JBIException {
        String result = this.setApplicationConfigurationOnInstance(name, appConfig);
        return result;
    }

    private String setApplicationConfigurationOnInstance(String name, CompositeData appCfg) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(this.mInstanceName)) {
            this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName), "setApplicationConfiguration", new Object[]{name, appCfg}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"}, this.mInstanceName);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("setApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        } else {
            Object[] params = new String[]{this.mComponentName, this.mInstanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("setApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private String deleteApplicationConfigurationFromInstance(String name) throws ManagementException {
        String responseMsg = null;
        if (this.isInstanceRunning(this.mInstanceName)) {
            this.invokeRemoteOperation(this.getRemoteInstanceComponentConfigMBeanName(this.mInstanceName), "deleteApplicationConfiguration", new Object[]{name}, new String[]{"java.lang.String"}, this.mInstanceName);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationConfiguration", MessageBuilder.TaskResult.SUCCESS);
        } else {
            Object[] params = new String[]{this.mComponentName, this.mInstanceName};
            String errMsg = this.mTranslator.getString("JBI_CCFG_COMPONENT_INSTANCE_DOWN", params);
            responseMsg = this.mMsgBuilder.buildFrameworkMessage("deleteApplicationConfiguration", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        }
        return responseMsg;
    }

    private ObjectName getComponentConfigurationMBeanName() {
        ObjectName configMBeanName = null;
        try {
            ObjectName standardPattern = this.mEnvCtx.getMBeanNames().getCustomComponentMBeanNameFilter(this.mInstanceName, "Configuration", this.mComponentName);
            Set<ObjectName> names = this.getMBeanServerConnection(this.mInstanceName).queryNames(standardPattern, null);
            if (!names.isEmpty()) {
                if (names.size() > 1) {
                    this.mLog.finest("More than one MBean matches ObjectName pattern " + standardPattern + ".  " + this.convertToString(names));
                }
                configMBeanName = names.iterator().next();
            } else {
                ObjectName ebiPattern = null;
                ebiPattern = new ObjectName("com.sun.ebi:ServiceType=Configuration,IdentificationName=" + this.mComponentName + ",*");
                Set<ObjectName> ebiNames = this.getMBeanServerConnection(this.mInstanceName).queryNames(ebiPattern, null);
                if (!ebiNames.isEmpty()) {
                    if (ebiNames.size() > 1) {
                        this.mLog.finest("More than one MBean matches ObjectName pattern " + standardPattern + ".  " + this.convertToString(ebiNames));
                    }
                    configMBeanName = ebiNames.iterator().next();
                }
            }
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
        }
        return configMBeanName;
    }

    boolean isStandardCascadedConfigMBean(ObjectName mbnName) {
        return "com.sun.jbi".equals(mbnName.getDomain());
    }

    private void instanceRunningCheck() throws JBIException {
        super.instanceRunningCheck(this.mInstanceName);
    }
}

