/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ComponentExtensionMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.facade.Facade;
import com.sun.jbi.management.system.ManagementException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jbi.JBIException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentExtension
extends Facade
implements ComponentExtensionMBean {
    private String mComponentName;
    private ComponentType mComponentType;

    public ComponentExtension(EnvironmentContext ctx, String target, String compName, ComponentType compType) throws ManagementException {
        super(ctx, target);
        this.mComponentName = compName;
        this.mComponentType = compType;
    }

    @Override
    public ObjectName getComponentConfigurationFacadeMBeanName(String target) throws JBIException {
        ObjectName facadeCompCfgMBean = null;
        facadeCompCfgMBean = this.mComponentType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Configuration, target) : this.mMBeanNames.getEngineMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Configuration, target);
        return facadeCompCfgMBean;
    }

    @Override
    public Map<String, ObjectName[]> getCustomMBeanNames(String customName) throws JBIException {
        if (!this.mTarget.equals("domain")) {
            return this.getCustomMBeanNamesOnTarget(customName);
        }
        return this.getCustomMBeanNamesOnAllTargets(customName);
    }

    @Override
    public Map<String, ObjectName[]> getLoggerMBeanNames() throws JBIException {
        if (!this.mTarget.equals("domain")) {
            return this.getLoggerMBeanNamesOnTarget();
        }
        return this.getLoggerMBeanNamesOnAllTargets();
    }

    private Map<String, ObjectName[]> getCustomMBeanNamesOnTarget(String customName) throws JBIException {
        HashMap<String, ObjectName[]> objNames = new HashMap<String, ObjectName[]>();
        this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_GETTING_CUSTOM_MBEANS_FOR_COMPONENT", this.mComponentName, this.mTarget));
        if (this.mPlatform.isStandaloneServer(this.mTarget)) {
            objNames.put(this.mTarget, this.getCustomMBeanNamesOnInstance(this.mTarget, customName));
        } else {
            Set<String> instances = this.mPlatform.getServersInCluster(this.mTarget);
            for (String instance : instances) {
                objNames.put(instance, this.getCustomMBeanNamesOnInstance(instance, customName));
            }
        }
        return objNames;
    }

    private Map<String, ObjectName[]> getCustomMBeanNamesOnAllTargets(String customName) throws JBIException {
        List<String> targets = null;
        try {
            targets = this.getAllTargets();
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        HashMap<String, ObjectName[]> objNames = new HashMap<String, ObjectName[]>();
        for (String target : targets) {
            try {
                ObjectName facadeCompExtMBean = null;
                facadeCompExtMBean = this.mComponentType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Extension, target) : this.mMBeanNames.getEngineMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Extension, target);
                Map targetObjNames = (Map)this.mMBeanSvr.invoke(facadeCompExtMBean, "getCustomMBeanNames", new Object[]{customName}, new String[]{"java.lang.String"});
                objNames.putAll(targetObjNames);
            }
            catch (Exception ex) {}
        }
        this.mLog.finer("The custom MBeans for component  " + this.mComponentName + " on targets " + targets.toString() + " are " + ((Object)objNames).toString());
        return objNames;
    }

    private ObjectName[] getCustomMBeanNamesOnInstance(String instanceName, String customName) {
        ObjectName customMBeanFilter = this.mMBeanNames.getCustomComponentMBeanNameFilter(instanceName, customName, this.mComponentName);
        Set<ObjectName> nameSet = this.mMBeanSvr.queryNames(customMBeanFilter, null);
        return nameSet.toArray(new ObjectName[nameSet.size()]);
    }

    private Map<String, ObjectName[]> getLoggerMBeanNamesOnTarget() throws JBIException {
        HashMap<String, ObjectName[]> objNames = new HashMap<String, ObjectName[]>();
        if (this.mPlatform.isStandaloneServer(this.mTarget)) {
            objNames.put(this.mTarget, this.getLoggerMBeanNamesOnInstance(this.mTarget));
        } else {
            Set<String> instances = this.mPlatform.getServersInCluster(this.mTarget);
            for (String instance : instances) {
                objNames.put(instance, this.getLoggerMBeanNamesOnInstance(instance));
            }
        }
        return objNames;
    }

    private Map<String, ObjectName[]> getLoggerMBeanNamesOnAllTargets() throws JBIException {
        List<String> targets = null;
        try {
            targets = this.getAllTargets();
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
        HashMap<String, ObjectName[]> objNames = new HashMap<String, ObjectName[]>();
        for (String target : targets) {
            try {
                ObjectName facadeCompExtMBean = null;
                facadeCompExtMBean = this.mComponentType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Extension, target) : this.mMBeanNames.getEngineMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.Extension, target);
                Map targetObjNames = (Map)this.mMBeanSvr.invoke(facadeCompExtMBean, "getLoggerMBeanNames", new Object[0], new String[0]);
                objNames.putAll(targetObjNames);
            }
            catch (Exception ex) {}
        }
        this.mLog.finer("The Logger MBeans for component  " + this.mComponentName + " on targets " + targets.toString() + " are " + ((Object)objNames).toString());
        return objNames;
    }

    private ObjectName[] getLoggerMBeanNamesOnInstance(String instanceName) {
        ObjectName loggerMBeanFilter = this.mMBeanNames.getComponentLoggerMBeanNameFilter(instanceName, this.mComponentName);
        Set<ObjectName> nameSet = this.mMBeanSvr.queryNames(loggerMBeanFilter, null);
        return nameSet.toArray(new ObjectName[nameSet.size()]);
    }
}

