/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ComponentLifeCycleMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.facade.Facade;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.system.ManagementException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jbi.JBIException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentLifeCycle
extends Facade
implements ComponentLifeCycleMBean {
    private String mComponentName;
    private ComponentType mComponentType;
    private Map<String, ObjectName> mInstanceComponentLCMBeans;

    public ComponentLifeCycle(EnvironmentContext ctx, String target, String compName, ComponentType compType, Map<String, ObjectName> compLCMBeans) throws ManagementException {
        super(ctx, target);
        this.mComponentName = compName;
        this.mComponentType = compType;
        this.mInstanceComponentLCMBeans = compLCMBeans;
    }

    public void start() throws JBIException {
        try {
            if (!this.mTarget.equals("domain")) {
                if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                    this.startComponentOnInstance(this.mTarget);
                } else {
                    this.startComponentOnCluster(this.mTarget);
                }
                this.setDesiredState(this.mComponentName, ComponentState.STARTED, this.mTarget);
            } else {
                this.throwNotSupportedManagementException("start");
            }
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    public void stop() throws JBIException {
        try {
            if (!this.mTarget.equals("domain")) {
                if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                    this.stopComponentOnInstance(this.mTarget);
                } else {
                    this.stopComponentOnCluster(this.mTarget);
                }
                this.setDesiredState(this.mComponentName, ComponentState.STOPPED, this.mTarget);
            } else {
                this.throwNotSupportedManagementException("stop");
            }
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    public void shutDown() throws JBIException {
        this.shutDown(false);
    }

    public String getCurrentState() {
        if (!this.mTarget.equals("domain")) {
            return this.getCurrentStateOnTarget();
        }
        return this.getCurrentStateOnAllTargets();
    }

    public ObjectName getExtensionMBeanName() throws JBIException {
        try {
            if (!this.mTarget.equals("domain")) {
                return this.getExtensionMBeanNameForTarget();
            }
            try {
                return new ObjectName("com.sun.jbi:Target=domain");
            }
            catch (Exception ex) {
                String msg = this.mMsgBuilder.buildExceptionMessage("getExtensionMBeanName", ex);
                throw new JBIException(msg);
            }
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    @Override
    public void shutDown(boolean force) throws JBIException {
        try {
            if (!this.mTarget.equals("domain")) {
                if (this.mPlatform.isStandaloneServer(this.mTarget)) {
                    this.shutDownComponentOnInstance(this.mTarget, force);
                } else {
                    this.shutdownComponentOnCluster(this.mTarget, force);
                }
                this.setDesiredState(this.mComponentName, ComponentState.SHUTDOWN, this.mTarget);
            } else {
                this.throwNotSupportedManagementException("shutDown");
            }
        }
        catch (ManagementException mex) {
            throw new JBIException(mex.getMessage());
        }
    }

    private void setDesiredState(String compName, ComponentState state, String target) throws ManagementException {
        try {
            this.getUpdater().setComponentState(target, state, compName);
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("setDesiredState", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    private String getCurrentStateOnTarget() {
        String state = "Unknown";
        this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_GETTING_COMPONENT_STATE_ON_TARGET", this.mComponentName, this.mTarget));
        try {
            state = this.mPlatform.isStandaloneServer(this.mTarget) ? this.getCurrentStateOnInstance(this.mTarget) : this.getCurrentStateOnCluster(this.mTarget);
        }
        catch (ManagementException mex) {
            throw new RuntimeException(new JBIException(mex.getMessage()));
        }
        return state;
    }

    private String getCurrentStateOnInstance(String instanceName) throws ManagementException {
        return this.getComponentStateOnInstance(this.mComponentName, instanceName);
    }

    private String getCurrentStateOnCluster(String clusterName) throws ManagementException {
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        ArrayList<ComponentState> states = new ArrayList<ComponentState>();
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    String state = this.getCurrentStateOnInstance(instance);
                    states.add(ComponentState.valueOfLifeCycleState(state));
                }
                catch (ManagementException mex) {
                    exceptionMap.put(instance, (Throwable)((Object)mex));
                }
            }
            try {
                if (exceptionMap.size() > 0) {
                    this.handleClusteredInstanceFailures("getCurrentState", exceptionMap, instances.size(), "JBI_ADMIN_FAILED_START_COMPONENT_ON_INSTANCE");
                }
            }
            catch (ManagementException mex) {
                throw new RuntimeException(mex.getMessage());
            }
        }
        this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_COMPONENT_STATES_ON_CLUSTER", this.mComponentName, clusterName, ((Object)states).toString()));
        ComponentState effState = ComponentState.computeEffectiveState(states);
        return ComponentState.getLifeCycleState(effState);
    }

    private ObjectName getExtensionMBeanNameForTarget() throws ManagementException {
        ObjectName objName = null;
        if (this.mPlatform.isStandaloneServer(this.mTarget)) {
            objName = this.getExtensionMBeanNameForInstance(this.mTarget);
        }
        return objName;
    }

    private ObjectName getExtensionMBeanNameForInstance(String instanceName) throws ManagementException {
        Object extMBean = null;
        if (this.isInstanceRunning(instanceName)) {
            String[] sign = new String[]{};
            Object[] params = new Object[]{};
            return (ObjectName)this.invokeRemoteOperation(this.getComponentLifeCycleMBeanName(this.mComponentName, this.mComponentType, instanceName), "getExtensionMBeanName", params, sign, instanceName);
        }
        Object[] params = new String[]{instanceName};
        String errMsg = this.mTranslator.getString("JBI_ADMIN_INSTANCE_DOWN", params);
        String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("getExtensionMBeanName", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
        throw new ManagementException(jbiTaskMsg);
    }

    private void shutDownComponentOnInstance(String instanceName, boolean force) throws ManagementException {
        this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_CHANGING_COMPONENT_STATE_ON_INSTANCE", "shutDown", this.mComponentName, instanceName));
        if (this.isInstanceRunning(instanceName)) {
            Object[] params;
            String[] sign;
            if (force) {
                sign = new String[]{"boolean"};
                params = new Object[]{new Boolean(force)};
            } else {
                sign = new String[]{};
                params = new Object[]{};
            }
            this.invokeRemoteVoidOperation(this.getComponentLifeCycleMBeanName(this.mComponentName, this.mComponentType, instanceName), "shutDown", params, sign, instanceName);
        }
    }

    private void startComponentOnInstance(String instanceName) throws ManagementException {
        this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_CHANGING_COMPONENT_STATE_ON_INSTANCE", "start", this.mComponentName, instanceName));
        if (this.isInstanceRunning(instanceName)) {
            String[] sign = new String[]{};
            Object[] params = new Object[]{};
            this.invokeRemoteVoidOperation(this.getComponentLifeCycleMBeanName(this.mComponentName, this.mComponentType, instanceName), "start", params, sign, instanceName);
        }
    }

    private void stopComponentOnInstance(String instanceName) throws ManagementException {
        this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_CHANGING_COMPONENT_STATE_ON_INSTANCE", "stop", this.mComponentName, instanceName));
        if (this.isInstanceRunning(instanceName)) {
            String[] sign = new String[]{};
            Object[] params = new Object[]{};
            this.invokeRemoteVoidOperation(this.getComponentLifeCycleMBeanName(this.mComponentName, this.mComponentType, instanceName), "stop", params, sign, instanceName);
        }
    }

    private void startComponentOnCluster(String clusterName) throws JBIException {
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    this.startComponentOnInstance(instance);
                }
                catch (JBIException jex) {
                    exceptionMap.put(instance, jex);
                }
            }
            if (exceptionMap.size() > 0) {
                try {
                    this.handleClusteredInstanceFailures("start", exceptionMap, instances.size(), "JBI_ADMIN_FAILED_START_COMPONENT_ON_INSTANCE");
                }
                catch (ManagementException mex) {
                    throw new RuntimeException(mex.getMessage());
                }
            }
        }
    }

    private void stopComponentOnCluster(String clusterName) throws JBIException {
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            String currState;
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    this.stopComponentOnInstance(instance);
                }
                catch (JBIException jex) {
                    exceptionMap.put(instance, jex);
                }
            }
            if (exceptionMap.size() > 0 && ComponentState.STOPPED != ComponentState.valueOfLifeCycleState(currState = this.getCurrentState())) {
                try {
                    this.handleClusteredInstanceFailures("stop", exceptionMap, exceptionMap.size(), "JBI_ADMIN_FAILED_STOP_COMPONENT_ON_INSTANCE");
                }
                catch (ManagementException mex) {
                    throw new RuntimeException(mex.getMessage());
                }
            }
        }
    }

    private void shutdownComponentOnCluster(String clusterName, boolean force) throws JBIException {
        Set<String> instances = this.mPlatform.getServersInCluster(clusterName);
        if (!instances.isEmpty()) {
            String currState;
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            for (String instance : instances) {
                try {
                    this.shutDownComponentOnInstance(instance, force);
                }
                catch (JBIException jex) {
                    exceptionMap.put(instance, jex);
                }
            }
            if (exceptionMap.size() > 0 && ComponentState.SHUTDOWN != ComponentState.valueOfLifeCycleState(currState = this.getCurrentState())) {
                try {
                    this.handleClusteredInstanceFailures("shutDown", exceptionMap, exceptionMap.size(), "JBI_ADMIN_FAILED_SHUTDOWN_COMPONENT_ON_INSTANCE");
                }
                catch (ManagementException mex) {
                    throw new RuntimeException(mex.getMessage());
                }
            }
        }
    }

    private ObjectName getComponentLifeCycleMBean(String instanceName) {
        ObjectName compLCMBean = this.mInstanceComponentLCMBeans.get(instanceName);
        boolean isInstanceRunning = false;
        try {
            isInstanceRunning = this.isInstanceRunning(instanceName);
        }
        catch (Exception ex) {
            this.mLog.fine(MessageHelper.getMsgString(ex));
        }
        if (compLCMBean == null && isInstanceRunning) {
            MBeanNames mbnNames = this.mMgtCtx.getMBeanNames(instanceName);
            compLCMBean = ComponentType.BINDING == this.mComponentType ? mbnNames.getBindingMBeanName(this.mComponentName, "Lifecycle") : mbnNames.getEngineMBeanName(this.mComponentName, "Lifecycle");
        }
        return compLCMBean;
    }

    private boolean canPerformOperationOnInstanceCheck(String instanceName, String taskId) {
        ObjectName compLC;
        boolean canDo = true;
        try {
            compLC = this.getComponentLifeCycleMBeanName(this.mComponentName, this.mComponentType, instanceName);
        }
        catch (ManagementException mex) {
            compLC = null;
        }
        if (compLC == null) {
            String warning = this.mTranslator.getString("JBI_ADMIN_CANNOT_PERFORM_COMPONENT_LIFECYCLE_OP", taskId, this.mComponentName, instanceName);
            canDo = false;
        }
        return canDo;
    }

    private String getCurrentStateOnAllTargets() {
        List<String> targets = null;
        try {
            targets = this.getAllTargets();
        }
        catch (ManagementException mex) {
            throw new RuntimeException(mex.getMessage());
        }
        ArrayList<ComponentState> states = new ArrayList<ComponentState>();
        for (String target : targets) {
            try {
                ObjectName facadeCompLCMBean = null;
                facadeCompLCMBean = this.mComponentType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.ComponentLifeCycle, target) : this.mMBeanNames.getEngineMBeanName(this.mComponentName, MBeanNames.ComponentServiceType.ComponentLifeCycle, target);
                String state = (String)this.mMBeanSvr.getAttribute(facadeCompLCMBean, "CurrentState");
                states.add(ComponentState.valueOfLifeCycleState(state));
                this.mLog.finest("The state of component " + this.mComponentName + " on target " + target + " is " + state);
            }
            catch (Exception ex) {
                states.add(ComponentState.UNKNOWN);
            }
        }
        this.mLog.finest("The state of component  " + this.mComponentName + " on targets " + targets.toString() + " is " + states);
        ComponentState effState = ComponentState.computeEffectiveState(states);
        return ComponentState.getLifeCycleState(effState);
    }
}

