/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.esb.eventmanagement.impl.EventForwarderMBean;
import com.sun.esb.eventmanagement.impl.EventManagementControllerMBean;
import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.api.performance.PerformanceMeasurementService;
import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.esb.management.impl.notification.NotificationServiceMBeanImpl;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.AdminServiceMBean;
import com.sun.jbi.management.ComponentExtensionMBean;
import com.sun.jbi.management.ComponentLifeCycleMBean;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.DeploymentServiceMBean;
import com.sun.jbi.management.EventNotifierMBean;
import com.sun.jbi.management.InstallationServiceMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.facade.AdminService;
import com.sun.jbi.management.facade.ClusterInstanceComponentConfiguration;
import com.sun.jbi.management.facade.ComponentConfiguration;
import com.sun.jbi.management.facade.ComponentExtension;
import com.sun.jbi.management.facade.ComponentLifeCycle;
import com.sun.jbi.management.facade.DeploymentService;
import com.sun.jbi.management.facade.EventNotifier;
import com.sun.jbi.management.facade.InstallationService;
import com.sun.jbi.management.facade.RuntimeConfiguration;
import com.sun.jbi.management.internal.support.AntScriptRunner;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveDownload;
import com.sun.jbi.management.repository.ArchiveDownloadMBean;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.ArchiveUpload;
import com.sun.jbi.management.repository.ArchiveUploadMBean;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.util.FacadeMbeanHelper;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.platform.PlatformEventListener;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.runtime.mbeans.JBIAdminCommandsUIMBean;
import com.sun.jbi.ui.runtime.mbeans.JBIStatisticsMBean;
import com.sun.jbi.ui.runtime.mbeans.UIMBeanFactory;
import com.sun.jbi.util.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.modelmbean.ModelMBeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementRuntimeService
implements ServiceLifecycle,
PlatformEventListener,
Constants {
    private static final String ESB_UPLOAD_MBEAN_NAME = "com.sun.jbi.esb:ServiceType=ArchiveUpload";
    private EnvironmentContext mEnvCtx;
    private MBeanServer mMBeanSvr;
    private Logger mLog = Logger.getLogger("com.sun.jbi.management");
    private MBeanNames mMBeanNames;
    private ManagementContext mMgtCtx;
    private StringTranslator mTranslator;
    private PlatformContext mPlatform;
    private EventNotifier mNotifier;
    private Set<MBeanNames.ServiceType> mConfigSvcTypes;
    private Properties mDefaults;
    private static final String DEFAULT_CONFIG_FILE = "runtime-config.defaults";

    @Override
    public void initService(EnvironmentContext aContext) throws JBIException {
        this.mLog.finest("Initializing Management Runtime Service.");
        this.mEnvCtx = aContext;
        this.mMgtCtx = new ManagementContext(this.mEnvCtx);
        this.mPlatform = this.mEnvCtx.getPlatformContext();
        this.mMBeanSvr = this.mEnvCtx.getMBeanServer();
        this.mMBeanNames = this.mEnvCtx.getMBeanNames();
        this.mTranslator = this.mEnvCtx.getStringTranslator("com.sun.jbi.management.facade");
        this.mLog.finest(" This is target " + this.mPlatform.getTargetName());
        this.mPlatform.addListener(this);
        try {
            if (this.mPlatform.isAdminServer()) {
                this.registerUploadDownloadMBeans("domain");
                this.registerDomainFacadeMBeans();
                this.registerInstanceFacadeMBeans();
                this.registerClusterFacadeMBeans();
                this.registerJavaCAPSManagementServiceMBeans();
                this.registerJbiAdminUiMBeans();
                this.createClientConfigFiles();
                this.registerEventManagementControllerMbean();
                this.registerEventManagementForwarderMbean();
            } else {
                this.registerUploadDownloadMBeans(this.mPlatform.getInstanceName());
                this.registerEventManagementForwarderMbean();
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    @Override
    public void startService() throws JBIException {
        this.mLog.finest("Starting Management Runtime Service.");
        this.updateRegistry();
        try {
            if (this.mPlatform.isAdminServer()) {
                this.registerComponentFacadeMBeans();
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    @Override
    public void stopService() throws JBIException {
        this.mLog.finest("Stopping Management Runtime Service.");
        try {
            if (this.mPlatform.isAdminServer()) {
                this.mNotifier.stop();
                this.unregisterJbiAdminUiMBeans();
                this.unregisterJavaCAPSManagementServiceMBeans();
                this.unregisterClusterFacadeMBeans();
                this.unregisterInstanceFacadeMBeans();
                this.unregisterDomainFacadeMBeans();
                this.unregisterUploadDownloadMBeans("domain");
                this.unregisterEventManagementForwarderMbean();
                this.unregisterEventManagementControllerMbean();
            } else {
                this.unregisterUploadDownloadMBeans(this.mPlatform.getInstanceName());
                this.unregisterEventManagementForwarderMbean();
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void registerDomainFacadeMBeans() throws Exception {
        String domain = "domain";
        this.mLog.finest("Loading Facade MBeans");
        InstallationService instSvc = new InstallationService(this.mEnvCtx, domain);
        DeploymentService dplySvc = new DeploymentService(this.mEnvCtx, domain);
        AdminService adminSvc = new AdminService(this.mEnvCtx, domain);
        StandardMBean instStd = new StandardMBean(instSvc, InstallationServiceMBean.class);
        StandardMBean dplyStd = new StandardMBean(dplySvc, DeploymentServiceMBean.class);
        StandardMBean adminStd = new StandardMBean(adminSvc, AdminServiceMBean.class);
        this.mMBeanSvr.registerMBean(adminStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, domain));
        this.mMBeanSvr.registerMBean(instStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, domain));
        this.mMBeanSvr.registerMBean(dplyStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, domain));
        EventNotifier notifier = new EventNotifier(this.mEnvCtx, domain);
        StandardMBean notifierStd = new StandardMBean(notifier, EventNotifierMBean.class);
        this.mMBeanSvr.registerMBean(notifierStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.Framework, MBeanNames.ServiceType.Notification, domain));
        this.mNotifier = notifier;
        this.mNotifier.start();
        this.registerRuntimeConfigFacadeMBeansForTarget(domain);
    }

    private void registerUploadDownloadMBeans(String target) throws Exception {
        this.mLog.finest("Loading Upload / Download MBeans");
        ArchiveUpload uploadSvc = new ArchiveUpload(this.mMgtCtx);
        ArchiveDownload downloadSvc = new ArchiveDownload(this.mMgtCtx);
        StandardMBean uploadStd = new StandardMBean(uploadSvc, ArchiveUploadMBean.class);
        StandardMBean downloadStd = new StandardMBean(downloadSvc, ArchiveDownloadMBean.class);
        this.mMBeanSvr.registerMBean(uploadStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Upload, target));
        this.mMBeanSvr.registerMBean(downloadStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Download, target));
    }

    private void registerInstanceFacadeMBeans() throws Exception {
        this.mLog.finest("Loading Instance Facade MBeans");
        Set<String> instances = this.mPlatform.getStandaloneServerNames();
        for (String instance : instances) {
            this.registerFacadeMBeansForTarget(instance);
        }
    }

    private void registerClusterFacadeMBeans() throws Exception {
        if (this.mPlatform.supportsMultipleServers()) {
            this.mLog.finest("Loading Cluster Facade MBeans");
            Set<String> clusters = this.mPlatform.getClusterNames();
            for (String cluster : clusters) {
                this.registerFacadeMBeansForTarget(cluster);
            }
        }
    }

    private void registerComponentFacadeMBeans() throws Exception {
        this.registerComponentLifeCycleFacadeMBeansForTarget("domain");
        this.registerComponentExtensionFacadeMBeansForTarget("domain");
        this.mLog.finest("Loading Instance ComponentLifeCycle Facade MBeans");
        for (String target : this.mPlatform.getStandaloneServerNames()) {
            this.registerComponentLifeCycleFacadeMBeansForTarget(target);
            this.registerComponentExtensionFacadeMBeansForTarget(target);
            this.registerComponentConfigurationFacadeMBeansForTarget(target);
        }
        if (!this.mPlatform.isAdminServer() || this.mPlatform.supportsMultipleServers()) {
            this.mLog.finest("Loading Cluster ComponentLifecycle Facade MBeans");
            for (String target : this.mPlatform.getClusterNames()) {
                this.registerComponentLifeCycleFacadeMBeansForTarget(target);
                this.registerComponentExtensionFacadeMBeansForTarget(target);
                this.registerComponentConfigurationFacadeMBeansForTarget(target);
                Set<String> clusterInstances = this.mPlatform.getServersInCluster(target);
                for (String clusterInstance : clusterInstances) {
                    this.registerComponentConfigurationFacadeMBeansForClusterInstance(clusterInstance);
                }
            }
        }
    }

    private void registerFacadeMBeansForTarget(String target) throws Exception {
        ObjectName adminSvcObjName = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, target);
        ObjectName instSvcObjName = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, target);
        ObjectName dplySvcObjName = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, target);
        if (!this.mMBeanSvr.isRegistered(adminSvcObjName)) {
            AdminService adminSvc = new AdminService(this.mEnvCtx, target);
            StandardMBean adminStd = new StandardMBean(adminSvc, AdminServiceMBean.class);
            this.mMBeanSvr.registerMBean(adminStd, adminSvcObjName);
        }
        if (!this.mMBeanSvr.isRegistered(instSvcObjName)) {
            InstallationService instSvc = new InstallationService(this.mEnvCtx, target);
            StandardMBean instStd = new StandardMBean(instSvc, InstallationServiceMBean.class);
            this.mMBeanSvr.registerMBean(instStd, instSvcObjName);
        }
        if (!this.mMBeanSvr.isRegistered(dplySvcObjName)) {
            DeploymentService dplySvc = new DeploymentService(this.mEnvCtx, target);
            StandardMBean dplyStd = new StandardMBean(dplySvc, DeploymentServiceMBean.class);
            this.mMBeanSvr.registerMBean(dplyStd, dplySvcObjName);
        }
        this.registerRuntimeConfigFacadeMBeansForTarget(target);
    }

    private void unregisterDomainFacadeMBeans() throws Exception {
        String domain = "domain";
        this.mLog.finest("Unloading domain facade MBeans");
        this.unregisterComponentLifeCycleFacadeMBeansForTarget(domain);
        this.unregisterComponentExtensionFacadeMBeansForTarget(domain);
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, domain));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, domain));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, domain));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.Framework, MBeanNames.ServiceType.Notification, domain));
        this.unregisterRuntimeConfigFacadeMBeansForTarget(domain);
    }

    private void unregisterUploadDownloadMBeans(String target) throws Exception {
        this.mLog.finest("Unloading Upload / Download MBeans");
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Upload, target));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Download, target));
    }

    private void unregisterInstanceFacadeMBeans() throws Exception {
        this.mLog.finest("Unloading instance facade MBeans");
        Set<String> instances = this.mPlatform.getStandaloneServerNames();
        for (String instance : instances) {
            this.unregisterFacadeMBeansForTarget(instance);
        }
    }

    private void unregisterClusterFacadeMBeans() throws Exception {
        if (this.mPlatform.supportsMultipleServers()) {
            this.mLog.finest("Unloading cluster facade MBeans");
            Set<String> clusters = this.mPlatform.getClusterNames();
            for (String cluster : clusters) {
                this.unregisterFacadeMBeansForTarget(cluster);
            }
        }
    }

    private void unregisterFacadeMBeansForTarget(String target) throws Exception {
        this.unregisterComponentLifeCycleFacadeMBeansForTarget(target);
        this.unregisterComponentExtensionFacadeMBeansForTarget(target);
        this.unregisterComponentConfigurationFacadeMBeansForTarget(target);
        if (this.mPlatform.isCluster(target)) {
            Set<String> clusterInstances = this.mPlatform.getServersInCluster(target);
            for (String clusterInstance : clusterInstances) {
                this.unregisterComponentConfigurationFacadeMBeansForClusterInstance(clusterInstance);
            }
        }
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, target));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, target));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, target));
        this.unregisterRuntimeConfigFacadeMBeansForTarget(target);
    }

    private void registerJbiAdminUiMBeans() throws JBIException {
        try {
            JBIAdminCommandsUIMBean jbiAdminCommandsUIMBeanImpl = this.createJBIAdminCommandsUIMBean(this.mEnvCtx);
            StandardMBean mbean = new StandardMBean(jbiAdminCommandsUIMBeanImpl, JBIAdminCommandsUIMBean.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
            JBIStatisticsMBean jbiStatisticsMBeanImpl = this.createJBIStatisticsMBean(this.mEnvCtx);
            StandardMBean statisticsMBean = new StandardMBean(jbiStatisticsMBeanImpl, JBIStatisticsMBean.class);
            this.mMBeanSvr.registerMBean(statisticsMBean, JBIJMXObjectNames.getJbiStatisticsMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void registerJavaCAPSManagementServiceMBeans() throws JBIException {
        StandardMBean mbean = null;
        try {
            AdministrationService administrationServiceMBeanImpl = this.createJavaCAPSAdministrationServiceMBean(this.mEnvCtx);
            mbean = new StandardMBean(administrationServiceMBeanImpl, AdministrationService.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsAdministrationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            ConfigurationService configurationServiceMBeanImpl = this.createJavaCAPSConfigurationServiceMBean(this.mEnvCtx);
            mbean = new StandardMBean(configurationServiceMBeanImpl, ConfigurationService.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsConfigurationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            com.sun.esb.management.api.deployment.DeploymentService deploymentServiceMBeanImpl = this.createJavaCAPSDeploymentServiceMBean(this.mEnvCtx);
            mbean = new StandardMBean(deploymentServiceMBeanImpl, com.sun.esb.management.api.deployment.DeploymentService.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsDeploymentServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            com.sun.esb.management.api.installation.InstallationService installationServiceMBeanImpl = this.createJavaCAPSInstallationServiceMBean(this.mEnvCtx);
            mbean = new StandardMBean(installationServiceMBeanImpl, com.sun.esb.management.api.installation.InstallationService.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsInstallationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            RuntimeManagementService runtimeManagementServiceMBeanImpl = this.createJavaCAPSRuntimeManagementServiceMBean(this.mEnvCtx);
            mbean = new StandardMBean(runtimeManagementServiceMBeanImpl, RuntimeManagementService.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsRuntimeManagementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            PerformanceMeasurementService performanceMeasurementServiceMBeanImpl = this.createJavaCAPSPerformanceMeasurementServiceMBean(this.mEnvCtx);
            mbean = new StandardMBean(performanceMeasurementServiceMBeanImpl, PerformanceMeasurementService.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsPerformanceMeasurementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            NotificationServiceMBeanImpl notificationService = new NotificationServiceMBeanImpl(this.mEnvCtx);
            this.mMBeanSvr.registerMBean(notificationService, JBIJMXObjectNames.getJavaCapsNotificationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void unregisterJavaCAPSManagementServiceMBeans() throws JBIException {
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJavaCapsAdministrationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJavaCapsConfigurationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJavaCapsDeploymentServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJavaCapsInstallationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJavaCapsRuntimeManagementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJavaCapsPerformanceMeasurementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJavaCapsNotificationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void unregisterJbiAdminUiMBeans() throws JBIException {
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJbiStatisticsMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    protected AdministrationService createJavaCAPSAdministrationServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSAdministrationServiceMBean(aContext);
    }

    protected ConfigurationService createJavaCAPSConfigurationServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSConfigurationServiceMBean(aContext);
    }

    protected com.sun.esb.management.api.deployment.DeploymentService createJavaCAPSDeploymentServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSDeploymentServiceMBean(aContext);
    }

    protected com.sun.esb.management.api.installation.InstallationService createJavaCAPSInstallationServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSInstallationServiceMBean(aContext);
    }

    protected RuntimeManagementService createJavaCAPSRuntimeManagementServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSRuntimeManagementServiceMBean(aContext);
    }

    protected PerformanceMeasurementService createJavaCAPSPerformanceMeasurementServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSPerformanceMeasurementServiceMBean(aContext);
    }

    protected JBIAdminCommandsUIMBean createJBIAdminCommandsUIMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJBIAdminCommandsUIMBean(aContext);
    }

    protected JBIStatisticsMBean createJBIStatisticsMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJBIStatisticsMBean(aContext);
    }

    @Override
    public void createdInstance(String instanceName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                if (this.mPlatform.isStandaloneServer(instanceName)) {
                    this.getRegistry().getUpdater().addServer(instanceName);
                    this.addSystemComponents(instanceName);
                    this.registerFacadeMBeansForTarget(instanceName);
                    this.registerComponentLifeCycleFacadeMBeansForTarget(instanceName);
                    this.registerComponentExtensionFacadeMBeansForTarget(instanceName);
                    this.registerComponentConfigurationFacadeMBeansForTarget(instanceName);
                } else if (this.mPlatform.isClusteredServer(instanceName)) {
                    this.registerComponentConfigurationFacadeMBeansForClusterInstance(instanceName);
                }
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_CREATE_INSTANCE_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    @Override
    public void deletedInstance(String instanceName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                List<String> servers = this.getRegistry().getGenericQuery().getServers();
                if (servers.contains(instanceName)) {
                    this.unregisterFacadeMBeansForTarget(instanceName);
                    this.unregisterComponentLifeCycleFacadeMBeansForTarget(instanceName);
                    this.unregisterComponentExtensionFacadeMBeansForTarget(instanceName);
                    this.unregisterComponentConfigurationFacadeMBeansForTarget(instanceName);
                    this.getRegistry().getUpdater().removeServer(instanceName);
                } else {
                    this.unregisterComponentConfigurationFacadeMBeansForClusterInstance(instanceName);
                }
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_DELETE_INSTANCE_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    @Override
    public void createdCluster(String clusterName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                this.getRegistry().getUpdater().addCluster(clusterName);
                this.addSystemComponents(clusterName);
                this.registerFacadeMBeansForTarget(clusterName);
                this.registerComponentLifeCycleFacadeMBeansForTarget(clusterName);
                this.registerComponentExtensionFacadeMBeansForTarget(clusterName);
                this.registerComponentConfigurationFacadeMBeansForTarget(clusterName);
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_CREATE_CLUSTER_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    @Override
    public void deletedCluster(String clusterName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                this.unregisterFacadeMBeansForTarget(clusterName);
                this.unregisterComponentLifeCycleFacadeMBeansForTarget(clusterName);
                this.unregisterComponentExtensionFacadeMBeansForTarget(clusterName);
                this.unregisterComponentConfigurationFacadeMBeansForTarget(clusterName);
                this.getRegistry().getUpdater().removeCluster(clusterName);
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_DELETE_CLUSTER_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    private void updateRegistry() throws JBIException {
        try {
            if (this.mPlatform.isAdminServer()) {
                Set<String> asServers = this.mPlatform.getStandaloneServerNames();
                List<String> regServers = this.getRegistry().getGenericQuery().getServers();
                for (String asServer : asServers) {
                    if (regServers.contains(asServer)) continue;
                    this.getRegistry().getUpdater().addServer(asServer);
                    this.addSystemComponents(asServer);
                    this.registerFacadeMBeansForTarget(asServer);
                }
                for (String regServer : regServers) {
                    if (asServers.contains(regServer)) continue;
                    this.getRegistry().getUpdater().removeServer(regServer);
                    this.unregisterFacadeMBeansForTarget(regServer);
                }
                Set<String> asClusters = this.mPlatform.getClusterNames();
                List<String> regClusters = this.getRegistry().getGenericQuery().getClusters();
                for (String asCluster : asClusters) {
                    if (regClusters.contains(asCluster)) continue;
                    this.getRegistry().getUpdater().addCluster(asCluster);
                    this.addSystemComponents(asCluster);
                    this.registerFacadeMBeansForTarget(asCluster);
                }
                for (String regCluster : regClusters) {
                    if (asClusters.contains(regCluster)) continue;
                    this.getRegistry().getUpdater().removeCluster(regCluster);
                    this.unregisterFacadeMBeansForTarget(regCluster);
                }
            } else {
                String thisTargetName = this.mPlatform.getTargetName();
                if (thisTargetName.equals(this.mPlatform.getInstanceName())) {
                    List<String> regServers = this.getRegistry().getGenericQuery().getServers();
                    if (!regServers.contains(thisTargetName)) {
                        this.getRegistry().getUpdater().addServer(thisTargetName);
                    }
                } else {
                    List<String> regClusters = this.getRegistry().getGenericQuery().getClusters();
                    if (!regClusters.contains(thisTargetName)) {
                        this.getRegistry().getUpdater().addCluster(thisTargetName);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void registerComponentExtensionFacadeMBeansForTarget(String target) throws Exception {
        ObjectName compExtName;
        StandardMBean compExtMBean;
        ComponentExtension compExt;
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        for (String compName : bindingComponents) {
            compExt = new ComponentExtension(this.mEnvCtx, target, compName, ComponentType.BINDING);
            compExtMBean = new StandardMBean(compExt, ComponentExtensionMBean.class);
            compExtName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            this.mMBeanSvr.registerMBean(compExtMBean, compExtName);
        }
        for (String compName : engineComponents) {
            compExt = new ComponentExtension(this.mEnvCtx, target, compName, ComponentType.ENGINE);
            compExtMBean = new StandardMBean(compExt, ComponentExtensionMBean.class);
            compExtName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            this.mMBeanSvr.registerMBean(compExtMBean, compExtName);
        }
    }

    private void unregisterComponentExtensionFacadeMBeansForTarget(String target) throws Exception {
        ObjectName compExtName;
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        ArrayList<ObjectName> objNames = new ArrayList<ObjectName>();
        for (String compName : bindingComponents) {
            compExtName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            objNames.add(compExtName);
        }
        for (String compName : engineComponents) {
            compExtName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            objNames.add(compExtName);
        }
        for (ObjectName objName : objNames) {
            if (!this.mMBeanSvr.isRegistered(objName)) continue;
            this.mMBeanSvr.unregisterMBean(objName);
        }
    }

    private void registerComponentLifeCycleFacadeMBeansForTarget(String target) throws Exception {
        Map<String, Map<String, ObjectName>> bindings = this.getBindingComponentLifeCycleNames(target);
        Map<String, Map<String, ObjectName>> engines = this.getEngineComponentLifeCycleNames(target);
        Set<String> bindingNames = bindings.keySet();
        for (String compName : bindingNames) {
            ComponentLifeCycle bindingLC = new ComponentLifeCycle(this.mEnvCtx, target, compName, ComponentType.BINDING, bindings.get(compName));
            StandardMBean compLC = new StandardMBean(bindingLC, ComponentLifeCycleMBean.class);
            ObjectName compLCName = FacadeMbeanHelper.getComponentLifeCycleFacadeMBeanName(compName, ComponentType.BINDING, target, this.mEnvCtx.getMBeanNames());
            this.mMBeanSvr.registerMBean(compLC, compLCName);
        }
        Set<String> engineNames = engines.keySet();
        for (String compName : engineNames) {
            ComponentLifeCycle engineLC = new ComponentLifeCycle(this.mEnvCtx, target, compName, ComponentType.ENGINE, engines.get(compName));
            StandardMBean compLC = new StandardMBean(engineLC, ComponentLifeCycleMBean.class);
            ObjectName compLCName = FacadeMbeanHelper.getComponentLifeCycleFacadeMBeanName(compName, ComponentType.ENGINE, target, this.mEnvCtx.getMBeanNames());
            this.mMBeanSvr.registerMBean(compLC, compLCName);
        }
    }

    private void unregisterComponentLifeCycleFacadeMBeansForTarget(String target) throws Exception {
        ObjectName[] compLCNames;
        for (ObjectName compLC : compLCNames = FacadeMbeanHelper.getComponentLifeCycleObjectNames(this.mMBeanSvr, this.mEnvCtx.getMBeanNames(), target)) {
            if (!this.mMBeanSvr.isRegistered(compLC)) continue;
            this.mMBeanSvr.unregisterMBean(compLC);
        }
    }

    private void registerComponentConfigurationFacadeMBeansForTarget(String target) throws Exception {
        ObjectName compCfgName;
        ComponentConfiguration compCfg;
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        for (String compName : bindingComponents) {
            compCfg = new ComponentConfiguration(this.mEnvCtx, target, compName, ComponentType.BINDING);
            compCfgName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, target);
            this.mMBeanSvr.registerMBean(compCfg, compCfgName);
        }
        for (String compName : engineComponents) {
            compCfg = new ComponentConfiguration(this.mEnvCtx, target, compName, ComponentType.ENGINE);
            compCfgName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, target);
            this.mMBeanSvr.registerMBean(compCfg, compCfgName);
        }
    }

    private void unregisterComponentConfigurationFacadeMBeansForTarget(String target) throws Exception {
        ObjectName compCfgName;
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        ArrayList<ObjectName> objNames = new ArrayList<ObjectName>();
        for (String compName : bindingComponents) {
            compCfgName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, target);
            objNames.add(compCfgName);
        }
        for (String compName : engineComponents) {
            compCfgName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, target);
            objNames.add(compCfgName);
        }
        for (ObjectName objName : objNames) {
            if (!this.mMBeanSvr.isRegistered(objName)) continue;
            this.mMBeanSvr.unregisterMBean(objName);
        }
    }

    private void registerComponentConfigurationFacadeMBeansForClusterInstance(String clusterInstance) throws Exception {
        ObjectName compCfgName;
        ClusterInstanceComponentConfiguration compCfg;
        String cluster = this.mPlatform.getTargetName(clusterInstance);
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(cluster);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        for (String compName : bindingComponents) {
            compCfg = new ClusterInstanceComponentConfiguration(this.mEnvCtx, clusterInstance, cluster, compName, ComponentType.BINDING);
            compCfgName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, clusterInstance);
            this.mMBeanSvr.registerMBean(compCfg, compCfgName);
        }
        for (String compName : engineComponents) {
            compCfg = new ClusterInstanceComponentConfiguration(this.mEnvCtx, clusterInstance, cluster, compName, ComponentType.ENGINE);
            compCfgName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, clusterInstance);
            this.mMBeanSvr.registerMBean(compCfg, compCfgName);
        }
    }

    private void unregisterComponentConfigurationFacadeMBeansForClusterInstance(String clusterInstance) throws Exception {
        ObjectName compCfgName;
        String cluster = this.mPlatform.getTargetName(clusterInstance);
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(cluster);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        ArrayList<ObjectName> objNames = new ArrayList<ObjectName>();
        for (String compName : bindingComponents) {
            compCfgName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, clusterInstance);
            objNames.add(compCfgName);
        }
        for (String compName : engineComponents) {
            compCfgName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Configuration, clusterInstance);
            objNames.add(compCfgName);
        }
        for (ObjectName objName : objNames) {
            if (!this.mMBeanSvr.isRegistered(objName)) continue;
            this.mMBeanSvr.unregisterMBean(objName);
        }
    }

    private Map<String, Map<String, ObjectName>> getBindingComponentLifeCycleNames(String target) throws Exception {
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        HashMap<String, Map<String, ObjectName>> allBindings = new HashMap<String, Map<String, ObjectName>>();
        boolean i = false;
        for (String bindingName : bindingComponents) {
            HashMap<String, ObjectName> bindingObjNames = new HashMap<String, ObjectName>();
            if ("domain".equals(target)) {
                bindingObjNames.put(target, null);
            } else if (this.mPlatform.isStandaloneServer(target)) {
                ObjectName bindingObjName = this.mMgtCtx.getMBeanNames(target).getBindingMBeanName(bindingName, "Lifecycle");
                bindingObjNames.put(target, bindingObjName);
            } else {
                Set<String> instances = this.mPlatform.getServersInCluster(target);
                for (String instance : instances) {
                    ObjectName bindingObjName = this.mMgtCtx.getMBeanNames(instance).getBindingMBeanName(bindingName, "Lifecycle");
                    bindingObjNames.put(instance, bindingObjName);
                }
            }
            allBindings.put(bindingName, bindingObjNames);
        }
        return allBindings;
    }

    private Map<String, Map<String, ObjectName>> getEngineComponentLifeCycleNames(String target) throws Exception {
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        HashMap<String, Map<String, ObjectName>> allEngines = new HashMap<String, Map<String, ObjectName>>();
        boolean i = false;
        for (String engineName : engineComponents) {
            HashMap<String, ObjectName> engineObjNames = new HashMap<String, ObjectName>();
            if ("domain".equals(target)) {
                engineObjNames.put(target, null);
            } else if (this.mPlatform.isStandaloneServer(target)) {
                ObjectName engineObjName = this.mMgtCtx.getMBeanNames(target).getEngineMBeanName(engineName, "Lifecycle");
                engineObjNames.put(target, engineObjName);
            } else {
                Set<String> instances = this.mPlatform.getServersInCluster(target);
                for (String instance : instances) {
                    ObjectName engineObjName = this.mMgtCtx.getMBeanNames(instance).getEngineMBeanName(engineName, "Lifecycle");
                    engineObjNames.put(instance, engineObjName);
                }
            }
            allEngines.put(engineName, engineObjNames);
        }
        return allEngines;
    }

    private void registerRuntimeConfigFacadeMBeansForTarget(String target) throws Exception {
        Map<MBeanNames.ServiceType, ConfigurationFactory> configs = ConfigurationBuilder.createConfigurations(this.readDefaultProperties());
        this.mConfigSvcTypes = configs.keySet();
        for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
            ObjectName name = this.mEnvCtx.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, serviceType, target);
            if (this.mMBeanSvr.isRegistered(name)) continue;
            ModelMBeanInfo mbeanInfo = RuntimeConfiguration.createMBeanInfo(configs.get((Object)serviceType).createMBeanAttributeInfo());
            RuntimeConfiguration modelConfigMBean = new RuntimeConfiguration(mbeanInfo, ConfigurationCategory.valueOf(serviceType.toString()), target);
            modelConfigMBean.setManagedResource(modelConfigMBean, "ObjectReference");
            this.mMBeanSvr.registerMBean(modelConfigMBean, name);
        }
    }

    private void unregisterRuntimeConfigFacadeMBeansForTarget(String target) throws Exception {
        if (this.mConfigSvcTypes != null) {
            for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
                ObjectName name = this.mEnvCtx.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, serviceType, target);
                if (!this.mMBeanSvr.isRegistered(name)) continue;
                this.mMBeanSvr.unregisterMBean(name);
            }
        }
    }

    private void addSystemComponents(String targetName) throws Exception {
        ComponentQuery compQuery = this.getRegistry().getComponentQuery("domain");
        GenericQuery genQuery = this.getRegistry().getGenericQuery();
        ComponentInfoImpl compInfo = null;
        String WORKSPACE = "workspace";
        String INSTALL_ROOT = "install_root";
        List components = compQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        for (String componentName : components) {
            Archive archive;
            if (!genQuery.isSystemComponent(componentName) || (archive = this.mMgtCtx.getRepository().getArchive(ArchiveType.COMPONENT, componentName)) == null) continue;
            String componentRoot = new File(archive.getPath()).getParent();
            String componentInstallRoot = componentRoot + File.separator + INSTALL_ROOT;
            String componentWorkspaceRoot = componentInstallRoot + File.separator + WORKSPACE;
            compInfo = new ComponentInfoImpl();
            compInfo.setName(componentName);
            compInfo.setInstallRoot(componentInstallRoot);
            compInfo.setWorkspaceRoot(componentWorkspaceRoot);
            compInfo.setStatus(ComponentState.SHUTDOWN);
            this.getRegistry().getUpdater().addComponent(targetName, compInfo);
        }
        List sharedLibs = compQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        for (String sharedLibName : sharedLibs) {
            Archive archive;
            if (!genQuery.isSystemSharedLibrary(sharedLibName) || (archive = this.mMgtCtx.getRepository().getArchive(ArchiveType.SHARED_LIBRARY, sharedLibName)) == null) continue;
            String sharedLibRoot = new File(archive.getPath()).getParent();
            String sharedLibInstallRoot = sharedLibRoot + File.separator + INSTALL_ROOT;
            compInfo = new ComponentInfoImpl();
            compInfo.setName(sharedLibName);
            compInfo.setInstallRoot(sharedLibInstallRoot);
            this.getRegistry().getUpdater().addSharedLibrary(targetName, compInfo);
        }
    }

    private void createClientConfigFiles() {
        if (!new File(this.getJbiDomainUpdateScriptPath()).canRead()) {
            return;
        }
        System.setProperty("com.sun.jbi.management.JmxRmiPort", this.mPlatform.getJmxRmiPort());
        this.mLog.fine("Running ant admin startup tasks ...");
        String antfn = this.getJbiDomainUpdateScriptPath();
        AntScriptRunner ant = new AntScriptRunner();
        AntScriptRunner.runAntTarget(this.mEnvCtx.getJbiInstanceRoot(), antfn, "admin_startup_tasks");
    }

    private String getJbiDomainUpdateScriptPath() {
        return this.mEnvCtx.getJbiInstallRoot() + File.separator + "templates" + File.separator + "update_jbi_domain.ant";
    }

    private Properties readDefaultProperties() throws IOException {
        if (this.mDefaults == null) {
            FileInputStream ipStr;
            this.mDefaults = new Properties();
            StringBuffer pathToConfig = new StringBuffer(this.mEnvCtx.getJbiInstallRoot());
            pathToConfig.append(File.separatorChar);
            pathToConfig.append("lib");
            pathToConfig.append(File.separatorChar);
            pathToConfig.append("install");
            pathToConfig.append(File.separatorChar);
            pathToConfig.append("templates");
            pathToConfig.append(File.separatorChar);
            File defConfig = new File(pathToConfig.toString(), DEFAULT_CONFIG_FILE);
            if (defConfig.exists() && defConfig.length() > 0L && (ipStr = new FileInputStream(defConfig)) != null) {
                this.mDefaults.load(ipStr);
                ((InputStream)ipStr).close();
            }
        }
        return this.mDefaults;
    }

    protected Registry getRegistry() {
        return (Registry)this.mEnvCtx.getRegistry();
    }

    private void registerEventManagementControllerMbean() throws Exception {
        this.mLog.finest("reg. Event Management Controller MBeans");
        EventManagementControllerMBean emController = new EventManagementControllerMBean(this.mEnvCtx);
        ObjectName emcObjectName = new ObjectName("EventManagement:name=EventManagementControllerMBean");
        this.mMBeanSvr.registerMBean(emController, emcObjectName);
    }

    private void unregisterEventManagementControllerMbean() throws Exception {
        this.mLog.finest("unreg. Event Management Controller MBeans");
        ObjectName emcObjectName = new ObjectName("EventManagement:name=EventManagementControllerMBean");
        if (this.mMBeanSvr.isRegistered(emcObjectName)) {
            this.mMBeanSvr.unregisterMBean(emcObjectName);
        }
    }

    private void registerEventManagementForwarderMbean() throws Exception {
        this.mLog.finest("reg. Event Management Forwarder MBeans");
        EventForwarderMBean emForwarder = new EventForwarderMBean(this.mEnvCtx);
        ObjectName emfObjectName = new ObjectName("EventManagement:name=EventForwarderMBean");
        this.mMBeanSvr.registerMBean(emForwarder, emfObjectName);
    }

    private void unregisterEventManagementForwarderMbean() throws Exception {
        this.mLog.finest("unreg. Event Management Forwarder MBeans");
        ObjectName emfObjectName = new ObjectName("EventManagement:name=EventForwarderMBean");
        if (this.mMBeanSvr.isRegistered(emfObjectName)) {
            this.mMBeanSvr.unregisterMBean(emfObjectName);
        }
    }
}

