/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.management.ComponentInfo;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.descriptor.SharedLibraryDescriptor;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.registry.data.ServiceUnitInfoImpl;
import com.sun.jbi.management.registry.xml.AppConfigType;
import com.sun.jbi.management.registry.xml.AppVariableType;
import com.sun.jbi.management.registry.xml.ComponentConfigType;
import com.sun.jbi.management.registry.xml.ComponentRefType;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.registry.xml.LifeCycleStatusEnum;
import com.sun.jbi.management.registry.xml.ObjectFactory;
import com.sun.jbi.management.registry.xml.PropertyType;
import com.sun.jbi.management.registry.xml.ServiceAssemblyRefType;
import com.sun.jbi.management.registry.xml.ServiceUnitListType;
import com.sun.jbi.management.registry.xml.ServiceUnitType;
import com.sun.jbi.management.registry.xml.SharedLibraryRefType;
import com.sun.jbi.management.util.PropertyFilter;
import com.sun.jbi.management.util.StringHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTranslator {
    private static ObjectFactory sObjectFactory;
    private static String NA;

    public static SharedLibraryRefType getJaxbSharedLibraryRef(ComponentInfo slInfo) throws JAXBException {
        SharedLibraryRefType slRef = sObjectFactory.createSharedLibraryRefType();
        slRef.setNameRef(StringHelper.trim(slInfo.getName()));
        slRef.setInstallRoot(ObjectTranslator.getRelativePath(StringHelper.trim(slInfo.getInstallRoot())));
        return slRef;
    }

    public static ServiceAssemblyRefType getJaxbServiceAssemblyRef(String saName) throws JAXBException {
        ServiceAssemblyRefType saRef = sObjectFactory.createServiceAssemblyRefType();
        saRef.setNameRef(StringHelper.trim(saName));
        return saRef;
    }

    public static ComponentRefType getJaxbComponentRef(ComponentInfo compInfo) throws JAXBException {
        ComponentRefType compRef = sObjectFactory.createComponentRefType();
        compRef.setNameRef(StringHelper.trim(compInfo.getName()));
        compRef.setInstallRoot(ObjectTranslator.getRelativePath(StringHelper.trim(compInfo.getInstallRoot())));
        compRef.setServiceUnits(ObjectTranslator.getJaxbServiceUnitListType(compInfo.getServiceUnitList()));
        compRef.setState(LifeCycleStatusEnum.fromValue(compInfo.getStatus().toString()));
        compRef.setWorkspace(ObjectTranslator.getRelativePath(StringHelper.trim(compInfo.getWorkspaceRoot())));
        ObjectTranslator.updateJaxbComponentPropertyList(compInfo.getProperties(), compRef.getProperty());
        return compRef;
    }

    public static ServiceUnitListType getJaxbServiceUnitListType(List<ServiceUnitInfo> suInfoList) throws JAXBException {
        ServiceUnitListType suListType = sObjectFactory.createServiceUnitListType();
        for (ServiceUnitInfo suInfo : suInfoList) {
            ServiceUnitType suType = ObjectTranslator.getJaxbServiceUnitType(suInfo);
            suListType.getServiceUnit().add(suType);
        }
        return suListType;
    }

    public static ServiceUnitType getJaxbServiceUnitType(ServiceUnitInfo suInfo) throws JAXBException {
        ServiceUnitType suType = sObjectFactory.createServiceUnitType();
        suType.setName(StringHelper.trim(suInfo.getName()));
        suType.setServiceAssemblyRef(StringHelper.trim(suInfo.getServiceAssemblyName()));
        suType.setState(LifeCycleStatusEnum.fromValue(suInfo.getState().toString()));
        return suType;
    }

    public static void updateJaxbComponentPropertyList(Map compProps, List<PropertyType> list) throws JAXBException {
        Iterator itr = compProps.keySet().iterator();
        while (itr.hasNext()) {
            PropertyType pt = sObjectFactory.createPropertyType();
            String key = (String)itr.next();
            pt.setName(StringHelper.trim(key));
            pt.setValue(StringHelper.trim((String)compProps.get(key)));
            list.add(pt);
        }
    }

    public static ComponentInfo getRegistryComponent(ComponentRefType compRef, GenericQueryImpl genQuery) throws JAXBException, RegistryException {
        ComponentInfoImpl compInfo = null;
        if (compRef != null) {
            String compName = StringHelper.trim(compRef.getNameRef());
            String compInstallRoot = StringHelper.trim(compRef.getInstallRoot());
            compInfo = new ComponentInfoImpl();
            compInfo.setName(compName);
            compInfo.setInstallRoot(ObjectTranslator.getAbsolutePath(compInstallRoot));
            compInfo.setStatus(ComponentState.valueOfString(StringHelper.trim(compRef.getState().value())));
            compInfo.setWorkspaceRoot(ObjectTranslator.getAbsolutePath(StringHelper.trim(compRef.getWorkspace())));
            compInfo.setTimestamp(genQuery.getComponentTimestamp(compName));
            compInfo.setUpgradeNumber(genQuery.getComponentUpgradeNumber(compName).intValue());
            compInfo.setServiceUnitList(ObjectTranslator.getRegistryServiceUnitListType(compRef.getServiceUnits(), StringHelper.trim(compRef.getNameRef())));
            ObjectTranslator.updateRegistryComponentPropertyList(compInfo.getProperties(), compRef.getProperty());
            ObjectTranslator.updateRegistryComponentConfigInfo(compInfo, compRef.getComponentConfig());
            compInfo = ObjectTranslator.updateComponentWithDescriptorData(compInfo, genQuery);
        }
        return compInfo;
    }

    public static ComponentInfo getRegistryComponent(String componentName, GenericQueryImpl genQuery) throws JAXBException, RegistryException {
        ComponentInfoImpl compInfo = null;
        if (componentName != null) {
            compInfo = new ComponentInfoImpl();
            compInfo.setName(componentName);
            compInfo.setInstallRoot(NA);
            compInfo.setStatus(ComponentState.UNKNOWN);
            compInfo.setWorkspaceRoot(NA);
            compInfo.setTimestamp(genQuery.getComponentTimestamp(componentName));
            compInfo.setUpgradeNumber(genQuery.getComponentUpgradeNumber(componentName).intValue());
            compInfo.setServiceUnitList(new ArrayList<ServiceUnitInfo>());
            compInfo = ObjectTranslator.updateComponentWithDescriptorData(compInfo, genQuery);
        }
        return compInfo;
    }

    public static ComponentInfo getRegistrySharedLibrary(GenericQueryImpl genQuery, SharedLibraryRefType slRef) throws RegistryException {
        ComponentInfoImpl slInfo = null;
        if (slRef != null) {
            String slName = slRef.getNameRef();
            slInfo = new ComponentInfoImpl();
            slInfo.setName(slName);
            slInfo.setInstallRoot(ObjectTranslator.getAbsolutePath(slRef.getInstallRoot()));
            slInfo.setStatus(ComponentState.SHUTDOWN);
            slInfo.setComponentType(ComponentType.SHARED_LIBRARY);
            slInfo.setTimestamp(genQuery.getComponentTimestamp(slName));
            slInfo = ObjectTranslator.updateSharedLibraryWithDescriptorData(slInfo, genQuery);
        }
        return slInfo;
    }

    public static ComponentInfo getRegistrySharedLibrary(GenericQueryImpl genQuery, String slName) throws RegistryException {
        ComponentInfoImpl slInfo = new ComponentInfoImpl();
        slInfo.setName(slName);
        slInfo.setInstallRoot(NA);
        slInfo.setStatus(ComponentState.SHUTDOWN);
        slInfo.setComponentType(ComponentType.SHARED_LIBRARY);
        slInfo.setTimestamp(genQuery.getComponentTimestamp(slName));
        slInfo = ObjectTranslator.updateSharedLibraryWithDescriptorData(slInfo, genQuery);
        return slInfo;
    }

    private static List<String> getClassPathList(String installRoot, List<String> classPathList) {
        ArrayList<String> absCp = new ArrayList<String>();
        for (String classpath : classPathList) {
            absCp.add(installRoot + File.separator + classpath);
        }
        return absCp;
    }

    private static List<ServiceUnitInfo> getRegistryServiceUnitListType(ServiceUnitListType suList, String targetComponent) {
        ArrayList<ServiceUnitInfo> suInfoList = new ArrayList<ServiceUnitInfo>();
        if (suList != null) {
            List<ServiceUnitType> sus = suList.getServiceUnit();
            for (ServiceUnitType suType : sus) {
                ServiceUnitInfo suInfo = ObjectTranslator.getRegistryServiceUnitType(suType, targetComponent);
                suInfoList.add(suInfo);
            }
        }
        return suInfoList;
    }

    private static void updateRegistryComponentPropertyList(Map compProps, List<PropertyType> list) throws JAXBException {
        for (PropertyType pt : list) {
            compProps.put(pt.getName(), pt.getValue());
        }
    }

    private static void updateRegistryComponentConfigInfo(ComponentInfoImpl compInfo, ComponentConfigType compCfg) {
        if (compCfg != null) {
            List<PropertyType> regProps = compCfg.getProperty();
            Properties props = new Properties();
            for (PropertyType regProp : regProps) {
                props.put(regProp.getName(), regProp.getValue());
            }
            compInfo.setConfiguration(props);
            List<AppVariableType> appVars = compCfg.getApplicationVariable();
            ComponentInfo.Variable[] vars = new ComponentInfo.Variable[appVars.size()];
            int i = 0;
            for (AppVariableType appVar : appVars) {
                vars[i++] = new ComponentInfo.Variable(appVar.getName(), appVar.getValue(), appVar.getType());
            }
            compInfo.setVariables(vars);
            List<AppConfigType> appConfigs = compCfg.getApplicationConfiguration();
            for (AppConfigType appConfig : appConfigs) {
                List<PropertyType> cfgProps = appConfig.getProperty();
                Properties appCfgProps = new Properties();
                for (PropertyType cfgrop : cfgProps) {
                    appCfgProps.put(cfgrop.getName(), cfgrop.getValue());
                }
                compInfo.setApplicationConfiguration(appCfgProps.getProperty("configurationName"), appCfgProps);
            }
        }
    }

    private static ServiceUnitInfo getRegistryServiceUnitType(ServiceUnitType suType, String targetComponent) {
        ServiceUnitInfoImpl suInfo = new ServiceUnitInfoImpl();
        suInfo.setName(StringHelper.trim(suType.getName()));
        suInfo.setTargetComponent(targetComponent);
        suInfo.setServiceAssemblyName(StringHelper.trim(suType.getServiceAssemblyRef()));
        suInfo.setState(ServiceUnitState.valueOfString(StringHelper.trim(suType.getState().value())));
        return suInfo;
    }

    private static ComponentInfoImpl updateComponentWithDescriptorData(ComponentInfoImpl compInfo, GenericQueryImpl genQuery) throws RegistryException {
        String compName = compInfo.getName();
        String compInstallRoot = StringHelper.trim(compInfo.getInstallRoot());
        String compRoot = "";
        if (!NA.equals(compInstallRoot)) {
            compRoot = ObjectTranslator.getAbsolutePath(compInstallRoot);
        }
        compInfo.setInstallationDescriptor(genQuery.getComponentInstallationDescriptor(compName));
        Jbi jbi = genQuery.getComponentJbi(compName);
        if (jbi != null) {
            ComponentDescriptor descr = new ComponentDescriptor(jbi);
            String compClass = descr.getComponentClassName();
            String bootClass = descr.getBootstrapClassName();
            compInfo.setComponentClassName(compClass);
            compInfo.setBootstrapClassName(bootClass);
            compInfo.setComponentType(descr.getComponentType());
            compInfo.setDescription(descr.getDescription());
            compInfo.setClassLoaderSelfFirst(descr.isComponentClassLoaderSelfFirst());
            compInfo.setBootstrapClassLoaderSelfFirst(descr.isBootstrapClassLoaderSelfFirst());
            compInfo.setSharedLibraryNames(descr.getSharedLibraryIds());
            compInfo.setClassPathElements(ObjectTranslator.getClassPathList(compRoot, descr.getComponentClassPathElements()));
            compInfo.setBootstrapClassPathElements(ObjectTranslator.getClassPathList(compRoot, descr.getBootstrapClassPathElements()));
        }
        return compInfo;
    }

    private static ComponentInfoImpl updateSharedLibraryWithDescriptorData(ComponentInfoImpl slInfo, GenericQueryImpl genQuery) throws RegistryException {
        String slName = slInfo.getName();
        String slInstallRoot = StringHelper.trim(slInfo.getInstallRoot());
        String slRoot = "";
        if (!NA.equals(slInstallRoot)) {
            slRoot = ObjectTranslator.getAbsolutePath(slInstallRoot);
        }
        slInfo.setInstallationDescriptor(genQuery.getSharedLibraryInstallationDescriptor(slName));
        Jbi jbi = genQuery.getSharedLibraryJbi(slName);
        if (jbi != null) {
            SharedLibraryDescriptor descr = new SharedLibraryDescriptor(jbi);
            slInfo.setDescription(descr.getDescription());
            slInfo.setClassLoaderSelfFirst(descr.isSharedLibraryClassLoaderSelfFirst());
            slInfo.setClassPathElements(ObjectTranslator.getClassPathList(slRoot, descr.getSharedLibraryClassPathElements()));
        }
        return slInfo;
    }

    private static String getRelativePath(String path) {
        String resStr = PropertyFilter.replacePropertyValues(path, "com.sun.jbi.platform.instanceRoot");
        resStr = PropertyFilter.replacePropertyValues(resStr, "com.sun.jbi.platform.installRoot");
        return resStr;
    }

    private static String getAbsolutePath(String path) {
        return PropertyFilter.filterProperties(path);
    }

    static {
        NA = "NA";
        sObjectFactory = new ObjectFactory();
    }
}

