/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.RegistrySpec;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.registry.xml.ComponentQueryImpl;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.registry.xml.Jbi;
import com.sun.jbi.management.registry.xml.ObjectFactory;
import com.sun.jbi.management.registry.xml.RegistryUtil;
import com.sun.jbi.management.registry.xml.ServiceAssemblyQueryImpl;
import com.sun.jbi.management.registry.xml.UpdaterImpl;
import com.sun.jbi.management.repository.Repository;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.util.FileHelper;
import com.sun.jbi.management.util.LockManager;
import com.sun.jbi.platform.PlatformContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class RegistryImpl
implements Registry {
    public static final String REGISTRY_FILE = "jbi-registry.xml";
    public static final String REGISTRY_SYNC_FILE = "jbi-registry-sync.xml";
    public static final String REGISTRY_BKUP_FILE = "jbi-registry-backup.xml";
    public static final String REGISTRY_ERROR_FOLDER = "error";
    public static final String JBI_REGISTRY_SCHEMA = "jbi-registry.xsd";
    public static final String JBI_REGISTRY_SCHEMA_DIR = "schemas";
    public static final String VALIDATE = "validate";
    public static final String REGISTRY_XML_PACKAGE = "com.sun.jbi.management.registry.xml";
    private Properties mProps = null;
    private Jbi mJbiRegistry;
    private PlatformContext mPlatform;
    private Marshaller mMarshaller = null;
    private LockManager mRegistryObjRWLockManager;
    private LockManager mSerializationRWLockManager;
    private ManagementContext mMgtCtx;
    private RegistrySpec mSpec;
    static final String STRING_TRANSLATOR_NAME = "com.sun.jbi.management";
    private StringTranslator mTranslator;
    private Logger mLogger;
    private static JAXBContext sJC;
    private String mRegistryFolderPath;
    private String mErrorFolderPath;
    private String mRegistryFilePath;
    private String mRegistryFile;
    private String mRegistrySyncFilePath;
    private String mRegistrySyncFile;
    private String mRegistryBackupFilePath;
    private RegistryUtil mRegUtil;
    private File mRegSchema;

    private static void initJaxbContext() throws Exception {
        if (sJC == null) {
            ClassLoader cl = Class.forName("com.sun.jbi.management.registry.xml.Jbi").getClassLoader();
            sJC = JAXBContext.newInstance((String)REGISTRY_XML_PACKAGE, (ClassLoader)cl);
        }
    }

    public RegistryImpl(RegistrySpec spec) throws RegistryException {
        this.mSpec = spec;
        this.mProps = spec.getProperties();
        this.mRegistryObjRWLockManager = null;
        this.mSerializationRWLockManager = null;
        this.mLogger = Logger.getLogger("com.sun.jbi.management.registry");
        this.mMgtCtx = spec.getManagementContext();
        RegistryImpl registryImpl = this;
        this.mPlatform = registryImpl.mMgtCtx.getEnvironmentContext().getPlatformContext();
        RegistryImpl registryImpl2 = this;
        this.mTranslator = registryImpl2.mMgtCtx.getEnvironmentContext().getStringTranslator(STRING_TRANSLATOR_NAME);
        this.mRegistryFolderPath = this.mProps.getProperty("com.sun.jbi.registry.folder");
        this.mErrorFolderPath = this.mRegistryFolderPath + File.separator + REGISTRY_ERROR_FOLDER;
        String regFile = this.mProps.getProperty("com.sun.jbi.registry.file");
        if (regFile == null) {
            regFile = REGISTRY_FILE;
        }
        this.mRegistryFile = regFile;
        this.mRegistryFilePath = this.mRegistryFolderPath + File.separator + regFile;
        this.mRegistryBackupFilePath = this.mRegistryFolderPath + File.separator + REGISTRY_BKUP_FILE;
        try {
            RegistryImpl registryImpl3 = this;
            File schemaDir = new File(registryImpl3.mMgtCtx.getEnvironmentContext().getJbiInstallRoot(), JBI_REGISTRY_SCHEMA_DIR);
            this.mRegSchema = new File(schemaDir, JBI_REGISTRY_SCHEMA);
            RegistryImpl.initJaxbContext();
        }
        catch (Exception ex) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_FAILED_JAXB_INIT", ex.toString());
            this.mLogger.severe(errMsg);
            throw new RegistryException(errMsg, ex);
        }
        this.mJbiRegistry = this.initJbiRegistry();
        try {
            this.mRegUtil = new RegistryUtil(this.mMgtCtx, this);
            this.mRegUtil.syncWithRepository();
        }
        catch (Exception ex) {
            throw new RegistryException(ex);
        }
    }

    public void destroy() {
        File regFile = new File(this.getRegistryFilePath());
        File bkupFile = new File(this.getRegistryBkupFilePath());
        if (regFile.exists()) {
            regFile.delete();
        }
        if (bkupFile.exists()) {
            bkupFile.delete();
        }
        this.mJbiRegistry = null;
    }

    public void reinitialize() throws RegistryException {
        this.mJbiRegistry = null;
        this.initJbiRegistry();
    }

    private synchronized Jbi initJbiRegistry() throws RegistryException {
        block11: {
            if (this.mJbiRegistry == null) {
                try {
                    String lockWaitInterval = this.mProps.getProperty("com.sun.jbi.registry.lock.interval");
                    this.mRegistryObjRWLockManager = new LockManager(new ReentrantReadWriteLock(), "Registry Object Lock", this.mMgtCtx, lockWaitInterval);
                    this.mSerializationRWLockManager = new LockManager(new ReentrantReadWriteLock(), "Registry Serialization Lock", this.mMgtCtx, lockWaitInterval);
                    this.mMarshaller = sJC.createMarshaller();
                    this.mMarshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
                    this.mMarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.mRegSchema));
                    File regFile = new File(this.getRegistryFilePath());
                    File bkupFile = new File(this.getRegistryBkupFilePath());
                    this.mLogger.finer("Registry file is " + this.getRegistryFilePath());
                    if (!regFile.exists()) {
                        if (!bkupFile.exists()) {
                            this.createPrimaryRegistry();
                        } else {
                            this.loadBackupRegistry();
                        }
                        break block11;
                    }
                    try {
                        this.loadPrimaryRegistry();
                    }
                    catch (Exception ex) {
                        this.mLogger.warning(ex.toString());
                        if (bkupFile.exists()) {
                            this.loadBackupRegistry();
                            break block11;
                        }
                        throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_REGISTRY_CORRUPT", this.getRegistryFilePath(), ex.getMessage(), this.getRegistryBkupFilePath()));
                    }
                }
                catch (SAXException se) {
                    se.printStackTrace();
                    String errMsg = this.mTranslator.getString("JBI_ADMIN_REGISTRY_CREATION_FAILED", se.toString());
                    throw new RegistryException(errMsg, se);
                }
                catch (JAXBException ex) {
                    ex.printStackTrace();
                    String errMsg = this.mTranslator.getString("JBI_ADMIN_REGISTRY_CREATION_FAILED", ex.toString());
                    throw new RegistryException(errMsg, ex);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    String errMsg = this.mTranslator.getString("JBI_ADMIN_REGISTRY_CREATION_FAILED", ex.toString());
                    throw new RegistryException(errMsg, ex);
                }
            }
        }
        return this.mJbiRegistry;
    }

    private synchronized void loadPrimaryRegistry() throws FileNotFoundException, JAXBException {
        File registryFile = new File(this.getRegistryFilePath());
        try {
            Unmarshaller u = sJC.createUnmarshaller();
            u.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.mRegSchema));
            FileInputStream fis = new FileInputStream(registryFile);
            this.mJbiRegistry = (Jbi)u.unmarshal((InputStream)fis);
            try {
                fis.close();
            }
            catch (IOException ioex) {
                this.mLogger.warning(ioex.toString());
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
            String errMsg = this.mTranslator.getString("JBI_ADMIN_INVALID_REGISTRY_FORMAT", se.toString());
            throw new JAXBException(errMsg, (Throwable)se);
        }
        catch (JAXBException ex) {
            File errFile = new File(this.mErrorFolderPath + File.separator + "registry-" + System.currentTimeMillis() + ".xml");
            this.movetoErrFile(registryFile, errFile);
            throw ex;
        }
    }

    private void movetoErrFile(File origFile, File errFile) {
        File errFolder = new File(this.mErrorFolderPath);
        if (!errFolder.exists()) {
            FileHelper.createFolder(errFolder);
        }
        if (!origFile.renameTo(errFile)) {
            this.mLogger.warning(this.mTranslator.getString("JBI_ADMIN_REGISTRY_FILE_RENAME_FAILED", origFile.getAbsolutePath(), errFile.getAbsolutePath()));
        }
    }

    private synchronized void loadBackupRegistry() throws IOException, JAXBException {
        File bkupFile = new File(this.mRegistryBackupFilePath);
        File regFile = new File(this.getRegistryFilePath());
        Date lastModified = new Date(bkupFile.lastModified());
        this.mLogger.warning(this.mTranslator.getString("JBI_ADMIN_REGISTRY_USING_BKUP", this.mRegistryBackupFilePath, DateFormat.getDateTimeInstance().format(lastModified)));
        if (!bkupFile.renameTo(regFile)) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_REGISTRY_FILE_RENAME_FAILED", this.mRegistryBackupFilePath, this.mRegistryFilePath);
            throw new IOException(errMsg);
        }
        try {
            Unmarshaller u = sJC.createUnmarshaller();
            u.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.mRegSchema));
            FileInputStream fis = new FileInputStream(regFile);
            this.mJbiRegistry = (Jbi)u.unmarshal((InputStream)fis);
            try {
                fis.close();
            }
            catch (IOException ioex) {
                this.mLogger.warning(ioex.toString());
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
            String errMsg = this.mTranslator.getString("JBI_ADMIN_INVALID_REGISTRY_FORMAT", se.toString());
            throw new JAXBException(errMsg, (Throwable)se);
        }
    }

    private synchronized void createPrimaryRegistry() throws RegistryException {
        try {
            File registryFile = new File(this.mRegistryFilePath);
            this.mLogger.fine(this.mTranslator.getString("JBI_ADMIN_REGISTRY_CREATE", this.mRegistryFilePath));
            FileHelper.createFile(registryFile);
            ObjectFactory factory = new ObjectFactory();
            this.mJbiRegistry = new ObjectFactory().createJbi();
            this.mJbiRegistry.setClusters(factory.createClusterListType());
            this.mJbiRegistry.setServers(factory.createServerListType());
            this.mJbiRegistry.setSharedLibraries(factory.createSharedLibraries());
            this.mJbiRegistry.setServiceAssemblies(factory.createServiceAssemblies());
            this.mJbiRegistry.setConfigs(factory.createConfigs());
            Writer wr = this.getRegistryWriter();
            String validate = this.mProps.getProperty(VALIDATE, "false").toLowerCase();
            if (Boolean.getBoolean(validate)) {
                this.mMarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.mRegSchema));
            }
            this.mMarshaller.marshal((Object)this.mJbiRegistry, wr);
            wr.close();
        }
        catch (SAXException se) {
            se.printStackTrace();
            String errMsg = this.mTranslator.getString("JBI_ADMIN_INVALID_REGISTRY_OBJECT");
            this.mLogger.severe(errMsg);
            throw new RegistryException(errMsg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_REGISTRY_CREATE_FAILED", this.mRegistryFilePath, ex.getMessage()));
        }
    }

    Marshaller getMarshaller() {
        return this.mMarshaller;
    }

    public Updater getUpdater() throws RegistryException {
        String validate = this.mProps.getProperty(VALIDATE, "false").toLowerCase();
        this.initJbiRegistry();
        return new UpdaterImpl(this.mJbiRegistry, this.mMgtCtx, Boolean.getBoolean(validate), this);
    }

    public GenericQuery getGenericQuery() throws RegistryException {
        String validate = this.mProps.getProperty(VALIDATE, "false").toLowerCase();
        this.initJbiRegistry();
        return new GenericQueryImpl(this.mJbiRegistry, this.mMgtCtx, Boolean.getBoolean(validate), this);
    }

    public ComponentQuery getComponentQuery(String targetName) throws RegistryException {
        String validate = this.mProps.getProperty(VALIDATE, "false").toLowerCase();
        this.initJbiRegistry();
        return new ComponentQueryImpl(this.mJbiRegistry, this.mMgtCtx, Boolean.getBoolean(validate), targetName, this);
    }

    public ComponentQuery getComponentQuery() throws RegistryException {
        return this.getComponentQuery(this.mPlatform.getTargetName());
    }

    public ServiceAssemblyQuery getServiceAssemblyQuery(String targetName) throws RegistryException {
        String validate = this.mProps.getProperty(VALIDATE, "false").toLowerCase();
        this.initJbiRegistry();
        return new ServiceAssemblyQueryImpl(this.mJbiRegistry, this.mMgtCtx, Boolean.getBoolean(validate), targetName, this);
    }

    public ServiceAssemblyQuery getServiceAssemblyQuery() throws RegistryException {
        return this.getServiceAssemblyQuery(this.mPlatform.getTargetName());
    }

    Writer getRegistryWriter() {
        OutputStreamWriter osw = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.getRegistryFile());
            osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return osw;
    }

    public File getRegistryFile() {
        File regFile = new File(this.mRegistryFilePath);
        if (!regFile.exists()) {
            FileHelper.createFile(regFile);
        }
        return regFile;
    }

    public String getRegistryFolderPath() {
        return this.mRegistryFolderPath;
    }

    public String getRegistryFilePath() {
        return this.mRegistryFilePath;
    }

    public String getRegistryBkupFilePath() {
        return this.mRegistryBackupFilePath;
    }

    public ManagementContext getManagementContext() {
        return this.mMgtCtx;
    }

    public Repository getRepository() {
        return this.mMgtCtx.getRepository();
    }

    public RegistrySpec getRegistrySpec() {
        return this.mSpec;
    }

    public String getProperty(String propName) {
        if (propName.equals("com.sun.jbi.registry.file")) {
            return this.mRegistryFile;
        }
        if (propName.equals("com.sun.jbi.registry.syncfile")) {
            return REGISTRY_SYNC_FILE;
        }
        if (propName.equals("com.sun.jbi.registry.folder")) {
            return this.mRegistryFolderPath;
        }
        if (propName.equals("com.sun.jbi.registry.readonly")) {
            return this.mProps.getProperty("com.sun.jbi.registry.readonly");
        }
        return null;
    }

    public void commit() throws RegistryException {
        boolean regFileBackedUp = false;
        File backupFile = new File(this.getRegistryBkupFilePath());
        File regFile = new File(this.getRegistryFilePath());
        try {
            this.mSerializationRWLockManager.acquireWriteLock();
            if (backupFile.exists() && !backupFile.delete()) {
                this.mLogger.warning(this.mTranslator.getString("JBI_ADMIN_REGISTRY_FILE_DELETE_FAILED", this.getRegistryBkupFilePath()));
            }
            if (!regFile.renameTo(backupFile)) {
                this.mLogger.warning(this.mTranslator.getString("JBI_ADMIN_REGISTRY_FILE_RENAME_FAILED", this.getRegistryBkupFilePath(), this.getRegistryFilePath()));
            } else {
                regFileBackedUp = true;
            }
            Writer wr = this.getRegistryWriter();
            this.mMarshaller.marshal((Object)this.mJbiRegistry, wr);
            wr.close();
        }
        catch (Exception ex) {
            if (regFileBackedUp) {
                backupFile.renameTo(regFile);
            }
            this.reinitialize();
            this.mSerializationRWLockManager.releaseWriteLock();
            String errMsg = this.mTranslator.getString("JBI_ADMIN_FAILED_SERIALIZE_REGISTRY", ex.toString());
            ex.printStackTrace();
            this.mLogger.severe(errMsg);
            throw new RegistryException(errMsg);
        }
        finally {
            this.mSerializationRWLockManager.releaseWriteLock();
        }
    }

    public ByteArrayInputStream snapshot() throws RegistryException {
        try {
            this.mSerializationRWLockManager.acquireWriteLock();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.mMarshaller.marshal((Object)this.mJbiRegistry, (OutputStream)baos);
            baos.flush();
            baos.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception ex) {
            String errMsg = this.mTranslator.getString("JBI_ADMIN_FAILED_SERIALIZE_REGISTRY", ex.toString());
            ex.printStackTrace();
            this.mLogger.severe(errMsg);
            throw new RegistryException(errMsg);
        }
        finally {
            this.mSerializationRWLockManager.releaseWriteLock();
        }
    }

    LockManager getRegistryObjectLockManager() {
        return this.mRegistryObjRWLockManager;
    }

    LockManager getSerializationLockManager() {
        return this.mSerializationRWLockManager;
    }
}

