/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ComponentInfo;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.registry.xml.AppConfigType;
import com.sun.jbi.management.registry.xml.AppVariableType;
import com.sun.jbi.management.registry.xml.ClusterListType;
import com.sun.jbi.management.registry.xml.ComponentConfigType;
import com.sun.jbi.management.registry.xml.ComponentRefType;
import com.sun.jbi.management.registry.xml.Components;
import com.sun.jbi.management.registry.xml.ConfigCategoryType;
import com.sun.jbi.management.registry.xml.ConfigType;
import com.sun.jbi.management.registry.xml.ConfigTypeEnum;
import com.sun.jbi.management.registry.xml.DomainComponentType;
import com.sun.jbi.management.registry.xml.DomainEntityType;
import com.sun.jbi.management.registry.xml.DomainSharedLibraryType;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.registry.xml.InstalledComponentsListType;
import com.sun.jbi.management.registry.xml.Jbi;
import com.sun.jbi.management.registry.xml.LifeCycleStatusEnum;
import com.sun.jbi.management.registry.xml.ObjectFactory;
import com.sun.jbi.management.registry.xml.ObjectTranslator;
import com.sun.jbi.management.registry.xml.PropertyType;
import com.sun.jbi.management.registry.xml.RegistryImpl;
import com.sun.jbi.management.registry.xml.ServerListType;
import com.sun.jbi.management.registry.xml.ServiceAssemblies;
import com.sun.jbi.management.registry.xml.ServiceAssemblyRefType;
import com.sun.jbi.management.registry.xml.ServiceUnitListType;
import com.sun.jbi.management.registry.xml.ServiceUnitType;
import com.sun.jbi.management.registry.xml.SharedLibraries;
import com.sun.jbi.management.registry.xml.SharedLibraryRefType;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.util.LockManager;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdaterImpl
implements Updater {
    private Jbi mJbiRegistry;
    private RegistryImpl mRegistry;
    private boolean mValidate;
    private ManagementContext mMgtCtx;
    private Logger mLogger;
    private StringTranslator mTranslator;
    private GenericQueryImpl mGenQuery;
    private ObjectFactory mObjectFactory;
    private String mThisTarget;
    private LockManager mRegObjLM;

    public UpdaterImpl(Jbi jbi, ManagementContext mgtCtx, boolean validate, RegistryImpl registry) throws RegistryException {
        this.mJbiRegistry = jbi;
        this.mRegistry = registry;
        this.mValidate = validate;
        this.mMgtCtx = mgtCtx;
        UpdaterImpl updaterImpl = this;
        this.mLogger = updaterImpl.mMgtCtx.getLogger();
        UpdaterImpl updaterImpl2 = this;
        this.mTranslator = updaterImpl2.mMgtCtx.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        this.mGenQuery = (GenericQueryImpl)this.mRegistry.getGenericQuery();
        this.mObjectFactory = new ObjectFactory();
        this.mRegObjLM = registry.getRegistryObjectLockManager();
        UpdaterImpl updaterImpl3 = this;
        this.mThisTarget = updaterImpl3.mMgtCtx.getEnvironmentContext().getPlatformContext().getTargetName();
    }

    @Override
    public void addComponent(ComponentInfo componentInfo) throws RegistryException {
        this.addComponent(this.mThisTarget, componentInfo);
    }

    @Override
    public void addComponent(String componentName, String fileName, Calendar timestamp) throws RegistryException {
        this.mRegObjLM.acquireWriteLock();
        try {
            Components compType = this.mJbiRegistry.getComponents();
            if (compType == null) {
                compType = this.mObjectFactory.createComponents();
                this.mJbiRegistry.setComponents(compType);
            }
            DomainComponentType component = this.mObjectFactory.createDomainComponentType();
            component.setName(componentName);
            component.setFileName(fileName);
            component.setTimestamp(BigInteger.valueOf(timestamp.getTimeInMillis()));
            compType.getComponent().add(component);
        }
        catch (Exception jex) {
            this.mRegObjLM.releaseWriteLock();
            throw new RegistryException(jex);
        }
        this.commit();
    }

    @Override
    public void addComponent(String targetName, ComponentInfo componentInfo) throws RegistryException {
        boolean updated;
        block8: {
            updated = false;
            this.mRegObjLM.acquireWriteLock();
            try {
                if (this.mGenQuery.isTargetServer(targetName)) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        if (!server.getNameRef().equals(targetName)) continue;
                        this.addComponentRef(componentInfo, server);
                        updated = true;
                        break block8;
                    }
                    break block8;
                }
                if (this.mGenQuery.isTargetCluster(targetName)) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        if (!cluster.getNameRef().equals(targetName)) continue;
                        this.addComponentRef(componentInfo, cluster);
                        updated = true;
                        break block8;
                    }
                    break block8;
                }
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_UNKNOWN_TARGET", targetName));
            }
            catch (RegistryException re) {
                this.mRegObjLM.releaseWriteLock();
                throw re;
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
        }
        if (updated) {
            this.commit();
        }
    }

    @Override
    public void removeComponent(String componentName) throws RegistryException {
        this.removeComponent(this.mThisTarget, componentName);
    }

    @Override
    public void removeComponent(String targetName, String componentName) throws RegistryException {
        block8: {
            this.mRegObjLM.acquireWriteLock();
            try {
                if (this.mGenQuery.isTargetDomain(targetName)) {
                    this.deleteComponent(componentName);
                    this.mGenQuery.removeComponentFromCache(componentName);
                    break block8;
                }
                if (this.mGenQuery.isTargetServer(targetName)) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        if (!server.getNameRef().equals(targetName)) continue;
                        this.removeComponentRef(componentName, server);
                    }
                    break block8;
                }
                if (this.mGenQuery.isTargetCluster(targetName)) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        if (!cluster.getNameRef().equals(targetName)) continue;
                        this.removeComponentRef(componentName, cluster);
                    }
                    break block8;
                }
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_UNKNOWN_TARGET", targetName));
            }
            catch (RegistryException re) {
                this.mRegObjLM.releaseWriteLock();
                throw re;
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
        }
        this.commit();
    }

    @Override
    public void addSharedLibrary(ComponentInfo sharedLibraryInfo) throws RegistryException {
        this.addSharedLibrary(this.mThisTarget, sharedLibraryInfo);
    }

    @Override
    public void addSharedLibrary(String slName, String fileName, Calendar timestamp) throws RegistryException {
        this.mRegObjLM.acquireWriteLock();
        try {
            SharedLibraries slType = this.mJbiRegistry.getSharedLibraries();
            if (slType == null) {
                slType = this.mObjectFactory.createSharedLibraries();
                this.mJbiRegistry.setSharedLibraries(slType);
            }
            DomainSharedLibraryType sharedLibrary = this.mObjectFactory.createDomainSharedLibraryType();
            sharedLibrary.setName(slName);
            sharedLibrary.setFileName(fileName);
            sharedLibrary.setTimestamp(BigInteger.valueOf(timestamp.getTimeInMillis()));
            slType.getSharedLibrary().add(sharedLibrary);
        }
        catch (Exception jex) {
            this.mRegObjLM.releaseWriteLock();
            throw new RegistryException(jex);
        }
        this.commit();
    }

    @Override
    public void addSharedLibrary(String targetName, ComponentInfo sharedLibraryInfo) throws RegistryException {
        block8: {
            this.mRegObjLM.acquireWriteLock();
            try {
                if (this.mGenQuery.isTargetDomain(targetName)) {
                    this.addSharedLibrary(sharedLibraryInfo.getName(), "unknown", null);
                    break block8;
                }
                if (this.mGenQuery.isTargetServer(targetName)) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        if (!server.getNameRef().equals(targetName)) continue;
                        this.addSharedLibraryRef(sharedLibraryInfo, server);
                    }
                    break block8;
                }
                if (this.mGenQuery.isTargetCluster(targetName)) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        if (!cluster.getNameRef().equals(targetName)) continue;
                        this.addSharedLibraryRef(sharedLibraryInfo, cluster);
                    }
                    break block8;
                }
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_UNKNOWN_TARGET", targetName));
            }
            catch (RegistryException re) {
                this.mRegObjLM.releaseWriteLock();
                throw re;
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
        }
        this.commit();
    }

    @Override
    public void removeSharedLibrary(String sharedLibraryName) throws RegistryException {
        this.removeSharedLibrary(this.mThisTarget, sharedLibraryName);
    }

    @Override
    public void removeSharedLibrary(String targetName, String sharedLibraryName) throws RegistryException {
        block8: {
            this.mRegObjLM.acquireWriteLock();
            try {
                if (this.mGenQuery.isTargetDomain(targetName)) {
                    this.deleteSharedLibrary(sharedLibraryName);
                    this.mGenQuery.removeSharedLibraryFromCache(sharedLibraryName);
                    break block8;
                }
                if (this.mGenQuery.isTargetServer(targetName)) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        if (!server.getNameRef().equals(targetName)) continue;
                        this.removeSharedLibraryRef(sharedLibraryName, server);
                    }
                    break block8;
                }
                if (this.mGenQuery.isTargetCluster(targetName)) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        if (!cluster.getNameRef().equals(targetName)) continue;
                        this.removeSharedLibraryRef(sharedLibraryName, cluster);
                    }
                    break block8;
                }
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_UNKNOWN_TARGET", targetName));
            }
            catch (RegistryException re) {
                this.mRegObjLM.releaseWriteLock();
                throw re;
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
        }
        this.commit();
    }

    @Override
    public void addServiceAssembly(String saName) throws RegistryException {
        this.addServiceAssembly(this.mThisTarget, saName);
    }

    @Override
    public void addServiceAssembly(String saName, String fileName, Calendar timestamp) throws RegistryException {
        this.mRegObjLM.acquireWriteLock();
        try {
            ServiceAssemblies saType = this.mJbiRegistry.getServiceAssemblies();
            if (saType == null) {
                saType = this.mObjectFactory.createServiceAssemblies();
                this.mJbiRegistry.setServiceAssemblies(saType);
            }
            DomainEntityType serviceAssembly = this.mObjectFactory.createDomainEntityType();
            serviceAssembly.setName(saName);
            serviceAssembly.setFileName(fileName);
            serviceAssembly.setTimestamp(BigInteger.valueOf(timestamp.getTimeInMillis()));
            saType.getServiceAssembly().add(serviceAssembly);
        }
        catch (Exception jex) {
            this.mRegObjLM.releaseWriteLock();
            throw new RegistryException(jex);
        }
        this.commit();
    }

    @Override
    public void addServiceAssembly(String targetName, String saName) throws RegistryException {
        block8: {
            this.mRegObjLM.acquireWriteLock();
            try {
                if (this.mGenQuery.isTargetDomain(targetName)) {
                    this.addServiceAssembly(saName, "unknown", null);
                    break block8;
                }
                if (this.mGenQuery.isTargetServer(targetName)) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        if (!server.getNameRef().equals(targetName)) continue;
                        this.addServiceAssemblyRef(saName, server);
                    }
                    break block8;
                }
                if (this.mGenQuery.isTargetCluster(targetName)) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        if (!cluster.getNameRef().equals(targetName)) continue;
                        this.addServiceAssemblyRef(saName, cluster);
                    }
                    break block8;
                }
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_UNKNOWN_TARGET", targetName));
            }
            catch (RegistryException re) {
                this.mRegObjLM.releaseWriteLock();
                throw re;
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
        }
        this.commit();
    }

    @Override
    public void removeServiceAssembly(String saName) throws RegistryException {
        this.removeServiceAssembly(this.mThisTarget, saName);
    }

    @Override
    public void removeServiceAssembly(String targetName, String saName) throws RegistryException {
        block8: {
            this.mRegObjLM.acquireWriteLock();
            try {
                if (this.mGenQuery.isTargetDomain(targetName)) {
                    this.deleteServiceAssembly(saName);
                    this.mGenQuery.removeServiceAssemblyFromCache(saName);
                    break block8;
                }
                if (this.mGenQuery.isTargetServer(targetName)) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        if (!server.getNameRef().equals(targetName)) continue;
                        this.removeServiceAssemblyRef(saName, server);
                    }
                    break block8;
                }
                if (this.mGenQuery.isTargetCluster(targetName)) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        if (!cluster.getNameRef().equals(targetName)) continue;
                        this.removeServiceAssemblyRef(saName, cluster);
                    }
                    break block8;
                }
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_UNKNOWN_TARGET", targetName));
            }
            catch (RegistryException re) {
                this.mRegObjLM.releaseWriteLock();
                throw re;
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
        }
        this.commit();
    }

    @Override
    public void addServer(String serverNameRef) throws RegistryException {
        try {
            if (!this.mGenQuery.isTargetServer(serverNameRef) && !this.mGenQuery.isTargetCluster(serverNameRef)) {
                this.mRegObjLM.acquireWriteLock();
                try {
                    ServerListType servers = this.mJbiRegistry.getServers();
                    if (servers == null) {
                        servers = this.mObjectFactory.createServerListType();
                        this.mJbiRegistry.setServers(servers);
                    }
                    InstalledComponentsListType server = this.mObjectFactory.createInstalledComponentsListType();
                    server.setNameRef(serverNameRef);
                    this.mJbiRegistry.getServers().getServer().add(server);
                }
                catch (RuntimeException rte) {
                    this.mRegObjLM.releaseWriteLock();
                    throw rte;
                }
            } else {
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_DUPLICATE_TARGET", serverNameRef));
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void removeServer(String serverNameRef) throws RegistryException {
        this.mRegObjLM.acquireWriteLock();
        try {
            InstalledComponentsListType serverToDel = null;
            List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
            for (InstalledComponentsListType server : servers) {
                if (!server.getNameRef().equals(serverNameRef)) continue;
                serverToDel = server;
            }
            if (serverToDel != null) {
                servers.remove(serverToDel);
            }
        }
        catch (RuntimeException rte) {
            this.mRegObjLM.releaseWriteLock();
            throw rte;
        }
        this.commit();
    }

    @Override
    public void addCluster(String clusterNameRef) throws RegistryException {
        try {
            if (!this.mGenQuery.isTargetServer(clusterNameRef) && !this.mGenQuery.isTargetCluster(clusterNameRef)) {
                this.mRegObjLM.acquireWriteLock();
                try {
                    ClusterListType clusters = this.mJbiRegistry.getClusters();
                    if (clusters == null) {
                        clusters = this.mObjectFactory.createClusterListType();
                        this.mJbiRegistry.setClusters(clusters);
                    }
                    InstalledComponentsListType cluster = this.mObjectFactory.createInstalledComponentsListType();
                    cluster.setNameRef(clusterNameRef);
                    this.mJbiRegistry.getClusters().getCluster().add(cluster);
                }
                catch (RuntimeException rte) {
                    this.mRegObjLM.releaseWriteLock();
                    throw rte;
                }
            } else {
                throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_DUPLICATE_TARGET", clusterNameRef));
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void removeCluster(String clusterNameRef) throws RegistryException {
        this.mRegObjLM.acquireWriteLock();
        try {
            InstalledComponentsListType clusterToDel = null;
            List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
            for (InstalledComponentsListType cluster : clusters) {
                if (!cluster.getNameRef().equals(clusterNameRef)) continue;
                clusterToDel = cluster;
            }
            if (clusterToDel != null) {
                clusters.remove(clusterToDel);
            }
        }
        catch (RuntimeException rte) {
            this.mRegObjLM.releaseWriteLock();
            throw rte;
        }
        this.commit();
    }

    @Override
    public void setComponentFileName(String fileName, String componentName) throws RegistryException {
        DomainComponentType comp = this.mGenQuery.getComponent(componentName);
        if (comp != null) {
            this.mRegObjLM.acquireWriteLock();
            try {
                comp.setFileName(fileName);
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
    }

    @Override
    public void setSharedLibraryFileName(String fileName, String slName) throws RegistryException {
        DomainSharedLibraryType sl = this.mGenQuery.getSharedLibrary(slName);
        if (sl != null) {
            this.mRegObjLM.acquireWriteLock();
            try {
                sl.setFileName(fileName);
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
    }

    @Override
    public void setServiceAssemblyFileName(String fileName, String saName) throws RegistryException {
        DomainEntityType sa = this.mGenQuery.getServiceAssembly(saName);
        if (sa != null) {
            this.mRegObjLM.acquireWriteLock();
            try {
                sa.setFileName(fileName);
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
    }

    @Override
    public void setComponentState(ComponentState state, String componentName) throws RegistryException {
        this.setComponentState(this.mThisTarget, state, componentName);
    }

    @Override
    public void setComponentState(String targetName, ComponentState state, String componentName) throws RegistryException {
        ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
        if (comp != null) {
            this.mRegObjLM.acquireWriteLock();
            try {
                this.mLogger.finest("Setting component " + componentName + " to " + state.toString() + " for target " + targetName);
                comp.setState(LifeCycleStatusEnum.fromValue(state.toString()));
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
    }

    @Override
    public void setComponentProperties(String targetName, Map<String, String> props, String componentName) throws RegistryException {
        try {
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName == null ? this.mThisTarget : targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                List<PropertyType> properties = comp.getProperty();
                int numProps = props.size();
                Iterator<String> itr = props.keySet().iterator();
                while (itr.hasNext()) {
                    PropertyType prop = this.mObjectFactory.createPropertyType();
                    String key = itr.next();
                    prop.setName(key);
                    prop.setValue(props.get(key));
                }
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void setServiceUnitState(ServiceUnitState state, String componentName, String suName) throws RegistryException {
        this.setServiceUnitState(this.mThisTarget, state, componentName, suName);
    }

    @Override
    public void setServiceUnitState(String targetName, ServiceUnitState state, String componentName, String suName) throws RegistryException {
        ComponentRefType compRef = this.mGenQuery.getComponent(componentName, targetName);
        boolean updated = false;
        this.mRegObjLM.acquireWriteLock();
        try {
            ServiceUnitListType suListType = compRef.getServiceUnits();
            if (suListType != null) {
                List<ServiceUnitType> suList = suListType.getServiceUnit();
                for (ServiceUnitType su : suList) {
                    if (!su.getName().equals(suName)) continue;
                    su.setState(LifeCycleStatusEnum.fromValue(state.toString()));
                }
                updated = true;
            }
        }
        catch (RuntimeException rte) {
            this.mRegObjLM.releaseWriteLock();
            throw rte;
        }
        if (updated) {
            this.commit();
        } else {
            this.mRegObjLM.releaseWriteLock();
        }
    }

    @Override
    public void setServiceAssemblyState(ServiceAssemblyState state, String saName) throws RegistryException {
        this.setServiceAssemblyState(this.mThisTarget, state, saName);
    }

    @Override
    public void setServiceAssemblyState(String targetName, ServiceAssemblyState state, String saName) throws RegistryException {
        ServiceAssemblyRefType sa = this.mGenQuery.getServiceAssembly(saName, targetName);
        if (sa != null) {
            this.mRegObjLM.acquireWriteLock();
            try {
                this.mLogger.finest("Setting service assembly " + saName + " state to " + state.toString() + " for target " + targetName);
                sa.setState(LifeCycleStatusEnum.fromValue(state.toString()));
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
    }

    @Override
    public void addServiceUnitToComponent(String componentName, ServiceUnitInfo suInfo) throws RegistryException {
        this.addServiceUnitToComponent(this.mThisTarget, componentName, suInfo);
    }

    @Override
    public void addServiceUnitToComponent(String targetName, String componentName, ServiceUnitInfo suInfo) throws RegistryException {
        try {
            ComponentRefType compRef = this.mGenQuery.getComponent(componentName, targetName);
            if (compRef == null) {
                String errMsg = this.mTranslator.getString("JBI_ADMIN_COMPONENT_MISSING_IN_REGISTRY", componentName);
                this.mLogger.warning(errMsg);
                throw new RegistryException(errMsg);
            }
            this.mRegObjLM.acquireWriteLock();
            try {
                ServiceUnitListType suListType = compRef.getServiceUnits();
                if (suListType == null) {
                    suListType = this.mObjectFactory.createServiceUnitListType();
                    compRef.setServiceUnits(suListType);
                }
                List<ServiceUnitType> suList = suListType.getServiceUnit();
                for (ServiceUnitType su : suList) {
                    if (!su.getName().equals(suInfo.getName())) continue;
                    throw new RegistryException(this.mTranslator.getString("JBI_ADMIN_CANNOT_ADD_DUPLICATE_SU", suInfo.getName(), componentName, targetName));
                }
                suList.add(ObjectTranslator.getJaxbServiceUnitType(suInfo));
            }
            catch (RegistryException re) {
                this.mRegObjLM.releaseWriteLock();
                throw re;
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (JAXBException jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void removeServiceUnitFromComponent(String componentName, String suName) throws RegistryException {
        this.removeServiceUnitFromComponent(this.mThisTarget, componentName, suName);
    }

    @Override
    public void removeServiceUnitFromComponent(String targetName, String componentName, String suName) throws RegistryException {
        ComponentRefType compRef = this.mGenQuery.getComponent(componentName, targetName);
        boolean updated = false;
        this.mRegObjLM.acquireWriteLock();
        try {
            ServiceUnitListType suListType = compRef.getServiceUnits();
            if (suListType != null) {
                ServiceUnitType suToDel = null;
                List<ServiceUnitType> suList = suListType.getServiceUnit();
                for (ServiceUnitType su : suList) {
                    if (!su.getName().equals(suName)) continue;
                    suToDel = su;
                }
                suList.remove(suToDel);
                updated = true;
            }
        }
        catch (RuntimeException rte) {
            this.mRegObjLM.releaseWriteLock();
            throw rte;
        }
        if (updated) {
            this.commit();
        } else {
            this.mRegObjLM.releaseWriteLock();
        }
    }

    @Override
    public void setAttribute(ConfigurationCategory type, String name, String value) throws RegistryException {
        this.setAttribute(this.mThisTarget, type, name, value);
    }

    @Override
    public void setAttribute(String targetName, ConfigurationCategory type, String name, String value) throws RegistryException {
        if ("com.sun.jbi".equals(name)) {
            return;
        }
        ObjectFactory factory = new ObjectFactory();
        this.mRegObjLM.acquireWriteLock();
        try {
            if (this.mGenQuery.isAttributeOverriden(targetName, type, name)) {
                ConfigCategoryType category = this.mGenQuery.getConfigCategory(targetName, type);
                List<PropertyType> props = category.getProperty();
                for (PropertyType prop : props) {
                    if (!prop.getName().equals(name)) continue;
                    prop.setValue(value);
                }
            } else {
                ConfigCategoryType category;
                ConfigType configType = this.mGenQuery.getConfig(targetName);
                if (configType == null) {
                    configType = factory.createConfigType();
                    configType.setName(this.mGenQuery.getConfigName(targetName));
                    if (this.mJbiRegistry.getConfigs() == null) {
                        this.mJbiRegistry.setConfigs(factory.createConfigs());
                    }
                    this.mJbiRegistry.getConfigs().getConfig().add(configType);
                }
                if ((category = this.mGenQuery.getConfigCategory(targetName, type)) == null) {
                    List<ConfigCategoryType> categoryList = configType.getConfigType();
                    category = factory.createConfigCategoryType();
                    category.setCategory(ConfigTypeEnum.fromValue(type.toString()));
                    categoryList.add(category);
                }
                List<PropertyType> props = category.getProperty();
                PropertyType newProp = factory.createPropertyType();
                newProp.setName(name);
                newProp.setValue(value);
                props.add(newProp);
            }
        }
        catch (RuntimeException rte) {
            this.mRegObjLM.releaseWriteLock();
            throw rte;
        }
        this.commit();
    }

    @Override
    public void deleteAttribute(ConfigurationCategory type, String name) throws RegistryException {
        this.deleteAttribute(this.mThisTarget, type, name);
    }

    @Override
    public void deleteAttribute(String targetName, ConfigurationCategory type, String name) throws RegistryException {
        if (!this.mGenQuery.isTargetServer(targetName) && !this.mGenQuery.isTargetCluster(targetName)) {
            return;
        }
        ObjectFactory factory = new ObjectFactory();
        this.mRegObjLM.acquireWriteLock();
        try {
            if (this.mGenQuery.isAttributeOverriden(targetName, type, name)) {
                ConfigCategoryType category = this.mGenQuery.getConfigCategory(targetName, type);
                List<PropertyType> props = category.getProperty();
                PropertyType propToDelete = null;
                for (PropertyType prop : props) {
                    if (!prop.getName().equals(name)) continue;
                    propToDelete = prop;
                    break;
                }
                if (propToDelete != null) {
                    props.remove(propToDelete);
                }
            }
        }
        catch (RuntimeException rte) {
            this.mRegObjLM.releaseWriteLock();
            throw rte;
        }
        this.commit();
    }

    @Override
    public void setComponentUpgradeNumber(String componentName, BigInteger upgradeNumber) throws RegistryException {
        block3: {
            this.mRegObjLM.acquireWriteLock();
            try {
                Components compType = this.mJbiRegistry.getComponents();
                if (compType == null) break block3;
                List<DomainComponentType> components = compType.getComponent();
                for (DomainComponentType component : components) {
                    if (!component.getName().equals(componentName)) continue;
                    component.setUpgradeNumber(upgradeNumber);
                    break;
                }
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
        }
        this.commit();
    }

    public void correctTimestamps() throws RegistryException {
        this.mRegObjLM.acquireWriteLock();
        try {
            SharedLibraries slType;
            Components compType = this.mJbiRegistry.getComponents();
            if (compType != null) {
                List<DomainComponentType> components = compType.getComponent();
                for (DomainComponentType component : components) {
                    if (!component.getTimestamp().equals(BigInteger.valueOf(0L))) continue;
                    long timestamp = 0L;
                    String filename = this.mRegistry.getRepository().getArchive(ArchiveType.COMPONENT, component.getName()).getPath();
                    File file = new File(filename);
                    timestamp = file.lastModified();
                    component.setTimestamp(BigInteger.valueOf(timestamp));
                }
            }
            if ((slType = this.mJbiRegistry.getSharedLibraries()) != null) {
                List<DomainSharedLibraryType> libraries = slType.getSharedLibrary();
                for (DomainSharedLibraryType library : libraries) {
                    if (!library.getTimestamp().equals(BigInteger.valueOf(0L))) continue;
                    long timestamp = 0L;
                    String filename = this.mRegistry.getRepository().getArchive(ArchiveType.SHARED_LIBRARY, library.getName()).getPath();
                    File file = new File(filename);
                    timestamp = file.lastModified();
                    library.setTimestamp(BigInteger.valueOf(timestamp));
                }
            }
        }
        catch (RuntimeException rte) {
            this.mRegObjLM.releaseWriteLock();
            throw rte;
        }
        this.commit();
    }

    @Override
    public void setComponentAttribute(String componentName, String name, String value) throws RegistryException {
        this.setComponentAttribute(componentName, this.mThisTarget, name, value);
    }

    @Override
    public void setComponentAttribute(String componentName, String targetName, String name, String value) throws RegistryException {
        try {
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<PropertyType> properties = ccfg.getProperty();
                ArrayList<PropertyType> newProperties = new ArrayList<PropertyType>();
                PropertyType prop = this.mObjectFactory.createPropertyType();
                prop.setName(name);
                prop.setValue(value);
                newProperties.add(prop);
                this.merge(properties, newProperties);
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void setComponentAttributes(String componentName, Properties props) throws RegistryException {
        this.setComponentAttributes(componentName, this.mThisTarget, props);
    }

    @Override
    public void setComponentAttributes(String componentName, String targetName, Properties props) throws RegistryException {
        try {
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<PropertyType> properties = ccfg.getProperty();
                int numProps = props.size();
                ArrayList<PropertyType> newProperties = new ArrayList<PropertyType>();
                Iterator<Object> itr = props.keySet().iterator();
                while (itr.hasNext()) {
                    PropertyType prop = this.mObjectFactory.createPropertyType();
                    String key = (String)itr.next();
                    prop.setName(key);
                    prop.setValue((String)props.get(key));
                    newProperties.add(prop);
                }
                this.merge(properties, newProperties);
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void addComponentApplicationVariables(String componentName, ComponentInfo.Variable[] appVars) throws RegistryException {
        this.addComponentApplicationVariables(componentName, this.mThisTarget, appVars);
    }

    @Override
    public void addComponentApplicationVariables(String componentName, String targetName, ComponentInfo.Variable[] appVars) throws RegistryException {
        try {
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<AppVariableType> variables = ccfg.getApplicationVariable();
                for (ComponentInfo.Variable appVar : appVars) {
                    AppVariableType var = this.mObjectFactory.createAppVariableType();
                    var.setName(appVar.getName());
                    var.setValue(appVar.getValue() == null ? "null" : appVar.getValue());
                    var.setType(appVar.getType());
                    variables.add(var);
                }
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void updateComponentApplicationVariables(String componentName, ComponentInfo.Variable[] appVars) throws RegistryException {
        this.updateComponentApplicationVariables(componentName, this.mThisTarget, appVars);
    }

    @Override
    public void updateComponentApplicationVariables(String componentName, String targetName, ComponentInfo.Variable[] appVars) throws RegistryException {
        try {
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<AppVariableType> variables = ccfg.getApplicationVariable();
                for (ComponentInfo.Variable appVar : appVars) {
                    boolean updated = false;
                    for (AppVariableType var : variables) {
                        if (!var.getName().equals(appVar.getName())) continue;
                        var.setName(appVar.getName());
                        var.setValue(appVar.getValue() == null ? "null" : appVar.getValue());
                        var.setType(appVar.getType());
                        updated = true;
                        break;
                    }
                    if (updated) continue;
                    AppVariableType var = this.mObjectFactory.createAppVariableType();
                    var.setName(appVar.getName());
                    var.setValue(appVar.getValue() == null ? "null" : appVar.getValue());
                    var.setType(appVar.getType());
                    variables.add(var);
                }
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void deleteComponentApplicationVariables(String componentName, String[] names) throws RegistryException {
        this.deleteComponentApplicationVariables(componentName, this.mThisTarget, names);
    }

    @Override
    public void deleteComponentApplicationVariables(String componentName, String targetName, String[] names) throws RegistryException {
        try {
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<AppVariableType> variables = ccfg.getApplicationVariable();
                for (String name : names) {
                    AppVariableType tbd = null;
                    for (AppVariableType var : variables) {
                        if (!var.getName().equals(name)) continue;
                        tbd = var;
                        break;
                    }
                    if (tbd == null) continue;
                    variables.remove(tbd);
                }
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void addComponentApplicationConfiguration(String componentName, Properties appConfig) throws RegistryException {
        this.addComponentApplicationConfiguration(componentName, this.mThisTarget, appConfig);
    }

    @Override
    public void addComponentApplicationConfiguration(String componentName, String targetName, Properties appConfig) throws RegistryException {
        try {
            String configName = (String)appConfig.get("configurationName");
            if (configName == null) {
                String errMsg = this.mTranslator.getString("JBI_ADMIN_APP_CONFIG_PROPS_MISSING_NAME");
                throw new RegistryException(errMsg);
            }
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<AppConfigType> configs = ccfg.getApplicationConfiguration();
                AppConfigType cfg = this.mObjectFactory.createAppConfigType();
                List<PropertyType> cfgPropList = cfg.getProperty();
                Set<Object> keys = appConfig.keySet();
                for (Object key : keys) {
                    PropertyType prop = this.mObjectFactory.createPropertyType();
                    String propKey = (String)key;
                    prop.setName(propKey);
                    prop.setValue((String)appConfig.get(propKey));
                    cfgPropList.add(prop);
                }
                cfg.setName(configName);
                configs.add(cfg);
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void updateComponentApplicationConfiguration(String componentName, Properties appConfig) throws RegistryException {
        this.updateComponentApplicationConfiguration(componentName, this.mThisTarget, appConfig);
    }

    @Override
    public void updateComponentApplicationConfiguration(String componentName, String targetName, Properties appConfig) throws RegistryException {
        try {
            String configName = (String)appConfig.get("configurationName");
            if (configName == null) {
                String errMsg = this.mTranslator.getString("JBI_ADMIN_APP_CONFIG_PROPS_MISSING_NAME");
                throw new RegistryException(errMsg);
            }
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<AppConfigType> configs = ccfg.getApplicationConfiguration();
                AppConfigType oldCfg = null;
                for (AppConfigType config : configs) {
                    List<PropertyType> cfgPropList = config.getProperty();
                    if (!this.checkContainsProperty(cfgPropList, "configurationName", configName)) continue;
                    oldCfg = config;
                }
                if (oldCfg != null) {
                    List<PropertyType> cfgPropList = oldCfg.getProperty();
                    Set<Object> keys = appConfig.keySet();
                    for (Object key : keys) {
                        String propKey = (String)key;
                        Object valueObj = appConfig.get(propKey);
                        boolean keyFound = false;
                        if (valueObj == null) continue;
                        for (PropertyType prop : cfgPropList) {
                            if (!prop.getName().equals(propKey)) continue;
                            prop.setValue(valueObj.toString());
                            keyFound = true;
                        }
                        if (keyFound) continue;
                        PropertyType prop = this.mObjectFactory.createPropertyType();
                        prop.setName(propKey);
                        prop.setValue(valueObj.toString());
                        cfgPropList.add(prop);
                    }
                } else {
                    AppConfigType cfg = this.mObjectFactory.createAppConfigType();
                    List<PropertyType> cfgPropList = cfg.getProperty();
                    Set<Object> keys = appConfig.keySet();
                    for (Object key : keys) {
                        PropertyType prop = this.mObjectFactory.createPropertyType();
                        String propKey = (String)key;
                        prop.setName(propKey);
                        prop.setValue((String)appConfig.get(propKey));
                        cfgPropList.add(prop);
                    }
                    cfg.setName(configName);
                    configs.add(cfg);
                }
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    @Override
    public void deleteComponentApplicationConfiguration(String componentName, String appConfigName) throws RegistryException {
        this.deleteComponentApplicationConfiguration(componentName, this.mThisTarget, appConfigName);
    }

    @Override
    public void deleteComponentApplicationConfiguration(String componentName, String targetName, String appConfigName) throws RegistryException {
        try {
            ComponentRefType comp = this.mGenQuery.getComponent(componentName, targetName);
            this.mRegObjLM.acquireWriteLock();
            try {
                ComponentConfigType ccfg = comp.getComponentConfig();
                if (ccfg == null) {
                    ObjectFactory factory = new ObjectFactory();
                    ccfg = factory.createComponentConfigType();
                    comp.setComponentConfig(ccfg);
                }
                List<AppConfigType> configs = ccfg.getApplicationConfiguration();
                AppConfigType tbdCfg = null;
                for (AppConfigType config : configs) {
                    List<PropertyType> cfgPropList = config.getProperty();
                    if (!this.checkContainsProperty(cfgPropList, "configurationName", appConfigName)) continue;
                    tbdCfg = config;
                }
                if (tbdCfg != null) {
                    configs.remove(tbdCfg);
                }
            }
            catch (RuntimeException rte) {
                this.mRegObjLM.releaseWriteLock();
                throw rte;
            }
            this.commit();
        }
        catch (Exception jex) {
            throw new RegistryException(jex);
        }
    }

    private void deleteComponent(String componentName) {
        Components compType = this.mJbiRegistry.getComponents();
        if (compType != null) {
            DomainComponentType compToDel = null;
            List<DomainComponentType> components = compType.getComponent();
            for (DomainComponentType component : components) {
                if (!component.getName().equals(componentName)) continue;
                compToDel = component;
            }
            if (compToDel != null) {
                components.remove(compToDel);
            }
        }
    }

    private void deleteSharedLibrary(String sharedLibraryName) {
        SharedLibraries slType = this.mJbiRegistry.getSharedLibraries();
        if (slType != null) {
            DomainSharedLibraryType slToDel = null;
            List<DomainSharedLibraryType> sls = slType.getSharedLibrary();
            for (DomainSharedLibraryType sl : sls) {
                if (!sl.getName().equals(sharedLibraryName)) continue;
                slToDel = sl;
            }
            if (slToDel != null) {
                sls.remove(slToDel);
            }
        }
    }

    private void deleteServiceAssembly(String serviceAssemblyName) throws RegistryException {
        ServiceAssemblies saType = this.mJbiRegistry.getServiceAssemblies();
        if (saType != null) {
            DomainEntityType saToDel = null;
            List<DomainEntityType> sas = saType.getServiceAssembly();
            for (DomainEntityType sa : sas) {
                if (!sa.getName().equals(serviceAssemblyName)) continue;
                saToDel = sa;
            }
            if (saToDel != null) {
                sas.remove(saToDel);
            }
        }
    }

    private void addComponentRef(ComponentInfo compInfo, InstalledComponentsListType iclt) throws RegistryException {
        try {
            ComponentRefType compRef = ObjectTranslator.getJaxbComponentRef(compInfo);
            iclt.getComponentRef().add(compRef);
        }
        catch (JAXBException jex) {
            throw new RegistryException(jex);
        }
    }

    private void removeComponentRef(String componentName, InstalledComponentsListType iclt) {
        if (iclt != null) {
            ComponentRefType compToDel = null;
            List<ComponentRefType> components = iclt.getComponentRef();
            for (ComponentRefType component : components) {
                if (!component.getNameRef().equals(componentName)) continue;
                compToDel = component;
            }
            if (compToDel != null) {
                components.remove(compToDel);
            }
        }
    }

    private void addSharedLibraryRef(ComponentInfo slInfo, InstalledComponentsListType iclt) throws RegistryException {
        try {
            SharedLibraryRefType slRef = ObjectTranslator.getJaxbSharedLibraryRef(slInfo);
            iclt.getSharedLibraryRef().add(slRef);
        }
        catch (JAXBException jex) {
            throw new RegistryException(jex);
        }
    }

    private void removeSharedLibraryRef(String sharedLibraryName, InstalledComponentsListType iclt) {
        SharedLibraryRefType slToBeDeleted = null;
        if (iclt != null) {
            List<SharedLibraryRefType> sls = iclt.getSharedLibraryRef();
            for (SharedLibraryRefType sl : sls) {
                if (!sl.getNameRef().equals(sharedLibraryName)) continue;
                slToBeDeleted = sl;
            }
            if (slToBeDeleted != null) {
                sls.remove(slToBeDeleted);
            }
        }
    }

    private void addServiceAssemblyRef(String saName, InstalledComponentsListType iclt) throws RegistryException {
        try {
            ServiceAssemblyRefType saRef = ObjectTranslator.getJaxbServiceAssemblyRef(saName);
            iclt.getServiceAssemblyRef().add(saRef);
        }
        catch (JAXBException jex) {
            throw new RegistryException(jex);
        }
    }

    private void removeServiceAssemblyRef(String saName, InstalledComponentsListType iclt) {
        ServiceAssemblyRefType saToBeDeleted = null;
        if (iclt != null) {
            List<ServiceAssemblyRefType> sas = iclt.getServiceAssemblyRef();
            for (ServiceAssemblyRefType sa : sas) {
                if (!sa.getNameRef().equals(saName)) continue;
                saToBeDeleted = sa;
            }
            if (saToBeDeleted != null) {
                sas.remove(saToBeDeleted);
            }
        }
    }

    private void commit() throws RegistryException {
        this.mRegObjLM.downgradeWriteLock();
        try {
            this.mRegistry.commit();
        }
        catch (RegistryException rex) {
            throw rex;
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
    }

    private void merge(List<PropertyType> properties, List<PropertyType> newEntries) {
        for (PropertyType newProp : newEntries) {
            boolean replaced = false;
            for (PropertyType oldProp : properties) {
                if (!oldProp.getName().equals(newProp.getName())) continue;
                oldProp.setValue(newProp.getValue());
                replaced = true;
                break;
            }
            if (replaced) continue;
            properties.add(newProp);
        }
    }

    boolean checkContainsProperty(List<PropertyType> propList, String name, String value) {
        for (PropertyType prop : propList) {
            if (!prop.getName().equals(name) || !prop.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }
}

