/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.repository;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.descriptor.ServiceUnit;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

public class Archive {
    private static final String JBI_XML = "jbi.xml";
    private static final String JBI_XML_BASE = "jbi_";
    private static final String JBI_XML_EXT = ".xml";
    private static final String JBI_XML_DIR = "META-INF/";
    private static final String JBI_XML_PATH = "META-INF/jbi.xml";
    public static final String JBI_DESCRIPTOR_SCHEMA = "jbi.xsd";
    public static final String JBI_DESCRIPTOR_SCHEMA_DIR = "schemas";
    private Jbi mJbiXml;
    private Jbi mJbiXmlLocalized;
    private String mJbiXmlString = null;
    private String mJbiXmlStringLocalized;
    private ArchiveType mType;
    private String mPath;
    private String mJbiName;
    private String mFileName;
    private Calendar mUploadTimestamp;
    private Calendar mJbiXmlTimestamp;
    private BigInteger mSize;
    private HashMap mChildren = new HashMap();
    private boolean mRequiresValidation;
    private Unmarshaller mReader;
    private Marshaller mWriter;
    private File mDescSchema;

    public Archive(File archiveZip, boolean validate) throws IOException, RepositoryException {
        this.mRequiresValidation = validate;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.sun.jbi.management.descriptor", (ClassLoader)Class.forName("com.sun.jbi.management.descriptor.Jbi").getClassLoader());
            this.mReader = jc.createUnmarshaller();
            EnvironmentContext envCtx = EnvironmentAccess.getContext();
            File schemaDir = new File(envCtx.getJbiInstallRoot(), JBI_DESCRIPTOR_SCHEMA_DIR);
            this.mDescSchema = new File(schemaDir, JBI_DESCRIPTOR_SCHEMA);
            this.mReader.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.mDescSchema));
            this.mWriter = jc.createMarshaller();
            this.mWriter.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
        }
        catch (Exception ex) {
            throw new RepositoryException(ex.toString());
        }
        this.parseArchive(archiveZip);
        this.initJbiXmlString(false);
        this.initJbiXmlString(true);
    }

    public ArchiveType getType() {
        return this.mType;
    }

    public String getJbiName() {
        return this.mJbiName;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public String getPath() {
        return this.mPath;
    }

    public Jbi getJbiXml(boolean localized) {
        if (localized) {
            return this.mJbiXmlLocalized;
        }
        return this.mJbiXml;
    }

    public String getJbiXmlString(boolean localized) {
        if (localized) {
            return this.mJbiXmlStringLocalized;
        }
        return this.mJbiXmlString;
    }

    public Calendar getUploadTimestamp() {
        return this.mUploadTimestamp;
    }

    public BigInteger getSize() {
        return this.mSize;
    }

    public Calendar getJbiXmlTimestamp() {
        return this.mJbiXmlTimestamp;
    }

    public void setJbiName(String jbiName) {
        this.mJbiName = jbiName;
    }

    public void setUploadTimestamp(Calendar timestamp) {
        this.mUploadTimestamp = timestamp;
    }

    public void setPath(String path) {
        this.mPath = path;
    }

    public boolean hasChildren() {
        return !this.mChildren.isEmpty();
    }

    public Iterator listChildren() {
        return this.mChildren.keySet().iterator();
    }

    public String getChildPath(String name) {
        return (String)this.mChildren.get(name);
    }

    private ZipEntry getJbiXmlEntry(ZipFile archive, Locale locale) throws IOException {
        ZipEntry jbiXmlEntry;
        if (null != locale) {
            String jbiXmlPath = "META-INF/jbi_" + locale.toString() + JBI_XML_EXT;
            jbiXmlEntry = archive.getEntry(jbiXmlPath);
            if (null == jbiXmlEntry && null == (jbiXmlEntry = archive.getEntry(jbiXmlPath = "META-INF/jbi_" + locale.getLanguage() + JBI_XML_EXT))) {
                jbiXmlEntry = archive.getEntry(JBI_XML_PATH);
            }
        } else {
            jbiXmlEntry = archive.getEntry(JBI_XML_PATH);
        }
        return jbiXmlEntry;
    }

    private void parseArchive(File archiveFile) throws IOException, RepositoryException {
        ZipFile zip = new ZipFile(archiveFile);
        this.mPath = archiveFile.getAbsolutePath();
        this.mFileName = archiveFile.getName();
        ZipEntry jbiXmlEntry = this.getJbiXmlEntry(zip, null);
        ZipEntry jbiXmlEntryLocalized = this.getJbiXmlEntry(zip, Locale.getDefault());
        this.mSize = BigInteger.valueOf(archiveFile.length());
        try {
            if (jbiXmlEntry == null) {
                throw new FileNotFoundException(archiveFile.getName() + " : " + JBI_XML_PATH);
            }
            this.mJbiXml = this.loadJbiXml(archiveFile.getName(), zip.getInputStream(jbiXmlEntry));
            this.mJbiXmlLocalized = jbiXmlEntry == jbiXmlEntryLocalized ? this.mJbiXml : this.loadJbiXml(archiveFile.getName(), zip.getInputStream(jbiXmlEntryLocalized));
            this.parseJbiXml();
            if (this.mType.equals(ArchiveType.SERVICE_ASSEMBLY)) {
                this.processServiceUnits(zip);
            }
        }
        catch (IOException ioex) {
            throw new RepositoryException(ioex.toString());
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        this.mJbiXmlTimestamp = Calendar.getInstance();
        this.mJbiXmlTimestamp.setTimeInMillis(jbiXmlEntry.getTime());
    }

    private void parseJbiXml() {
        if (this.mJbiXml.getComponent() != null) {
            this.mJbiName = this.mJbiXml.getComponent().getIdentification().getName();
            this.mType = ArchiveType.COMPONENT;
        } else if (this.mJbiXml.getSharedLibrary() != null) {
            this.mJbiName = this.mJbiXml.getSharedLibrary().getIdentification().getName();
            this.mType = ArchiveType.SHARED_LIBRARY;
        } else if (this.mJbiXml.getServiceAssembly() != null) {
            this.mJbiName = this.mJbiXml.getServiceAssembly().getIdentification().getName();
            this.mType = ArchiveType.SERVICE_ASSEMBLY;
        } else {
            this.mType = ArchiveType.SERVICE_UNIT;
        }
    }

    private void processServiceUnits(ZipFile zip) throws IOException, RepositoryException {
        List<ServiceUnit> suList = this.mJbiXml.getServiceAssembly().getServiceUnit();
        for (int i = 0; i < suList.size(); ++i) {
            ServiceUnit su = suList.get(i);
            String suName = su.getIdentification().getName();
            String suPath = su.getTarget().getArtifactsZip();
            ZipEntry suZip = zip.getEntry(suPath);
            if (suZip == null) {
                throw new FileNotFoundException(this.localName(zip) + " : " + suPath);
            }
            InputStream suStream = this.getZipStream(zip.getInputStream(suZip), JBI_XML_PATH);
            if (suStream.available() <= 0) {
                throw new FileNotFoundException(suPath + " : " + JBI_XML_PATH);
            }
            this.loadJbiXml(suPath, suStream);
            this.mChildren.put(suName, suPath);
        }
    }

    private InputStream getZipStream(InputStream zipStream, String name) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(zipStream);
        while ((entry = zis.getNextEntry()) != null && !entry.getName().equals(name)) {
        }
        return zis;
    }

    private Jbi loadJbiXml(String entryName, InputStream jbiXmlStream) throws RepositoryException {
        Jbi jbiXml;
        try {
            jbiXml = (Jbi)this.mReader.unmarshal(jbiXmlStream);
        }
        catch (JAXBException jEx) {
            String message;
            String string = message = jEx.getLinkedException() != null ? jEx.getLinkedException().getMessage() : jEx.getMessage();
            if (message == null) {
                message = jEx.toString();
            }
            throw new RepositoryException("Schema validation failed for " + entryName + " : " + JBI_XML + ".  " + message);
        }
        return jbiXml;
    }

    private String localName(ZipFile zip) {
        return new File(zip.getName()).getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initJbiXmlString(boolean localized) throws RepositoryException {
        StringWriter sw = null;
        ZipFile zip = null;
        StreamSource source = null;
        StreamResult result = null;
        try {
            block16: {
                try {
                    zip = new ZipFile(new File(this.mPath));
                    ZipEntry jbiXmlEntry = localized ? this.getJbiXmlEntry(zip, Locale.getDefault()) : this.getJbiXmlEntry(zip, null);
                    TransformerFactory tF = TransformerFactory.newInstance();
                    Transformer tr = tF.newTransformer();
                    tr.setOutputProperty("indent", "yes");
                    source = new StreamSource(zip.getInputStream(jbiXmlEntry));
                    sw = new StringWriter();
                    result = new StreamResult(sw);
                    tr.transform(source, result);
                    if (sw == null) break block16;
                    if (localized) {
                        this.mJbiXmlStringLocalized = sw.toString();
                    } else {
                        this.mJbiXmlString = sw.toString();
                    }
                }
                catch (Exception ex) {
                    throw new RepositoryException(ex.toString());
                }
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (zip != null) {
                    zip.close();
                }
                if (sw != null) {
                    sw.close();
                }
                if (source != null && source.getInputStream() != null) {
                    source.getInputStream().close();
                }
                if (result == null) throw throwable;
                if (result.getOutputStream() == null) throw throwable;
                result.getOutputStream().close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        if (zip != null) {
            zip.close();
        }
        if (sw != null) {
            sw.close();
        }
        if (source != null && source.getInputStream() != null) {
            source.getInputStream().close();
        }
        if (result == null) return;
        if (result.getOutputStream() == null) return;
        result.getOutputStream().close();
        return;
    }
}

