/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.repository;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.repository.ArchiveDownloadMBean;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.Repository;
import com.sun.jbi.management.system.ManagementContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class ArchiveDownload
implements ArchiveDownloadMBean {
    private ManagementContext mContext;
    private StringTranslator mStrings;
    private Logger mLog;
    private HashMap mSessions;
    private Repository mRepository;
    private String mInstallRoot;

    public ArchiveDownload(ManagementContext ctx) {
        this.mContext = ctx;
        this.mSessions = new HashMap();
        this.mLog = ctx.getLogger();
        this.mRepository = ctx.getRepository();
        this.mStrings = ctx.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        this.mInstallRoot = new File(ctx.getEnvironmentContext().getJbiInstanceRoot()).getPath();
    }

    public Object getServiceAssemblyArchiveId(String saName) {
        return this.mRepository.getArchive(ArchiveType.SERVICE_ASSEMBLY, saName).getPath();
    }

    public Object getComponentArchiveId(String componentName) {
        return this.mRepository.getArchive(ArchiveType.COMPONENT, componentName).getPath();
    }

    public Object getSharedLibraryArchiveId(String sharedLibrayName) {
        return this.mRepository.getArchive(ArchiveType.SHARED_LIBRARY, sharedLibrayName).getPath();
    }

    public Object initiateRegistryDownload() throws IOException {
        try {
            String id = this.createUID();
            ArchiveDownload archiveDownload = this;
            this.mSessions.put(id, ((Registry)archiveDownload.mContext.getEnvironmentContext().getRegistry()).snapshot());
            return id;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public Object initiateDownload(Object archiveId) throws IOException {
        String file = (String)archiveId;
        File archive = new File(file);
        if (!archive.isAbsolute()) {
            file = this.mInstallRoot + File.separator + file;
            archive = new File(file);
        }
        if (file.startsWith(this.mInstallRoot)) {
            String id = this.createUID();
            if (!archive.exists()) {
                throw new IOException(this.mStrings.getString("JBI_ADMIN_DOWNLOAD_ARCHIVE_DOES_NOT_EXIST", archive.getPath()));
            }
            FileInputStream fis = new FileInputStream(archive);
            this.mSessions.put(id, fis);
            return id;
        }
        throw new IOException(this.mStrings.getString("JBI_ADMIN_DOWNLOAD_ARCHIVE_DOES_NOT_EXIST", file));
    }

    public byte[] downloadBytes(Object id, int length) throws IOException {
        byte[] bytes = new byte[length];
        int count = this.getDownloadStream(id).read(bytes);
        if (count <= 0) {
            bytes = new byte[]{};
        } else if (count != length) {
            byte[] tmp = new byte[count];
            System.arraycopy(bytes, 0, tmp, 0, count);
            bytes = tmp;
        }
        return bytes;
    }

    public void terminateDownload(Object id) throws IOException {
        this.getDownloadStream(id).close();
        this.mSessions.remove(id);
    }

    public void terminateAllDownloads() {
        try {
            Iterator ids = this.mSessions.keySet().iterator();
            while (ids.hasNext()) {
                this.terminateDownload(ids.next());
            }
        }
        catch (IOException ioEx) {
            this.mLog.warning(ioEx.getMessage());
        }
    }

    private InputStream getDownloadStream(Object id) throws IOException {
        InputStream is = (InputStream)this.mSessions.get(id);
        if (is == null) {
            throw new IOException(this.mStrings.getString("JBI_ADMIN_DOWNLOAD_ID_NOT_FOUND"));
        }
        return is;
    }

    private String createUID() {
        String uid = new UID().toString();
        if (uid.startsWith("-")) {
            uid = uid.substring(1);
        }
        return uid;
    }
}

