/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.repository;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.descriptor.ServiceUnit;
import com.sun.jbi.management.internal.support.DirectoryUtil;
import com.sun.jbi.management.internal.support.JarFactory;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.management.system.ManagementContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository {
    private static final String COMPONENT_STORE_NAME = "components";
    private static final String SHARED_LIBRARY_STORE_NAME = "shared-libraries";
    private static final String SERVICE_ASSEMBLY_STORE_NAME = "service-assemblies";
    private static final String TEMP_STORE_NAME = "tmp" + File.separator + "upload";
    private static final String INSTALL_ROOT = "install_root";
    private static final String APPLICATIONS_DIR = "applications";
    private static final String STRING_TRANSLATOR_NAME = "com.sun.jbi.management";
    private static final int BUFFER_SIZE = 8192;
    private StringTranslator mStrings;
    private ManagementContext mContext;
    private Logger mLog;
    protected static final String DIR_SUFFIX_PATTERN = "\\x2E\\d+";
    private File mComponentStore;
    private File mSharedLibraryStore;
    private File mServiceAssemblyStore;
    private File mTempStore;
    private long mRepositoryInitTime;
    private HashMap<String, Archive> mArchiveCache;

    public Repository(ManagementContext context) throws RepositoryException {
        this.mContext = context;
        this.mStrings = context.getEnvironmentContext().getStringTranslator(STRING_TRANSLATOR_NAME);
        this.mLog = context.getLogger();
        this.mArchiveCache = new HashMap();
        this.initStores();
    }

    public void cleanRepository() {
        this.cleanDirectory(this.mTempStore, false);
        this.removeDeletedArchives();
    }

    public void setRepositoryInitTime(long initTime) {
        this.mRepositoryInitTime = initTime;
    }

    public Archive addArchive(ArchiveType type, String path) throws RepositoryException {
        Archive archive;
        try {
            archive = new Archive(new File(path), true);
        }
        catch (IOException ioEx) {
            throw new RepositoryException(ioEx);
        }
        if (!archive.getType().equals(type)) {
            throw new RepositoryException(this.mStrings.getString("JBI_ADMIN_ARCHIVE_TYPE_MISMATCH", type.toString(), archive.getType().toString()));
        }
        this.addArchive(archive);
        return archive;
    }

    public synchronized void addArchive(Archive archive) throws RepositoryException {
        if (this.archiveExists(archive.getType(), archive.getJbiName())) {
            throw new RepositoryException(this.mStrings.getString("JBI_ADMIN_ARCHIVE_EXISTS", archive.getType().toString(), archive.getJbiName()));
        }
        this.addToRepository(archive);
        this.mArchiveCache.put(archive.getPath(), archive);
    }

    public boolean archiveExists(ArchiveType type, String name) {
        return this.getArchiveDirectory(type, name) != null;
    }

    public synchronized Archive getArchive(Object archiveId) {
        Archive archive = null;
        try {
            File file = new File((String)archiveId);
            if (file.exists()) {
                if (this.mArchiveCache.containsKey(archiveId)) {
                    return this.mArchiveCache.get(archiveId);
                }
                archive = new Archive(file, false);
                Calendar uploadTime = Calendar.getInstance();
                uploadTime.setTimeInMillis(file.lastModified());
                archive.setUploadTimestamp(uploadTime);
                if (archive.getType().equals(ArchiveType.SERVICE_UNIT)) {
                    archive.setJbiName(file.getParentFile().getName());
                }
                this.mArchiveCache.put(archive.getPath(), archive);
            }
        }
        catch (Exception ex) {
            this.mLog.info(ex.getMessage());
        }
        return archive;
    }

    public synchronized Archive getArchive(ArchiveType type, String name) {
        String path;
        Archive archive = null;
        archive = this.searchArchiveCache(type, name);
        if (archive == null && (path = this.findArchive(type, name)) != null) {
            archive = this.getArchive(path);
        }
        return archive;
    }

    public String findArchiveDirectory(ArchiveType type, String name) {
        String dirPath = null;
        File archiveDir = this.getArchiveDirectory(type, name);
        if (archiveDir != null && archiveDir.exists()) {
            dirPath = archiveDir.getAbsolutePath();
        }
        return dirPath;
    }

    public synchronized String findArchive(ArchiveType type, String name) {
        File[] files;
        String path = null;
        File archiveDir = this.getArchiveDirectory(type, name);
        if (archiveDir != null && archiveDir.exists() && (files = archiveDir.listFiles()).length >= 1) {
            int i;
            for (i = 0; i < files.length && files[i].isDirectory(); ++i) {
            }
            if (i != files.length) {
                path = files[i].getAbsolutePath();
            }
        }
        return path;
    }

    public synchronized void removeArchive(ArchiveType type, String name) throws RepositoryException {
        String dirPath = null;
        File dir = null;
        String path = this.findArchive(type, name);
        if (path == null) {
            this.mLog.warning(this.mStrings.getString("JBI_ADMIN_ARCHIVE_NOT_EXIST", type.toString(), name));
            dirPath = this.findArchiveDirectory(type, name);
            if (dirPath != null) {
                dir = new File(dirPath);
            }
        } else {
            File file = new File(path);
            dir = file.getParentFile();
        }
        if (dir != null && !DirectoryUtil.removeDir(dir.getAbsolutePath())) {
            this.mLog.fine(this.mStrings.getString("JBI_ADMIN_FILE_DELETE_FAILED", dir.getAbsolutePath()));
        }
        if (path != null) {
            this.mArchiveCache.remove(path);
            if (ArchiveType.SERVICE_ASSEMBLY.equals(type) && dir != null) {
                Set<String> allKeys = this.mArchiveCache.keySet();
                String[] allPaths = new String[allKeys.size()];
                for (String aPath : allPaths = allKeys.toArray(allPaths)) {
                    if (!aPath.startsWith(dir.getAbsolutePath())) continue;
                    this.mArchiveCache.remove(aPath);
                }
            }
        }
    }

    public File getTempStore() {
        return this.mTempStore;
    }

    public synchronized void purge() {
        this.mArchiveCache.clear();
        this.cleanDirectory(this.mComponentStore, true);
        this.cleanDirectory(this.mSharedLibraryStore, true);
        this.cleanDirectory(this.mServiceAssemblyStore, true);
        this.cleanDirectory(this.mTempStore, true);
    }

    public List<String> getArchiveEntityNames(ArchiveType type) {
        File dir = this.getStore(type);
        ArrayList<String> markedDirs = new ArrayList<String>();
        File[] subDirs = dir.listFiles();
        ArrayList<String> entityNames = new ArrayList<String>();
        for (File subDir : subDirs) {
            if (!subDir.isDirectory()) continue;
            if (!DirectoryUtil.isMarked(subDir)) {
                entityNames.add(subDir.getName());
                continue;
            }
            markedDirs.add(subDir.getName());
        }
        ArrayList<String> updatedEntityNames = new ArrayList<String>();
        for (String dirName : entityNames) {
            int dotIndex = dirName.lastIndexOf(46);
            if (dotIndex != -1) {
                String name = dirName.substring(0, dotIndex);
                String suffix = dirName.substring(dotIndex, dirName.length());
                if (this.isSuffix(suffix)) {
                    int suffixedInt = Integer.parseInt(dirName.substring(dotIndex + 1, dirName.length()));
                    String prevSuffix = Integer.toString(suffixedInt - 1);
                    StringBuffer prevMarkedDirName = new StringBuffer(name);
                    if (suffixedInt > 1) {
                        prevMarkedDirName.append(".");
                        prevMarkedDirName.append(prevSuffix);
                    }
                    if (markedDirs.contains(prevMarkedDirName.toString())) {
                        dirName = name;
                    }
                }
            }
            updatedEntityNames.add(dirName);
        }
        return updatedEntityNames;
    }

    private void removeDeletedArchives() {
        DirectoryUtil.removeMarkedDirs(this.mComponentStore.getAbsolutePath());
        DirectoryUtil.removeMarkedDirs(this.mSharedLibraryStore.getAbsolutePath());
        DirectoryUtil.removeMarkedDirs(this.mServiceAssemblyStore.getAbsolutePath());
    }

    private void initStores() throws RepositoryException {
        Repository repository = this;
        String jbiInstallRoot = repository.mContext.getEnvironmentContext().getJbiInstanceRoot();
        Repository repository2 = this;
        String jbiHome = repository2.mContext.getEnvironmentContext().getJbiInstallRoot();
        try {
            this.mComponentStore = this.loadStore(jbiInstallRoot, COMPONENT_STORE_NAME);
            this.mSharedLibraryStore = this.loadStore(jbiInstallRoot, SHARED_LIBRARY_STORE_NAME);
            this.mTempStore = this.loadStore(jbiInstallRoot, TEMP_STORE_NAME);
            this.mServiceAssemblyStore = this.loadStore(jbiInstallRoot, SERVICE_ASSEMBLY_STORE_NAME);
        }
        catch (IOException ioEx) {
            throw new RepositoryException(ioEx);
        }
    }

    private void addToRepository(Archive archive) throws RepositoryException {
        long timestamp;
        File archiveDir = this.createArchiveDirectory(archive.getType(), archive.getJbiName());
        File archiveZip = new File(archiveDir, archive.getFileName());
        File archiveFile = new File(archive.getPath());
        try {
            this.transfer(new FileInputStream(archiveFile), new FileOutputStream(archiveZip));
            timestamp = archiveFile.lastModified();
            archiveZip.setLastModified(timestamp);
            archive.setPath(archiveZip.getAbsolutePath());
            if (archive.getType().equals(ArchiveType.SERVICE_ASSEMBLY)) {
                this.extractServiceUnits(archive);
            }
        }
        catch (IOException ioEx) {
            throw new RepositoryException(ioEx);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        archive.setUploadTimestamp(calendar);
        if (!archive.getType().equals(ArchiveType.SERVICE_ASSEMBLY)) {
            File archiveInstallRoot = new File(archiveDir, INSTALL_ROOT);
            this.extractArchive(archiveInstallRoot, archiveZip);
        }
    }

    private void extractArchive(File parentDir, File archiveZip) throws RepositoryException {
        parentDir.mkdir();
        try {
            JarFactory jarHelper = new JarFactory(parentDir.getAbsolutePath());
            jarHelper.unJar(archiveZip);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    private boolean cleanDirectory(File dir, boolean all) {
        File[] tmps = dir.listFiles();
        boolean cleaned = true;
        for (int i = 0; i < tmps.length; ++i) {
            if (all || tmps[i].lastModified() < this.mRepositoryInitTime) {
                if (tmps[i].isDirectory() && !this.cleanDirectory(tmps[i], all)) {
                    return false;
                }
                if (tmps[i].delete()) continue;
                this.mLog.warning(this.mStrings.getString("JBI_ADMIN_FILE_DELETE_FAILED", tmps[i].getAbsolutePath()));
                return false;
            }
            cleaned = false;
        }
        return cleaned;
    }

    private void finalizeDiscardedObjects() {
        System.gc();
        System.runFinalization();
    }

    private File loadStore(String root, String name) throws IOException {
        File dir = new File(root + File.separator + name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private File getStore(ArchiveType type) {
        File store = null;
        if (type.equals(ArchiveType.COMPONENT)) {
            store = this.mComponentStore;
        } else if (type.equals(ArchiveType.SHARED_LIBRARY)) {
            store = this.mSharedLibraryStore;
        } else if (type.equals(ArchiveType.SERVICE_ASSEMBLY)) {
            store = this.mServiceAssemblyStore;
        } else if (type.equals(ArchiveType.SERVICE_UNIT)) {
            store = this.mServiceAssemblyStore;
        }
        return store;
    }

    private void transfer(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[8192];
        int count = 0;
        while (count > -1) {
            output.write(buf, 0, count);
            count = input.read(buf);
        }
        output.flush();
        input.close();
        output.close();
    }

    private void extractServiceUnits(Archive archive) throws IOException, RepositoryException {
        String targetComponent = null;
        ZipFile zip = new ZipFile(archive.getPath());
        Iterator suList = archive.listChildren();
        while (suList.hasNext()) {
            String suName = (String)suList.next();
            ZipEntry entry = zip.getEntry(archive.getChildPath(suName));
            File suDir = new File(this.getArchiveDirectory(ArchiveType.SERVICE_ASSEMBLY, archive.getJbiName()), suName);
            suDir.mkdir();
            File suFile = new File(suDir, archive.getChildPath(suName));
            this.transfer(zip.getInputStream(entry), new FileOutputStream(suFile));
            List<ServiceUnit> sus = archive.getJbiXml(false).getServiceAssembly().getServiceUnit();
            for (ServiceUnit su : sus) {
                if (!su.getIdentification().getName().equals(suName)) continue;
                targetComponent = su.getTarget().getComponentName();
            }
            File suComponentDir = new File(suDir, targetComponent);
            this.extractArchive(suComponentDir, suFile);
        }
        zip.close();
    }

    private File createArchiveDirectory(ArchiveType type, String name) {
        File archiveDir = new File(this.getStore(type), name);
        if (archiveDir.exists()) {
            int i = 1;
            while (archiveDir.exists()) {
                archiveDir = new File(this.getStore(type), name + "." + i);
                ++i;
            }
        }
        archiveDir.mkdir();
        return archiveDir;
    }

    private File getArchiveDirectory(ArchiveType type, String name) {
        File archiveDir = null;
        String dirName = null;
        if (type.equals(ArchiveType.SERVICE_UNIT)) {
            name = name.replace('\\', '/');
            dirName = this.extractServiceAssemblyName(name);
        } else {
            dirName = name;
        }
        Archive cachedArchive = this.searchArchiveCache(type, dirName);
        if (cachedArchive != null) {
            archiveDir = new File(cachedArchive.getPath()).getParentFile();
        } else {
            File tmpDir = new File(this.getStore(type), dirName);
            if (tmpDir.exists() && !DirectoryUtil.isMarked(tmpDir)) {
                archiveDir = tmpDir;
            } else {
                Pattern namePattern = Pattern.compile(dirName + DIR_SUFFIX_PATTERN);
                File[] dirs = DirectoryUtil.listFiles(this.getStore(type), namePattern);
                if (dirs != null) {
                    for (File file : dirs) {
                        if (!file.isDirectory() || DirectoryUtil.isMarked(file)) continue;
                        archiveDir = file;
                        break;
                    }
                }
            }
        }
        if (type.equals(ArchiveType.SERVICE_UNIT)) {
            String suName = this.extractServiceUnitName(name);
            archiveDir = new File(archiveDir, suName);
        }
        return archiveDir;
    }

    private Archive searchArchiveCache(ArchiveType type, String name) {
        Set<String> keys = this.mArchiveCache.keySet();
        for (String key : keys) {
            Archive archive = this.mArchiveCache.get(key);
            if (!archive.getType().equals(type) || !archive.getJbiName().equals(name)) continue;
            return archive;
        }
        return null;
    }

    private String extractServiceUnitName(String relativeName) {
        String suName = relativeName;
        int fSlash = relativeName.indexOf(47);
        if (fSlash != -1) {
            suName = relativeName.substring(fSlash + 1, relativeName.length());
        }
        return suName;
    }

    private String extractServiceAssemblyName(String relativeName) {
        String saName = relativeName;
        int fSlash = relativeName.indexOf(47);
        if (fSlash != -1) {
            saName = relativeName.substring(0, fSlash);
        }
        return saName;
    }

    private String stripSuffix(String dirName) {
        int dotIndex = dirName.lastIndexOf(46);
        if (dotIndex != -1) {
            String name = dirName.substring(0, dotIndex);
            String suffix = dirName.substring(dotIndex, dirName.length());
            if (this.isSuffix(suffix)) {
                return name;
            }
        }
        return dirName;
    }

    private boolean isSuffix(String suffix) {
        Pattern suffixPattern = Pattern.compile(DIR_SUFFIX_PATTERN);
        return suffixPattern.matcher(suffix).matches();
    }
}

