/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.support;

import com.sun.jbi.ComponentType;
import com.sun.jbi.management.MBeanNames;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanNamesImpl
implements MBeanNames {
    public static final String JBI_DOMAIN = "com.sun.jbi";
    public static final String SERVICE_TYPE_KEY = "ServiceType";
    public static final String SERVICE_NAME_KEY = "ServiceName";
    private static final String TARGET_KEY = "Target";
    private static final String COMPONENT_NAME_KEY = "ComponentName";
    private static final String EQUAL = "=";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private String mDomainName;
    private String mInstanceName;

    public MBeanNamesImpl(String jmxDomain, String instanceName) {
        this.mDomainName = jmxDomain;
        this.mInstanceName = instanceName;
    }

    public String getJmxDomainName() {
        return this.mDomainName;
    }

    public ObjectName createCustomComponentMBeanName(String customName) {
        return null;
    }

    public ObjectName getComponentMBeanName(String compName, ComponentType compType, MBeanNames.ComponentServiceType serviceType, String target) {
        ObjectName mbn;
        switch (compType) {
            case BINDING: {
                mbn = this.getBindingMBeanName(compName, serviceType, target);
                break;
            }
            case ENGINE: {
                mbn = this.getEngineMBeanName(compName, serviceType, target);
                break;
            }
            default: {
                throw new IllegalArgumentException(compType.toString());
            }
        }
        return mbn;
    }

    public ObjectName getBindingMBeanName(String bindingName, String controlType) {
        String tmp = this.createBindingMBeanName(null, bindingName, controlType);
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    public ObjectName getCustomBindingMBeanName(String customName, String bindingName) {
        String tmp = this.createBindingMBeanName(customName, bindingName, "Custom");
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    public ObjectName getCustomEngineMBeanName(String customName, String engineName) {
        String tmp = this.createEngineMBeanName(customName, engineName, "Custom");
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    public ObjectName getEngineMBeanName(String engineName, String controlType) {
        String tmp = this.createEngineMBeanName(null, engineName, controlType);
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    public ObjectName getSystemServiceMBeanName(String serviceName, String type) {
        String tmp = this.createSystemServiceMBeanName(serviceName, type);
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    public ObjectName getSystemServiceMBeanName(String serviceName, String type, String instanceName) {
        String tmp = this.createSystemServiceMBeanNameForInstance(serviceName, type, instanceName);
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    public ObjectName getSystemServiceLoggerMBeanName(String name, Logger logger) {
        String tmp = this.createSystemServiceLoggerMBeanName(name, logger.getName());
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    public String getJbiInstanceName() {
        return this.mInstanceName;
    }

    public ObjectName getLocalSystemServiceMBeanName(String name, String type) {
        String tmp = this.createLocalSystemServiceMBeanName(name, type);
        ObjectName mbname = null;
        try {
            mbname = new ObjectName(tmp);
        }
        catch (Exception e) {
            mbname = null;
            e.printStackTrace();
        }
        return mbname;
    }

    private String createSystemServiceMBeanName(String aServiceName, String aControlType) {
        String tmp = this.mDomainName;
        tmp = tmp + ":JbiName=" + this.mInstanceName;
        tmp = tmp + ",ServiceName=" + aServiceName;
        tmp = tmp + ",ControlType=" + aControlType;
        tmp = tmp + ",ComponentType=System";
        return tmp;
    }

    private String createSystemServiceMBeanNameForInstance(String aServiceName, String aControlType, String anInstanceName) {
        String tmp = this.mDomainName;
        tmp = tmp + ":JbiName=" + anInstanceName;
        tmp = tmp + ",ServiceName=" + aServiceName;
        tmp = tmp + ",ControlType=" + aControlType;
        tmp = tmp + ",ComponentType=System";
        return tmp;
    }

    private String createLocalSystemServiceMBeanName(String aServiceName, String aControlType) {
        String tmp = this.mDomainName;
        tmp = tmp + ":ServiceName=" + aServiceName;
        tmp = tmp + ",ControlType=" + aControlType;
        tmp = tmp + ",ComponentType=System";
        return tmp;
    }

    private String createSystemServiceLoggerMBeanName(String aServiceName, String aLoggerName) {
        String tmp = this.mDomainName;
        tmp = tmp + ":JbiName=" + this.mInstanceName;
        tmp = tmp + ",ServiceName=" + aServiceName;
        tmp = tmp + ",ControlType=Logger";
        tmp = tmp + ",ComponentType=System";
        tmp = tmp + ",LoggerName=" + aLoggerName;
        return tmp;
    }

    private String createEngineMBeanName(String aCustomName, String theName, String aControlType) {
        return this.createComponentMBeanName(aCustomName, "Engine", theName, aControlType);
    }

    private String createBindingMBeanName(String aCustomName, String theName, String aControlType) {
        return this.createComponentMBeanName(aCustomName, "Binding", theName, aControlType);
    }

    private String createComponentMBeanName(String aCustomName, String aType, String theName, String aControlType) {
        String tmp = this.mDomainName;
        tmp = tmp + ":JbiName=" + this.mInstanceName;
        if (null != aCustomName && "Logger" != aControlType) {
            tmp = tmp + ",CustomControlName=" + aCustomName;
        }
        tmp = tmp + ",ComponentName=" + theName;
        tmp = tmp + ",ControlType=" + aControlType;
        tmp = tmp + ",ComponentType=Installed";
        tmp = tmp + ",InstalledType=" + aType;
        if ("Logger" == aControlType && null != aCustomName) {
            tmp = tmp + ",LoggerName=" + aCustomName;
        }
        return tmp;
    }

    public ObjectName getBindingMBeanName(String bindingName, MBeanNames.ComponentServiceType serviceType, String target) {
        String adminMBeanName = "com.sun.jbi:Target=" + target + COMMA + SERVICE_TYPE_KEY + EQUAL + serviceType.toString() + COMMA + COMPONENT_NAME_KEY + EQUAL + bindingName;
        try {
            return new ObjectName(adminMBeanName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ObjectName getEngineMBeanName(String engineName, MBeanNames.ComponentServiceType serviceType, String target) {
        String adminMBeanName = "com.sun.jbi:Target=" + target + COMMA + SERVICE_TYPE_KEY + EQUAL + serviceType.toString() + COMMA + COMPONENT_NAME_KEY + EQUAL + engineName;
        try {
            return new ObjectName(adminMBeanName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ObjectName getSystemServiceMBeanName(MBeanNames.ServiceName serviceName, MBeanNames.ServiceType serviceType, String target) {
        String adminMBeanName = "com.sun.jbi:Target=" + target + COMMA + SERVICE_NAME_KEY + EQUAL + serviceName.toString() + COMMA + SERVICE_TYPE_KEY + EQUAL + serviceType.toString();
        try {
            return new ObjectName(adminMBeanName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ObjectName getCustomComponentMBeanNameFilter(String instanceName, String customName, String componentName) {
        StringBuffer customMBeanFilter = new StringBuffer(this.mDomainName);
        customMBeanFilter.append(":JbiName=" + instanceName);
        customMBeanFilter.append(",CustomControlName=" + customName);
        customMBeanFilter.append(",ComponentName=" + componentName);
        customMBeanFilter.append(",ControlType=Custom");
        customMBeanFilter.append(",*");
        try {
            return new ObjectName(customMBeanFilter.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ObjectName getComponentLoggerMBeanNameFilter(String instanceName, String componentName) {
        StringBuffer customMBeanFilter = new StringBuffer(this.mDomainName);
        customMBeanFilter.append(":JbiName=" + instanceName);
        customMBeanFilter.append(",ComponentName=" + componentName);
        customMBeanFilter.append(",ControlType=Logger");
        customMBeanFilter.append(",*");
        try {
            return new ObjectName(customMBeanFilter.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ObjectName getComponentExtensionFacadeMBeanName(String componentName, String target) {
        ObjectName extensionMBeanObjectName = null;
        StringBuffer objNameBuff = new StringBuffer("com.sun.jbi:");
        objNameBuff.append("Target=" + target);
        objNameBuff.append(",ComponentName=" + componentName);
        objNameBuff.append(",ServiceType=" + (Object)((Object)MBeanNames.ComponentServiceType.Extension));
        try {
            extensionMBeanObjectName = new ObjectName(objNameBuff.toString());
        }
        catch (MalformedObjectNameException exception) {
            extensionMBeanObjectName = null;
        }
        return extensionMBeanObjectName;
    }
}

