/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime.verifier;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.runtime.verifier.EndpointInfo;
import com.sun.jbi.ui.runtime.verifier.VerifierException;
import com.sun.jbi.ui.runtime.verifier.util.TemplateGenerator;
import com.sun.jbi.ui.runtime.verifier.util.VerifierUtils;
import com.sun.jbi.util.ComponentConfigurationHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIApplicationVerifier {
    private EnvironmentContext mEnvCtx;
    private I18NBundle mResourceBundle;
    private String mTarget;
    private Map<String, ComponentState> mStartedComponents = new HashMap<String, ComponentState>();
    private List<String> mMissingComponents = new ArrayList<String>();
    private VerifierUtils mVerifierUtil;
    private static final String EQUAL = "=";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String JAVAEE_SERVICE_ENGINE = "sun-javaee-engine";
    private static final String JAVAEE_VERIFIER = "JavaEEVerifier";
    private boolean mGenerateTemplates = false;
    private boolean mIncludeDeployCommand = false;
    private Map<String, List<String>> mAppVarTemplatesMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> mAppConfigTemplatesMap = new HashMap<String, List<String>>();
    private Map<String, CompositeType> mAppConfigTypeMap = new HashMap<String, CompositeType>();
    private Map<String, Map<String, Object>> mAppVarValuesMap;
    private Map<String, Map<String, Properties>> mAppConfigValuesMap;
    private Map<String, String> mSUNameToZipEntryName;
    private String REPOSITORY_SA_STORE = "jbi" + File.separator + "service-assemblies";
    private MBeanNames mBeanNames = null;
    private static String TEMPLATE_DIR_SUFFIX = "-templates";
    static String[] ENDPOINT_DATA_ITEM_NAMES = new String[]{"EndpointName", "ServiceUnitName", "ComponentName", "Status", "MissingApplicationVariables", "MissingApplicationConfigurations"};
    static String[] ENDPOINT_DATA_ITEM_DESCRIPTIONS = new String[]{"Endpoint Name", "Service Unit Name", "Component Name", "Status of the endpoint", "List of missing application variables", "List of missing application configurations"};
    static String[] JAVAEE_VERIFIER_ITEM_NAMES = new String[]{"ServiceUnitName", "JavaEEVerifierReport"};
    static String[] JAVAEE_VERIFIER_ITEM_DESCRIPTIONS = new String[]{"Service Unit Name", "JavaEE Verification Report"};
    static String STATUS_UNRESOLVED = "UNRESOLVED";
    static String STATUS_RESOLVED = "RESOLVED";
    static String STATUS_UNKNOWN = "UNKNOWN";
    static String STATUS_UNCONFIGURED = "UNRESOLVED";

    public JBIApplicationVerifier(EnvironmentContext envCtx) {
        this.mEnvCtx = envCtx;
        this.mResourceBundle = new I18NBundle("com.sun.jbi.ui.runtime.verifier");
        this.mVerifierUtil = new VerifierUtils(this.mResourceBundle);
        this.mBeanNames = envCtx.getMBeanNames();
    }

    public CompositeData verifyApplication(String applicationURL, String targetName, boolean generateTemplates, String templateDir, boolean includeDeployCommand, String clientSAFilePath) throws JBIRemoteException {
        JBIArchive archive;
        ToolsLogManager.getRuntimeLogger().finer("Verifier entered with SA " + applicationURL);
        if (applicationURL == null || applicationURL.length() == 0) {
            String message = this.mResourceBundle.getMessage("VERIFIER_INVALID_INPUT");
            ToolsLogManager.getRuntimeLogger().info(message);
            throw new JBIRemoteException(message);
        }
        this.mTarget = targetName;
        this.mGenerateTemplates = generateTemplates;
        this.mIncludeDeployCommand = includeDeployCommand;
        try {
            archive = new JBIArchive(applicationURL);
            this.mSUNameToZipEntryName = this.mVerifierUtil.getSUJarEntryMap(archive);
        }
        catch (Exception ex) {
            ToolsLogManager.getRuntimeLogger().info(ex.getMessage());
            throw new JBIRemoteException(ex.getMessage());
        }
        if (!archive.isServiceAssemblyArchive()) {
            String message = this.mResourceBundle.getMessage("VERIFIER_INVALID_SA");
            ToolsLogManager.getRuntimeLogger().info(message);
            throw new JBIRemoteException(message);
        }
        try {
            String[] saInfo = this.getSAInfo(archive);
            String[] missingComponents = this.validateComponentList(archive, targetName);
            for (int i = 0; i < missingComponents.length; ++i) {
                this.mMissingComponents.add(missingComponents[i]);
            }
            CompositeData[] javaEEVerifierReports = null;
            if (this.isJavaEEVerifierAvailable()) {
                javaEEVerifierReports = this.verifyJavaEEServiceUnits(applicationURL, archive, targetName);
            } else {
                ToolsLogManager.getRuntimeLogger().fine("JavaEE Verifier MBean is not available");
            }
            CompositeData[] endpointData = this.getEndpointsInfo(archive);
            String zipFile = null;
            String saName = saInfo[0];
            if (this.mGenerateTemplates) {
                boolean isAnt = true;
                TemplateGenerator generator = new TemplateGenerator(this.mEnvCtx, this.mResourceBundle);
                zipFile = generator.generateTemplates(this.mAppVarTemplatesMap, this.mAppConfigTemplatesMap, this.mAppConfigTypeMap, this.mIncludeDeployCommand, this.mTarget, isAnt, saName, clientSAFilePath);
            }
            CompositeData response = this.composeResponse(saInfo, missingComponents, endpointData, javaEEVerifierReports, zipFile);
            return response;
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
            }
            throw new JBIRemoteException(ex);
        }
    }

    public String[] validateComponentList(JBIArchive archive, String targetName) throws JBIRemoteException {
        ToolsLogManager.getRuntimeLogger().finer("Validating component list");
        try {
            List components = this.getComponentListForSA(archive);
            ArrayList<String> missingComponents = new ArrayList<String>();
            ComponentQuery componentQuery = this.mEnvCtx.getComponentQuery(targetName);
            List existingComponents = componentQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
            for (String component : components) {
                if (existingComponents.contains(component)) continue;
                missingComponents.add(component);
                ToolsLogManager.getRuntimeLogger().finer("Component " + component + " is not installed");
            }
            return missingComponents.toArray(new String[missingComponents.size()]);
        }
        catch (Exception ex) {
            throw new JBIRemoteException(ex.getMessage());
        }
    }

    private String[] getSAInfo(JBIArchive archive) throws JBIRemoteException {
        ToolsLogManager.getRuntimeLogger().finer("Getting info from the SA ");
        try {
            ServiceAssemblyDD saDesc = (ServiceAssemblyDD)archive.getJbiDescriptor();
            return new String[]{saDesc.getName(), saDesc.getDescription(), Integer.toString(saDesc.getServiceUnitDDList().size())};
        }
        catch (Exception ex) {
            throw new JBIRemoteException(ex.getMessage());
        }
    }

    private CompositeData composeResponse(String[] saInfo, String[] missingComponents, CompositeData[] endpointData, CompositeData[] javaEEVerifierReports, String zipID) throws JBIRemoteException {
        ToolsLogManager.getRuntimeLogger().finer("Composing verifier response ");
        try {
            OpenType[] ENDPOINT_DATA_ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING)};
            CompositeType endpointInfoType = new CompositeType("EndpointInfoType", "Provides information about an endpoint", ENDPOINT_DATA_ITEM_NAMES, ENDPOINT_DATA_ITEM_DESCRIPTIONS, ENDPOINT_DATA_ITEM_TYPES);
            ToolsLogManager.getRuntimeLogger().finer("Composed endpoint info type");
            CompositeType javaEEVerifierReportType = null;
            if (javaEEVerifierReports != null && javaEEVerifierReports.length > 0 && javaEEVerifierReports[0] != null) {
                javaEEVerifierReportType = javaEEVerifierReports[0].getCompositeType();
                ToolsLogManager.getRuntimeLogger().finer("Composed javaee verifier report type");
            }
            ArrayList<String> verifierReportItemNames = new ArrayList<String>();
            verifierReportItemNames.add("ServiceAssemblyName");
            verifierReportItemNames.add("ServiceAssemblyDescription");
            verifierReportItemNames.add("NumServiceUnits");
            verifierReportItemNames.add("AllComponentsInstalled");
            verifierReportItemNames.add("MissingComponentsList");
            verifierReportItemNames.add("EndpointInfo");
            verifierReportItemNames.add("TemplateZIPID");
            if (javaEEVerifierReportType != null) {
                verifierReportItemNames.add("JavaEEVerifierReport");
            }
            ArrayList<String> verifierReportItemDescriptions = new ArrayList<String>();
            verifierReportItemDescriptions.add("Name of the Service Assembly");
            verifierReportItemDescriptions.add("Description of the Service Assembly");
            verifierReportItemDescriptions.add("Number of Service Units");
            verifierReportItemDescriptions.add("Are all necessary components installed");
            verifierReportItemDescriptions.add("List of missing components");
            verifierReportItemDescriptions.add("Information about the endpoints");
            verifierReportItemDescriptions.add("Id for the zip file with configuration templates");
            if (javaEEVerifierReportType != null) {
                verifierReportItemDescriptions.add("Java EE Verifier Reports");
            }
            ArrayList<OpenType> verifierReportItemTypes = new ArrayList<OpenType>();
            verifierReportItemTypes.add(SimpleType.STRING);
            verifierReportItemTypes.add(SimpleType.STRING);
            verifierReportItemTypes.add(SimpleType.INTEGER);
            verifierReportItemTypes.add(SimpleType.BOOLEAN);
            verifierReportItemTypes.add(new ArrayType(1, SimpleType.STRING));
            verifierReportItemTypes.add(new ArrayType(1, endpointInfoType));
            verifierReportItemTypes.add(SimpleType.STRING);
            if (javaEEVerifierReportType != null) {
                verifierReportItemTypes.add(new ArrayType(1, javaEEVerifierReportType));
            }
            CompositeType verifierReportType = new CompositeType("VerifierReportType", "Type of the verification report", verifierReportItemNames.toArray(new String[0]), verifierReportItemDescriptions.toArray(new String[0]), verifierReportItemTypes.toArray(new OpenType[0]));
            ArrayList<Object> verifierReportValues = new ArrayList<Object>();
            verifierReportValues.add(saInfo[0]);
            verifierReportValues.add(saInfo[1]);
            verifierReportValues.add(Integer.valueOf(saInfo[2]));
            verifierReportValues.add(new Boolean(missingComponents.length == 0));
            verifierReportValues.add(missingComponents);
            verifierReportValues.add(endpointData);
            verifierReportValues.add(zipID);
            if (javaEEVerifierReportType != null) {
                verifierReportValues.add(javaEEVerifierReports);
            }
            CompositeDataSupport cData = new CompositeDataSupport(verifierReportType, verifierReportItemNames.toArray(new String[0]), verifierReportValues.toArray(new Object[0]));
            ToolsLogManager.getRuntimeLogger().finer("Verifier Report: " + cData);
            return cData;
        }
        catch (OpenDataException ode) {
            if (ode.getMessage() != null) {
                ToolsLogManager.getRuntimeLogger().warning(ode.getMessage());
            }
            throw new JBIRemoteException(ode.getMessage());
        }
    }

    private CompositeData[] getEndpointsInfo(JBIArchive archive) throws JBIRemoteException {
        try {
            OpenType[] ENDPOINT_DATA_ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING)};
            CompositeType endpointInfoType = new CompositeType("EndpointInfoType", "Provides information about an endpoint", ENDPOINT_DATA_ITEM_NAMES, ENDPOINT_DATA_ITEM_DESCRIPTIONS, ENDPOINT_DATA_ITEM_TYPES);
            Map<String, EndpointInfo> endpointInfo = this.getEndpointDetails(archive);
            CompositeData[] endpointArray = new CompositeData[endpointInfo.keySet().size()];
            Iterator<String> endpointsIter = endpointInfo.keySet().iterator();
            int counter = 0;
            EndpointInfo endpoint = null;
            while (endpointsIter.hasNext()) {
                try {
                    endpoint = endpointInfo.get(endpointsIter.next());
                    String status = null;
                    String[] missingVars = new String[]{};
                    String[] missingConfigs = new String[]{};
                    if (!this.isComponentRunning(endpoint.getComponentName(), this.mTarget)) {
                        status = STATUS_UNKNOWN;
                    } else {
                        if (this.supportsAppVars(endpoint.getComponentName(), this.mTarget)) {
                            missingVars = this.getMissingApplicationVariables(endpoint);
                        }
                        if (this.supportsAppConfig(endpoint.getComponentName(), this.mTarget)) {
                            missingConfigs = this.getMissingApplicationConfigurations(endpoint);
                        }
                        status = this.getEndpointStatus(endpoint, missingVars, missingConfigs);
                    }
                    Object[] endpointValues = new Object[]{endpoint.getEndpointName(), endpoint.getServiceUnitName(), endpoint.getComponentName(), status, missingVars, missingConfigs};
                    CompositeDataSupport endpointData = new CompositeDataSupport(endpointInfoType, ENDPOINT_DATA_ITEM_NAMES, endpointValues);
                    endpointArray[counter] = endpointData;
                    ++counter;
                }
                catch (VerifierException ve) {
                    ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("VERIFIER_ENDPOINT_STATUS_NOT_DETERMINED", new Object[]{endpoint.getEndpointName()}));
                    if (ve.getMessage() == null) continue;
                    ToolsLogManager.getRuntimeLogger().warning(ve.getMessage());
                }
                catch (Throwable jRE) {
                    ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("VERIFIER_ENDPOINT_STATUS_NOT_DETERMINED", new Object[]{endpoint.getEndpointName()}));
                    if (jRE.getMessage() == null) continue;
                    ToolsLogManager.getRuntimeLogger().warning(jRE.getMessage());
                }
            }
            for (String componentName : this.mStartedComponents.keySet()) {
                this.revertComponentState(componentName, this.mStartedComponents.get(componentName), this.mTarget);
            }
            return endpointArray;
        }
        catch (OpenDataException ode) {
            throw new JBIRemoteException(ode.getMessage());
        }
        catch (VerifierException ve) {
            throw new JBIRemoteException(ve.getMessage());
        }
    }

    private List getComponentListForSA(JBIArchive archive) throws JBIRemoteException {
        try {
            ServiceAssemblyDD saDesc = (ServiceAssemblyDD)archive.getJbiDescriptor();
            List suDescs = saDesc.getServiceUnitDDList();
            ArrayList<String> components = new ArrayList<String>();
            for (ServiceAssemblyDD.ServiceUnitDD suDesc : suDescs) {
                components.add(suDesc.getTargetName());
            }
            return components;
        }
        catch (Exception ex) {
            throw new JBIRemoteException(ex.getMessage());
        }
    }

    private String getTargetComponentForSU(JBIArchive archive, String suName) throws VerifierException {
        try {
            ServiceAssemblyDD saDesc = (ServiceAssemblyDD)archive.getJbiDescriptor();
            List suDescs = saDesc.getServiceUnitDDList();
            ArrayList components = new ArrayList();
            for (ServiceAssemblyDD.ServiceUnitDD suDesc : suDescs) {
                if (!suDesc.getName().equals(suName)) continue;
                return suDesc.getTargetName();
            }
            return null;
        }
        catch (Exception ex) {
            throw new VerifierException(ex);
        }
    }

    private Map<String, EndpointInfo> getEndpointDetails(JBIArchive archive) throws VerifierException, JBIRemoteException {
        try {
            HashMap<String, EndpointInfo> endpointDetails = new HashMap<String, EndpointInfo>();
            Map<String, String[]> wsdlMap = this.mVerifierUtil.getWSDLs(archive);
            Iterator<String> iterSuNames = wsdlMap.keySet().iterator();
            while (iterSuNames.hasNext()) {
                try {
                    String suName = iterSuNames.next();
                    String targetComponent = this.getTargetComponentForSU(archive, suName);
                    if (targetComponent != null && targetComponent.equals(JAVAEE_SERVICE_ENGINE)) continue;
                    ToolsLogManager.getRuntimeLogger().finer("Collecting details of endpoints in " + suName);
                    String[] wsdls = wsdlMap.get(suName);
                    Map<String, List<String>> appConfigMap = this.mVerifierUtil.getEndpointConfigMap(archive, this.mSUNameToZipEntryName.get(suName));
                    for (int j = 0; j < wsdls.length; ++j) {
                        try {
                            if ("".compareTo(wsdls[j]) == 0) continue;
                            String[] endpointNames = this.mVerifierUtil.getEndpointName(wsdls[j]);
                            for (int i = 0; i < endpointNames.length; ++i) {
                                String componentName = this.getTargetComponentForSU(archive, suName);
                                List appVarList = this.mVerifierUtil.getApplicationVariables(wsdls[j], endpointNames[i]);
                                List<String> appConfigList = appConfigMap.get(endpointNames[i]);
                                EndpointInfo endpointInfo = new EndpointInfo();
                                endpointInfo.setEndpointName(endpointNames[i]);
                                endpointInfo.setServiceUnitName(suName);
                                endpointInfo.setComponentName(componentName);
                                endpointInfo.setApplicationVariables(appVarList);
                                endpointInfo.setApplicationConfigurations(appConfigList);
                                if (!(appVarList != null && appVarList.size() != 0 || appConfigList != null && appConfigList.size() != 0)) {
                                    endpointInfo.setEndpointConfigured(this.mVerifierUtil.isPortConfiguredForEndpoint(wsdls[j], endpointNames[i]));
                                } else {
                                    endpointInfo.setEndpointConfigured(true);
                                }
                                if (endpointDetails.containsKey(endpointNames[i])) {
                                    ComponentType newComponentType = this.getComponentType(componentName);
                                    ComponentType oldComponentType = this.getComponentType(((EndpointInfo)endpointDetails.get(endpointNames[i])).getComponentName());
                                    if (oldComponentType.equals((Object)ComponentType.ENGINE) && newComponentType.equals((Object)ComponentType.BINDING)) {
                                        endpointDetails.put(endpointNames[i], endpointInfo);
                                        ToolsLogManager.getRuntimeLogger().finer("Endpoint found in more than 1 wsdl, adding endpoint for component " + componentName);
                                    }
                                } else {
                                    endpointDetails.put(endpointNames[i], endpointInfo);
                                }
                                ToolsLogManager.getRuntimeLogger().finer("Discovered endpoint: " + endpointInfo);
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            if (ex.getMessage() == null) continue;
                            ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
                        }
                    }
                }
                catch (Exception ex) {
                    if (ex.getMessage() == null) continue;
                    ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
                }
            }
            return endpointDetails;
        }
        catch (VerifierException ex) {
            if (ex.getMessage() != null) {
                ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
            }
            throw ex;
        }
    }

    private ComponentType getComponentType(String componentName) throws VerifierException {
        try {
            ComponentQuery componentQuery = this.mEnvCtx.getComponentQuery(this.mTarget);
            ComponentInfo compInfo = componentQuery.getComponentInfo(componentName);
            return compInfo.getComponentType();
        }
        catch (Exception ex) {
            throw new VerifierException(ex.getMessage());
        }
    }

    private String getEndpointStatus(EndpointInfo endpointInfo, String[] missingAppVars, String[] missingAppConfigs) throws VerifierException, JBIRemoteException {
        if (this.mMissingComponents.contains(endpointInfo.getComponentName())) {
            return STATUS_UNKNOWN;
        }
        if (!endpointInfo.getEndpointConfigured()) {
            return STATUS_UNCONFIGURED;
        }
        if (!(missingAppVars != null && missingAppVars.length != 0 || missingAppConfigs != null && missingAppConfigs.length != 0)) {
            return STATUS_RESOLVED;
        }
        return STATUS_UNRESOLVED;
    }

    private String[] getMissingApplicationVariables(EndpointInfo endpoint) throws VerifierException, JBIRemoteException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        ArrayList<String> unresolvedVars = new ArrayList<String>();
        String componentName = endpoint.getComponentName();
        List tmpAppVarList = endpoint.getApplicationVariables();
        List<String> appVarList = this.removeComponentConfigurations(tmpAppVarList, componentName);
        if (this.mMissingComponents.contains(componentName)) {
            return new String[0];
        }
        Properties applicationVariables = this.getApplicationVariables(componentName, this.mTarget);
        Set<Object> existingApplicationVariables = applicationVariables.keySet();
        ToolsLogManager.getRuntimeLogger().finer("List of application vars for component" + existingApplicationVariables);
        for (String variable : appVarList) {
            if (existingApplicationVariables.contains(variable)) continue;
            unresolvedVars.add(variable);
        }
        List appConfigList = endpoint.getApplicationConfigurations();
        if (appConfigList != null) {
            Set applicationConfigurations = this.getApplicationConfigurations(componentName, this.mTarget);
            for (String config : appConfigList) {
                if (!applicationConfigurations.contains(config)) continue;
                List<String> referredVars = this.getAppVarReferencedInAppConfig(componentName, config);
                for (String var : referredVars) {
                    if (existingApplicationVariables.contains(var)) continue;
                    unresolvedVars.add(var);
                }
            }
        }
        if (this.mGenerateTemplates) {
            List<String> currentVars = this.mAppVarTemplatesMap.containsKey(componentName) ? this.mAppVarTemplatesMap.get(componentName) : new ArrayList<String>();
            currentVars.addAll(unresolvedVars);
            this.mAppVarTemplatesMap.put(componentName, currentVars);
        }
        return unresolvedVars.toArray(new String[0]);
    }

    private String[] getMissingApplicationConfigurations(EndpointInfo endpoint) throws VerifierException, JBIRemoteException {
        ArrayList<String> unresolvedConfigs = new ArrayList<String>();
        String componentName = endpoint.getComponentName();
        List appConfigList = endpoint.getApplicationConfigurations();
        if (this.mMissingComponents.contains(componentName)) {
            return new String[0];
        }
        Set applicationConfigurations = this.getApplicationConfigurations(componentName, this.mTarget);
        ToolsLogManager.getRuntimeLogger().finer("List of application configs for component" + applicationConfigurations);
        if (appConfigList != null) {
            for (String config : appConfigList) {
                if (applicationConfigurations.contains(config)) continue;
                unresolvedConfigs.add(config);
            }
        }
        if (this.mGenerateTemplates) {
            List<String> currentConfigs = this.mAppConfigTemplatesMap.containsKey(componentName) ? this.mAppConfigTemplatesMap.get(componentName) : new ArrayList<String>();
            currentConfigs.addAll(unresolvedConfigs);
            this.mAppConfigTemplatesMap.put(componentName, currentConfigs);
            this.mAppConfigTypeMap.put(componentName, this.getAppConfigType(componentName, this.mTarget));
        }
        return unresolvedConfigs.toArray(new String[0]);
    }

    private List<String> getAppVarReferencedInAppConfig(String component, String configName) {
        ArrayList<String> varsList;
        block4: {
            varsList = new ArrayList<String>();
            try {
                Map<String, Properties> appConfigMap = this.getApplicationConfigurationsAsMap(component, this.mTarget);
                Properties configValue = appConfigMap.get(configName);
                if (configValue != null) {
                    for (Object key : configValue.keySet()) {
                        varsList.addAll(this.mVerifierUtil.getAppVars((String)configValue.get(key)));
                    }
                }
            }
            catch (VerifierException vex) {
                if (vex.getMessage() == null) break block4;
                ToolsLogManager.getRuntimeLogger().warning(vex.getMessage());
            }
        }
        return varsList;
    }

    private List<String> removeComponentConfigurations(List<String> theList, String componentName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, JBIRemoteException, VerifierException {
        ArrayList<String> returnList = new ArrayList<String>(theList);
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, this.mTarget);
        MBeanServer mbeanServer = this.mEnvCtx.getMBeanServer();
        MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(configFacadeMBean);
        MBeanAttributeInfo[] mbeanAttrInfoArray = mbeanInfo.getAttributes();
        for (String varName : theList) {
            if (varName == null) continue;
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray) {
                String key = "" + attributeInfo.getName();
                if (varName == null || varName.trim().compareTo(key) != 0) continue;
                returnList.remove(varName);
            }
        }
        return returnList;
    }

    private Properties getApplicationVariables(String componentName, String targetName) throws VerifierException, JBIRemoteException {
        Properties appVarProps = new Properties();
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ToolsLogManager.getRuntimeLogger().finer("getApplicationVariables(" + componentName + COMMA + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                TabularData appVarTable = (TabularData)this.getAttributeValue(configFacadeMBean, "ApplicationVariables");
                appVarProps = new ComponentConfigurationHelper().convertToApplicationVariablesProperties(appVarTable);
                ToolsLogManager.getRuntimeLogger().finer("getApplicationVariables(): result = " + appVarProps);
            }
            catch (JBIRemoteException jbiRE) {
                throw new VerifierException(jbiRE);
            }
            catch (Exception ex) {
                throw new VerifierException(ex);
            }
        }
        return appVarProps;
    }

    private Set getApplicationConfigurations(String componentName, String target) throws VerifierException, JBIRemoteException {
        Map<Object, Object> appConfigMap;
        block4: {
            appConfigMap = new HashMap();
            ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, target);
            ToolsLogManager.getRuntimeLogger().finer("getApplicationConfigurations" + componentName + COMMA + target + "): configMBean = " + configFacadeMBean);
            if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
                try {
                    TabularData appConfigTable = (TabularData)this.getAttributeValue(configFacadeMBean, "ApplicationConfigurations");
                    if (appConfigTable != null) {
                        appConfigMap = this.getApplicationConfigurationsMap(appConfigTable);
                    }
                }
                catch (Throwable ex) {
                    if (ex.getMessage() == null) break block4;
                    ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
                }
            }
        }
        return appConfigMap.keySet();
    }

    private CompositeType getAppConfigType(String componentName, String target) throws VerifierException, JBIRemoteException {
        CompositeType appConfigType;
        block3: {
            appConfigType = null;
            ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, target);
            ToolsLogManager.getRuntimeLogger().finer("getAppConfigType" + componentName + COMMA + target + "): configMBean = " + configFacadeMBean);
            if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
                try {
                    appConfigType = (CompositeType)this.invokeMBeanOperation(configFacadeMBean, "queryApplicationConfigurationType", new Object[0], new String[0]);
                }
                catch (Exception ex) {
                    if (ex.getMessage() == null) break block3;
                    ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
                }
            }
        }
        return appConfigType;
    }

    public boolean isComponentRunning(String componentName, String target) {
        ComponentQuery compQuery = this.mEnvCtx.getComponentQuery(target);
        ComponentInfo compInfo = compQuery.getComponentInfo(componentName);
        if (compInfo == null) {
            return false;
        }
        ComponentState compState = compInfo.getStatus();
        if (compState.equals((Object)ComponentState.STARTED)) {
            return true;
        }
        if (this.mEnvCtx.isStartOnVerifyEnabled() && this.startComponent(componentName, target)) {
            this.mStartedComponents.put(componentName, compState);
            return true;
        }
        return false;
    }

    private boolean startComponent(String componentName, String targetName) {
        try {
            ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
            Object result = null;
            ToolsLogManager.getRuntimeLogger().finer("Calling start on Component LifecycleMBean " + lifecycleObjectName);
            result = this.invokeMBeanOperation(lifecycleObjectName, "start", new Object[0], new String[0]);
            return true;
        }
        catch (Exception ex) {
            ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("VERIFIER_COMPONENT_NOT_STARTED", new Object[]{componentName}));
            if (ex.getMessage() != null) {
                ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
            }
            return false;
        }
    }

    private boolean supportsAppConfig(String componentName, String target) throws VerifierException, JBIRemoteException {
        Boolean supported;
        block3: {
            ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, target);
            ToolsLogManager.getRuntimeLogger().finer("supportsAppConfig" + componentName + COMMA + target + "): configMBean = " + configFacadeMBean);
            supported = Boolean.FALSE;
            if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
                try {
                    supported = (Boolean)this.invokeMBeanOperation(configFacadeMBean, "isAppConfigSupported", new Object[0], new String[0]);
                }
                catch (Throwable ex) {
                    if (ex.getMessage() == null) break block3;
                    ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
                }
            }
        }
        return supported;
    }

    private boolean supportsAppVars(String componentName, String target) throws VerifierException, JBIRemoteException {
        Boolean supported;
        block3: {
            ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, target);
            ToolsLogManager.getRuntimeLogger().finer("supportsAppVars" + componentName + COMMA + target + "): configMBean = " + configFacadeMBean);
            supported = Boolean.FALSE;
            if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
                try {
                    supported = (Boolean)this.invokeMBeanOperation(configFacadeMBean, "isAppVarsSupported", new Object[0], new String[0]);
                }
                catch (Throwable ex) {
                    if (ex.getMessage() == null) break block3;
                    ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
                }
            }
        }
        return supported;
    }

    private boolean revertComponentState(String componentName, ComponentState compState, String targetName) {
        try {
            ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
            String lifecycleMethodName = "shutDown";
            if (compState.equals((Object)ComponentState.STOPPED)) {
                lifecycleMethodName = "stop";
            }
            Object result = null;
            ToolsLogManager.getRuntimeLogger().finer("Calling shutdown on Component LifecycleMBean " + lifecycleObjectName);
            result = this.invokeMBeanOperation(lifecycleObjectName, lifecycleMethodName, new Object[0], new String[0]);
            return true;
        }
        catch (Exception ex) {
            ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("VERIFIER_COMPONENT_NOT_SHUTDOWN", new Object[]{componentName}));
            if (ex.getMessage() != null) {
                ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
            }
            return false;
        }
    }

    private ObjectName getComponentLifeCycleMBeanObjectName(String componentName, String targetName) throws VerifierException {
        ObjectName lifecycleObjectNamePattern = null;
        try {
            lifecycleObjectNamePattern = JBIJMXObjectNames.getComponentLifeCycleMBeanObjectNamePattern(componentName, targetName);
        }
        catch (MalformedObjectNameException ex) {
            throw new VerifierException(ex);
        }
        MBeanServer mbeanServer = this.mEnvCtx.getMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(lifecycleObjectNamePattern, null);
        if (objectNames.isEmpty()) {
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_NO_COMPONENT_LIFECYCLE_OBJECT", new Object[]{componentName, targetName}));
        }
        if (objectNames.size() > 1) {
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_MANY_COMPONENT_LIFECYCLE_OBJECT", new Object[]{componentName, targetName}));
        }
        ObjectName lifecyleObjectName = objectNames.iterator().next();
        return lifecyleObjectName;
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvCtx.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.invoke(objectName, operationName, params, signature);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JBIRemoteException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new JBIRemoteException(rEx);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw JBIRemoteException.filterJmxExceptions(ex);
        }
        return result;
    }

    private ObjectName getComponentConfigurationFacadeMBeanName(String componentName, String targetName) throws JBIRemoteException, VerifierException {
        ObjectName extensionMBeanObjectName;
        ObjectName objName;
        block3: {
            objName = null;
            ToolsLogManager.getRuntimeLogger().finer("Get Component Configuration MBean Name for component " + componentName);
            extensionMBeanObjectName = null;
            try {
                extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, targetName);
            }
            catch (VerifierException exception) {
                if (exception.getMessage() == null) break block3;
                ToolsLogManager.getRuntimeLogger().warning(exception.getMessage());
            }
        }
        if (extensionMBeanObjectName == null) {
            return objName;
        }
        this.checkForValidTarget(extensionMBeanObjectName, targetName);
        ToolsLogManager.getRuntimeLogger().finer("Calling getComponentConfigurationFacadeMBeanName on extensionMBeanObjectName = " + extensionMBeanObjectName);
        Object[] params = new Object[]{targetName};
        String[] signature = new String[]{"java.lang.String"};
        objName = (ObjectName)this.invokeMBeanOperation(extensionMBeanObjectName, "getComponentConfigurationFacadeMBeanName", params, signature);
        return objName;
    }

    public ObjectName getExtensionMBeanObjectName(String componentName, String targetName) throws VerifierException {
        ObjectName extensionMBeanObjectNamePattern = null;
        MBeanNames mbeanNames = this.mEnvCtx.getMBeanNames();
        String objectNamePatternString = "com.sun.jbi:Target=" + targetName + COMMA + "ComponentName" + EQUAL + componentName + COMMA + "ServiceType" + EQUAL + (Object)((Object)MBeanNames.ComponentServiceType.Extension);
        try {
            extensionMBeanObjectNamePattern = new ObjectName(objectNamePatternString);
        }
        catch (MalformedObjectNameException exception) {
            return null;
        }
        catch (NullPointerException exception) {
            return null;
        }
        MBeanServer mbeanServer = this.mEnvCtx.getMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(extensionMBeanObjectNamePattern, null);
        if (objectNames.isEmpty()) {
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_NO_COMPONENT_EXTENSION_OBJECT", new Object[]{componentName, extensionMBeanObjectNamePattern.toString()}));
        }
        if (objectNames.size() > 1) {
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_MANY_COMPONENT_EXTENSION_OBJECT", new Object[]{componentName, extensionMBeanObjectNamePattern.toString()}));
        }
        ObjectName extensionMBeanObjectName = null;
        extensionMBeanObjectName = objectNames.iterator().next();
        ToolsLogManager.getRuntimeLogger().finer("extensionMBeanObjectName Found : " + extensionMBeanObjectName);
        return extensionMBeanObjectName;
    }

    boolean isValidTarget(ObjectName objectName) throws JBIRemoteException {
        boolean result = false;
        MBeanServer mbeanServer = this.mEnvCtx.getMBeanServer();
        try {
            result = mbeanServer.isRegistered(objectName);
        }
        catch (RuntimeException exception) {
            // empty catch block
        }
        return result;
    }

    protected Object getAttributeValue(ObjectName objectName, String attributeName) throws JBIRemoteException {
        MBeanServer mbeanServer = this.mEnvCtx.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new JBIRemoteException(e);
        }
        catch (MBeanException e) {
            throw new JBIRemoteException(e);
        }
        catch (ReflectionException e) {
            throw new JBIRemoteException(e);
        }
        return result;
    }

    void checkForValidTarget(ObjectName objectName, String targetName) throws JBIRemoteException {
        boolean isRegistered = this.isValidTarget(objectName);
        if (!isRegistered) {
            String[] args = new String[]{targetName};
            throw new JBIRemoteException(this.mResourceBundle.getMessage("VERIFIER_INVALID_MBEAN", new Object[]{objectName, targetName}));
        }
    }

    private Map<String, Properties> getApplicationConfigurationsMap(TabularData td) {
        HashMap<String, Properties> configMap = new HashMap<String, Properties>();
        Set<?> configKeys = td.keySet();
        for (Object configKey : configKeys) {
            List keyList = (List)configKey;
            Object[] index = new String[keyList.size()];
            index = keyList.toArray(index);
            CompositeData cd = td.get(index);
            Properties configProps = new ComponentConfigurationHelper().convertCompositeDataToProperties(cd);
            configMap.put((String)index[0], configProps);
        }
        return configMap;
    }

    private boolean isJavaEEVerifierAvailable() {
        try {
            return this.isValidTarget(this.getJavaEEVerifierMBeanName());
        }
        catch (MalformedObjectNameException malformedObjEx) {}
        catch (JBIRemoteException jbiRe) {}
        finally {
            return false;
        }
    }

    private ObjectName getJavaEEVerifierMBeanName() throws MalformedObjectNameException {
        return new ObjectName("com.sun.jbi:" + "ServiceName" + EQUAL + JAVAEE_VERIFIER + COMMA + "ComponentType" + EQUAL + "System");
    }

    private CompositeData[] verifyJavaEEServiceUnits(String saPath, JBIArchive archive, String target) {
        try {
            ServiceAssemblyDD saDesc = (ServiceAssemblyDD)archive.getJbiDescriptor();
            List suDescs = saDesc.getServiceUnitDDList();
            ArrayList<CompositeData> verifierReports = new ArrayList<CompositeData>();
            for (ServiceAssemblyDD.ServiceUnitDD suDesc : suDescs) {
                String targetComponent = suDesc.getTargetName();
                String suName = suDesc.getName();
                if (targetComponent == null || !targetComponent.equals(JAVAEE_SERVICE_ENGINE)) continue;
                TabularData verifierReport = this.verifyJavaEEServiceUnit(saPath, suDesc.getArtifactZipName(), target);
                CompositeData formattedReport = this.formatJavaEEVerifierReport(suName, verifierReport);
                verifierReports.add(formattedReport);
            }
            return verifierReports.toArray(new CompositeData[0]);
        }
        catch (Throwable ex) {
            ToolsLogManager.getRuntimeLogger().log(Level.INFO, this.mResourceBundle.getMessage("VERIFIER_JAVAEE_VERIFICATION_FAILED"), ex);
            return null;
        }
    }

    private TabularData verifyJavaEEServiceUnit(String saPath, String suZipName, String target) throws Exception {
        try {
            if (saPath == null || suZipName == null) {
                ToolsLogManager.getRuntimeLogger().warning(this.mResourceBundle.getMessage("VERIFIER_JAVAEE_EAR_FILE_NOT_FOUND"));
                return null;
            }
            ToolsLogManager.getRuntimeLogger().finer("Invoking JavaEEVerifier with : " + saPath + suZipName);
            TabularData verifierReport = (TabularData)this.invokeMBeanOperation(this.getJavaEEVerifierMBeanName(), "verifyServiceUnit", new Object[]{saPath, suZipName, target}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
            return verifierReport;
        }
        catch (Throwable t) {
            ToolsLogManager.getRuntimeLogger().log(Level.INFO, this.mResourceBundle.getMessage("VERIFIER_JAVAEE_VERIFICATION_FAILED"), t);
            return null;
        }
    }

    private CompositeData formatJavaEEVerifierReport(String suName, TabularData verifierReport) {
        try {
            CompositeDataSupport formattedReport = null;
            if (verifierReport != null) {
                OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, verifierReport.getTabularType()};
                Object[] values = new Object[]{suName, verifierReport};
                CompositeType cType = new CompositeType("JavaEEVerifier Report", "Java EE Verifier Report", JAVAEE_VERIFIER_ITEM_NAMES, JAVAEE_VERIFIER_ITEM_DESCRIPTIONS, itemTypes);
                formattedReport = new CompositeDataSupport(cType, JAVAEE_VERIFIER_ITEM_NAMES, values);
            }
            return formattedReport;
        }
        catch (OpenDataException oe) {
            if (oe.getMessage() != null) {
                ToolsLogManager.getRuntimeLogger().warning(oe.getMessage());
            }
            return null;
        }
    }

    public String exportApplicationConfiguration(String applicationName, String targetName, String configDir) throws JBIRemoteException {
        this.mTarget = targetName;
        if (!this.isApplicationDeployedOnTarget(applicationName, targetName)) {
            String message = this.mResourceBundle.getMessage("VERIFIER_EXPORT_CONFIG_APP_NOT_DEPLOYED", new Object[]{applicationName, targetName});
            ToolsLogManager.getRuntimeLogger().warning(message);
            throw new JBIRemoteException(message);
        }
        String zipFile = null;
        try {
            String saDir = this.locateInRepository(applicationName);
            ToolsLogManager.getRuntimeLogger().finer("Located Service Assembly in: " + saDir);
            this.mAppVarTemplatesMap = this.getApplicationVariablesMap(applicationName, saDir);
            ToolsLogManager.getRuntimeLogger().finer("Created list of application variables " + this.mAppVarTemplatesMap);
            this.mAppConfigTemplatesMap = this.getApplicationConfigsMap(applicationName, saDir);
            ToolsLogManager.getRuntimeLogger().finer("Created list of application configs " + this.mAppConfigTemplatesMap);
            if (this.mAppConfigTemplatesMap != null) {
                for (String component : this.mAppConfigTemplatesMap.keySet()) {
                    ArrayList<String> referredVars = new ArrayList<String>();
                    for (String config : this.mAppConfigTemplatesMap.get(component)) {
                        referredVars.addAll(this.getAppVarReferencedInAppConfig(component, config));
                    }
                    List<String> tmpAppVarList = this.mAppVarTemplatesMap.get(component);
                    List<String> appVars = this.removeComponentConfigurations(tmpAppVarList, component);
                    appVars.addAll(referredVars);
                    this.mAppVarTemplatesMap.put(component, appVars);
                }
            }
            this.mAppConfigTypeMap = this.getAppConfigTypeMap(this.mAppConfigTemplatesMap.keySet());
            ToolsLogManager.getRuntimeLogger().finer("Created list of application config types ");
            this.mAppVarValuesMap = this.getAppVarsValueMap(this.mAppVarTemplatesMap, targetName);
            this.mAppConfigValuesMap = this.getAppConfigValuesMap(this.mAppConfigTemplatesMap, targetName);
            TemplateGenerator generator = new TemplateGenerator(this.mEnvCtx, this.mResourceBundle);
            zipFile = generator.generateTemplates(this.mAppVarTemplatesMap, this.mAppConfigTemplatesMap, this.mAppConfigTypeMap, false, this.mTarget, true, applicationName, null, true, this.mAppVarValuesMap, this.mAppConfigValuesMap);
            ToolsLogManager.getRuntimeLogger().finer("Generated templates in " + zipFile);
        }
        catch (Throwable th) {
            String message = this.mResourceBundle.getMessage("VERIFIER_ERROR_EXPORTING_APP_CONFIG");
            ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, th);
            throw new JBIRemoteException(message);
        }
        return zipFile;
    }

    private Map<String, List<String>> getApplicationVariablesMap(String applicationName, String saDir) {
        HashMap<String, List<String>> appVarMap = new HashMap<String, List<String>>();
        try {
            Map<String, File[]> susWsdlMap = this.mVerifierUtil.getWSDLs(saDir);
            Map<String, String> suCompMap = this.getServiceUnitComponentMap(applicationName, this.mTarget);
            for (String serviceUnit : susWsdlMap.keySet()) {
                String component = suCompMap.get(serviceUnit);
                if (component == null || component.equals(JAVAEE_SERVICE_ENGINE)) continue;
                ArrayList appVarListForComponent = new ArrayList();
                File[] wsdls = susWsdlMap.get(serviceUnit);
                for (int j = 0; j < wsdls.length; ++j) {
                    try {
                        String[] endpointNames = this.mVerifierUtil.getEndpointName(wsdls[j]);
                        for (int iter = 0; iter < endpointNames.length; ++iter) {
                            appVarListForComponent.addAll(this.mVerifierUtil.getApplicationVariables(wsdls[j], endpointNames[iter]));
                        }
                        continue;
                    }
                    catch (VerifierException ex) {
                        // empty catch block
                    }
                }
                appVarMap.put(component, appVarListForComponent);
                ToolsLogManager.getRuntimeLogger().finer("Application Variables List for Component " + component + " is " + appVarListForComponent);
            }
        }
        catch (Exception ex) {
            String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_COLLECTING_LIST_OF_APP_VARS", new Object[]{applicationName});
            ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, ex);
        }
        return appVarMap;
    }

    private Map<String, List<String>> getApplicationConfigsMap(String applicationName, String saDir) {
        HashMap<String, List<String>> appConfigMap;
        block6: {
            appConfigMap = new HashMap<String, List<String>>();
            try {
                Map<String, String> suCompNameMap = this.getServiceUnitComponentMap(applicationName, this.mTarget);
                for (String serviceUnitName : suCompNameMap.keySet()) {
                    try {
                        String component = suCompNameMap.get(serviceUnitName);
                        if (component == null || component.equals(JAVAEE_SERVICE_ENGINE)) continue;
                        String suDir = saDir + File.separator + serviceUnitName + File.separator + component;
                        Map<String, List<String>> endpointConfigMap = this.mVerifierUtil.getEndpointConfigMap(suDir);
                        ArrayList appConfigListForComponent = new ArrayList();
                        for (String endpointName : endpointConfigMap.keySet()) {
                            List<String> configs = endpointConfigMap.get(endpointName);
                            if (configs == null) continue;
                            appConfigListForComponent.addAll(endpointConfigMap.get(endpointName));
                        }
                        appConfigMap.put(component, appConfigListForComponent);
                    }
                    catch (VerifierException vEx) {
                        if (vEx.getMessage() == null) continue;
                        ToolsLogManager.getRuntimeLogger().warning(vEx.getMessage());
                    }
                }
            }
            catch (Exception vEx) {
                String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_COLLECTING_LIST_OF_APP_CONFIGS", new Object[]{applicationName});
                if (vEx.getMessage() == null) break block6;
                ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, vEx);
            }
        }
        return appConfigMap;
    }

    private boolean isApplicationDeployedOnTarget(String applicationName, String target) {
        try {
            String[] saList = (String[])this.getAttributeValue(this.getDeploymentServiceFacadeMBeanName(target), "DeployedServiceAssemblies");
            if (saList != null) {
                for (int i = 0; i < saList.length; ++i) {
                    if (!applicationName.equals(saList[i])) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable ex) {
            if (ex.getMessage() != null) {
                ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
            }
            return false;
        }
    }

    private String locateInRepository(String saName) throws VerifierException {
        try {
            File saStore = new File(this.mEnvCtx.getAppServerInstanceRoot(), this.REPOSITORY_SA_STORE);
            File saDir = new File(saStore, saName);
            if (saDir.exists()) {
                return saDir.getAbsolutePath();
            }
            throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_APPLICATION_NOT_LOCATED", new Object[]{saName}));
        }
        catch (Throwable ex) {
            throw new VerifierException(ex);
        }
    }

    private Map<String, String> getServiceUnitComponentMap(String applicationName, String targetName) throws VerifierException {
        HashMap<String, String> suCompMap = new HashMap<String, String>();
        try {
            ComponentQuery compQuery = this.mEnvCtx.getComponentQuery(targetName);
            String[] componentList = (String[])this.invokeMBeanOperation(this.getDeploymentServiceFacadeMBeanName(targetName), "getComponentsForDeployedServiceAssembly", new Object[]{applicationName}, new String[]{"java.lang.String"});
            for (int i = 0; i < componentList.length; ++i) {
                ComponentInfo compInfo = compQuery.getComponentInfo(componentList[i]);
                List<ServiceUnitInfo> suInfoList = compInfo.getServiceUnitList();
                for (ServiceUnitInfo suInfo : suInfoList) {
                    if (!suInfo.getServiceAssemblyName().equals(applicationName)) continue;
                    suCompMap.put(suInfo.getName(), componentList[i]);
                }
            }
        }
        catch (Throwable ex) {
            throw new VerifierException(ex);
        }
        return suCompMap;
    }

    private ObjectName getDeploymentServiceFacadeMBeanName(String targetName) throws VerifierException {
        return this.mBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, targetName);
    }

    private Map<String, CompositeType> getAppConfigTypeMap(Set<String> componentList) {
        HashMap<String, CompositeType> configTypeMap = new HashMap<String, CompositeType>();
        for (String component : componentList) {
            try {
                configTypeMap.put(component, this.getAppConfigType(component, this.mTarget));
            }
            catch (VerifierException verEx) {
                if (verEx.getMessage() == null) continue;
                ToolsLogManager.getRuntimeLogger().warning(verEx.getMessage());
            }
            catch (JBIRemoteException jbiRe) {
                String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_COLLECTING_LIST_OF_APP_CONFIG_TYPE");
                ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, jbiRe);
            }
        }
        return configTypeMap;
    }

    private Map<String, Map<String, Object>> getAppVarsValueMap(Map<String, List<String>> appVarTemplatesMap, String targetName) {
        HashMap<String, Map<String, Object>> appVarValuesMap = new HashMap<String, Map<String, Object>>();
        try {
            for (String component : appVarTemplatesMap.keySet()) {
                HashMap<String, Object> valuesNeededForComponent = new HashMap<String, Object>();
                try {
                    Properties appVarProps = new Properties();
                    ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(component, targetName);
                    if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
                        TabularData appVarTable = (TabularData)this.getAttributeValue(configFacadeMBean, "ApplicationVariables");
                        appVarProps = new ComponentConfigurationHelper().convertToApplicationVariablesProperties(appVarTable);
                        for (Object varName : appVarProps.keySet()) {
                            if (!appVarTemplatesMap.get(component).contains(varName)) continue;
                            valuesNeededForComponent.put((String)varName, appVarProps.get(varName));
                        }
                    }
                    appVarValuesMap.put(component, valuesNeededForComponent);
                }
                catch (Throwable th) {
                    String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_GETTING_APP_VAR_VALUE", new Object[]{component});
                    ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, th);
                }
            }
        }
        catch (Throwable th) {
            String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_GETTING_APP_VAR_VALUE");
            ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, th);
        }
        return appVarValuesMap;
    }

    private Map<String, Map<String, Properties>> getAppConfigValuesMap(Map<String, List<String>> appConfigTemplatesMap, String targetName) {
        HashMap<String, Map<String, Properties>> appConfigValuesMap = new HashMap<String, Map<String, Properties>>();
        try {
            for (String component : appConfigTemplatesMap.keySet()) {
                HashMap<String, Properties> valuesNeededForComponent = new HashMap<String, Properties>();
                try {
                    Map<String, Properties> appConfigMap = this.getApplicationConfigurationsAsMap(component, targetName);
                    for (String configName : appConfigMap.keySet()) {
                        if (!appConfigTemplatesMap.get(component).contains(configName)) continue;
                        valuesNeededForComponent.put(configName, appConfigMap.get(configName));
                    }
                    appConfigValuesMap.put(component, valuesNeededForComponent);
                }
                catch (Throwable th) {
                    String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_GETTING_APP_CONFIG_VALUE", new Object[]{component});
                    ToolsLogManager.getRuntimeLogger().warning(message);
                    ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, th);
                }
            }
        }
        catch (Throwable th) {
            String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_GETTING_APP_CONFIG_VALUE");
            ToolsLogManager.getRuntimeLogger().log(Level.WARNING, message, th);
        }
        return appConfigValuesMap;
    }

    private Map<String, Properties> getApplicationConfigurationsAsMap(String component, String target) throws VerifierException {
        Map<String, Properties> appConfigMap = new HashMap<String, Properties>();
        try {
            ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(component, target);
            if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
                TabularData appConfigTable = (TabularData)this.getAttributeValue(configFacadeMBean, "ApplicationConfigurations");
                appConfigMap = this.getApplicationConfigurationsMap(appConfigTable);
            }
        }
        catch (JBIRemoteException ex) {
            throw new VerifierException(ex);
        }
        return appConfigMap;
    }
}

