/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.util;

import com.sun.jbi.util.StringTranslator;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConfigurationHelper {
    private StringTranslator mTranslator;
    private static CompositeType sAppVarComposite;
    private static TabularType sAppVarTable;
    private static String[] sAppVarItemNames;
    private static String[] sappVarRowIndex;
    private static Logger mLog;
    private static final String APP_CONFIG_ELEMENT_NAME = "ApplicationConfiguration";
    private static final String APP_VAR_ELEMENT_NAME = "ApplicationVariable";
    private static final String IS_PASSWD_ATTRIB_NAME = "isPasswordField";
    private static final String ENCRYPTED_ATTRIB_NAME = "encrypted";
    private static final String NAME_ATTRIB_NAME = "name";
    private static final String PROPERTY_ELEMENT_NAME = "Property";
    private static final String PROPERTY_GROUP_ELEMENT_NAME = "PropertyGroup";
    private static final String IS_REQUIRED_ATTRIB_NAME = "isRequiredField";
    private static final String REQUIRED_ATTRIB_NAME = "required";
    public static final String DEFAULT_APP_VAR_TYPE = "STRING";
    public static final String CONFIGURATION_NS = "http://www.sun.com/jbi/Configuration/V1.0";
    private static final Pattern NUMBER_PATTERN;

    private void initOpenTypes() throws OpenDataException {
        sAppVarItemNames = new String[]{NAME_ATTRIB_NAME, "value", "type"};
        String[] appVarItemDesc = new String[]{"Application variable name", "Application variable value", "Application variable type"};
        OpenType[] appVarRowAttrTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        sappVarRowIndex = new String[]{NAME_ATTRIB_NAME};
        sAppVarComposite = new CompositeType("ApplicationVariableComposite", "Application variable name and value pair", sAppVarItemNames, appVarItemDesc, appVarRowAttrTypes);
        sAppVarTable = new TabularType("ApplicationVariableList", "List of application variables", sAppVarComposite, sappVarRowIndex);
    }

    public ComponentConfigurationHelper() {
        try {
            mLog = Logger.getLogger("com.sun.jbi.util");
            this.mTranslator = new StringTranslator("com.sun.jbi.util", null);
            this.initOpenTypes();
        }
        catch (OpenDataException opex) {
            throw new RuntimeException(opex);
        }
    }

    public CompositeType getApplicationVariablesType() {
        return sAppVarComposite;
    }

    public TabularType getApplicationVariableTabularType() {
        return sAppVarTable;
    }

    public String[] getApplicationVariableItemNames() {
        return sAppVarItemNames;
    }

    public TabularData convertToApplicationVariablesTable(Properties props) throws Exception {
        TabularDataSupport tabularData = new TabularDataSupport(sAppVarTable);
        Set<Object> names = props.keySet();
        for (Object name : names) {
            String appVarName = (String)name;
            String value = props.getProperty(appVarName);
            String appVarType = this.getAppVarType(value, DEFAULT_APP_VAR_TYPE);
            String appVarValue = this.getAppVarValue(value);
            if (appVarType != null) {
                appVarType = this.convertTypeCase(appVarType);
            }
            CompositeDataSupport cd = new CompositeDataSupport(this.getApplicationVariablesType(), sAppVarItemNames, new String[]{appVarName, appVarValue, appVarType});
            tabularData.put(cd);
        }
        return tabularData;
    }

    public Properties convertToApplicationVariablesProperties(TabularData appVars) throws Exception {
        Properties props = new Properties();
        Set<?> names = appVars.keySet();
        for (Object name : names) {
            Object[] key = ((List)name).toArray();
            CompositeData cd = appVars.get(key);
            if (cd == null) continue;
            String appVarName = (String)cd.get(sAppVarItemNames[0]);
            String appVarValue = (String)cd.get(sAppVarItemNames[1]);
            String appVarType = (String)cd.get(sAppVarItemNames[2]);
            if (appVarType == null) {
                appVarType = DEFAULT_APP_VAR_TYPE;
            }
            if (appVarValue == null) {
                appVarValue = "null";
            }
            String value = "[" + this.convertTypeCase(appVarType) + "]" + appVarValue;
            props.put(appVarName, value);
        }
        return props;
    }

    public Properties convertToApplicationVariableProperty(CompositeData appVar) throws Exception {
        Properties props = new Properties();
        if (appVar != null) {
            String appVarName = (String)appVar.get(sAppVarItemNames[0]);
            String appVarValue = (String)appVar.get(sAppVarItemNames[1]);
            String appVarType = (String)appVar.get(sAppVarItemNames[2]);
            if (appVarType == null) {
                appVarType = DEFAULT_APP_VAR_TYPE;
            }
            if (appVarValue == null) {
                appVarValue = "null";
            }
            String value = "[" + this.convertTypeCase(appVarType) + "]" + appVarValue;
            props.put(appVarName, value);
        }
        return props;
    }

    public CompositeData createApplicationVariableComposite(String name, String value, String type) throws Exception {
        if (type == null) {
            type = DEFAULT_APP_VAR_TYPE;
        }
        return new CompositeDataSupport(this.getApplicationVariablesType(), sAppVarItemNames, new String[]{name, value, type});
    }

    public CompositeData createApplicationVariableComposite(String name, String typeAndValueStr) throws Exception {
        return new CompositeDataSupport(this.getApplicationVariablesType(), sAppVarItemNames, new String[]{name, this.getAppVarValue(typeAndValueStr), this.getAppVarType(typeAndValueStr, DEFAULT_APP_VAR_TYPE)});
    }

    public String getAppVarType(String str, String defStr) throws Exception {
        str = str.trim();
        int indexOfRP = str.indexOf(91);
        int indexOfLP = str.indexOf(93);
        if (indexOfRP != 0 || indexOfLP == -1) {
            return defStr;
        }
        String type = str.substring(indexOfRP + 1, indexOfLP);
        if (type == null) {
            type = defStr;
        } else if (type.trim().equals("")) {
            type = defStr;
        }
        String rsltStr = type;
        if (type != null) {
            rsltStr = this.convertTypeCase(type);
        }
        return rsltStr;
    }

    public String getAppVarValue(String str) throws Exception {
        int indexOfRP = str.indexOf(91);
        int indexOfLP = str.indexOf(93);
        if (indexOfRP != 0 || indexOfLP == -1) {
            return str;
        }
        return str.substring(indexOfLP + 1, str.length());
    }

    public Properties convertCompositeDataToProperties(CompositeData cd) {
        Properties appConfigProps = new Properties();
        CompositeType ct = cd.getCompositeType();
        Set<String> keys = ct.keySet();
        for (String key : keys) {
            Object obj = cd.get(key);
            if (obj == null) continue;
            Properties props = this.convertToString(ct.getType(key), obj, key);
            appConfigProps.putAll((Map<?, ?>)props);
        }
        return appConfigProps;
    }

    public CompositeData convertPropertiesToCompositeData(Properties props, CompositeType appConfigType) throws Exception {
        Set<String> keySet = appConfigType.keySet();
        this.propertyKeysValidCheck(props.keySet(), keySet);
        Vector<String> itemNames = new Vector<String>();
        Vector<Object> itemValues = new Vector<Object>();
        boolean i = false;
        for (String itemName : keySet) {
            OpenType<?> itemType = appConfigType.getType(itemName);
            if (itemType.isArray()) {
                int indexSuffix = 0;
                boolean done = false;
                ArrayList<String> itemValueArray = new ArrayList<String>();
                do {
                    String suffixedItemName = itemName + "." + indexSuffix;
                    ++indexSuffix;
                    if (props.containsKey(suffixedItemName)) {
                        itemValueArray.add(props.getProperty(suffixedItemName));
                        continue;
                    }
                    done = true;
                } while (!done);
                if (!itemValueArray.isEmpty()) {
                    itemNames.add(itemName);
                    itemValues.add(this.convertToOpenType(itemType, itemValueArray));
                    continue;
                }
                itemNames.add(itemName);
                itemValues.add(null);
                continue;
            }
            if (props.containsKey(itemName)) {
                String itemStrValue = props.getProperty(itemName);
                itemNames.add(itemName);
                itemValues.add(this.convertToOpenType(itemType, itemStrValue));
                continue;
            }
            itemNames.add(itemName);
            itemValues.add(null);
        }
        CompositeDataSupport cd = new CompositeDataSupport(appConfigType, itemNames.toArray(new String[itemNames.size()]), itemValues.toArray(new Object[itemValues.size()]));
        return cd;
    }

    public boolean isPassword(String attributeName, Document configDoc) throws Exception {
        boolean isPasswordField = false;
        if (configDoc != null) {
            if (this.isOldConfigNS(configDoc)) {
                Element attribElement = (Element)configDoc.getElementsByTagNameNS("*", attributeName = this.getActualAttributeName(attributeName)).item(0);
                if (attribElement != null) {
                    String isPwdStr = attribElement.getAttribute(IS_PASSWD_ATTRIB_NAME);
                    isPasswordField = Boolean.parseBoolean(isPwdStr);
                } else {
                    String errMsg = this.mTranslator.getString("CCFG_ATTR_DEF_MISSING_IN_XML", attributeName);
                    mLog.fine(errMsg);
                }
            } else {
                NodeList properties = configDoc.getElementsByTagNameNS("*", PROPERTY_ELEMENT_NAME);
                int numNodes = properties.getLength();
                for (int i = 0; i < numNodes; ++i) {
                    Element propertyElement = (Element)properties.item(i);
                    if (!attributeName.equals(propertyElement.getAttribute(NAME_ATTRIB_NAME))) continue;
                    isPasswordField = Boolean.parseBoolean(propertyElement.getAttribute(ENCRYPTED_ATTRIB_NAME));
                }
            }
        }
        return isPasswordField;
    }

    public boolean isRequired(String attributeName, Document configDoc) throws Exception {
        boolean isRequiredField = false;
        if (configDoc != null) {
            if (this.isOldConfigNS(configDoc)) {
                Element attribElement = (Element)configDoc.getElementsByTagNameNS("*", attributeName = this.getActualAttributeName(attributeName)).item(0);
                if (attribElement != null) {
                    String isRqdStr = attribElement.getAttribute(IS_REQUIRED_ATTRIB_NAME);
                    isRequiredField = Boolean.parseBoolean(isRqdStr);
                } else {
                    String errMsg = this.mTranslator.getString("CCFG_ATTR_DEF_MISSING_IN_XML", attributeName);
                    mLog.fine(errMsg);
                }
            } else {
                NodeList properties = configDoc.getElementsByTagNameNS("*", PROPERTY_ELEMENT_NAME);
                int numNodes = properties.getLength();
                for (int i = 0; i < numNodes; ++i) {
                    Element propertyElement = (Element)properties.item(i);
                    if (!attributeName.equals(propertyElement.getAttribute(NAME_ATTRIB_NAME))) continue;
                    isRequiredField = Boolean.parseBoolean(propertyElement.getAttribute(REQUIRED_ATTRIB_NAME));
                }
            }
        }
        return isRequiredField;
    }

    public boolean isComponentConfigSupported(Document configDoc) {
        boolean isConfigSupported = false;
        if (configDoc != null && !this.isOldConfigNS(configDoc)) {
            Element root = configDoc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int numNodes = children.getLength();
            for (int i = 0; i < numNodes; ++i) {
                Node child = children.item(i);
                if (!PROPERTY_ELEMENT_NAME.equals(child.getLocalName()) && !PROPERTY_GROUP_ELEMENT_NAME.equals(child.getLocalName())) continue;
                isConfigSupported = true;
                break;
            }
        }
        return isConfigSupported;
    }

    public boolean isAppVarsSupported(Document configDoc) {
        boolean isAppVarsSupported = false;
        if (configDoc != null && !this.isOldConfigNS(configDoc)) {
            Element root = configDoc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int numNodes = children.getLength();
            for (int i = 0; i < numNodes; ++i) {
                Node child = children.item(i);
                if (!APP_VAR_ELEMENT_NAME.equals(child.getLocalName())) continue;
                isAppVarsSupported = true;
                break;
            }
        }
        return isAppVarsSupported;
    }

    public boolean isAppConfigSupported(Document configDoc) {
        boolean isAppConfigSupported = false;
        if (configDoc != null && !this.isOldConfigNS(configDoc)) {
            Element root = configDoc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int numNodes = children.getLength();
            for (int i = 0; i < numNodes; ++i) {
                Node child = children.item(i);
                if (!APP_CONFIG_ELEMENT_NAME.equals(child.getLocalName())) continue;
                isAppConfigSupported = true;
                break;
            }
        }
        return isAppConfigSupported;
    }

    public String getActualAttributeName(String name) {
        String attribName = name;
        String attribSuffix = "";
        int index = name.lastIndexOf(46);
        if (index != -1 && (attribSuffix = name.substring(index + 1, name.length())) != null && NUMBER_PATTERN.matcher(attribSuffix).matches()) {
            attribName = name.substring(0, index);
        }
        return attribName;
    }

    private Object convertToOpenType(OpenType openType, String itemStrValue) throws Exception {
        try {
            String className = openType.getClassName();
            if (className.equals(CompositeData.class.getName())) {
                CompositeType subCompositeType = (CompositeType)openType;
                Properties cdProps = this.convertToProperties(itemStrValue);
                CompositeData cd = this.convertPropertiesToCompositeData(cdProps, subCompositeType);
                return cd;
            }
            Class<?> objClass = Class.forName(className);
            Class[] argClass = new Class[]{String.class};
            Constructor<?> objConstructor = objClass.getConstructor(argClass);
            Object[] argValue = new String[]{itemStrValue};
            return objConstructor.newInstance(argValue);
        }
        catch (Exception ex) {
            String errMsg = this.mTranslator.getString("CCFG_FAILED_CONVERSION_TO_OPEN_TYPE", itemStrValue, openType.getTypeName());
            throw new Exception(errMsg);
        }
    }

    private Object convertToOpenType(OpenType openType, List<String> itemValueArray) throws Exception {
        if (openType.isArray()) {
            ArrayType arrayType = (ArrayType)openType;
            Object[] objArray = (Object[])Array.newInstance(Class.forName(arrayType.getElementOpenType().getClassName()), itemValueArray.size());
            int i = 0;
            for (String itemValue : itemValueArray) {
                objArray[i++] = this.convertToOpenType(arrayType.getElementOpenType(), itemValue);
            }
            return objArray;
        }
        String errMsg = this.mTranslator.getString("CCFG_FAILED_CONVERSION_TO_OPEN_TYPE_AR", itemValueArray.toString(), openType.getTypeName());
        throw new Exception(errMsg);
    }

    private Properties convertToString(OpenType type, Object value, String itemName) {
        Properties props = new Properties();
        if (type.isArray()) {
            Object[] itemArray = (Object[])value;
            for (int i = 0; i < itemArray.length; ++i) {
                props.put(itemName + "." + i, itemArray[i].toString());
            }
        } else if (type.getClassName().equals(CompositeData.class.getName())) {
            if (value != null) {
                Properties cdProps = this.convertCompositeDataToProperties((CompositeData)value);
                Set<Object> keys = cdProps.keySet();
                StringBuffer compositeStrBuf = new StringBuffer("\"");
                Iterator<Object> itr = keys.iterator();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    compositeStrBuf.append(key + "=" + cdProps.get(key));
                    if (itr.hasNext()) {
                        compositeStrBuf.append(", ");
                        continue;
                    }
                    compositeStrBuf.append("\"");
                }
                props.put(itemName, compositeStrBuf.toString());
            }
        } else {
            props.put(itemName, value.toString());
        }
        return props;
    }

    private Properties convertToProperties(String propsStr) {
        propsStr.trim();
        if (propsStr.startsWith("\"")) {
            propsStr = propsStr.substring(1);
        }
        if (propsStr.endsWith("\"")) {
            propsStr = propsStr.substring(0, propsStr.length() - 1);
        }
        String[] nvPairs = propsStr.split(",", -1);
        Properties props = new Properties();
        for (String nvPair : nvPairs) {
            String[] nv = nvPair.split("=", 2);
            if (nv.length != 2) continue;
            props.put(nv[0].trim(), nv[1].trim());
        }
        return props;
    }

    private boolean isOldConfigNS(Document configDoc) {
        Element configElement = configDoc.getDocumentElement();
        return !configElement.getNamespaceURI().equals(CONFIGURATION_NS);
    }

    private void propertyKeysValidCheck(Set propKeys, Set itemNames) throws Exception {
        Vector<String> invalidKeys = new Vector<String>();
        for (Object obj : propKeys) {
            boolean found = false;
            String key = this.getActualAttributeName((String)obj);
            for (Object itemName : itemNames) {
                if (!itemName.equals(key)) continue;
                found = true;
            }
            if (found) continue;
            invalidKeys.add(key);
        }
        if (!invalidKeys.isEmpty()) {
            String errMsg = this.mTranslator.getString("CCFG_CD_EXTRA_PROPS", this.convertToString(invalidKeys));
            throw new Exception(errMsg);
        }
    }

    protected String convertToString(Collection colxn) {
        StringBuffer strBuf = new StringBuffer("[ ");
        if (!colxn.isEmpty()) {
            Iterator itr = colxn.iterator();
            while (itr.hasNext()) {
                strBuf.append(itr.next().toString());
                if (itr.hasNext()) {
                    strBuf.append(", ");
                    continue;
                }
                strBuf.append(" ");
            }
        }
        strBuf.append(" ]");
        return strBuf.toString();
    }

    private String convertTypeCase(String type) {
        if (type != null) {
            return type.toUpperCase();
        }
        return type;
    }

    static {
        NUMBER_PATTERN = Pattern.compile("\\d");
    }
}

