/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.action;

import com.sun.java.swing.action.ActionUtilities;
import com.sun.java.swing.action.DelegateAction;
import com.sun.java.swing.action.StateChangeAction;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.ImageIcon;

public abstract class ActionManager {
    private HashMap actions = new HashMap();
    private static ActionUtilities utilities = new ActionUtilities();
    protected static ActionManager manager;

    protected ActionManager() {
        this.addActions();
    }

    public static ActionManager getInstance() {
        return manager;
    }

    protected abstract void addActions();

    protected void addAction(String cmdname, Action action) {
        this.actions.put(cmdname, action);
    }

    public Action getAction(String key) {
        return (Action)this.actions.get(key);
    }

    public DelegateAction getDelegateAction(String name) {
        Action a = this.getAction(name);
        if (a instanceof DelegateAction) {
            return (DelegateAction)a;
        }
        return null;
    }

    public StateChangeAction getStateChangeAction(String name) {
        Action a = this.getAction(name);
        if (a instanceof StateChangeAction) {
            return (StateChangeAction)a;
        }
        return null;
    }

    public static ImageIcon getIcon(String name) {
        return utilities.getIcon(name);
    }

    public void setActionEnabled(String name, boolean enabled) {
        Action action = this.getAction(name);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }
}

