/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.jdi.BaseLineInfo;
import sun.jvm.hotspot.jdi.ConcreteMethodImpl;
import sun.jvm.hotspot.jdi.JNITypeParser;
import sun.jvm.hotspot.jdi.LineInfo;
import sun.jvm.hotspot.jdi.NonConcreteMethodImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.SDE;
import sun.jvm.hotspot.jdi.StratumLineInfo;
import sun.jvm.hotspot.jdi.TypeComponentImpl;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;

public abstract class MethodImpl
extends TypeComponentImpl
implements com.sun.jdi.Method {
    private JNITypeParser signatureParser;
    protected Method saMethod;

    abstract int argSlotCount() throws AbsentInformationException;

    abstract List allLineLocations(SDE.Stratum var1, String var2) throws AbsentInformationException;

    abstract List locationsOfLine(SDE.Stratum var1, String var2, int var3) throws AbsentInformationException;

    static MethodImpl createMethodImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, Method saMethod) {
        if (saMethod.isNative() || saMethod.isAbstract()) {
            return new NonConcreteMethodImpl(vm, declaringType, saMethod);
        }
        return new ConcreteMethodImpl(vm, declaringType, saMethod);
    }

    MethodImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, Method saMethod) {
        super(vm, declaringType);
        this.saMethod = saMethod;
        this.getParser();
    }

    private JNITypeParser getParser() {
        if (this.signatureParser == null) {
            Symbol sig1 = this.saMethod.getSignature();
            this.signature = sig1.asString();
            this.signatureParser = new JNITypeParser(this.signature);
        }
        return this.signatureParser;
    }

    Method ref() {
        return this.saMethod;
    }

    @Override
    public String genericSignature() {
        Symbol genSig = this.saMethod.getGenericSignature();
        return genSig != null ? genSig.asString() : null;
    }

    @Override
    public String returnTypeName() {
        return this.getParser().typeName();
    }

    @Override
    public Type returnType() throws ClassNotLoadedException {
        return this.findType(this.getParser().signature());
    }

    private Type findType(String signature) throws ClassNotLoadedException {
        ReferenceTypeImpl enclosing = (ReferenceTypeImpl)this.declaringType();
        return enclosing.findType(signature);
    }

    public List argumentTypeNames() {
        return this.getParser().argumentTypeNames();
    }

    List argumentSignatures() {
        return this.getParser().argumentSignatures();
    }

    Type argumentType(int index) throws ClassNotLoadedException {
        ReferenceTypeImpl enclosing = (ReferenceTypeImpl)this.declaringType();
        String signature = (String)this.argumentSignatures().get(index);
        return enclosing.findType(signature);
    }

    public List argumentTypes() throws ClassNotLoadedException {
        int size = this.argumentSignatures().size();
        ArrayList<Type> types = new ArrayList<Type>(size);
        for (int i = 0; i < size; ++i) {
            Type type = this.argumentType(i);
            types.add(type);
        }
        return types;
    }

    @Override
    public boolean isAbstract() {
        return this.saMethod.isAbstract();
    }

    @Override
    public boolean isBridge() {
        return this.saMethod.isBridge();
    }

    @Override
    public boolean isSynchronized() {
        return this.saMethod.isSynchronized();
    }

    @Override
    public boolean isNative() {
        return this.saMethod.isNative();
    }

    @Override
    public boolean isVarArgs() {
        return this.saMethod.isVarArgs();
    }

    @Override
    public boolean isConstructor() {
        return this.saMethod.isConstructor();
    }

    @Override
    public boolean isStaticInitializer() {
        return this.saMethod.isStaticInitializer();
    }

    @Override
    public boolean isObsolete() {
        return this.saMethod.isObsolete();
    }

    public final List allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    public List allLineLocations(String stratumID, String sourceName) throws AbsentInformationException {
        return this.allLineLocations(this.declaringType.stratum(stratumID), sourceName);
    }

    public final List locationsOfLine(int lineNumber) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, lineNumber);
    }

    public List locationsOfLine(String stratumID, String sourceName, int lineNumber) throws AbsentInformationException {
        return this.locationsOfLine(this.declaringType.stratum(stratumID), sourceName, lineNumber);
    }

    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long codeIndex) {
        if (stratum.isJava()) {
            return new BaseLineInfo(-1, this.declaringType);
        }
        return new StratumLineInfo(stratum.id(), -1, null, null);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MethodImpl) {
            MethodImpl other = (MethodImpl)obj;
            return ((Object)this.declaringType()).equals(other.declaringType()) && this.ref().equals(other.ref()) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int compareTo(com.sun.jdi.Method method) {
        ReferenceTypeImpl declaringType = (ReferenceTypeImpl)this.declaringType();
        int rc = declaringType.compareTo(method.declaringType());
        if (rc == 0) {
            rc = declaringType.indexOf(this) - declaringType.indexOf(method);
        }
        return rc;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.declaringType().name());
        sb.append(".");
        sb.append(this.name());
        sb.append("(");
        boolean first = true;
        Iterator it = this.argumentTypeNames().iterator();
        while (it.hasNext()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append((String)it.next());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String name() {
        Symbol myName = this.saMethod.getName();
        return myName.asString();
    }

    @Override
    public int modifiers() {
        return this.saMethod.getAccessFlagsObj().getStandardFlags();
    }

    @Override
    public boolean isPackagePrivate() {
        return this.saMethod.isPackagePrivate();
    }

    @Override
    public boolean isPrivate() {
        return this.saMethod.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.saMethod.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.saMethod.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.saMethod.isStatic();
    }

    @Override
    public boolean isSynthetic() {
        return this.saMethod.isSynthetic();
    }

    @Override
    public boolean isFinal() {
        return this.saMethod.isFinal();
    }

    @Override
    public int hashCode() {
        return this.saMethod.hashCode();
    }
}

