/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class MethodKlass
extends Klass {
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("methodKlass");
        headerSize = type.getSize() + Oop.getHeaderSize();
    }

    MethodKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public long getObjectSize() {
        return MethodKlass.alignObjectSize(headerSize);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("MethodKlass");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MethodKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

