/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.windows;

import java.awt.Composite;
import java.awt.Shape;
import java.awt.geom.Path2D;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.windows.GDIWindowSurfaceData;

public class GDIRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    native void doDrawLine(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        int n5 = sunGraphics2D.transX;
        int n6 = sunGraphics2D.transY;
        try {
            this.doDrawLine((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + n5, n2 + n6, n3 + n5, n4 + n6);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doDrawRect(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        try {
            this.doDrawRect((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doDrawRoundRect(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.doDrawRoundRect((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doDrawOval(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        try {
            this.doDrawOval((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doDrawArc(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.doDrawArc((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doDrawPoly(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int[] var7, int[] var8, int var9, boolean var10);

    @Override
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        try {
            this.doDrawPoly((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, false);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    @Override
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        try {
            this.doDrawPoly((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, true);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doFillRect(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        try {
            this.doFillRect((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doFillRoundRect(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.doFillRoundRect((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doFillOval(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        try {
            this.doFillOval((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doFillArc(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.doFillArc((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doFillPoly(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int[] var7, int[] var8, int var9);

    @Override
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        try {
            this.doFillPoly((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    native void doShape(GDIWindowSurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, Path2D.Float var7, boolean var8);

    void doShape(SunGraphics2D sunGraphics2D, Shape shape, boolean bl) {
        int n;
        int n2;
        Path2D.Float float_;
        if (sunGraphics2D.transformState <= 1) {
            float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
            n2 = sunGraphics2D.transX;
            n = sunGraphics2D.transY;
        } else {
            float_ = new Path2D.Float(shape, sunGraphics2D.transform);
            n2 = 0;
            n = 0;
        }
        try {
            this.doShape((GDIWindowSurfaceData)sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.eargb, n2, n, float_, bl);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
    }

    public void doFillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        GDIWindowSurfaceData gDIWindowSurfaceData;
        int[] nArray = new int[4];
        try {
            gDIWindowSurfaceData = (GDIWindowSurfaceData)sunGraphics2D.surfaceData;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
        Region region = sunGraphics2D.getCompClip();
        Composite composite = sunGraphics2D.composite;
        int n = sunGraphics2D.eargb;
        while (spanIterator.nextSpan(nArray)) {
            this.doFillRect(gDIWindowSurfaceData, region, composite, n, nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            this.doShape(sunGraphics2D, shape, false);
        } else if (sunGraphics2D.strokeState < 3) {
            ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
            try {
                this.doFillSpans(sunGraphics2D, shapeSpanIterator);
            }
            finally {
                shapeSpanIterator.dispose();
            }
        } else {
            this.doShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape), true);
        }
    }

    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.doShape(sunGraphics2D, shape, true);
    }

    public native void devCopyArea(GDIWindowSurfaceData var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public GDIRenderer traceWrap() {
        return new Tracer();
    }

    public static class Tracer
    extends GDIRenderer {
        @Override
        void doDrawLine(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawLine");
            super.doDrawLine(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5);
        }

        @Override
        void doDrawRect(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRect");
            super.doDrawRect(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5);
        }

        @Override
        void doDrawRoundRect(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRoundRect");
            super.doDrawRoundRect(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        @Override
        void doDrawOval(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawOval");
            super.doDrawOval(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5);
        }

        @Override
        void doDrawArc(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIDrawArc");
            super.doDrawArc(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        @Override
        void doDrawPoly(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, boolean bl) {
            GraphicsPrimitive.tracePrimitive("GDIDrawPoly");
            super.doDrawPoly(gDIWindowSurfaceData, region, composite, n, n2, n3, nArray, nArray2, n4, bl);
        }

        @Override
        void doFillRect(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIFillRect");
            super.doFillRect(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5);
        }

        @Override
        void doFillRoundRect(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIFillRoundRect");
            super.doFillRoundRect(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        @Override
        void doFillOval(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIFillOval");
            super.doFillOval(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5);
        }

        @Override
        void doFillArc(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIFillArc");
            super.doFillArc(gDIWindowSurfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        @Override
        void doFillPoly(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4) {
            GraphicsPrimitive.tracePrimitive("GDIFillPoly");
            super.doFillPoly(gDIWindowSurfaceData, region, composite, n, n2, n3, nArray, nArray2, n4);
        }

        @Override
        void doShape(GDIWindowSurfaceData gDIWindowSurfaceData, Region region, Composite composite, int n, int n2, int n3, Path2D.Float float_, boolean bl) {
            GraphicsPrimitive.tracePrimitive(bl ? "GDIFillShape" : "GDIDrawShape");
            super.doShape(gDIWindowSurfaceData, region, composite, n, n2, n3, float_, bl);
        }

        @Override
        public void devCopyArea(GDIWindowSurfaceData gDIWindowSurfaceData, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDICopyArea");
            super.devCopyArea(gDIWindowSurfaceData, n, n2, n3, n4, n5, n6);
        }
    }
}

